<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once("../../Group-Office.php");

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('email');

require_once($GO_CONFIG->class_path."mail/imap.class.inc");
require_once($GO_MODULES->class_path."email.class.inc");
require_once($GO_LANGUAGE->get_language_file('email'));
$mail = new imap();
$email = new email();


$account_id = isset($_REQUEST['account_id']) ? $_REQUEST['account_id'] :0;
$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';

$return_to = (isset($_REQUEST['return_to']) && $_REQUEST['return_to'] != '') ?
$_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];
$link_back = (isset($_REQUEST['link_back']) && $_REQUEST['link_back'] != '') ?
$_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];

$disable_accounts = ($GO_CONFIG->get_setting('em_disable_accounts') == 'true') ?
true : false;

if(isset($_REQUEST['feedback'])) $feedback = $_REQUEST['feedback'];

//delete accounts if requested
switch ($task)
{
	case 'save_folders':
	
	$account = $email->get_account($account_id);
	
	if ($account && $mail->open($account['host'], $account['type'],
			$account['port'],$account['username'],
			$account['password'],'INBOX', 0, $account['use_ssl'], $account['novalidate_cert']))
	{
		$subscribed = $mail->get_subscribed();
		$subscribed_names = array();
		if (isset($_POST['use']))
		{
			while($mailbox = array_shift($subscribed))
			{
				$subscribed_names[] = $mailbox['name'];

				$search_name = get_magic_quotes_gpc() ? addslashes($mailbox['name']) : $mailbox['name'];
				if (!in_array($search_name, $_POST['use']))
				{
					if($mail->unsubscribe($mailbox['name']))
					{
						$email->unsubscribe($account['id'], addslashes($mailbox['name']));
					}
				}
			}

			for ($i=0;$i<count($_POST['use']);$i++)
			{
				$must_be_subscribed = smart_stripslashes($_POST['use'][$i]);

				if (!in_array($must_be_subscribed, $subscribed_names))
				{
					if($mail->subscribe($must_be_subscribed))
					{
						$email->subscribe($account['id'], addslashes($must_be_subscribed));
					}
				}
			}
		}else
		{
			while($mailbox = array_shift($subscribed))
			{
				if($mail->unsubscribe($mailbox['name']))
				{
					$email->unsubscribe($account['id'], addslashes($mailbox['name']));
				}
			}
		}

		$sent = isset($_POST['sent']) ? smart_addslashes($_POST['sent']) : '';
		$trash = isset($_POST['trash']) ? smart_addslashes($_POST['trash']) : '';
		$drafts = isset($_POST['drafts']) ? smart_addslashes($_POST['drafts']) : '';

		$email->update_folders($account_id, $sent, $trash, $drafts);

		if (isset($_POST['new_name']))
		{
			$new_name = smart_stripslashes(trim($_POST['new_name']));
			$old_name = smart_stripslashes(trim($_POST['old_name']));
			$location = smart_stripslashes(trim($_POST['location']));
			if ($new_name == '')
			{
				$feedback = '<p class="Error">'.$error_missing_field.'</p>';
			}else
			{
				if ($mail->rename_folder($old_name, $location.$new_name))
				{
					$email->rename_folder($account_id, addslashes($old_name), addslashes($location.$new_name));
					//synchronise Group-Office with the IMAP server
					$subscribed = $mail->get_subscribed($account['mbroot']);
					$mailboxes = $mail->get_mailboxes($account['mbroot']);
					$email->synchronise($account['id'], $mailboxes, $subscribed);
				}
			}
		}
		$mail->close();
		}
	
		if (isset($_POST['close']) && $_POST['close'] == 'true')
		{
			header('Location: '.$return_to);
			exit();
		}
	break;
	
	case 'save_account':
	
	$task = 'account';
	$mbroot = isset($_POST['mbroot']) ? smart_addslashes($_POST['mbroot']) : '';
	if ($_POST['name'] == "" ||
	$_POST['mail_address'] == "" ||
	$_POST['port'] == "" ||
	$_POST['user'] == "" ||
	$_POST['pass'] == "" ||
	$_POST['host'] == "")
	{
		$feedback = $error_missing_field;
	}else
	{
		$use_ssl = isset($_REQUEST['use_ssl']) ? '1' : '0';
		$novalidate_cert = isset($_REQUEST['novalidate_cert']) ? '1' : '0';

		$sent = $_POST['type'] == 'pop3' ? '' : smart_addslashes($_POST['sent']);
		$trash = $_POST['type'] == 'pop3' ? '' : smart_addslashes($_POST['trash']);
		$drafts = $_POST['type'] == 'pop3' ? '' : smart_addslashes($_POST['drafts']);

		$auto_check = isset($_POST['auto_check']) ? '1' : '0';
		if ($account_id > 0)
		{
			if(!$email->update_account($account_id, $_POST['type'],
			smart_addslashes($_POST['host']),
			$_POST['port'], $use_ssl, $novalidate_cert, $mbroot,
			smart_addslashes($_POST['user']),
			smart_addslashes($_POST['pass']), smart_addslashes($_POST['name']),
			smart_addslashes($_POST['mail_address']),
			smart_addslashes($_POST['signature']),
			$sent, $trash, $drafts, $auto_check))
			{
				$feedback = '<p class="Error">'.$ml_connect_failed.' \''.$_POST['host'].
				'\' '.$ml_at_port.': '.$_POST['port'].'</p>';
				$feedback .= '<p class="Error">'.$email->last_error.'</p>';
			}else
			{
				header('Location: '.$return_to);
				exit();
			}
		}else
		{
			if(!$email_id = $email->add_account($GO_SECURITY->user_id, $_POST['type'],
			smart_addslashes($_POST['host']),
			$_POST['port'], $use_ssl, $novalidate_cert, $mbroot,
			smart_addslashes($_POST['user']),
			smart_addslashes($_POST['pass']),
			smart_addslashes($_POST['name']),
			smart_addslashes($_POST['mail_address']),
			smart_addslashes($_POST['signature']),
			$sent, $trash,$drafts, $auto_check))
			{
				$feedback = '<p class="Error">'.$ml_connect_failed.' \''.
				$_POST['host'].'\' '.$ml_at_port.': '.$_POST['port'].'</p>'.
				'<p class="Error">'.$email->last_error.'</p>';
			}else
			{
				header('Location: '.$return_to);
				exit();
			}
		}
	}
}


require_once($GO_THEME->theme_path."header.inc");

echo '<form method="POST" action="'.$_SERVER['PHP_SELF'].'" name="email_client">';
echo '<input type="hidden" name="task" value="" />';
echo '<input type="hidden" name="close" value="false" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="link_back" value="'.$link_back.'" />';
echo '<input type="hidden" value="'.$account_id.'" name="account_id" />';

if (isset($account_id))
{
	$title = $ml_edit_account;
}else
{
	$title = $ml_new_account;
}
$tabtable = new tabtable('account_tab', $title, '100%', '300', '100', '', true);

if($account_id > 0)
{
	$account = $email->get_account($account_id);
}else
{
	$account = false;
}

if($account && $account['type'] == "imap")
{
	$tabtable->add_tab('properties',$strProperties);
	$tabtable->add_tab('folders',$ml_folders);
	$tabtable->add_tab('filters',$ml_filters);	 
}

$tabtable->print_head($return_to);

switch($tabtable->get_active_tab_id())
{
	case 'folders':
		require('folders.inc');
	break;
	
	case 'filters':
		require('filters.inc');
	break;
	
	default:
		require('account.inc');
	break;
}

?>
<script type="text/javascript" language="javascript">

function _save(task, close)
{
	document.forms[0].task.value = task;
	document.forms[0].close.value = close;
	document.forms[0].submit();
}
</script>
<?php
$tabtable->print_foot();
echo '</form>';
require_once($GO_THEME->theme_path."footer.inc");
?>
