<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */


//load Group-Office
require_once("../../Group-Office.php");

//authenticate the user
$GO_SECURITY->authenticate();

//see if the user has access to this module
//for this to work there must be a module named 'example'
$GO_MODULES->authenticate('cms');

//load the CMS module class library
require_once($GO_MODULES->class_path.'cms.class.inc');
$cms = new cms();

//get the language file
require_once($GO_LANGUAGE->get_language_file('cms'));

$site_id = isset($_REQUEST['site_id']) ? $_REQUEST['site_id'] : 0;
$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';

$search_word_id = isset($_REQUEST['search_word_id']) ? $_REQUEST['search_word_id'] : 0;

$return_to = isset($_REQUEST['return_to']) ? $_REQUEST['return_to'] : 'index.php';
$sites = isset($_POST['sites']) ? '&sites='.$_POST['sites'] : '';
$link_back = $_SERVER['PHP_SELF'].'?site_id='.$site_id.$sites.'&return_to='.urlencode($return_to);

$root_publish_path = $GO_CONFIG->get_setting('cms_publish_path');

switch($task)
{
	case 'save_site':
	
		$domain = $cms->prepare_domain(smart_addslashes(trim($_POST['domain'])));
		$allow_properties = isset($_POST['allow_properties']) ? '1' : '0';
		$multilingual= isset($_POST['multilingual']) ? '1' : '0';
		
		$webmaster = isset($_POST['webmaster']) ? $_POST['webmaster'] : '';
		if ($domain == '' || $webmaster == '')
		{
			$feedback= '<p class="Error">'.$error_missing_field.'</p>';
		}else
		{
			if(!$site = $cms->get_site($_POST['site_id']))
			{
				$feedback = '<p class="Error">'.$strSaveError.'</p>';
			}else
			{
				$existing_site = $cms->get_site_by_domain($domain);
				if ($existing_site && $existing_site['id'] != $_POST['site_id'])
				{
					$feedback = '<p class="Error">'.$cms_site_exists.'</p>';
				}else
				{
					if (isset($_POST['secure']))
					{
						if ($site['acl_read'] == 0)
						{
							if (!$acl_read = $GO_SECURITY->get_new_acl('cms read: '.$domain))
							{
								die($strAclError);
							}
						}else
						{
							$acl_read = $site['acl_read'];
						}
					}else
					{
						$acl_read = 0;
						if($site['acl_read'] > 0)
						{
							$GO_SECURITY->delete_acl($site['acl_read']);
						}
					}

					if (!$cms->update_site(
								$site_id,
								$domain,
								$webmaster,
								$allow_properties,
								$multilingual,
								$acl_read))
					{
						$feedback = '<p class="Error">'.$strSaveError.'</p>';
					}else
					{
						if($_POST['close'] == 'true')
						{
							header('Location: '.$return_to);
							exit();
						}
					}

				}
			}			
		}
	break;
	
	case 'save_publish':
		$publish_path = smart_stripslashes(trim($_POST['publish_path']));
		if ($publish_path == '')
		{
			$feedback = '<p class="Error">'.$error_missing_field.'</p>';
		}else
		{
			if (substr($publish_path,0,1) == $GO_CONFIG->slash) $publish_path = substr($publish_path,1);
			if (substr($publish_path, -1) != $GO_CONFIG->slash) $publish_path = $publish_path.$GO_CONFIG->slash;

			$existing_site = $cms->get_site_by_publish_path(addslashes($publish_path));

			if ($existing_site && $existing_site['id'] != $site_id)
			{
				$feedback = '<p class="Error">'.$cms_path_already_used.'</p>';
			}else
			{
				$full_publish_path = '';
				$dirs = explode($GO_CONFIG->slash, $publish_path);
				while($dir = array_shift($dirs))
				{
					$full_publish_path = $full_publish_path.$dir.$GO_CONFIG->slash;
					$existing_site = $cms->get_site_by_publish_path(addslashes($full_publish_path));
					if ($existing_site && $existing_site['id'] != $site_id)
					{
						$path_used = true;
						break;
					}
				}

				if (isset($path_used))
				{
					$feedback = '<p class="Error">'.$cms_path_already_used.'</p>';
				}else
				{
					require_once($GO_CONFIG->class_path.'filesystem.class.inc');
					$fs = new filesystem(true);

					$site = $cms->get_site($site_id);

					if ($site['publish_path'] != '' && file_exists($root_publish_path.$site['publish_path']) && $site['publish_path']  != $publish_path)
					{
						$publish_dir = $root_publish_path;
						$dirs = explode($GO_CONFIG->slash, $site['publish_path']);
						while($dir = array_shift($dirs))
						{
							$publish_dir = $publish_dir.$dir.$GO_CONFIG->slash;
							$fs->delete($publish_dir);
						}
					}

					$full_publish_path = $root_publish_path;

					$dirs = explode($GO_CONFIG->slash, $publish_path);
					while($dir = array_shift($dirs))
					{
						$full_publish_path = $full_publish_path.$dir.$GO_CONFIG->slash;
						if (!file_exists($full_publish_path))
						{
							@mkdir($full_publish_path, $GO_CONFIG->create_mode);
						}
						if (!is_writable($full_publish_path))
						{
							$feedback = '<p class="Error">'.$cms_path_not_writable.': \''.$full_publish_path.'\'</p>';
							break;
						}
					}
					if ($full_publish_path == $root_publish_path.$publish_path)
					{
						$cms->set_publishing($site_id, $publish_style, addslashes($publish_path));
						require_once($GO_CONFIG->class_path.'cms_site.class.inc');
						$cms_site = new cms_site($site_id);
						$cms_site->publish();

						if ($close == 'true')
						{
							header('Location: '.$return_to);
							exit();
						}
					}
				}
			}
		}
	break;
}


//create a tab window
$site = $cms->get_site($site_id);

if($task != 'save_site')
{
	$domain = $site['domain'];
	$webmaster = $site['webmaster'];
	$secure_check = ($site['acl_read'] > 0) ? true : false;
	$allow_properties_check = ($site['allow_properties'] == '1') ? true : false;
	$multilingual_check = ($site['multilingual'] == '1') ? true : false;
}else
{
	$allow_properties_check = isset($_POST['allow_properties']);
	$secure_check = isset($_POST['secure']);
	$multilingual_check = isset($_POST['multilingual']);
}

if (!$GO_SECURITY->has_permission($GO_SECURITY->user_id, $site['acl_write']))
{
	header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
	exit();
}

$tabtable = new tabtable('sites', htmlspecialchars($site['domain']), '100%', '400','100','',true);
if($site['user_id'] == $GO_SECURITY->user_id || $site['allow_properties'] == '1')
{
	$tabtable->add_tab('properties', $strProperties);
}
$tabtable->add_tab('languages', $cms_languages);

if ($root_publish_path != '')
{
	$tabtable->add_tab('publish', $cms_publish);
}

if($site['user_id'] == $GO_SECURITY->user_id)
{
	$tabtable->add_tab('write_permissions', $strWriteRights);

	if ($site['acl_read'] > 0)
	{
		$tabtable->add_tab('read_permissions', $strReadRights);
	}	
}
/*if ($task == 'edit_search_words')
{
	$tabtable->set_active_tab('search_words');
}*/


//set the page title for the header file
$page_title = $lang_modules['cms'];

//require the header file. This will draw the logo's and the menu
require_once($GO_THEME->theme_path."header.inc");
echo '<form name="cms" method="post" action="'.$_SERVER['PHP_SELF'].'">';
echo '<input type="hidden" name="site_id" value="'.$site_id.'" />';
echo '<input type="hidden" name="close" value="false" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';

$tabtable->print_head($return_to);

switch($tabtable->get_active_tab_id())
{
	case 'search_words':
		require_once('site_search_words.inc');
		break;

	case 'publish':
		require_once('publish.inc');
		break;

	case 'languages':
		require_once('languages.inc');
		break;

	case 'write_permissions':
		echo '<table border="0" cellpadding="10" cellspacing="0"><tr><td>';
		$read_only = ($site['user_id'] == $GO_SECURITY->user_id) ? false : true;
		print_acl($site["acl_write"], $read_only);
		echo '</td></tr></table><br />';
		$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
		break;

	case 'read_permissions':
		echo '<table border="0" cellpadding="10" cellspacing="0"><tr><td>';
		$read_only = ($site['user_id'] == $GO_SECURITY->user_id) ? false : true;
		print_acl($site["acl_read"], $read_only);
		echo '</td></tr></table><br />';
		$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
		break;

	default:

		?>
			<input type="hidden" name="task" />
			<br />
			<table border="0" cellpadding="4" cellspacing="0">
			<?php
			if(isset($feedback)) echo '<tr><td colspan="2">'.$feedback.'&nbsp;</td></tr>';
		?>

			<tr>
				<td>
				<?php echo $cms_domain; ?>*:
				</td>
				<td>
				<input type="text" class="textbox" name="domain" value="<?php echo htmlspecialchars($domain); ?>" maxlength="100" style="width: 250" />
				</td>
			</tr>				
			<tr>
				<td>
				<?php echo $cms_webmaster; ?>*:
				</td>
				<td>
				<input type="text" class="textbox" name="webmaster" value="<?php echo htmlspecialchars($webmaster); ?>" maxlength="100" style="width: 250" />
				</td>
			</tr>
			<tr>
				<td colspan="2">
				<?php
				$checkbox = new checkbox('secure', 'true', $cms_use_go_auth, $secure_check);
				echo '<br />';
				$checkbox = new checkbox('allow_properties', 'true', $cms_allow_properties, $allow_properties_check);
				echo '<br />';
				$checkbox = new checkbox('multilingual', 'true', $cms_multilingual, $multilingual_check);
				?>
				</td>
			</tr>
			<tr>
				<td colspan="2">
				<br />
				<?php
				$button = new button($cmdOk, "javascript:save_close_site()");
				echo '&nbsp;&nbsp;';
				$button = new button($cmdApply, "javascript:save_site()");
				echo '&nbsp;&nbsp;';
				$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
				?>
				</td>
			</tr>
			</table>
			<script type="text/javascript">
			function save_close_site()
			{
				document.forms[0].close.value='true';
				document.forms[0].task.value='save_site';
				document.forms[0].submit();
			}

		function save_site()
		{
			document.forms[0].task.value='save_site';
			document.forms[0].submit();
		}
		document.forms[0].domain.focus();
		</script>
			<?php

		
		break;
}

$tabtable->print_foot();
echo '</form>';
require_once($GO_THEME->theme_path."footer.inc");
?>
