<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */

$site_id = isset ($_REQUEST['site_id']) ? $_REQUEST['site_id'] : 0;

$image_filter[] = 'jpg';
$image_filter[] = 'gif';
$image_filter[] = 'png';
$image_filter[] = 'jpeg';
$image_filter[] = 'jpe';

function get_path($folder_id) {
	global $cms;
	$path = '';

	while ($folder = $cms->get_folder($folder_id)) {
		$path = '/<a href="'.$_SERVER['PHP_SELF'].'?folder_id='.$folder['id'].'">'.$folder['name'].'</a>'.$path;
		$folder_id = $folder['parent_id'];
	}
	return $path;
}

require_once ("../../Group-Office.php");

//authenticate the user
$GO_SECURITY->authenticate();

//see if the user has access to this module
//for this to work there must be a module named 'example'
$GO_MODULES->authenticate('cms');

//get the language file
require_once ($GO_LANGUAGE->get_language_file('cms'));

require_once ($GO_MODULES->class_path.'cms.class.inc');
$cms = new cms();

$cms_settings = $cms->get_settings($GO_SECURITY->user_id);

$site = $cms->get_site($_SESSION['site_id']);
$language = $cms->get_language($_SESSION['language_id']);

if (!$GO_SECURITY->has_permission($GO_SECURITY->user_id, $site['acl_write'])) {
	require_once ($GO_THEME->theme_path."header.inc");
	require_once ($GO_CONFIG->root_path.'error_docs/403.inc');
	require_once ($GO_THEME->theme_path."footer.inc");
	exit ();

}

$_SESSION['cms']['select_folder_id'] = isset($_SESSION['cms']['select_folder_id']) ? $_SESSION['cms']['select_folder_id'] : $language['root_folder_id'];
//set the folder id we are in
$folder_id = isset ($_REQUEST['folder_id']) ? $_REQUEST['folder_id'] : $_SESSION['cms']['select_folder_id'];
$_SESSION['cms']['select_folder_id'] = $folder_id;


require_once ($GO_THEME->theme_path."header.inc");

$folder = $cms->get_folder($folder_id);

echo '<h2>'.get_path($folder['parent_id']).'/<a href="'.$_SERVER['PHP_SELF'].'?site_id='.$site_id.'&folder_id='.$folder['id'].'">'.$folder['name'].'</a></h2>';
echo '<table border="0">';
if ($folder['parent_id'] != 0) {
	echo '<td align="center" width="60" nowrap>';
	echo '<a class="small" href="'.$_SERVER['PHP_SELF'].'?site_id='.$site_id.'&folder_id='.$folder['parent_id'].'"><img src="'.$GO_THEME->images['uplvl_big'].'" border="0" height="32" width="32" /><br />omhoog</a></td>';
}
echo '<td align="center" width="60" nowrap>';
echo '<a class="small" href="javascript:window.close();"><img src="'.$GO_THEME->images['close'].'" border="0" height="32" width="32" /><br />close</a></td>';
echo '</table>';

echo '<table class="go_table" width="100%"><tr>';
echo '<th width="16"><input type="checkbox" onclick="javascript:invert_selection()" name="dummy" /></th>';
echo '<th nowrap>'.$strName.'</a></th>';
echo '<th>'.$strType.'</a></th></tr>';

//list the folders first
$total_size = 0;
$count_folders = $cms->get_folders($folder_id);
while ($cms->next_record()) {
	$short_name = cut_string($cms->f('name'), 30);
	echo '<tr id="folder_'.$cms->f('id').'" class="Table1">';
	echo '<td><input onclick="javascript:folder_click(this)" type="checkbox" name="folders[]" value="'.$cms->f('id').'" id="'.$cms->f('name').'" /></td>'.'<td nowrap><a href="'.$_SERVER['PHP_SELF'].'?site_id='.$site_id.'&folder_id='.$cms->f('id').'" title="'.$cms->f('name').'">';

	if ($cms->f('disabled') == '1') {
		echo '<img width="16" height="16" border="0" src="'.$GO_THEME->images['invisible_folder'].'" align="absmiddle" />';
	} else {
		echo '<img width="16" height="16" border="0" src="'.$GO_THEME->images['folder'].'" align="absmiddle" />';
	}

	echo '&nbsp;&nbsp;'.$short_name.'</a>';
	echo '<td nowrap>'.$fbFolder.'&nbsp;&nbsp;</td>';
	echo '</tr>';
}

//list the files
$count_files = $cms->get_files($folder_id);
while ($cms->next_record()) {
	$total_size += $cms->f('size');
	$short_name = strip_extension(cut_string($cms->f('name'), 30));

	echo '<tr id="file_'.$cms->f('id').'" class="Table1">';
	echo '<td><input onclick="javascript:file_click(this)" type="checkbox" name="files[]" value="'.$cms->f('id').'" id="'.$cms->f('name').'" /></td>';
	echo '<td nowrap>';

	if (!eregi('htm', $cms->f('extension'))) {
		echo '<a href=\'javascript:_insertImage("'.$GO_MODULES->full_url.'download.php?site_id='.$site_id.'&amp;file_id='.$cms->f('id').'");\' title="'.$cms->f('name').'">';
	} else {
		if ($cms->f('title') != '') {
			$link_name = $cms->f('title');
		} else {
			$link_name = strip_extension($cms->f('name'));
		}
		echo '<a href=\'javascript:_insertHyperlink("'.$GO_MODULES->full_url.'view.php?site_id='.$site_id.'&amp;file_id='.$cms->f('id').'", "'.$link_name.'");\' title="'.$cms->f('name').'">';
	}

	echo '<img width="16" height="16" border="0" src="'.get_filetype_image($cms->f('extension')).'" align="absmiddle" />&nbsp;&nbsp;';

	if (isset ($cut_files) && in_array($cms->f('id'), $cut_files)) {
		echo '<font color="#7d7d7d">'.$short_name.'</font></a>&nbsp;&nbsp;</td>';
	} else {
		echo $short_name.'</a>&nbsp;&nbsp;</td>';
	}
	echo '<td nowrap>'.get_filetype_description($cms->f('extension')).'&nbsp;&nbsp;</td>';
	echo '</tr>';
}

$count_items = $count_folders + $count_files;
echo '<tr><td colspan="99" class="small" height="18">&nbsp;'.$count_items.' item(s)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$fbFolderSize.': '.format_size($total_size).'</td></tr>';
echo "</table>";
?>
<script type="text/javascript" language="javascript">

function _insertImage(url)
{
  opener.editor_insertHTML('<img src="'+url+'" />');
  //opener.editor_insertImage(url);
  window.close();
}

function _insertHyperlink(url, name)
{
  opener.editor_insertHTML('<a href="'+url+'">'+name+'</a>');
  window.close();
}

document.onblur = function() {
  setTimeout('self.focus()',100);
}

</script>
<?php
require_once ($GO_THEME->theme_path."footer.inc");
?>