<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/


//load Group-Office
require_once("../../Group-Office.php");

//authenticate the user
$GO_SECURITY->authenticate();

//see if the user has access to this module
//for this to work there must be a module named 'example'
$GO_MODULES->authenticate('cms');

//load the CMS module class library
require_once($GO_MODULES->class_path.'cms.class.inc');
$cms = new cms();

//get the language file
require_once($GO_LANGUAGE->get_language_file('cms'));

$site_id = isset($_REQUEST['site_id']) ? $_REQUEST['site_id'] : 0;
$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';

$return_to = isset($_REQUEST['return_to']) ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];
$link_back = isset($_REQUEST['link_back']) ? $_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];
$language_id = isset($_REQUEST['language_id']) ? $_REQUEST['language_id'] : 0;
$search_word_id = isset($_REQUEST['search_word_id']) ? $_REQUEST['search_word_id'] : 0;

switch($task)
{
	case 'save_language':
	$name = smart_addslashes($_POST['name']);
	$title = smart_addslashes($_POST['title']);
	$description = smart_addslashes($_POST['description']);
	$keywords = smart_addslashes($_POST['keywords']);
	$sort_order = smart_addslashes($_POST['sort_order']);

	if($name =='' || $title == '')
	{
		$feedback =  '<p class="Error">'.$error_missing_field.'</p>';
	}else
	{
		$language_id = isset($_POST['language_id']) ? $_POST['language_id'] : 0;
		if($language_id > 0)
		{
			if(!$cms->update_language($language_id, $_POST['template_id'], $name, $title, $description, $keywords, $sort_order, $_POST['language_code']))
			{
				$feedback =  '<p class="Error">'.$strSaveError.'</p>';
			}
		}else
		{
			if(!$language_id = $cms->add_language($site_id, $_POST['template_id'], $name, $title, $description, $keywords, $sort_order, $_POST['language_code']))
			{
				$feedback =  '<p class="Error">'.$strSaveError.'</p>';
			}
		}
		if($_POST['close'] == 'true')
		{
			header('Location: '.$return_to);
			exit();
		}
	}
	break;

	case 'save_image':
	$cms->save_language_image($language_id, smart_addslashes($_POST['image_url']));
	break;

	case 'upload_image':

	if (is_uploaded_file($_FILES['user_image']['tmp_name']))
	{
		if(!file_exists($GO_CONFIG->root_path.'public_files/'.$_SESSION['GO_SESSION']['username'].'/'))
		{
			mkdir($GO_CONFIG->root_path.'public_files/'.$_SESSION['GO_SESSION']['username'].'/', $GO_CONFIG->create_mode);
		}

		if(move_uploaded_file($_FILES['user_image']['tmp_name'],
		$GO_CONFIG->root_path.'public_files/'.$_SESSION['GO_SESSION']['username'].'/'.$_FILES['user_image']['name']))
		{
			$cms->save_language_image($language_id, smart_addslashes($GO_CONFIG->host.'public_files/'.$_SESSION['GO_SESSION']['username'].'/'.$_FILES['user_image']['name']));
		}
	}
	break;
}

require_once($GO_THEME->theme_path."header.inc");
echo '<form name="cms" method="post" action="'.$_SERVER['PHP_SELF'].'" enctype="multipart/form-data">';
echo '<input type="hidden" name="site_id" value="'.$site_id.'" />';
echo '<input type="hidden" name="close" value="false" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="link_back" value="'.$link_back.'" />';
echo '<input type="hidden" name="language_id" value="'.$language_id.'" />';
echo '<input type="hidden" name="task"  />';

$tabtable = new tabtable('language_tab', $cms_language, '100%', '400','100','',true);
$tabtable->add_tab('properties', $strProperties);
if($language_id > 0)
{
	$tabtable->add_tab('image', $cms_image);
}

$tabtable->print_head($return_to);

if($language_id > 0 && $task != 'save_language')
{
	$language = $cms->get_language($language_id);
	$name = $language['name'];
	$title = $language['title'];
	$keywords= $language['keywords'];
	$description= $language['description'];
	$sort_order= $language['sort_order'];
	$template_id = $language['template_id'];
	$language_code = $language['language_code'];
}else
{
	$name = isset($_POST['name']) ? smart_stripslashes($_POST['name']) : '';
	$title = isset($_POST['title']) ? smart_stripslashes($_POST['title']) : '';
	$keywords= isset($_POST['keywords']) ? smart_stripslashes($_POST['keywords']) : '';
	$description= isset($_POST['description']) ? smart_stripslashes($_POST['description']) : '';
	$sort_order= isset($_POST['sort_order']) ? smart_stripslashes($_POST['sort_order']) : '';
	$template_id = isset($_POST['template_id']) ? $_POST['template_id'] :'0';
	$language_code = isset($_POST['language_code']) ? $_POST['language_code'] : $GO_LANGUAGE->language['code'];
}

if ($cms->get_authorized_templates($GO_SECURITY->user_id) == 0)
{
	echo '<br />';
	echo $cms_no_themes;
	echo '<br /><br />';
	if($GO_MODULES->write_permission)
	{
		$button = new button($cmdOk, "javascript:document.location='".$GO_MODULES->url."index.php?tabindex=templates.inc';");
	}
}else
{
	switch($tabtable->get_active_tab_id())
	{
		case 'image':
		require_once('language_image.inc');
		break;
		case 'search_words':
		require_once('site_search_words.inc');
		break;

		default:

		if(isset($feedback))
		{
			echo $feedback;
		}
		?>
		
		<table>
		<tr>
			<td>
			<?php echo $strName; ?>:
			</td>
			<td>
			<input type="text" class="textbox" name="name" value="<?php echo htmlspecialchars($name); ?>" maxlength="100" style="width: 250" />
			</td>
		</tr>
		<tr>
			<td nowrap>
			<?php echo $cms_language; ?>:
			</td>
			<td>
			<?php
			$dropbox= new dropbox();
			$languages = $GO_LANGUAGE->get_languages();
			while($language = array_shift($languages))
			{
				$dropbox->add_value($language['code'], $language['description']);
			}
			$dropbox->print_dropbox("language_code", $language_code);
			?>
			</td>
		</tr>
		<tr>
			<td>
			<?php echo $cms_theme; ?>:
			</td>
			<td>
			<?php
			$dropbox=new dropbox();
			while ($cms->next_record())
			{
				if ((isset($site) && $cms->f('id') == $site['template_id']) ||
				$GO_SECURITY->has_permission($GO_SECURITY->user_id, $cms->f('acl_read')) ||
				$GO_SECURITY->has_permission($GO_SECURITY->user_id, $cms->f('acl_write')))
				{
					$dropbox->add_value($cms->f('id'), $cms->f('name'));
				}
			}
			$dropbox->print_dropbox('template_id', $template_id);
			?>
			</td>
		</tr>
		<tr>
			<td>
			<?php echo $cms_title; ?>:
			</td>
			<td>
			<input type="text" class="textbox" name="title" value="<?php echo htmlspecialchars($title); ?>" maxlength="100" style="width: 250" />
			</td>
		</tr>
		<tr>
			<td valign="top">
			<?php echo $strDescription; ?>:
			</td>
			<td>
			<textarea class="textbox" name="description" style="width: 250" rows="5"><?php echo htmlspecialchars($description); ?></textarea>
			</td>
		</tr>
		<tr>
			<td valign="top">
			<?php echo $cms_keywords; ?>:
			</td>
			<td>
			<textarea class="textbox" name="keywords" style="width: 250" rows="5"><?php echo htmlspecialchars($keywords); ?></textarea>
			</td>
		</tr>
		<tr>
			<td valign="top">
			<?php echo $cms_priority; ?>:
			</td>
			<td>
			<input type="text" class="textbox" name="sort_order" style="width: 250" value="<?php echo htmlspecialchars($sort_order); ?>" />
			</td>
		</tr>
		</table>
		<?php
		$button = new button($cmdOk, "javascript:document.forms[0].task.value='save_language';document.forms[0].close.value='true';document.forms[0].submit();");
		echo '&nbsp;&nbsp;';
		$button = new button($cmdApply, "javascript:document.forms[0].task.value='save_language';document.forms[0].submit();");
		echo '&nbsp;&nbsp;';
		$button = new button($cmdClose, "javascript:document.location='$return_to';");
		break;
	}
}

$tabtable->print_foot();
echo '</form>';
require_once($GO_THEME->theme_path."footer.inc");
?>
