<?php

/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once ("../../Group-Office.php");

//authenticate the user
$GO_SECURITY->authenticate();

//see if the user has access to this module
//for this to work there must be a module named 'example'
$GO_MODULES->authenticate('cms');

require_once ($GO_MODULES->class_path.'cms.class.inc');
$cms = new cms();

//get the language file
require_once ($GO_LANGUAGE->get_language_file('cms'));

$task = isset ($_REQUEST['task']) ? $_REQUEST['task'] : '';
$file_id = isset ($_REQUEST['file_id']) ? $_REQUEST['file_id'] : 0;
$folder_id = isset ($_REQUEST['folder_id']) ? $_REQUEST['folder_id'] : 0;
$link_back = 'edit.php?file_id='.$file_id.'&folder_id='.$folder_id;

if ($folder_id == 0 || $_SESSION['site_id'] == 0) {
	//no folder or site given so back off cowardly
	header('Location: index.php');
	exit ();
}

if ($task != '') {
	if ($file_id > 0) {
		$name = smart_addslashes(trim($_POST['name']));
		if ($name == '') {
			$feedback = '<p class="Error">'.$error_missing_field.'</p>';
		} else {
			$name .= '.html';
			$existing_id = $cms->file_exists($folder_id, $name);
			if ($existing_id && ($_POST['file_id'] != $existing_id)) {
				$feedback = '<p class="Error">'.$fbNameExists.'</p>';
			} else {
				$hot_item = isset ($_POST['hot_item']) ? '1' : '0';
				//fix for inserted iframes
				$content = preg_replace("'<iframe([^>]*)/>'si", "<iframe$1></iframe>", $_POST['content']);
				
				$title = (isset($_POST['title']) && $_POST['title'] != '' && !isset($_POST['auto_meta'])) ? 
						smart_addslashes($_POST['title']) : 
						addslashes($cms->get_title_from_html(smart_stripslashes($content), smart_stripslashes($_POST['title'])));
										
				$description = (isset($_POST['description']) && $_POST['description'] != '' && !isset($_POST['auto_meta'])) ? 
						smart_addslashes($_POST['description']) : 
						addslashes($cms->get_description_from_html(smart_stripslashes($content), smart_stripslashes($_POST['description'])));
						
				$keywords = (isset($_POST['keywords']) && $_POST['keywords'] != '' && !isset($_POST['auto_meta'])) ? 
						smart_addslashes($_POST['keywords']) : 
						addslashes($cms->get_keywords_from_html(smart_stripslashes($content), smart_stripslashes($_POST['keywords'])));
				
				$auto_meta = isset($_POST['auto_meta']) ? '1' : '0';
				
				$cms->update_file($file_id, $name, smart_addslashes($content), $auto_meta, $title, $description, $keywords, $hot_item);

			}
		}
	} else {
		$name = smart_addslashes(trim($_POST['name']));
		if ($name == '') {
			$feedback = '<p class="Error">'.$error_missing_field.'</p>';
		} else {
			$filename = $name.'.html';

			if ($cms->file_exists($folder_id, $filename)) {
				$feedback = '<p class="Error">'.$fbNameExists.'</p>';
			}
			elseif (!$file_id = $cms->add_file($folder_id, $filename, smart_addslashes($_POST['content']), '', '', '')) {
				$feedback = '<p class="Error">'.$strSaveError.'</p>';
			}
		}
	}
}

if ($file_id > 0) {
	$file = $cms->get_file($file_id);	
} else {
	require_once ($GO_THEME->theme_path."header.inc");
	require_once ("add_file.inc");
	require_once ($GO_THEME->theme_path."footer.inc");
	exit ();
}

//set the page title for the header file
$page_title = $lang_modules['cms'];

//get the site template
if ($site = $cms->get_site($_SESSION['site_id'])) {
	$language = $cms->get_language($_SESSION['language_id']);
	$template = $cms->get_template($language['template_id']);
}

$pagestyle = (isset ($template)) ? $template['additional_style'] : '';
$pagestyle = str_replace("\r", '', $pagestyle);
$pagestyle = str_replace("\n", '', $pagestyle);
$pagestyle = str_replace("\t", '', $pagestyle);
$pagestyle = str_replace("'", '"', $pagestyle);
//$pagestyle = str_replace(' ', '', $pagestyle);

//create htmlarea
$htmlarea = new htmlarea();
$htmlarea->add_button('insert', $cms_insert_file, $GO_CONFIG->control_url.'htmlarea/images/go_image.gif', 'false', "function insertObject()
    {
    popup('select.php?site_id=".$_SESSION['site_id']."', '600', '400');
    }");
$com_plugin = $GO_MODULES->get_plugin('components');
if ($com_plugin) {
	$htmlarea->add_button('insert_reg', $cms_insert_component, $GO_CONFIG->control_url.'htmlarea/images/component.gif', 'false', "function insert_component()
	    {
	    popup('".$com_plugin['url']."select.php?site_id=".$_SESSION['site_id']."', '300', '400');
	    }");

}

$GO_HEADER['head'] = $htmlarea->get_header('content', -470, -125, 25, $pagestyle, "config.baseURL='';", true, $template['restrict_editor'], 'cms/'.$_SESSION['site_id'].'/images/');
$GO_HEADER['body_arguments'] = 'onload="initEditor()"';

//require the header file. This will draw the logo's and the menu
require_once ($GO_THEME->theme_path."header.inc");

//echo '<table border="0" cellpadding="10" cellspacing="0"><tr><td>';
if (isset ($feedback))
	echo $feedback;
echo '<form method="post" name="editor" action="'.$_SERVER['PHP_SELF'].'">';

echo '<input type="hidden" name="file_id" value="'.$file['id'].'" />';
echo '<input type="hidden" name="folder_id" value="'.$file['folder_id'].'" />';
echo '<input type="hidden" name="unedited" value="" />';
echo '<input type="hidden" name="task" value="save" />';
echo '<input type="hidden" name="delete_search_word_id" value="" />';

echo '<table border="0">';
echo '<td class="ModuleIcons" nowrap>';
echo '<a href="javascript:_save(\'save\');"><img src="'.$GO_THEME->images['save_big'].'" border="0" height="32" width="32" /><br />'.$cmdSave.'</a></td>';
if ($file_id > 0) {
	echo '<td class="ModuleIcons"  nowrap>';
	echo '<a class="small" href="properties.php?task=file_properties&file_id='.$file['id'].'&return_to='.urlencode($link_back).'&folder_id='.$file['folder_id'].'"><img src="'.$GO_THEME->images['properties'].'" border="0" height="32" width="32" /><br />'.$fbProperties.'</a></td>';

	echo '<td class="ModuleIcons" nowrap>';
	echo '<a class="small" target="_blank" href="view.php?site_id='.$_SESSION['site_id'].'&folder_id='.$file['folder_id'].'&file_id='.$file['id'].'" title="'.$cms_preview.' \''.$file['name'].'\'"><img src="'.$GO_THEME->images['magnifier_big'].'" border="0" /><br />'.$cms_preview.'</a></td>';
}
echo '<td class="ModuleIcons"  nowrap>';
echo '<a class="small" href="javascript:confirm_close(\''.$GO_MODULES->url.'browse.php?folder_id='.$file['folder_id'].'\')"><img src="'.$GO_THEME->images['close'].'" border="0" height="32" width="32" /><br />'.$cmdClose.'</a></td>';

echo '<td class="ModuleIcons" nowrap>';
echo '<a class="small" href=\'javascript:clean_editor_html()\'><img src="'.$GO_THEME->images['filters'].'" border="0" height="32" width="32" /><br />'.$cms_cleanup.'</a></td>';
echo '</table>';

echo '<table width="100%" cellpadding="0" cellspacing="0"><tr><td valign="top">';

$tabtable = new tabtable('cms_edit', htmlspecialchars(strip_extension($file['name'])));
$tabtable->print_head();
$htmlarea->print_htmlarea(htmlspecialchars($file['content']));
$tabtable->print_foot();

echo '</td><td>&nbsp;</td><td valign="top">';

$tabtable = new tabtable('cms_properties', $fbProperties, '400');
$tabtable->print_head();
?>
<table border="0">
<tr>	
	<td><?php echo $strName; ?>:</td>
	<td><input type="text" class="textbox" name="name" value="<?php echo htmlspecialchars(strip_extension($file['name'])); ?>" maxlength="100" style="width: 300px;" /></td>
</tr>
<tr>
	<td colspan="2">
	<?php
	$hot_item_check = ($file['hot_item'] == '1') ? true : false;
	$checkbox = new checkbox('hot_item', '1', $cms_hot_item, $hot_item_check);
	?>
	</td>
</tr>
</table>

<?php
$tabtable->print_foot();

echo '<br />';

$tabtable = new tabtable('cms_searchengine_info', $cms_searchengine_info, '400');
$tabtable->print_head();
?>
<table border="0">
<tr>
	<td colspan="2">
	<?php
	$auto_meta_check = ($file['auto_meta'] == '1') ? true : false;
	$checkbox = new checkbox('auto_meta', '1', $cms_autogenerate_searchengine_info, $auto_meta_check);
	?>
	</td>
</tr>
<tr>
	<td valign="top">
	<?php echo $strTitle; ?>:
	</td>
	<td>
	<textarea class="textbox" name="title" style="width: 300" rows="2" max_length="90"><?php echo htmlspecialchars($file['title']); ?></textarea>
	</td>
</tr>
<tr>
	<td valign="top">
	<?php echo $strDescription; ?>:
	</td>
	<td>
	<textarea class="textbox" name="description" style="width: 300" rows="5" max_length="250"><?php echo htmlspecialchars($file['description']); ?></textarea>
	</td>
</tr>
<tr>
	<td valign="top">
	<?php echo $cms_keywords; ?>:
	</td>
	<td>
	<textarea class="textbox" name="keywords" style="width: 300" rows="5" max_length="250"><?php echo htmlspecialchars($file['keywords']); ?></textarea>
	</td>
</tr>

</table>
<?php

$tabtable->print_foot();

echo '<br />';
echo '</td></tr></table>';
echo '</form>';
?>
  <script type="text/javascript">

  function clean_formatting()
  {
  	document.forms[0].task.value='clean_formatting';
  	document.forms[0].onsubmit();
  	document.forms[0].submit();
  }

  function confirm_close(URL)
  {
  	//TODO: detect if content has been changed
  	//if (confirm('<?php echo $cms_confirm_close; ?>'))
  	//{
  	document.location=URL;
  	//}
  }
  function delete_search_word(search_word_id, message)
  {
  	if(confirm(message))
  	{
	  	document.forms[0].delete_search_word_id.value = search_word_id;
	  	document.forms[0].task.value='delete_search_word';
	  	document.forms[0].onsubmit();
	  	document.forms[0].submit();
  	}
  }
  
  function _save(task)
  {
  	document.editor.task.value=task;;
  	document.editor.onsubmit();
  	document.editor.submit();
  }
</script>

<?php
require_once ($GO_THEME->theme_path."footer.inc");
?>