<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once($GO_LANGUAGE->get_language_file('calendar'));

//define the items to show_calendar
$calendar_max_rows = isset($_REQUEST['calendar_max_rows']) ? $_REQUEST['calendar_max_rows'] : $_SESSION['GO_SESSION']['max_rows_list'];
$calendar_first = isset($_REQUEST['calendar_first']) ? $_REQUEST['calendar_first'] : 0;

//define load parameters
$user_id = isset($user_id) ? $user_id : 0;
$project_id = isset($project_id) ? $project_id : 0;
$contact_id = isset($contact_id) ? $contact_id : 0;
$company_id = isset($company_id) ? $company_id : 0;

$cal_settings = $cal->get_settings($GO_SECURITY->user_id);

if(isset($_REQUEST['new_calendar_sort_order']) && $_REQUEST['new_calendar_sort_order'] != $cal_settings['sort_order'])
{
	$cal_settings['sort_order'] = $_REQUEST['new_calendar_sort_order'];
	$cal_settings['sort_field'] = $_REQUEST['new_calendar_sort_field'];
	$cal->update_settings($cal_settings);
}

if ($cal_settings['sort_order'] == "DESC")
{
	$sort_arrow = '&nbsp;<img src="'.$GO_THEME->images['arrow_down'].'" border="0" />';
	$new_calendar_sort_order = "ASC";
}else
{
	$sort_arrow = '&nbsp;<img src="'.$GO_THEME->images['arrow_up'].'" border="0" />';
	$new_calendar_sort_order = "DESC";
}



$count = $cal->get_events(0, 0, $user_id, $contact_id, $company_id, $project_id,
0,0, $cal_settings['sort_field'], $cal_settings['sort_order'],
$calendar_first, $calendar_max_rows);

echo '<input type="hidden" name="calendar_first" value="'.$calendar_first.'" />';
echo '<input type="hidden" name="calendar_max_rows" value="'.$calendar_max_rows.'" />';
echo '<input type="hidden" name="new_calendar_sort_field" value="'.$cal_settings['sort_field'].'" />';
echo '<input type="hidden" name="new_calendar_sort_order" value="'.$cal_settings['sort_order'].'" />';


$str_count = $count == 1 ? $cal_count_single : $cal_count_multiple;
echo '<div class="small" style="text-align:right;">'.$count.' '.$str_count.'</div>';

echo '<table class="go_table" width="100%">';
echo '<tr height="20">'.
'<th><a'.
'	href="javascript:calendar_sort(\'name\',\''.$new_calendar_sort_order.'\');">'.
$strName.'</a>';
if ($cal_settings['sort_field'] == 'name')
{
	echo $sort_arrow;
}
echo '</th>'.
'<th><a'.
'	href="javascript:calendar_sort(\'start_time\',\''.$new_calendar_sort_order.'\');">'.
$sc_start_at.'</a>';
if ($cal_settings['sort_field'] == 'start_time')
{
	echo $sort_arrow;
}
echo '</th>'.
'<th><a'.
'	href="javascript:calendar_sort(\'end_time\',\''.$new_calendar_sort_order.'\');">'.
$sc_end_at.'</a>';
if ($cal_settings['sort_field'] == 'end_time')
{
	echo $sort_arrow;
}
echo '</th>'.
'<th><a'.
'	href="javascript:calendar_sort(\'repeat_type\',\''.$new_calendar_sort_order.'\');">'.
$sc_recur_section.'</a>';
if ($cal_settings['sort_field'] == 'repeat_type')
{
	echo $sort_arrow;
}
echo '</th>'.
'<th>&nbsp;</th></tr>';

if ($count > 0)
{
	while($cal->next_record())
	{
		echo '<tr style="background-color: #'.$cal->f('background').'"><td><a class="normal" href="'.$GO_MODULES->modules['calendar']['url'].'event.php?event_id='.$cal->f('id').'&return_to='.rawurlencode($link_back).'">'.htmlspecialchars($cal->f('name')).'</a>';
		if($cal->f('description'))
		{
			echo '<div class="description">'.text_to_html($cal->f('description')).'</div>';
		}
		echo '</td>';		
		echo '<td nowrap>'.date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], gmt_to_local_time($cal->f('start_time'))).'&nbsp;</td>';
		echo '<td nowrap>'.date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], gmt_to_local_time($cal->f('end_time'))).'&nbsp;</td>';

		echo '<td nowrap>'.$sc_types[$cal->f('repeat_type')];

		if($cal->f('repeat_type') > 0)
		{
			if($cal->f('repeat_forever') == '1')
			{
				echo ' '.$cal_forever;
			}else
			{
				echo ' '.$cal_until.' '.date($_SESSION['GO_SESSION']['date_format'], gmt_to_local_time($cal->f('repeat_end_time')));
			}
		}

		echo '&nbsp;</td>';

		echo '<td align="right"><a href="'.$GO_MODULES->modules['calendar']['url'].'delete_event.php?event_id='.$cal->f('id').'&return_to='.urlencode($link_back).'" title="'.$strDeleteItem.' \''.htmlspecialchars($cal->f('name')).'\'"><img src="'.$GO_THEME->images['delete'].'" border="0"></a></td>';
	}

	$links = '';
	$max_links=10;
	if ($calendar_max_rows != 0)
	{
		if ($count > $calendar_max_rows)
		{
			$links = '<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr><td>';
			$next_start = $calendar_first+$calendar_max_rows;
			$previous_start = $calendar_first-$calendar_max_rows;
			if ($calendar_first != 0)
			{
				$links .= '<a href="javascript:calendar_change_list(0, '.$calendar_max_rows.');">&lt&lt</a>&nbsp;';
				$links .= '<a href="javascript:calendar_change_list('.$previous_start.', '.$calendar_max_rows.');">'.$cmdPrevious.'</a>&nbsp;';
			}else
			{
				$links .= '<font color="#cccccc">&lt&lt '.$cmdPrevious.'</font>&nbsp;';
			}

			$start = ($calendar_first-(($max_links/2)*$calendar_max_rows));

			$end = ($calendar_first+(($max_links/2)*$calendar_max_rows));

			if ($start < 0)
			{
				$end = $end - $start;
				$start=0;
			}
			if ($end > $count)
			{
				$end = $count;
			}
			if ($start > 0)
			{
				$links .= '...&nbsp;';
			}

			for ($i=$start;$i<$end;$i+=$calendar_max_rows)
			{
				$page = ($i/$calendar_max_rows)+1;
				if ($i==$calendar_first)
				{
					$links .= '<b><i>'.$page.'</i></b>&nbsp;';
				}else
				{
					$links .= '<a href="javascript:calendar_change_list('.$i.', '.$calendar_max_rows.');">'.$page.'</a>&nbsp;';
				}
			}

			if ($end < $count)
			{
				$links .= '...&nbsp;';
			}

			$last_page = floor($count/$calendar_max_rows)*$calendar_max_rows;

			if ($count > $next_start)
			{
				$links .= '<a href="javascript:calendar_change_list('.$next_start.', '.$calendar_max_rows.');">'.$cmdNext.'</a>&nbsp;';
				$links .= '<a href="javascript:calendar_change_list('.$last_page.', '.$calendar_max_rows.');">&gt&gt</a>';
			}else
			{
				$links .= '<font color="#cccccc">'.$cmdNext.' &gt&gt</font>';
			}
			$links .= '</td><td align="right"><a class="normal" href="javascript:calendar_change_list(0, 0);">'.$cmdShowAll.'</a></td></tr></table>';

			echo '<tr height="20"><td colspan="99">'.$links.'</td></tr>';
		}
	}

}else
{
	echo '<tr><td colspan="99">'.$sc_no_events.'</td></tr>';
}
echo '</table>';
?>
<script type="text/javascript">
function calendar_change_list(calendar_first, calendar_max_rows)
{
	document.forms[0].calendar_first.value=calendar_first;
	document.forms[0].calendar_max_rows.value=calendar_max_rows;
	document.forms[0].submit();
}

function calendar_sort(field, direction)
{
	document.forms[0].new_calendar_sort_field.value=field;
	document.forms[0].new_calendar_sort_order.value=direction;
	document.forms[0].submit();
}


function set_completed(todo_id)
{
	document.forms[0].completed_todo_id.value=todo_id;
	document.forms[0].submit();
}

function delete_todo(id)
{
	document.forms[0].delete_todo_id.value=id;
	document.forms[0].submit();
}
</script>
