<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once ("../../Group-Office.php");

require_once ($GO_CONFIG->class_path.'mail/RFC822.class.inc');
$RFC822 = new RFC822();

//check for the addressbook module
$ab_module = isset ($GO_MODULES->modules['addressbook']) ? $GO_MODULES->modules['addressbook'] : false;
if ($ab_module) {
	require_once ($ab_module['class_path'].'addressbook.class.inc');
	$ab = new addressbook();
}

$projects_module = isset ($GO_MODULES->modules['projects']) ? $GO_MODULES->modules['projects'] : false;
if ($projects_module) {
	require_once ($projects_module['class_path'].'projects.class.inc');
	$projects = new projects();
}

$fs_module = isset ($GO_MODULES->modules['filesystem']) ? $GO_MODULES->modules['filesystem'] : false;
if ($fs_module) {
	require_once ($GO_CONFIG->class_path.'filesystem.class.inc');
	$fs = new filesystem();
}

//get the local times
$local_time = get_time();
$year = isset ($_REQUEST['year']) ? $_REQUEST['year'] : date("Y", $local_time);
$month = isset ($_REQUEST['month']) ? $_REQUEST['month'] : date("n", $local_time);
$day = isset ($_REQUEST['day']) ? $_REQUEST['day'] : date("j", $local_time);
$hour = isset ($_REQUEST['hour']) ? $_REQUEST['hour'] : date("H", $local_time);
$min = isset ($_REQUEST['min']) ? $_REQUEST['min'] : date("i", $local_time);

$hours = array ("00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23");
$mins = array ("00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55");

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('calendar');
require_once ($GO_LANGUAGE->get_language_file('calendar'));

require_once ($GO_MODULES->class_path.'calendar.class.inc');
$cal = new calendar();

$task = isset ($_POST['task']) ? $_POST['task'] : '';
$return_to = isset ($_REQUEST['return_to']) ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];
$link_back = isset ($_REQUEST['link_back']) ? $_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];

$settings = $cal->get_settings($GO_SECURITY->user_id);

$calendar_id = isset ($_REQUEST['calendar_id']) ? $_REQUEST['calendar_id'] : $settings['default_cal_id'];

//get the given calendar
if ($calendar_id > 0) {
	$calendar = $cal->get_calendar($calendar_id);
} else {
	$calendar = false;
}

$event_id = isset ($_REQUEST['event_id']) ? $_REQUEST['event_id'] : 0;
$send_invitation = isset ($_POST['send_invitation']) ? true : false;

if ($task == 'save_event') {
	$event['project_id'] = isset ($_REQUEST['project_id']) ? $_REQUEST['project_id'] : 0;
	$event['company_id'] = isset ($_REQUEST['company_id']) ? $_REQUEST['company_id'] : 0;
	$event['contact_id'] = isset ($_REQUEST['contact_id']) ? $_REQUEST['contact_id'] : 0;

	if (isset ($_POST['id']['type'])) {
		switch ($_POST['id']['type']) {
			case 'project' :
				$event['project_id'] = $_POST['id']['value'];
				break;
			case 'contact' :
				$event['contact_id'] = $_POST['id']['value'];
				break;
			case 'company' :
				$event['company_id'] = $_POST['id']['value'];
				break;
		}
	}

	$event['name'] = smart_addslashes(trim($_POST['name']));
	$event['description'] = smart_addslashes(trim($_POST['description']));
	$event['location'] = smart_addslashes(trim($_POST['location']));
	
	if ($event['name'] == '') {
		$feedback = '<p class="Error">'.$error_missing_field.'</p>';
	}
	elseif (!isset ($_POST['calendars']) || count($_POST['calendars']) == 0) {
		$feedback = '<p class="Error">'.$sc_select_calendar_please.'</p>';
	} else {
		$timezone_offset = get_timezone_offset(date_to_unixtime($_POST['start_date']));

		$event['repeat_forever'] = isset ($_POST['repeat_forever']) ? '1' : '0';
		$event['repeat_every'] = isset ($_POST['repeat_every']) ? $_POST['repeat_every'] : '0';
		$event['month_time'] = isset ($_POST['month_time']) ? $_POST['month_time'] : '0';
		$event['background'] = $_POST['background'];

		$event['reminder'] = $_POST['reminder_multiplier'] * $_POST['reminder_value'];
		if (isset ($_POST['all_day_event'])) {
			$event['all_day_event'] = '1';
			$start_hour = 0 - $timezone_offset;
			$start_min = '0';
			$end_hour = 23 - $timezone_offset;
			$end_min = 59;

			$event['start_time'] = date_to_unixtime($_POST['start_date'].' '.$start_hour.':'.$start_min);
			$event['end_time'] = date_to_unixtime($_POST['end_date'].' '.$end_hour.':'.$end_min);
		} else {
			$event['all_day_event'] = '0';
			$start_min = $_POST['start_min'];
			$start_hour = $_POST['start_hour'];
			$end_hour = $_POST['end_hour'];
			$end_min = $_POST['end_min'];

			$event['start_time'] = get_gmt_time(date_to_unixtime($_POST['start_date'].' '.$start_hour.':'.$start_min));
			$event['end_time'] = get_gmt_time(date_to_unixtime($_POST['end_date'].' '.$end_hour.':'.$end_min));

		}

		$timezone_offset = get_timezone_offset($event['start_time']);
		
		$event['repeat_type'] = $_POST['repeat_type'];
		if ($event['repeat_type'] != REPEAT_NONE) {
			$event['repeat_end_time'] = isset ($_POST['repeat_forever']) ? '0' : date_to_unixtime($_POST['repeat_end_date']);
		} else {
			$event['repeat_end_time'] = 0;
		}

		$shift_day = 0;
		//shift the selected weekdays to GMT time
		//if (!isset($_POST['all_day_event']))
		//{
		$shifted_start_hour = $start_hour - $timezone_offset;
		if ($shifted_start_hour > 23) {
			$shifted_start_hour = $shifted_start_hour -24;
			$shift_day = 1;
		}
		elseif ($shifted_start_hour < 0) {
			$shifted_start_hour = 24 + $shifted_start_hour;
			$shift_day = -1;
		}
		//}

		switch ($shift_day) {
			case 0 :
				$event['mon'] = isset ($_POST['repeat_days_1']) ? '1' : '0';
				$event['tue'] = isset ($_POST['repeat_days_2']) ? '1' : '0';
				$event['wed'] = isset ($_POST['repeat_days_3']) ? '1' : '0';
				$event['thu'] = isset ($_POST['repeat_days_4']) ? '1' : '0';
				$event['fri'] = isset ($_POST['repeat_days_5']) ? '1' : '0';
				$event['sat'] = isset ($_POST['repeat_days_6']) ? '1' : '0';
				$event['sun'] = isset ($_POST['repeat_days_0']) ? '1' : '0';
				break;

			case 1 :
				$event['mon'] = isset ($_POST['repeat_days_0']) ? '1' : '0';
				$event['tue'] = isset ($_POST['repeat_days_1']) ? '1' : '0';
				$event['wed'] = isset ($_POST['repeat_days_2']) ? '1' : '0';
				$event['thu'] = isset ($_POST['repeat_days_3']) ? '1' : '0';
				$event['fri'] = isset ($_POST['repeat_days_4']) ? '1' : '0';
				$event['sat'] = isset ($_POST['repeat_days_5']) ? '1' : '0';
				$event['sun'] = isset ($_POST['repeat_days_6']) ? '1' : '0';
				break;

			case -1 :
				$event['mon'] = isset ($_POST['repeat_days_2']) ? '1' : '0';
				$event['tue'] = isset ($_POST['repeat_days_3']) ? '1' : '0';
				$event['wed'] = isset ($_POST['repeat_days_4']) ? '1' : '0';
				$event['thu'] = isset ($_POST['repeat_days_5']) ? '1' : '0';
				$event['fri'] = isset ($_POST['repeat_days_6']) ? '1' : '0';
				$event['sat'] = isset ($_POST['repeat_days_0']) ? '1' : '0';
				$event['sun'] = isset ($_POST['repeat_days_1']) ? '1' : '0';
				break;
		}

		if ($event_id > 0) {
			$event['id'] = $event_id;
			
			if (!$cal->update_event($event)) {
				$feedback = '<p class="Error">'.$strSaveError.'</p>';
			} else {

				if ($event = $cal->get_event($event_id)) {
					switch ($_POST['permissions']) {
						case 'everybody_read' :
							$GO_SECURITY->delete_group_from_acl($GO_CONFIG->group_everyone, $event['acl_write']);
							if (!$GO_SECURITY->group_in_acl($GO_CONFIG->group_everyone, $event['acl_read'])) {
								$GO_SECURITY->add_group_to_acl($GO_CONFIG->group_everyone, $event['acl_read']);
							}
							break;

						case 'everybody_write' :
							$GO_SECURITY->delete_group_from_acl($GO_CONFIG->group_everyone, $event['acl_read']);
							if (!$GO_SECURITY->group_in_acl($GO_CONFIG->group_everyone, $event['acl_write'])) {
								$GO_SECURITY->add_group_to_acl($GO_CONFIG->group_everyone, $event['acl_write']);
							}
							break;

						case 'private' :
							$GO_SECURITY->delete_group_from_acl($GO_CONFIG->group_everyone, $event['acl_write']);
							$GO_SECURITY->delete_group_from_acl($GO_CONFIG->group_everyone, $event['acl_read']);
							break;
					}
				}
			}

		} else {
			$event['acl_read'] = $GO_SECURITY->get_new_acl('Event read');
			$event['acl_write'] = $GO_SECURITY->get_new_acl('Event read');

			if (!$event['acl_read']  || !$event['acl_write']  ||
				 !$event_id = $cal->add_event($event)) {
				 	
				$GO_SECURITY->delete_acl($event['acl_read'] );
				$GO_SECURITY->delete_acl($event['acl_write'] );
				$feedback = '<p class="Error">'.$strSaveError.'</p>';
			} else {
				$GO_SECURITY->add_user_to_acl($GO_SECURITY->user_id, $event['acl_write']);
				switch ($_POST['permissions']) {
					case 'everybody_read' :
						$GO_SECURITY->add_group_to_acl($GO_CONFIG->group_everyone, $event['acl_read']);
						break;
					case 'everybody_write' :
						$GO_SECURITY->add_group_to_acl($GO_CONFIG->group_everyone, $event['acl_write']);
						break;
				}
			}
		}
		if (!isset ($feedback)) {
			//enter the event in all selected calendars
			$cal2 = new calendar();
			$cal->get_authorized_calendars($GO_SECURITY->user_id);
			while ($cal->next_record()) {
				if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $cal->f('acl_write'))) {
					if (in_array($cal->f('id'), $_POST['calendars'])) {
						if (!$cal2->event_is_subscribed($event_id, $cal->f('id'))) {
							$cal2->subscribe_event($event_id, $cal->f('id'));
						}
					} else {
						if ($cal2->event_is_subscribed($event_id, $cal->f('id'))) {
							$cal2->unsubscribe_event($event_id, $cal->f('id'));
						}
					}
				}
			}

			$cal->delete_reminder($GO_SECURITY->user_id, $event_id);
			//set the reminder
			if ($event['reminder'] > 0) {
				$next_recurrence_time = $cal->get_next_recurrence_time($event_id);
				$remind_time = $next_recurrence_time - $event['reminder'];
				$cal->insert_reminder($GO_SECURITY->user_id, $event_id, $remind_time);
			}

			$participants = $RFC822->explode_address_list(smart_stripslashes($_POST['to']));
			$existing_participants = array ();
			$cal->get_participants($event_id);
			while ($cal->next_record()) {
				$existing_participants[] = $cal->f("email");
			}

			//if ((count($participants) > 0 && $send_invitation) || count($participants) > count($existing_participants)) {
			if (count($participants) > 0)
			{
				//send an invitation mail to all participants
				$mail_body = '<html><body>'.$sc_invited.'<br /><br />';
				$mail_body .= '<table border="0"><tr><td>'.$sc_title.':</td><td>'.$event['name'].'</td></tr>';

				if ($_POST['id'] > 0) {
					switch ($_POST['id']['type']) {
						case 'contact' :
							$mail_body .= '<tr><td>'.$strContact.':</td>';
							$mail_body .= '<td>'.show_contact($_POST['contact_id']).'</td></tr>';
							break;

						case 'company' :
							$mail_body .= '<tr><td>'.$strCompany.':</td>';
							$mail_body .= '<td>'.show_company($_POST['company_id']).'</td></tr>';
							break;

						case 'project' :

							break;
					}
				}
				if ($_POST['description'] != '') {
					$mail_body .= '<tr><td valign="top">'.$strDescription.':</td>';
					$mail_body .= '<td>'.text_to_html($_POST['description']).'</td></tr>';
				}

				if ($_POST['location'] != '') {
					$mail_body .= '<tr><td>'.$sc_location.':</td>';
					$mail_body .= '<td>'.text_to_html($_POST['location']).'</td></tr>';
				}

				$mail_body .= '<tr><td>'.$sc_type.':</td>';
				$mail_body .= '<td>'.$sc_types[$_POST['repeat_type']].'</td></tr>';

				//don't calculate timezone offset for all day events
				$timezone_offset_string = isset ($_POST['all_day_event']) ? 0 : $timezone_offset;
				if ($timezone_offset > 0) {
					$gmt_string = '\G\M\T +'.$timezone_offset_string;
				}
				elseif ($timezone_offset < 0) {
					$gmt_string = '\G\M\T -'.$timezone_offset_string;
				} else {
					$gmt_string = '\G\M\T';
				}

				if (isset ($_POST['all_day_event'])) {
					$event_datetime_format = $_SESSION['GO_SESSION']['date_format'];
				} else {
					$event_datetime_format = $_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'].' '.$gmt_string;
				}
				$event_time_format = $_SESSION['GO_SESSION']['time_format'].' '.$gmt_string;

				switch ($_POST['repeat_type']) {
					case REPEAT_NONE :

						$mail_body .= '<tr><td>'.$sc_start_at.':</td><td>'.date($event_datetime_format, $event['start_time'] + ($timezone_offset * 3600)).'</td></tr>';
						if ($event['end_time'] != $event['start_time']) {
							$mail_body .= '<tr><td>'.$sc_end_at.':</td><td>'.date($event_datetime_format, $event['end_time'] + ($timezone_offset * 3600)).'</td></tr>';
						}
						break;

					case REPEAT_WEEKLY :
						if (!isset ($_POST['all_day_event'])) {
							$mail_body .= '<tr><td>'.$sc_start_at.':</td><td>'.date($event_time_format, $event['start_time'] + ($timezone_offset * 3600)).'</td></tr>';
							if ($event['end_time'] != $event['start_time']) {
								$mail_body .= '<tr><td>'.$sc_end_at.':</td><td>'.date($event_time_format, $event['end_time'] + ($timezone_offset * 3600)).'</td></tr>';
							}
						}

						$mail_body .= '<tr><td>'.$sc_at_days.':</td><td>';

						$local_start_hour = date('H', $event['start_time'] - $timezone_offset) + ($timezone_offset / 3600);
						if ($local_start_hour > 23) {
							$local_start_hour = $local_start_hour -24;
							$shift_day = 1;
						}
						elseif ($local_start_hour < 0) {
							$local_start_hour = 24 + $local_start_hour;
							$shift_day = -1;
						} else {
							$shift_day = 0;
						}

						$event['days'] = array ();
						if (isset ($_POST['repeat_days_0'])) {
							$event['days'][] = $full_days[0 + $shift_day];
						}
						if (isset ($_POST['repeat_days_1'])) {
							$event['days'][] = $full_days[1 + $shift_day];
						}

						if (isset ($_POST['repeat_days_2'])) {
							$event['days'][] = $full_days[2 + $shift_day];
						}

						if (isset ($_POST['repeat_days_3'])) {
							$event['days'][] = $full_days[3 + $shift_day];
						}

						if (isset ($_POST['repeat_days_4'])) {
							$event['days'][] = $full_days[4 + $shift_day];
						}

						if (isset ($_POST['repeat_days_5'])) {
							$event['days'][] = $full_days[5 + $shift_day];
						}

						if (isset ($_POST['repeat_days_6'])) {
							$event['days'][] = $full_days[6] + $shift_day;
						}
						$mail_body .= implode(', ', $event['days']);

						$mail_body .= '</td></tr>';

						$mail_body .= '<tr><td>'.$sc_cycle_end.':</td><td>';
						if ($repeat_forever == '1') {
							$mail_body .= $sc_noend;
						} else {
							$mail_body .= date($_SESSION['GO_SESSION']['date_format'], $repeat_end_time);
						}
						$mail_body .= '</td></tr>';

						break;

					case REPEAT_DAILY :
						if (!isset ($_POST['all_day_event'])) {
							$mail_body .= '<tr><td>'.$sc_start_at.':</td><td>'.date($event_datetime_format, $event['start_time'] + ($timezone_offset * 3600)).'</td></tr>';
							$mail_body .= '<tr><td>'.$sc_end_at.':</td><td>'.date($event_datetime_format, $event['end_time'] + ($timezone_offset * 3600)).'</td></tr>';
						}
						$mail_body .= '<tr><td>'.$sc_cycle_end.':</td><td>';
						if (isset ($repeat_forever)) {
							$mail_body .= $sc_noend;
						} else {
							$mail_body .= date($_SESSION['GO_SESSION']['date_format'], $repeat_end_time);
						}
						$mail_body .= '</td></tr>';
						break;

					case REPEAT_MONTH_DATE :
						if (!isset ($_POST['all_day_event'])) {
							$mail_body .= '<tr><td>'.$sc_start_at.':</td><td>'.date($event_datetime_format, $event['start_time'] + ($timezone_offset * 3600)).'</td></tr>';
							if ($event['end_time'] != $event['start_time']) {
								$mail_body .= '<tr><td>'.$sc_end_at.':</td><td>'.date($event_datetime_format, $event['end_time'] + ($timezone_offset * 3600)).'</td></tr>';
							}
						} else {
							$mail_body .= '<tr><td>'.$sc_start_at.':</td><td>'.$sc_day.' '.date('d', $event['start_time']).'</td></tr>';
							$mail_body .= '<tr><td>'.$sc_end_at.':</td><td>'.$sc_day.' '.date('d', $event['start_time']).'</td></tr>';
						}

						$mail_body .= '<tr><td>'.$sc_cycle_end.':</td><td>';
						if ($repeat_forever == '1') {
							$mail_body .= $sc_noend;
						} else {
							$mail_body .= date($_SESSION['GO_SESSION']['date_format'], $repeat_end_time);
						}
						break;

					case REPEAT_MONTH_DAY :
						if (!isset ($_POST['all_day_event'])) {
							$mail_body .= '<tr><td>'.$sc_start_at.':</td><td>'.date($event_datetime_format, $event['start_time'] + ($timezone_offset * 3600)).'</td></tr>';
							if (isset ($repeat_forever)) {
								$mail_body .= '<tr><td>'.$sc_end_at.':</td><td>'.date($event_datetime_format, $event['end_time'] + ($timezone_offset * 3600)).'</td></tr>';
							}
						}

						$local_start_hour = date('H', $event['start_time'] - $timezone_offset) + ($timezone_offset / 3600);
						if ($local_start_hour > 23) {
							$local_start_hour = $local_start_hour -24;
							$shift_day = 1;
						}
						elseif ($local_start_hour < 0) {
							$local_start_hour = 24 + $local_start_hour;
							$shift_day = -1;
						} else {
							$shift_day = 0;
						}

						if (isset ($_POST['repeat_days_0'])) {
							$event['days'][] = $full_days[0 + $shift_day];
						}
						if (isset ($_POST['repeat_days_1'])) {
							$event['days'][] = $full_days[1 + $shift_day];
						}

						if (isset ($_POST['repeat_days_2'])) {
							$event['days'][] = $full_days[2 + $shift_day];
						}

						if (isset ($_POST['repeat_days_3'])) {
							$event['days'][] = $full_days[3 + $shift_day];
						}

						if (isset ($_POST['repeat_days_4'])) {
							$event['days'][] = $full_days[4 + $shift_day];
						}

						if (isset ($_POST['repeat_days_5'])) {
							$event['days'][] = $full_days[5 + $shift_day];
						}

						if (isset ($_POST['repeat_days_6'])) {
							$event['days'][] = $full_days[6] + $shift_day;
						}
						$mail_body .= implode(', ', $event['days']);

						$mail_body .= '</td></tr>';

						$mail_body .= '<tr><td>'.$sc_cycle_end.':</td><td>';
						if ($repeat_forever == '1') {
							$mail_body .= $sc_noend;
						} else {
							$mail_body .= date($_SESSION['GO_SESSION']['date_format'], $repeat_end_time);
						}

						break;

					case REPEAT_YEARLY;
						if (!isset ($_POST['all_day_event'])) {
							$mail_body .= '<tr><td>'.$sc_start_at.':</td><td>'.date($event_datetime_format, $event['start_time'] + ($timezone_offset * 3600)).'</td></tr>';
							if ($event['end_time'] != $event['start_time']) {
								$mail_body .= '<tr><td>'.$sc_end_at.':</td><td>'.date($event_datetime_format, $event['end_time'] + ($timezone_offset * 3600)).'</td></tr>';
							}
						} else {
							$mail_body .= '<tr><td>'.$sc_start_at.':</td><td>'.$sc_day.' '.date('d', $event['start_time']).'</td></tr>';
							$mail_body .= '<tr><td>'.$sc_end_at.':</td><td>'.$sc_day.' '.date('d', $event['start_time']).'</td></tr>';
						}

						$mail_body .= '<tr><td>'.$sc_cycle_end.':</td><td>';
						if ($repeat_forever == '1') {
							$mail_body .= $sc_noend;
						} else {
							$mail_body .= date($_SESSION['GO_SESSION']['date_format'], $repeat_end_time);
						}

						break;
				}

				$mail_body .= '</table><br /><br />'.$sc_accept_question.'<br /><br />';

				require_once ($GO_CONFIG->class_path."mail/phpmailer/class.phpmailer.php");
				require_once ($GO_CONFIG->class_path."mail/phpmailer/class.smtp.php");
				$mail = new PHPMailer();
				$mail->PluginDir = $GO_CONFIG->class_path.'mail/phpmailer/';
				$mail->SetLanguage($php_mailer_lang, $GO_CONFIG->class_path.'mail/phpmailer/language/');

				switch ($GO_CONFIG->mailer) {
					case 'smtp' :
						$mail->Host = $GO_CONFIG->smtp_server;
						$mail->Port = $GO_CONFIG->smtp_port;
						$mail->IsSMTP();
						break;
					case 'qmail' :
						$mail->IsQmail();
						break;
					case 'sendmail' :
						$mail->IsSendmail();
						break;
					case 'mail' :
						$mail->IsMail();
						break;
				}

				$mail->Sender = $_SESSION['GO_SESSION']["email"];
				$mail->From = $_SESSION['GO_SESSION']["email"];
				$mail->FromName = $_SESSION['GO_SESSION']["name"];
				$mail->AddReplyTo($_SESSION['GO_SESSION']["email"], $_SESSION['GO_SESSION']["name"]);
				$mail->WordWrap = 76;
				$mail->IsHTML(true);
				$mail->Subject = $event['name'];

				require_once ($GO_MODULES->class_path.'go_ical.class.inc');
				$ical = new go_ical();

				$ics_string = $ical->export_event($event_id);
				if ($ics_string) {
					$mail->AddStringAttachment($ics_string, $event['name'].'.ics', 'base64', 'text/calendar');
				}

				
				for ($i = 0; $i < sizeof($participants); $i ++) {
					$addresses = $RFC822->parse_address_list($participants[$i]);

					if ($send_invitation || !in_array($addresses[0]['email'], $existing_participants)) {

						$id = 0;
						if ($user_profile = $GO_USERS->get_user_by_email($addresses[0]['email'])) {
							$id = $user_profile["id"];
						}
						elseif (!$user_profile && $ab_module) {
							$user_profile = $ab->get_contact_by_email($addresses[0]['email'], $GO_SECURITY->user_id);
							$id = $user_profile["source_id"];
						}

						if ($id == 0) {
							$nouser_link = '<p><a href="'.$GO_MODULES->full_url.'accept.php?event_id='.$event_id.'&member=false&email='.urlencode($addresses[0]['email']).'" class="blue">'.$sc_accept.'</a>&nbsp;|&nbsp;<a href="'.$GO_MODULES->full_url.'decline.php?event_id='.$event_id.'&member=false&email='.urlencode($addresses[0]['email']).'" class="blue">'.$sc_decline.'</a></p>';

							$mail->Body = $mail_body.$nouser_link;
							$mail->ClearAllRecipients();
							$mail->AddAddress($addresses[0]['email'],$addresses[0]['personal']);

							if ($mail->Send() && !in_array($addresses[0]['email'], $existing_participants)) {
								$cal->add_participant($event_id, addslashes($addresses[0]['personal']), $addresses[0]['email']);
							}
						} else {
							$user_link = '<p class="cmd"><a href="'.$GO_CONFIG->full_url.'index.php?return_to='.urlencode($GO_MODULES->url.'accept.php?event_id='.$event_id.'&member=true&email='.urlencode($addresses[0]['email'])).'" class="blue">'.$sc_accept.'</a>&nbsp;|&nbsp;<a href="'.$GO_CONFIG->full_url.'index.php?return_to='.urlencode($GO_MODULES->url.'decline.php?event_id='.$event_id.'&member=true&email='.urlencode($addresses[0]['email'])).'" class="blue">'.$sc_decline.'</a></p>';

							if ($GO_SECURITY->user_id != $id) {
								$mail->Body = $mail_body.$user_link;
								$mail->ClearAllRecipients();
								$mail->AddAddress($addresses[0]['email'],$addresses[0]['personal']);
								if ($mail->Send() && !in_array($addresses[0]['email'], $existing_participants)) {
									$cal->add_participant($event_id, addslashes($addresses[0]['personal']), $addresses[0]['email'], $id);
								}
							} else {
								if(!in_array($addresses[0]['email'], $existing_participants))
								{
									$cal->add_participant($event_id, addslashes($addresses[0]['personal']), $addresses[0]['email'], $id);
									$cal->set_event_status($event_id, '1', $addresses[0]['email']);
								}								
							}
						}
					}
				}				
			}
			$participants_emails = array();
			for($i=0;$i<count($participants);$i++)
			{
				$addresses = $RFC822->parse_address_list($participants[$i]);
				$participants_emails[] = $addresses[0]['email'];
			}
			
			for($i=0;$i<count($existing_participants);$i++)
			{					
				if(!in_array($existing_participants[$i], $participants_emails))
				{
					$cal->delete_participant($event_id, addslashes($existing_participants[$i]));
				} 
			}
		
			$send_invitation = false;
			if ($_POST['close'] == 'true') {
				header('Location: '.$return_to);
				exit ();
			} else {
				$task = '';
			}
		}
	}
}

if ($event_id > 0 && $task != 'save_event' && $task != 'change_event') {
	if (isset ($_POST['new_event']) && $_POST['new_event'] == 'true') {
		//reset all event related form fields
		unset ($event, $_POST['name'], $_POST['description'], $_POST['location'], $_POST['reminder'], $_POST['background'], $_POST['permissions'], $_POST['repeat_type'], $_POST['repeat_end_date'], $_POST['repeat_forever'], $_POST['repeat_every'], $_POST['all_day_event'], $_POST['month_time'], $_POST['repeat_days_0'], $_POST['repeat_days_1'], $_POST['repeat_days_2'], $_POST['repeat_days_3'], $_POST['repeat_days_4'], $_POST['repeat_days_5'], $_POST['repeat_days_6']);
		$event_id = 0;
		$event['project_id'] = isset ($_REQUEST['project_id']) ? $_REQUEST['project_id'] : 0;
		$event['company_id'] = isset ($_REQUEST['company_id']) ? $_REQUEST['company_id'] : 0;
		$event['contact_id'] = isset ($_REQUEST['contact_id']) ? $_REQUEST['contact_id'] : 0;

		if (isset ($_POST['id_type'])) {
			switch ($_POST['id_type']) {
				case 'project' :
					$event['project_id'] = $_POST['id'];
					break;
				case 'contact' :
					$event['contact_id'] = $_POST['id'];
					break;
				case 'company' :
					$event['company_id'] = $_POST['id'];
					break;
			}
		}
	} else {
		//get the event
		$event = $cal->get_event($event_id);
	}
}
elseif (isset ($_REQUEST['ical_file']) && file_exists($_REQUEST['ical_file'])) {
	$event = $cal->get_event_from_ical_file($_REQUEST['ical_file']);
	$ical = true;
}

if (($event_id > 0 || isset ($ical)) && isset ($event) && $event) {
	if ($event_id > 0 && !$event['write_permission'] = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $event['acl_write'])) {
		header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
		exit ();
	}

	//populate an address string of the participants
	$event['to'] = '';
	$cal->get_participants($event_id);
	while ($cal->next_record()) {
		if ($event['to'] == '') {
			$event['to'] = $RFC822->write_address($cal->f("name"), $cal->f("email"));
		} else {
			$event['to'] .= ', '.$RFC822->write_address($cal->f("name"), $cal->f("email"));
		}
	}

	//$timezone_offset = get_timezone_offset($event['start_time']);

	//don't calculate timezone offset for all day events
	//$timezone_offset = ($event['all_day_event'] == '0') ? ($timezone_offset*3600) : 0;

	$timezone_offset = get_timezone_offset($event['start_time']) * 3600;

	$gmt_start_time = $event['start_time'];
	$event['start_time'] += $timezone_offset;
	$event['start_hour'] = date('G', $event['start_time']);
	$event['start_min'] = date('i', $event['start_time']);

	$event['end_time'] += $timezone_offset;
	$event['end_hour'] = date('G', $event['end_time']);
	$event['end_min'] = date('i', $event['end_time']);

	$event['start_date'] = date($_SESSION['GO_SESSION']['date_format'], $event['start_time']);
	$event['end_date'] = date($_SESSION['GO_SESSION']['date_format'], $event['end_time']);

	$event['repeat_end_date'] = date($_SESSION['GO_SESSION']['date_format'], $event['repeat_end_time']);

	if ($event['repeat_type'] != REPEAT_NONE) {
		if ($event['repeat_forever'] == '0') {
			$event['repeat_end_date'] = date($_SESSION['GO_SESSION']['date_format'], $event['repeat_end_time']+$timezone_offset);
		} else {
			$event['repeat_end_date'] = date($_SESSION['GO_SESSION']['date_format'], $event['end_time']);
		}
	} else {
		$event['repeat_end_date'] = date($_SESSION['GO_SESSION']['date_format'], $event['start_time']);
	}

	//to what calendars is this event subscribed?
	$event['calendars'] = array ();
	$cal->get_event_subscribtions($event_id);
	while ($cal->next_record()) {
		$event['calendars'][] = $cal->f('calendar_id');
	}

	//shift the selected weekdays to local time
	$local_start_hour = date("G", $gmt_start_time) + ($timezone_offset / 3600);
	if ($local_start_hour > 23) {
		$local_start_hour = $local_start_hour -24;
		$shift_day = 1;
	}
	elseif ($local_start_hour < 0) {
		$local_start_hour = 24 + $local_start_hour;
		$shift_day = -1;
	} else {
		$shift_day = 0;
	}

	switch ($shift_day) {
		case 1 :
			$mon = $event['sun'] == '1' ? '1' : '0';
			$tue = $event['mon'] == '1' ? '1' : '0';
			$wed = $event['tue'] == '1' ? '1' : '0';
			$thu = $event['wed'] == '1' ? '1' : '0';
			$fri = $event['thu'] == '1' ? '1' : '0';
			$sat = $event['fri'] == '1' ? '1' : '0';
			$sun = $event['sat'] == '1' ? '1' : '0';
			break;

		case -1 :
			$mon = $event['tue'] == '1' ? '1' : '0';
			$tue = $event['wed'] == '1' ? '1' : '0';
			$wed = $event['thu'] == '1' ? '1' : '0';
			$thu = $event['fri'] == '1' ? '1' : '0';
			$fri = $event['sat'] == '1' ? '1' : '0';
			$sat = $event['sun'] == '1' ? '1' : '0';
			$sun = $event['mon'] == '1' ? '1' : '0';
			break;

	}

	if ($shift_day != 0) {
		$event['sun'] = $sun;
		$event['mon'] = $mon;
		$event['tue'] = $tue;
		$event['wed'] = $wed;
		$event['thu'] = $thu;
		$event['fri'] = $fri;
		$event['sat'] = $sat;
	}

	$title = htmlspecialchars($event['name']);

	if ($event_id > 0) {
		if ($GO_SECURITY->group_in_acl($GO_CONFIG->group_everyone, $event['acl_read'])) {
			$event['permissions'] = 'everybody_read';
		}
		elseif ($GO_SECURITY->group_in_acl($GO_CONFIG->group_everyone, $event['acl_write'])) {
			$event['permissions'] = 'everybody_write';
		} else {
			$event['permissions'] = 'private';
		}
	} else {
		$event['permissions'] = 'everybody_read';
	}
} else {
	$title = $sc_new_app;
	$requested_time = mktime($hour, $min, 0, $month, $day, $year);

	$timezone_offset = get_timezone_offset($requested_time);

	$requested_date = date($_SESSION['GO_SESSION']['date_format'], $requested_time);
	//new event declare all vars
	$event['calendars'] = isset ($_POST['calendars']) ? $_POST['calendars'] : array ();
	$event['description'] = isset ($_POST['description']) ? smart_stripslashes($_POST['description']) : '';
	$event['name'] = isset ($_POST['name']) ? smart_stripslashes($_POST['name']) : '';
	$event['to'] = isset ($_POST['to']) ? smart_stripslashes($_POST['to']) : '';
	$event['contact_id'] = isset ($_REQUEST['contact_id']) ? $_REQUEST['contact_id'] : '';
	$event['company_id'] = isset ($_REQUEST['company_id']) ? $_REQUEST['company_id'] : '';
	$event['project_id'] = isset ($_REQUEST['project_id']) ? $_REQUEST['project_id'] : '';

	if (isset ($_POST['id_type'])) {
		switch ($_POST['id_type']) {
			case 'project' :
				$event['project_id'] = $_POST['id'];
				break;
			case 'contact' :
				$event['contact_id'] = $_POST['id'];
				break;
			case 'company' :
				$event['company_id'] = $_POST['id'];
				break;
		}
	}

	$event['start_date'] = isset ($_POST['start_date']) ? smart_stripslashes($_POST['start_date']) : $requested_date;
	$tmp = (strlen($hour) == 1) ? '0'.$hour : $hour;

	$event['start_hour'] = isset ($_POST['start_hour']) ? $_POST['start_hour'] : $tmp;
	$event['start_min'] = isset ($_POST['start_min']) ? $_POST['start_min'] : $min;

	$event['end_date'] = isset ($_POST['end_date']) ? $_POST['end_date'] : $requested_date;
	$tmp = (strlen($hour +1) == 1) ? '0'.$hour +1 : $hour +1;
	$event['end_hour'] = isset ($_POST['end_hour']) ? $_POST['end_hour'] : $tmp;
	$event['end_min'] = isset ($_POST['end_min']) ? $_POST['end_min'] : $min;

	$event['repeat_end_date'] = isset ($_POST['repeat_end_date']) ? $_POST['repeat_end_date'] : $requested_date;

	$event['repeat_type'] = isset ($_POST['repeat_type']) ? $_POST['repeat_type'] : REPEAT_NONE;
	$event['all_day_event'] = isset ($_POST['all_day_event']) ? $_POST['all_day_event'] : '0';
	$event['repeat_forever'] = isset ($_POST['repeat_forever']) ? $_POST['repeat_forever'] : '0';
	$event['repeat_every'] = isset ($_POST['repeat_every']) ? $_POST['repeat_every'] : '0';
	$event['month_time'] = isset ($_POST['month_time']) ? $_POST['month_time'] : '0';

	$event['sun'] = isset ($_POST['repeat_days_0']) ? true : false;
	$event['mon'] = isset ($_POST['repeat_days_1']) ? true : false;
	$event['tue'] = isset ($_POST['repeat_days_2']) ? true : false;
	$event['wed'] = isset ($_POST['repeat_days_3']) ? true : false;
	$event['thu'] = isset ($_POST['repeat_days_4']) ? true : false;
	$event['fri'] = isset ($_POST['repeat_days_5']) ? true : false;
	$event['sat'] = isset ($_POST['repeat_days_6']) ? true : false;
	$event['reminder'] = isset ($_POST['reminder']) ? $_POST['reminder'] : '0';
	$default_background = $calendar ? $calendar['background'] : 'FFFFCC';
	$event['background'] = isset ($_POST['background']) ? $_POST['background'] : $default_background;
	$event['location'] = isset ($_POST['location']) ? smart_stripslashes($_POST['location']) : '';
	$event['permissions'] = isset ($_POST['permissions']) ? $_POST['permissions'] : 'everybody_read';
}

$datepicker = new date_picker();
$GO_HEADER['head'] = $datepicker->get_header();

if ($ab_module && $ab_module['read_permission']) {
	$ab->search_contacts($GO_SECURITY->user_id, '%');
	while ($ab->next_record()) {
		if (validate_email($ab->f('email'))) {
			$middle_name = $ab->f('middle_name') == '' ? ' ' : ' '.$ab->f('middle_name').' ';
			$autocomplete_contacts[] = '"'.addslashes($ab->f('first_name').$middle_name.$ab->f('last_name')).'" <'.$ab->f('email').'>';
		}
	}
	if (isset ($autocomplete_contacts) && count($autocomplete_contacts) > 0) {
		$GO_HEADER['head'] .= '<script language="javascript" type="text/javascript" src="'.$GO_CONFIG->host.'javascript/actb.js"></script>';
		$GO_HEADER['head'] .= '<script type="text/javascript">'.'var autocomplete_contacts = new Array(\''.implode("','", $autocomplete_contacts).'\');'.'</script>';
	}
}

$overlib = new overlib();
$GO_HEADER['head'] .= $overlib->get_header();

require_once ($GO_THEME->theme_path.'header.inc');

if ($ab_module) {
	$ab->enable_contact_selector();
}

echo '<form name="event_form" method="post" action="'.$_SERVER['PHP_SELF'].'">';
echo '<input type="hidden" name="calendar_id" value="'.$calendar_id.'" />';
echo '<input type="hidden" name="event_id" value="'.$event_id.'" />';

echo '<input type="hidden" name="close" value="false" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="link_back" value="'.$link_back.'" />';
echo '<input type="hidden" name="new_event" value="false" />';

//address_string used by the addressbok selector
echo '<input type="hidden" name="address_string" value="" />';

$tabtable = new tabtable('event_table', $title, '100%', '400', '120', '', true, 'left', 'top', 'event_form');
$tabtable->add_tab('properties', $strProperties);

if ($event_id > 0) {
	if ($cal->get_participants($event_id)) {
		$tabtable->add_tab('participants', $sc_participants);
	}
}
$tabtable->add_tab('availability', $strAvailability);

$tabtable->print_head($return_to);
//echo '<br />';
switch ($tabtable->get_active_tab_id()) {
	case 'availability' :
		echo '<input type="hidden" name="task" value="" />';
		require_once ('check_availability.inc');
		break;
	case 'participants' :
	
		if(isset($_POST['status']) && $_POST['status'] > -1)
		{
			$cal->set_event_status($event_id, $_POST['status'], $_SESSION['GO_SESSION']['email']);
		}
		echo '<input type="hidden" name="task" value="" />';

		echo '<input type="hidden" name="status" value="-1" />';
		echo '<table border="0">';
		echo '<tr><td><h3>'.$strName.'</td>';
		echo '<td><h3>'.$strEmail.'</td>';
		echo '<td><h3>'.$sc_status.'</td></tr>';
		
		$cal->get_participants($event_id);
		
		while ($cal->next_record()) {
			echo '<tr><td nowrap>';
			if ($cal->f('user_id') > 0) {
				echo show_profile($cal->f('user_id'), '', 'normal', $link_back);
			} else {
				echo show_profile_by_email(addslashes($cal->f('email')), '', $link_back).'&nbsp;</td>';
			}
			echo '<td nowrap>'.mail_to(empty_to_stripe(addslashes($cal->f('email'))), htmlspecialchars($cal->f('name'))).'&nbsp;</td><td>';
			switch ($cal->f('status')) {
				case '0' :
					echo $sc_not_responded;
					break;

				case '1' :
					echo $sc_accepted;
					break;

				case '2' :
					echo $sc_declined;
					break;

			}
			echo '</td></tr>';
		}
		echo '</table>';
		$status = $cal->get_event_status($event_id, $_SESSION['GO_SESSION']['email']);
		if ($status !== false) {
			echo '<br />';
			switch ($status) {
				case '0';
					$button = new button($sc_accept, "javascript:document.event_form.status.value=1;document.event_form.submit();");
					echo '&nbsp;&nbsp;';
					$button = new button($sc_decline, "javascript:document.event_form.status.value=2;document.event_form.submit();");
					break;

				case '1';
					$button = new button($sc_decline, "javascript:document.event_form.status.value=2;document.event_form.submit();");
					break;

				case '2';
					$button = new button($sc_accept, "javascript:document.event_form.status.value=1;document.event_form.submit();");
					break;
			}
		}
		echo '<br /><br />';
		$button = new button($cmdClose, "javascript:document.location='".$return_to."'");
		break;
	case 'read_permissions' :
		echo '<input type="hidden" name="task" value="" />';
		$read_only = ($event['user_id'] == $GO_SECURITY->user_id) ? false : true;
		print_acl($event['acl_read'], $read_only);
		echo '<br /><br />';
		$button = new button($cmdCancel, "javascript:document.location='".$return_to."'");
		break;

	case 'write_permissions' :
		echo '<input type="hidden" name="task" value="" />';

		$read_only = ($event['user_id'] == $GO_SECURITY->user_id) ? false : true;
		print_acl($event['acl_write'], $read_only);
		echo '<br /><br />';
		$button = new button($cmdCancel, "javascript:document.location='".$return_to."'");
		break;

	default :
		echo '<input type="hidden" name="task" value="change_event" />';
		echo '<table border="0" cellpadding="2" cellspacing="0" width="100%">';
		if (isset ($feedback))
			echo '<tr><td colspan="2" class="Error">'.$feedback.'</td></tr>';
		echo '<tr><td>'.$strName.':&nbsp;</td><td width="100%"><input type="text" class="textbox" maxlength="50" name="name" style="width: 100%;" value="'.htmlspecialchars($event['name']).'" /></td></tr>';

		$type = '';
		$value = '';
		if ($event['project_id'] > 0) {
			$type = 'project';
			$value = $event['project_id'];
		}
		elseif ($event['contact_id'] > 0) {
			$type = 'contact';
			$value = $event['contact_id'];
		}
		elseif ($event['company_id'] > 0) {
			$type = 'company';
			$value = $event['company_id'];
		}
		$select = new select($type, 'event_form', 'id', $value, array ('contact', 'company', 'project'), $link_back);

		echo '<tr><td nowrap>'.$select->get_link($strRelatedTo).':</td>'.'<td>'.$select->get_field().'</td></tr>';

		echo '<tr><td nowrap valign="top">';

		if ($ab_module && $ab_module['read_permission']) {
			$link = $ab->select_contacts('document.event_form.to', $GO_MODULES->url.'add_contacts.php');

			echo '<a class="normal" href="'.$link.'"><img src="'.$GO_THEME->images['addressbook_small'].'" width="16" '.'height="16" border="0" align="absmiddle" style="margin-right: 5px;" />'.$sc_participants.'</a>:&nbsp;</td>';
		} else {
			echo $sc_participants.":&nbsp;";
		}
		echo '<td nowrap><textarea ';
		if (isset ($autocomplete_contacts)) {
			echo 'onfocus="document.onkeypress = kH;" onkeydown="actb_checkkey(event);" onkeyup="actb_tocomplete(this,event,autocomplete_contacts)" onblur="actb_removedisp(this);document.onkeypress = \'\';"';
		}

		echo 'class="textbox" name="to" style="width: 100%; height: 50px;">'.htmlspecialchars($event['to']).'</textarea>';

		if ($event_id > 0) {
			echo '<br />';
			$checkbox = new checkbox('send_invitation', 'true', $cal_resend_invitation, $send_invitation);
		} else {
			echo '<input type="hidden" name="send_invitation" value="true" />';
		}

		echo '</td></tr>';

		echo '<tr><td nowrap>'.$sc_location.':</td>'.'<td><input type="text" class="textbox" style="width: 100%;"'.'name="location" value="'.htmlspecialchars($event['location']).'" /></td></tr>'.'<tr><td valign="top">'.$sc_description.':&nbsp;</td><td>'.'<textarea class="textbox" name="description" style="width: 100%; height: 80px;">'.htmlspecialchars($event['description']).'</textarea></td></tr>'.'<tr><td colspan="2">&nbsp;</td></tr>';

		echo '<tr><td nowrap>'.$sc_start_at.':&nbsp;</td><td>';
		echo '<table border="0" cellpadding="0" cellspacing="0"><tr><td>';

		$datepicker->print_date_picker('start_date', $_SESSION['GO_SESSION']['date_format'], $event['start_date'], '', '', 'onchange="javascript:check_date(\'start_date\');"');
		//$datepicker->print_date_picker('start_date', $_SESSION['GO_SESSION']['date_format'], $event['start_date']);

		echo '</td><td>&nbsp;&nbsp;';

		$dropbox = new dropbox();
		for ($i = 0; $i < 24; $i ++) {
			$dropbox->add_value($i, str_replace(':00', '', date($_SESSION['GO_SESSION']['time_format'], mktime($i, 0, 0))));
		}
		$dropbox->print_dropbox("start_hour", $event['start_hour'], 'onchange="javascript:update_end_hour();"');
		echo '&nbsp;:&nbsp;';
		$dropbox = new dropbox();
		$dropbox->add_arrays($mins, $mins);
		$dropbox->print_dropbox("start_min", $event['start_min'], 'onchange="javascript:document.event_form.end_min.value=this.value;"');

		echo '</td></tr></table>';
		echo '</td></tr>';

		echo '<tr><td nowrap>'.$sc_end_at.':&nbsp;</td><td>';

		echo '<table border="0" cellpadding="0" cellspacing="0"><tr><td>';
		$datepicker->print_date_picker('end_date', $_SESSION['GO_SESSION']['date_format'], $event['end_date'], '', '', 'onchange="javascript:check_date(\'end_date\');"');
		//$datepicker->print_date_picker('end_date', $_SESSION['GO_SESSION']['date_format'], $event['end_date']);
		echo '</td><td>&nbsp;&nbsp;';
		$dropbox = new dropbox();
		for ($i = 0; $i < 24; $i ++) {
			$dropbox->add_value($i, str_replace(':00', '', date($_SESSION['GO_SESSION']['time_format'], mktime($i, 0, 0))));
		}
		$dropbox->print_dropbox("end_hour", $event['end_hour']);
		echo '&nbsp;:&nbsp;';
		$dropbox = new dropbox();
		$dropbox->add_arrays($mins, $mins);
		$dropbox->print_dropbox("end_min", $event['end_min']);
		echo '</td></tr></table>';
		echo '</td></tr>';

		$all_day_event = ($event['all_day_event'] == '1') ? true : false;

		echo '<tr><td>&nbsp;</td><td>';
		$checkbox = new checkbox('all_day_event', '1', $sc_notime, $all_day_event, false, 'onclick="javascript:disable_time()"');
		echo '</td></tr>';

		$calendar_count = $cal->get_authorized_calendars($GO_SECURITY->user_id);
		$dropbox = new dropbox();
		$count = 0;
		while ($cal->next_record()) {
			if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $cal->f('acl_write'))) {
				//remember the first ab that is writable
				if (!isset ($first_writable_cal)) {
					$first_writable_cal = $cal->f('id');
				}
				$dropbox->add_value($cal->f('id'), $cal->f('name'));
				$count ++;
			}
		}

		//if there was no or a read only addressbook given then change to the first writable
		if (!$calendar || !$GO_SECURITY->has_permission($GO_SECURITY->user_id, $calendar['acl_write'])) {
			//there is no writable addressbook so add one
			if (!isset ($first_writable_cal)) {
				$cal_name = $_SESSION['GO_SESSION']['name'];
				$new_cal_name = $cal_name;
				$x = 1;
				while ($cal->get_calendar_by_name($new_cal_name)) {
					$new_cal_name = $cal_name.' ('.$x.')';
					$x ++;
				}
				$calendar_id = $cal->add_calendar($GO_SECURITY->user_id, addslashes($new_cal_name), 7, 20);
				$dropbox->add_value($calendar_id, $new_cal_name);
			} else {
				$calendar_id = $first_writable_cal;
			}
		}

		if ($calendar_count > 1) {
			if (count($event['calendars']) == 0) {
				$event['calendars'][] = $calendar_id;
			}

			for ($i = 0; $i < count($event['calendars']); $i ++) {
				if (!$dropbox->is_in_dropbox($event['calendars'][$i])) {
					echo '<input type="hidden" name="calendars[]" value="'.$event['calendars'][$i].'" />';
				}
			}

			echo '<tr><td valign="top" nowrap>'.$sc_put_in.':</td>';
			echo '<td><table border="0">';
			$dropbox->print_dropbox('calendars[]', $event['calendars'], '', true, '5', '200');
			echo '</table></td></tr>';
		} else {
			echo '<input type="hidden" name="calendars[]" value="'.$calendar_id.'" />';
		}

		echo '<tr><td nowrap>'.$sc_background.':&nbsp;</td><td>';
		$color_selector = new color_selector();
		$color_selector->add_color('FFFFCC');
		$color_selector->add_color('FF6666');
		$color_selector->add_color('CCFFCC');
		$color_selector->add_color('99CCFF');
		$color_selector->add_color('FF99FF');
		$color_selector->add_color('FFCC66');
		$color_selector->add_color('CCCC66');
		$color_selector->add_color('F1F1F1');
		$color_selector->add_color('FFCCFF');
		$color_selector->print_color_selector('background', $event['background'], 'event_form');
		echo '</td></tr>';

		//  begin with section recurrence
		$button_closed = '<a class="normal" href="javascript:show_recur(true);"><img src="'.$GO_THEME->images['opt_close'].'" width="16" '.'height="10" border="0" />&nbsp;'.$sc_recur_section.'</a>';
		$button_opened = '<td colspan="2"><a class="normal" href="javascript:show_recur(false);"><img src="'.$GO_THEME->images['opt_open'].'" width="16" '.'height="10" border="0" />&nbsp;'.$sc_close.'</a></td>';
		$box_close = $box_open = '';
		if(empty($event['repeat_type'])){
			$box_close = ' style="display:none;"';
		}else{
			$box_open = ' style="display:none;"';
		}

		echo '<tr><td colspan="2">';
		echo '<table id="button_recur"'.$box_open.'><tr><td colspan="2">&nbsp;</td></tr><tr><td>'.$button_closed.'</td></tr></table>';
		echo '<table id="section_recur"'.$box_close.'><tr><td colspan="2">&nbsp;</td></tr><tr><td colspan="2">';

		echo '<tr>'.$button_opened.'</tr>';

		echo '<tr><td></td><td>'.$sc_recur_every.'</td><td>';

		$dropbox = new dropbox();
		for ($i = 1; $i < 13; $i ++) {
			$dropbox->add_value($i, $i);
		}
		$dropbox->print_dropbox('repeat_every', $event['repeat_every']);
		$dropbox = new dropbox();
		$dropbox->add_value('0', $sc_types1[REPEAT_NONE]);
		$dropbox->add_value('1', $sc_types1[REPEAT_DAILY]);
		$dropbox->add_value('2', $sc_types1[REPEAT_WEEKLY]);
		$dropbox->add_value('3', $sc_types1[REPEAT_MONTH_DATE]);
		$dropbox->add_value('4', $sc_types1[REPEAT_MONTH_DAY]);
		$dropbox->add_value('5', $sc_types1[REPEAT_YEARLY]);
		$dropbox->print_dropbox('repeat_type', $event['repeat_type'], 'onclick="javascript:toggle_repeat(this.value);"');

		echo '</td></tr>';

		echo '<tr><td></td><td>'.$sc_at_days.':</td><td>';
		echo '<table border="0" cellpadding="0" cellspacing="0"><tr>';
		echo '<td>';
		$dropbox = new dropbox();
		$dropbox->add_arrays(array (1, 2, 3, 4), $month_times);
		$dropbox->print_dropbox("month_time", $event['month_time']);
		echo '</td>';

		$day_data_field[0] = 'sun';
		$day_data_field[1] = 'mon';
		$day_data_field[2] = 'tue';
		$day_data_field[3] = 'wed';
		$day_data_field[4] = 'thu';
		$day_data_field[5] = 'fri';
		$day_data_field[6] = 'sat';

		$day_number = $_SESSION['GO_SESSION']['first_weekday'];

		for ($i = 0; $i < 7; $i ++) {
			if ($day_number == 7)
				$day_number = 0;
			echo '<td>';
			$checkbox = new checkbox('repeat_days_'.$day_number, '1', $days[$day_number], $event[$day_data_field[$day_number]]);
			echo '</td>';
			$day_number ++;
		}
		echo '</tr></table></td></tr>';
		echo '<tr><td></td><td>'.$sc_cycle_end.':&nbsp;</td><td>';
		$datepicker->print_date_picker('repeat_end_date', $_SESSION['GO_SESSION']['date_format'], $event['repeat_end_date']);

		$repeat_forever = $event['repeat_forever'] == '1' ? true : false;
		$checkbox = new checkbox('repeat_forever', '1', $sc_noend, $repeat_forever, false, 'onclick="javascript:toggle_repeat_end_info()"');
		echo '</td></tr>';

		echo '</td></tr></table></td></tr>';
		//  end with section recurrence

		//  begin with section options
		$button_closed = '<a class="normal" href="javascript:show_option(true);"><img src="'.$GO_THEME->images['opt_close'].'" width="16" '.'height="10" border="0" />&nbsp;'.$sc_options_section.'</a>';
		$button_opened = '<td colspan="2"><a class="normal" href="javascript:show_option(false);"><img src="'.$GO_THEME->images['opt_open'].'" width="16" '.'height="10" border="0" />&nbsp;'.$sc_close.'</a></td>';
		$box_close = $box_open = '';
		if(empty($event['reminder']) && $event['permissions'] == 'everybody_read'){
			$box_close = ' style="display:none;"';
		}else{
			$box_open = ' style="display:none;"';
		}

		echo '<tr><td colspan="2">';
		echo '<table id="button_option"'.$box_open.'><tr><td>'.$button_closed.'</td></tr><tr><td colspan="2">&nbsp;</td></tr></table>';
		echo '<table id="section_option"'.$box_close.'><tr><td colspan="2">';

		echo '<tr>'.$button_opened.'</tr>';

		echo '<tr><td></td><td>'.$sc_reminder.':</td><td>';

		if(empty($event['id']) && empty($event['reminder'])){
			$event['reminder'] = $settings['reminder'];
		}
		
		$multipliers[] = 604800;
		$multipliers[] = 86400;
		$multipliers[] = 3600;
		$multipliers[] = 60;

		$reminder_multiplier = 60;
		$reminder_value = 0;
		for ($i = 0; $i < count($multipliers); $i ++) {
			$devided = $event['reminder'] / $multipliers[$i];
			$match = (int) $devided;
			if ($match == $devided) {
				$reminder_multiplier = $multipliers[$i];
				$reminder_value = $devided;
				break;
			}
		}

		$dropbox = new dropbox();
		$dropbox->add_value('0', $cal_no_reminder);
		for ($i = 1; $i < 60; $i ++) {
			$dropbox->add_value($i, $i);
		}
		$dropbox->print_dropbox('reminder_value', $reminder_value);

		$dropbox = new dropbox();
		$dropbox->add_value('60', $sc_mins);
		$dropbox->add_value('3600', $sc_hours);
		$dropbox->add_value('86400', $sc_days);
		$dropbox->add_value('604800', $sc_weeks);
		$dropbox->print_dropbox('reminder_multiplier', $reminder_multiplier);

		echo '</td></tr>';
		echo '<tr><td colspan="2">&nbsp;</td></tr>';

/*		echo '<tr><td></td><td nowrap>'.$sc_background.':&nbsp;</td><td>';
		$color_selector = new color_selector();
		$color_selector->add_color('FFFFCC');
		$color_selector->add_color('FF6666');
		$color_selector->add_color('CCFFCC');
		$color_selector->add_color('99CCFF');
		$color_selector->add_color('FF99FF');
		$color_selector->add_color('FFCC66');
		$color_selector->add_color('CCCC66');
		$color_selector->add_color('F1F1F1');
		$color_selector->add_color('FFCCFF');
		$color_selector->print_color_selector('background', $event['background'], 'event_form');
		echo '</td></tr>';*/

		$permissions = isset ($_POST['permissions']) ? $_POST['permissions'] : 'everybody_read';
		echo '<tr><td></td><td valign="top">'.$strPermissions.':</td><td>';

		$radio_list = new radio_list('permissions', $event['permissions']);
		$radio_list->add_option('everybody_read', $cal_everybody_read);
		echo '<br />';
		$radio_list->add_option('everybody_write', $cal_everybody_write);
		echo '<br />';
		$radio_list->add_option('private', $sc_private_event);

		echo '</td></tr>';

		//  end with section options

		echo '</table></td></tr>';

		echo '<tr><td colspan="2">';
		$button = new button($cmdOk, "javascript:save_event('true', 'false');");
		echo '&nbsp;&nbsp;';
		$button = new button($cmdSaveNew, "javascript:save_event('false', 'true');");
		echo '&nbsp;&nbsp;';
		$button = new button($cmdApply, "javascript:save_event('false', 'false');");
		echo '&nbsp;&nbsp;';
		if ($event_id > 0) {
			$button = new button($cal_export, "document.location='export.php?event_id=$event_id';");
			echo '&nbsp;&nbsp;';
		}
		$button = new button($cmdCancel, "javascript:document.location='$return_to'");
		echo '</td></tr>';
		echo '</table>';
?>
		<script type="text/javascript" language="javascript">
		toggle_repeat('<?php echo $event['repeat_type']; ?>');
		<?php


		if ($event['all_day_event'] == '1') {
			echo 'disable_time();';
		}

		if ($event['repeat_forever'] == '1') {
			echo 'toggle_repeat_end_info();';
		}
?>
		function update_end_hour()
		{
			var start_hour = parseInt(document.event_form.start_hour.value);
			var end_hour = parseInt(document.event_form.end_hour.value);
			if (start_hour == 23)
			{
				document.event_form.end_hour.value='23';
				document.event_form.end_min.value='30';				
			}else
			{
				if (start_hour >= end_hour)
				{		
					end_hour = start_hour+1;
					document.event_form.end_hour.value=end_hour;
				}
			}
		}		

		
		function check_date(changed_field)
		{
			start_date = get_date(document.event_form.start_date.value, '<?php echo $_SESSION['GO_SESSION']['date_format']; ?>');
			end_date = get_date(document.event_form.end_date.value, '<?php echo $_SESSION['GO_SESSION']['date_format']; ?>');
			
			if(end_date < start_date)
			{
				if(changed_field == 'start_date')
				{
					document.event_form.end_date.value = document.event_form.start_date.value;
				}else
				{
					document.event_form.start_date.value = document.event_form.end_date.value;
				}
			}
		}
		


		function save_event(close, clear_form)
		{
			start_date = get_date(document.event_form.start_date.value+' '+document.event_form.start_hour.value+':'+document.event_form.start_min.value, '<?php echo $_SESSION['GO_SESSION']['date_format']; ?>');
			end_date = get_date(document.event_form.end_date.value+' '+document.event_form.end_hour.value+':'+document.event_form.end_min.value, '<?php echo $_SESSION['GO_SESSION']['date_format']; ?>');
			repeat_end_date = get_date(document.event_form.repeat_end_date.value, '<?php echo $_SESSION['GO_SESSION']['date_format']; ?>');

			if (start_date >= end_date)
			{
				alert("<?php echo $sc_start_later; ?>");
				return;
			}
			if (document.event_form.repeat_type.value != '0')
			{
				if ((start_date >= repeat_end_date) && document.event_form.repeat_forever.checked == false)
				{
					alert("<?php echo $sc_cycle_start_later; ?>");
					return;
				}
			}

			if (document.event_form.repeat_type.value == '1' && (document.event_form.reminder_value.value*document.event_form.reminder_multiplier.value)> 43200)
			{
				alert("<?php echo $sc_reminder_set_to_early; ?>");
				return;
			}

			if (document.event_form.repeat_type.value == '2' && (document.event_form.reminder_value.value*document.event_form.reminder_multiplier.value) > 518400)
			{
				alert("<?php echo $sc_reminder_set_to_early; ?>");
				return;
			}

			if (document.event_form.repeat_type.value == '2' || document.event_form.repeat_type.value == '4')
			{
				if (document.event_form.repeat_days_0.checked == false && document.event_form.repeat_days_1.checked == false && document.event_form.repeat_days_2.checked == false && document.event_form.repeat_days_3.checked == false && document.event_form.repeat_days_4.checked == false && document.event_form.repeat_days_5.checked == false && document.event_form.repeat_days_6.checked == false)
				{
					alert("<?php echo $sc_never_happens; ?>");
					return;
				}
			}
			document.event_form.task.value = 'save_event';
			document.event_form.close.value = close;
			document.event_form.new_event.value = clear_form;

			document.event_form.submit();

		}

		function remove_client()
		{
			document.event_form.contact_id.value = 0;
			document.event_form.contact_name.value = '';
			document.event_form.contact_name_text.value = '';
		}

		function toggle_repeat_end_info()
		{
			document.event_form.repeat_end_date.disabled = !document.event_form.repeat_end_date.disabled;
		}

		function disable_time()
		{
			if (document.event_form.start_hour.disabled==false)
			{
				document.event_form.start_hour.disabled=true;
				document.event_form.start_min.disabled=true;
				document.event_form.end_hour.disabled=true;
				document.event_form.end_min.disabled=true;
			}else
			{
				document.event_form.start_hour.disabled=false;
				document.event_form.start_min.disabled=false;
				document.event_form.end_hour.disabled=false;
				document.event_form.end_min.disabled=false;
			}
		}

		function toggle_repeat(repeat)
		{

			document.event_form.repeat_type.value = repeat;
			switch(repeat)
			{
				case '0':
				disable_days(true);
				document.event_form.month_time.disabled = true;
				disable_repeat_end_date(true);
				document.event_form.repeat_every.disabled = true;
				break;

				case '1':
				disable_days(true);
				document.event_form.month_time.disabled = true;
				disable_repeat_end_date(false);
				document.event_form.repeat_every.disabled = false;
				break;

				case '2':
				disable_days(false);
				document.event_form.month_time.disabled = true;
				disable_repeat_end_date(false);
				document.event_form.repeat_every.disabled = false;
				break;

				case '3':
				document.event_form.month_time.disabled = true;
				disable_days(true);
				disable_repeat_end_date(false);
				break;

				case '4':
				disable_days(false);
				document.event_form.month_time.disabled = false;
				disable_repeat_end_date(false);
				document.event_form.repeat_every.disabled = false;
				break;

				case '5':
				disable_days(true);
				document.event_form.month_time.disabled = true;
				disable_repeat_end_date(false);
				document.event_form.repeat_every.disabled = false;
				break;
			}
		}

		function disable_days(disable)
		{
			document.event_form.repeat_days_0.disabled=disable;
			document.event_form.repeat_days_1.disabled=disable;
			document.event_form.repeat_days_2.disabled=disable;
			document.event_form.repeat_days_3.disabled=disable;
			document.event_form.repeat_days_4.disabled=disable;
			document.event_form.repeat_days_5.disabled=disable;
			document.event_form.repeat_days_6.disabled=disable;

		}

		function disable_repeat_end_date(disable)
		{
			document.event_form.repeat_forever.disabled=disable;
			if (disable == true || (disable==false && document.event_form.repeat_forever.checked == false))
			{
				document.event_form.repeat_end_date.disabled=disable;
			}
		}
		function show_recur(bool)
		{
			var button = get_object('button_recur');
			var section = get_object('section_recur');
			button.style.display='inline';
			section.style.display='none';
			if (bool)
			{
				button.style.display='none';
				section.style.display='inline';
			}
		}

		function show_option(bool)
		{
			var button = get_object('button_option');
			var section = get_object('section_option');
			button.style.display='inline';
			section.style.display='none';
			if (bool)
			{
				button.style.display='none';
				section.style.display='inline';
			}
		}

		
		document.event_form.name.focus();
	</script>
	<?php

		break;
}

$tabtable->print_foot();
echo '</form>';
require_once ($GO_THEME->theme_path.'footer.inc');
?>