<?php
/*
   Copyright SoftSys 2004
   Author: Georg Lorenz <georg@lonux.de>
   Version: 1.0 Release date: 29 October 2004

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */
function set_availability($availability, $from_hour, $to_hour, $event_type='all_day', $event='', $current_date_time=0)
{
	if($event_type == 'all_day')
	{
		for($hour=$from_hour;$hour<=$to_hour;$hour++)
		{
			for($min=0;$min<=45;$min+=15)
			{
				$availability[$hour][$min] = false;
			}
		}
	}else
	{
		$date = getdate($current_date_time);
		$event_start = getdate($event['start_time']);
		$event_end = getdate($event['end_time']);
		if($event_start['mday'] == $date['mday'] && $event_start['mon'] == $date['mon'] && $event_start['year'] == $date['year'])
		{
			if($event_start['mday'] == $event_end['mday'] && $event_start['mon'] == $event_end['mon'] && $event_start['year'] == $event_end['year'])
			{
				if($event_start['hours'] == $event_end['hours'])
				{
					for($min=0;$min<$event_end['minutes'];$min+=15)
					{
						if($event_start['minutes'] <= $min && $event_end['minutes'] >= $min)
						{
							$availability[$event_start['hours']][$min] = false;
						}
					}
				}else
				{
					$go_on = true;
					for($index=$event_start['hours'];$index<$event_end['hours'];$index++)
					{
						if($index > $to_hour)
						{
							$go_on = false;
							break;
						}
						for($min=0;$min<=45;$min+=15)
						{
							if($event_start['hours'] == $index && $event_start['minutes'] <= $min)
							{
								$availability[$index][$min] = false;
							}elseif($event_start['hours'] < $index)
							{
								$availability[$index][$min] = false;
							}
						}
					}
					if($go_on)
					{
						for($min=0;$min<$event_end['minutes'];$min+=15)
						{
							if($event_end['minutes'] >= $min)
							{
								$availability[$event_end['hours']][$min] = false;
							}
						}
					}
				}
			}else
			{
				for($hour=$event_start['hours'];$hour<=$to_hour;$hour++)
				{
					for($min=0;$min<=45;$min+=15)
					{
						if($event_start['hours'] == $hour && $event_start['minutes'] <= $min)
						{
							$availability[$hour][$min] = false;
						}elseif($event_start['hours'] < $hour)
						{
							$availability[$hour][$min] = false;
						}
					}
				}
			}
		}elseif($event_end['mday'] == $date['mday'] && $event_end['mon'] == $date['mon'] &&	$event_end['year'] == $date['year'])
		{
			for($hour=$from_hour;$hour<=$event_end['hours'];$hour++)
			{
				for($min=0;$min<=45;$min+=15)
				{
					if($event_end['hours'] == $hour && $event_end['minutes'] > $min)
					{
						$availability[$hour][$min] = false;
					}elseif($event_end['hours'] > $hour)
					{
						$availability[$hour][$min] = false;
					}
				}
			}
		}else
		{
			for($hour=$from_hour;$hour<$to_hour;$hour++)
			{
				for($min=0;$min<=45;$min+=15)
				{
					$availability[$hour][$min] = false;
				}
			}
		}
	}
	return $availability;
}

//$return_to = isset($_REQUEST['return_to']) ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];
$participants = smart_stripslashes($event['to']);
//$calendar_id = isset($event['calendars']) ? $event['calendars'][0] : $calendar_id;


$choice['type'] = 'participants';
$choice['value'] = $sc_participants;
if(isset($_REQUEST['calendar_participants']))
{
	$choice = explode(':', $_REQUEST['calendar_participants']);
	$choice['type'] = $choice[0];
	$choice['value'] = $choice[1];
	if($choice['type'] == 'calendar')
	{
		$calendar_id = $choice['value'];
		$view_id = 0;
	}elseif($choice['type'] == 'view')
	{
		$view_id = $choice['value'];
		$calendar_id = 0;
	}
}

//$period_offset = date_to_unixtime($start_date);
$from_hour = 7;
$to_hour = 20;

$availability_cal = array();
$availability_member = array();
$availability_merged = array();

$member_rows = '';
$cal_row = '';
if(isset($_POST['day']))
{
	$new_time = mktime(0, 0, 0,$_POST['month'], $_POST['day'], $_POST['year']);
}else
{
	$new_time = date_to_unixtime($event['start_date']);	
}

$start_date = date($_SESSION['GO_SESSION']['date_format'], $new_time);
$end_date = $start_date;

$date_index = date('Ymd', $new_time);
$date = getdate($new_time);
$interval_start_time = mktime(0,0,0,$date['mon'], $date['mday']-1, $date['year']);
$interval_end_time = mktime(0,0,0,$date['mon'], $date['mday']+1, $date['year']);

switch($choice['type'])
{
	case 'participants':
		if($current_cal = $cal->get_calendar($calendar_id))
		{
			$from_hour = $current_cal['start_hour'];
			$to_hour = $current_cal['end_hour'];
		}
		
		for($hour=$from_hour;$hour<=$to_hour;$hour++)
		{
			for($min=0;$min<=45;$min+=15)
			{
				$availability_merged[$hour][$min] = true;
			}
		}
		
//		$td_width = floor(100 / ($to_hour-$from_hour+1));
		
		$user_profile = $GO_USERS->get_user($GO_SECURITY->user_id);
		$tmp_participants = empty($participants) ? $user_profile['email'] : $user_profile['email'].','.$participants;		
		
		$participants_array = $RFC822->explode_address_list($tmp_participants);
		
		for($i=0;$i<sizeof($participants_array);$i++)
		{
			if(!empty($participants_array[$i]))
			{
				$id = 0;

			    if($member_profile = $GO_USERS->get_user_by_email(smart_addslashes($participants_array[$i])))
			    {
					$id = $member_profile["id"];

					$member_events = false;
					if($id)
					{
						$member_events = $cal->get_events_in_array(0, 0, $id, 
									$interval_start_time, $interval_end_time, 
									$from_hour,
									'Ymd');
					}

					if($i == 0)
					{
						$member_rows = '<tr><th class="caption"><img src="'.$GO_THEME->images['user_small'].'" border="0" width="16" height="16" /></th><th class="caption" nowrap>'.$cal_own_availability.'</th>';
					}else
					{
						$member_rows .= '<tr><th class="caption"><img src="'.$GO_THEME->images['user_small'].'" border="0" width="16" height="16" /></th><th class="caption" nowrap>'.
										get_name_from_string(stripslashes($participants_array[$i])).'</th>';
					}
		
					$member_rows .= '<td style="width:100%;"><table style="width:100%;"><tr>';

					for($hour=$from_hour;$hour<=$to_hour;$hour++)
					{
						for($min=0;$min<=45;$min+=15)
						{
							$availability_member[$hour][$min] = true;
						}
						$tooltip = $hour.':00';
						$link = '<a href="javascript:goto_event(\''.$hour.'\',\'00\');" '.$overlib->print_overlib($tooltip, $current_cal['name'], 'WRAP').'>'.$hour.'</a>';
						$member_rows .= '<td class="hour" colspan="4">'.$link.'</td>';
					}
					$member_rows .= '</tr><tr>';
			
					if (isset($member_events['all_day'][$date_index]))
					{
						$availability_member = set_availability($availability_member, $from_hour, $to_hour);
					}elseif (isset($member_events['timed'][$date_index]))
					{
						while($timed_events = array_shift($member_events['timed'][$date_index]))
						{
							while ($member_event = array_shift($timed_events))
							{
								$availability_member = set_availability($availability_member, $from_hour, $to_hour, 'timed', $member_event, $new_time);
							}
						}
					}
					
					foreach($availability_member as $hour => $value)
					{
						for($min=0;$min<=45;$min+=15)
						{
							$minute = strlen($min) == 1 ? '0'.$min : $min;
							$tooltip = $hour.':'.$minute;
							$link = '<a href="javascript:goto_event(\''.$hour.'\',\''.$min.'\');" '.$overlib->print_overlib($tooltip, $current_cal['name'], 'WRAP').'>&nbsp;</a>';
							$member_rows .= $value[$min] ? '<td class="available">'.$link.'</td>' : '<td class="unavailable">&nbsp;</td>';
							$availability_merged[$hour][$min] = !$value[$min] ? $value[$min] : $availability_merged[$hour][$min];
						}
					}
					$member_rows .= '</tr></table></td>';
				}
			}
		}
		$member_rows .= '</tr>';
		break;

	default:
		$calendars = array();
		if($choice['type'] == 'calendar')
		{
			$calendars[0] = $cal->get_calendar($calendar_id);
		}else
		{
			$calendars = $cal->get_view_calendars($view_id);
		}

		foreach($calendars as $calendar)
		{
			if($current_cal = $cal->get_calendar($calendar['id']))
			{
				$from_hour = $current_cal['start_hour'];
				$to_hour = $current_cal['end_hour'];
			}

			for($hour=$from_hour;$hour<=$to_hour;$hour++)
			{
				for($min=0;$min<=45;$min+=15)
				{
					$availability_cal[$hour][$min] = true;
				}
			}

			$cal_events = $cal->get_events_in_array($calendar['id'], 0, 0, 
						$interval_start_time, $interval_end_time, 
						$date['mday'], $date['mon'], $date['year'], $from_hour,
						'Ymd');
	
			$cal_row .= '<tr><th class="caption"><img src="'.$GO_THEME->images['calendar_small'].'" border="0" width="16" height="16" /></th><th class="caption" nowrap>'.$calendar['name'].'</th>';
			$cal_row .= '<td style="width:100%;"><table style="width:100%;"><tr>';
//			$td_width = floor(100 / ($to_hour-$from_hour+1));
			for($hour=$from_hour;$hour<=$to_hour;$hour++)
			{
				$tooltip = $hour.':00';
				$link = '<a href="javascript:goto_event(\''.$hour.'\',\'00\');"  '.$overlib->print_overlib($tooltip, $calendar['name'], 'WRAP').'>'.$hour.'</a>';
				$cal_row .= '<td class="hour" colspan="4">'.$link.'</td>';
			}
			$cal_row .= '</tr><tr>';

			if(isset($cal_events['all_day'][$date_index]) || isset($cal_events['timed'][$date_index]))
			{
				if(isset($cal_events['all_day'][$date_index]))
				{
					$availability_cal = set_availability($availability_cal, $from_hour, $to_hour);
				}elseif (isset($cal_events['timed'][$date_index]))
				{
					while($timed_events = array_shift($cal_events['timed'][$date_index]))
					{
						while ($cal_event = array_shift($timed_events))
						{
							$availability_cal = set_availability($availability_cal, $from_hour, $to_hour, 'timed', $cal_event, $new_time);
						}
					}
				}
			}
			foreach($availability_cal as $hour => $value)
			{
				for($min=0;$min<=45;$min+=15)
				{
					$minute = strlen($min) == 1 ? '0'.$min : $min;
					$tooltip = $hour.':'.$minute;
					$link = '<a href="javascript:goto_event(\''.$hour.'\',\''.$min.'\');" '.$overlib->print_overlib($tooltip, $current_cal['name'], 'WRAP').'>&nbsp;</a>';
					$cal_row .= $value[$min] ? '<td class="available">'.$link.'</td>' : '<td class="unavailable">&nbsp;</td>';
				}
			}
			$cal_row .= '</tr></table></td></tr>';
		}
		break;
}

$merged_row = '';
if(isset($participants_array) && count($participants_array) > 1)
{
	$hour_header = '';
	foreach($availability_merged as $hour => $value)
	{
		$tooltip = $hour.':00';
		$link = '<a href="javascript:goto_event(\''.$hour.'\',\'00\');" '.$overlib->print_overlib($tooltip, $current_cal['name'], 'WRAP').'>'.$hour.'</a>';
		$hour_header .= '<td class="hour" colspan="4">'.$link.'</td>';
		for($min=0;$min<=45;$min+=15)
		{
			$minute = strlen($min) == 1 ? '0'.$min : $min;
			$tooltip = $hour.':'.$minute;
			$link = '<a href="javascript:goto_event(\''.$hour.'\',\''.$min.'\');" '.$overlib->print_overlib($tooltip, $current_cal['name'], 'WRAP').'>&nbsp;</a>';
			$merged_row .= $value[$min] ? '<td class="available">'.$link.'</td>' : '<td class="unavailable">&nbsp;</td>';
		}
	}
	$merged_row = '<tr><th class="caption"><img src="'.$GO_THEME->images['users_small'].
				'" border="0" width="16" height="16" /></th><th class="caption" nowrap>'.
				$cal_merged_overview.'</th><td width="100%"><table id="availability" width="100%"><tr>'.
				$hour_header.'</tr><tr>'.$merged_row.'</tr></table></td></tr>';
}


echo '<input type="hidden" name="day" value="'.$day.'" />';
echo '<input type="hidden" name="month" value="'.$month.'" />';
echo '<input type="hidden" name="year" value="'.$year.'" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="to" value="'.htmlspecialchars($participants).'" />';
echo '<input type="hidden" name="end_date" value="'.$end_date.'" />';
echo '<input type="hidden" name="hour" value="'.$hour.'" />';
echo '<input type="hidden" name="min" value="'.$min.'" />';
echo '<input type="hidden" name="calendar_id" value="'.$calendar_id.'" />';
echo '<input type="hidden" name="event_id" value="'.$event_id.'" />';
echo '<input type="hidden" name="name" value="'.$event['name'].'" />';
echo '<input type="hidden" name="location" value="'.$event['location'].'" />';
echo '<input type="hidden" name="description" value="'.$event['description'].'" />';
if(isset($_POST['address_string']))
{
	echo '<input type="hidden" name="address_string" value="'.$_POST['address_string'].'" />';
}
if(isset($_POST['id_type']))
{
	echo '<input type="hidden" name="id_type" value="'.$_POST['id_type'].'" />';
	echo '<input type="hidden" name="id" value="'.$_POST['id'].'" />';
}
echo '<input type="hidden" name="repeat_type" value="'.$event['repeat_type'].'" />';
echo '<input type="hidden" name="reminder" value="'.$event['reminder'].'" />';
echo '<input type="hidden" name="background" value="'.$event['background'].'" />';
echo '<input type="hidden" name="permissions" value="'.$event['permissions'].'" />';
if(isset($event['all_day_event']))
{
	echo '<input type="hidden" name="all_day_event" value="'.$event['all_day_event'].'" />';
}
if(isset($event['repeat_every']))
{
	echo '<input type="hidden" name="repeat_every" value="'.$event['repeat_every'].'" />';
}
if(isset($event['repeat_end_date']))
{
	echo '<input type="hidden" name="repeat_end_date" value="'.$event['repeat_end_date'].'" />';
}
if(isset($event['repeat_forever']))
{
	echo '<input type="hidden" name="repeat_forever" value="'.$event['repeat_forever'].'" />';
}
if(isset($event['month_time']))
{
	echo '<input type="hidden" name="month_time" value="'.$event['month_time'].'" />';
}
for($i=0;$i<7;$i++)
{
	$field_name = 'repeat_days_'.$i;
	if(isset($_POST[$field_name]))
	{
		echo '<input type="hidden" name="'.$field_name.'" value="'.$_POST[$field_name].'" />';
	}
}

foreach($event['calendars'] as $calendar)
{
	echo '<input type="hidden" name="calendars[]" value="'.$calendar.'" />';
}

echo '<table>';
$dropbox= new dropbox();
$cal->get_authorized_calendars($GO_SECURITY->user_id);
$dropbox->add_optgroup($sc_calendars);
while ($cal->next_record())
{
	if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $cal->f('acl_write')))
	{
		$dropbox->add_value('calendar:'.$cal->f('id'), $cal->f('name'));
	}
}
if($cal->get_views($GO_SECURITY->user_id))
{
	$dropbox->add_optgroup($cal_views);
	while($cal->next_record())
	{
		$dropbox->add_value('view:'.$cal->f('id'), $cal->f('name'));
	}	    
}
$dropbox->add_optgroup($sc_participants);
$dropbox->add_value('participants:'.$sc_participants, $sc_participants);
echo '<tr><td colspan="2">'.$strCheckAvailabilityFor.': '.'</td><td>';
$dropbox->print_dropbox('calendar_participants', $choice['type'].':'.$choice['value'], 'onchange="javascript:goto_date('.($date['mday']).', '.$date['mon'].', '.$date['year'].');"');
echo '</td></tr>';

$img_back = '<img src="'.$GO_THEME->images['back_small'].'" border="0" width="16" height="16" align="absmiddle" />';
$img_forw = '<img src="'.$GO_THEME->images['forward_small'].'" border="0" width="16" height="16" align="absmiddle" />';
$prev_day = date($_SESSION['GO_SESSION']['date_format'], mktime(0, 0, 0, $date["mon"], $date["mday"]-1, $date["year"]));
$next_day = date($_SESSION['GO_SESSION']['date_format'], mktime(0, 0, 0, $date["mon"], $date["mday"]+1, $date["year"]));
$link_back = '<a href="javascript:goto_date('.($date['mday']-1).', '.$date['mon'].', '.$date['year'].')">'.$img_back.'&nbsp;</a>';
$link_forw = '<a href="javascript:goto_date('.($date['mday']+1).', '.$date['mon'].', '.$date['year'].')">&nbsp;'.$img_forw.'</a>';

echo '<tr><td>'.$strDate.': </td><td>'.$link_back.'&nbsp;'.$link_forw.'</td><td>';
$datepicker->print_date_picker('start_date', $_SESSION['GO_SESSION']['date_format'], $start_date, '', '', 'onchange="javascript:date_picker(calendar);"');

echo '</td></tr>';
echo '</table>';
echo '<br />';
echo '<table id="availability" width="100%">';
echo $merged_row.$cal_row.$member_rows.'</table>';

echo '<br />';
$button = new button($cmdBack,"javascript:change_tab('properties')");
?>
<script type="text/javascript" language="javascript">
 function date_picker(calendar) {
      // Beware that this function is called even if the end-user only
      // changed the month/year.  In order to determine if a date was
      // clicked you can use the dateClicked property of the calendar:
      if (calendar.dateClicked) {
	// OK, a date was clicked, redirect to /yyyy/mm/dd/index.php
	var y = calendar.date.getFullYear();
	var m = calendar.date.getMonth()+1;     // integer, 0..11
	var d = calendar.date.getDate();      // integer, 1..31
	
	goto_date(d,m,y);	
      }
    };
    
function goto_date(day, month, year)
{
	document.event_form.task.value='change_event';
	document.event_form.day.value = day;
	document.event_form.month.value = month;
	document.event_form.year.value = year;
	document.event_form.submit();
}

function goto_event(hour, min)
{
	document.event_form.task.value='change_event';
	document.event_form.event_table.value='properties';
	document.event_form.hour.value=hour;
	document.event_form.min.value=min;
	document.event_form.submit();
}
</script>
