<?php
$cal_index = isset($cal_index) ? $cal_index : 0;

//don't  display events in hours in month view
$index_hours = ($cal_settings['show_days'] > 29) ? false : true;

$events = $cal->get_events_in_array($calendar_id, $view_id, 0, 
		$interval_start_time, $interval_end_time, 
		$cal_start_hour, 'Ymd', $index_hours);

for($row=0;$row<$rows;$row++)
{
	$start_day = $row*$max_columns;
	$end_day = $cal_settings['show_days'] < $max_columns ? $cal_settings['show_days'] : $start_day+$max_columns;
	$row_offset = $cal_index * $rows;
	$current_row = $row_offset + $row;

	//create table headings
	if($index_hours)
	{
		echo '<tr>';
		echo '<th width="40" nowrap></th>';
	}else
	{
		if($row == 0)
		{
			echo '<tr><th width="2%" class="heading"></th>';
			for ($day_offset=$start_day;$day_offset<$end_day;$day_offset++)
			{
				$day_to_display = $day+$day_offset;
				$new_time = mktime(0,0, 0, $month, $day_to_display, $year);
				$weekday = date('w', $new_time);
				echo '<th width="14%" class="heading">'.$full_days[$weekday].'</th>';
			}
			echo '</tr><tr>';
		}
	}

	for ($day_offset=$start_day;$day_offset<$end_day;$day_offset++)
	{
		$day_to_display = $day+$day_offset;
		$new_time = mktime(0,0, 0, $month, $day_to_display, $year);
		$new_date = date(DB_DATE_FORMAT, $new_time);
		$new_day = date('j', $new_time);
		$new_month = date('n', $new_time);
		$new_year = date('Y', $new_time);

		//get holiday name if ever
		$holiday_name = "";
		if($holidays->get_holiday($GO_SECURITY->user_id, $calendar_id, $new_time))
		{
			$holiday_name = $holidays->f("name");
		}

		if ($new_date == $current_date)
		{
			$class="HoverLinkSelected";
		}else
		{
			$class="HoverLink";
			$weekday = date('w', $new_time);
			if($weekday == 0 || $weekday == 6 || !empty($holiday_name))
			{
				$class="Holiday";
			}
		}
		
		$month_to_display = date("n", mktime(0,0,0,$month,$day+7,$year));
		
		if ($new_date == $current_date)
		{
			$div_id="cell_selected";
		}else
		{
			if($month_to_display != $new_month)
			{
				$div_id="cell_other_month";
			}else
			{
				$weekday = date('w', $new_time);
				if($weekday == 0 || $weekday == 6 || !empty($holiday_name))
				{
					$div_id="cell_holiday";
				}else
				{
					$div_id="cell_current_month";
				}
			}
		}
		
		$weekday = date('w', $new_time);
		if($index_hours)
		{
			echo '<th><a href="javascript:change_view(1, '.$new_day.','.$new_month.', '.$new_year.');" class="'.
				$class.'">'.$full_days[$weekday].'<br />'.
				date($_SESSION['GO_SESSION']['date_format'],$new_time).
				'<br />'.$holiday_name.'</a>';
			echo '</th>';
		}else
		{
			$titles = array();
			$idx = 0;
			//month view
			if($start_day == $day_offset)
			{
				$weeknumber = date("W", mktime(0,0,0,$month,$day+$start_day,$year));
				echo '<th height="80px" width="2%" class="heading">'
					.'<a href="javascript:change_view(7, '.$new_day.','.$new_month.', '.$new_year.');">'
					.$weeknumber.'</th>';
			}

			$new_date = date('Ymd', $new_time);
			
			if (isset($events['all_day'][$new_date]))
			{
				while ($event = array_shift($events['all_day'][$new_date]))
				{
					$titles[$idx]['event_id'] = $event['id'];
					$titles[$idx]['event_link'] = $event['write_permission'] ? 'event.php' : 'show_event.php';
					$titles[$idx]['name'] = htmlspecialchars($event["name"]);
					$titles[$idx]['background'] = $event["background"];
					$titles[$idx]['start_date'] = date('Ymd', $event['start_time']);
					$titles[$idx]['end_date'] = date('Ymd', $event['end_time']);
					
					if (date($_SESSION['GO_SESSION']['date_format'], $event['start_time']) != date($_SESSION['GO_SESSION']['date_format'], $event['end_time']))
					{
						$titles[$idx]['tooltip'] = date($_SESSION['GO_SESSION']['date_format'], $event['start_time']).' - '.date($_SESSION['GO_SESSION']['date_format'], $event['end_time']).'&nbsp;';
					}
					$titles[$idx]['tooltip'] = isset($titles[$idx]['tooltip']) ? $titles[$idx]['tooltip'].htmlspecialchars($event["name"]) : htmlspecialchars($event["name"]);
				
					if($event['contact_id'] > 0 && $contact = $ab->get_contact($event['contact_id']))
					{	
						$middle_name = $contact['middle_name'] == '' ? '' : $contact['middle_name'].' ';
						$contact_name = $contact['first_name'].' '.$middle_name.$contact['last_name'];
						$titles[$idx]['tooltip'] .= '<br />'.$strContact.': '.htmlspecialchars($contact_name);
						if ($contact['company_name'] != '')
						{
							$titles[$idx]['tooltip'] .= " (".htmlspecialchars($contact['company_name']).")";
						}
						
					}elseif($event['company_id'] > 0 && $company = $ab->get_company($event['company_id']))
					{
						$titles[$idx]['tooltip'] .= '<br />'.$strCompany.': '.htmlspecialchars($company['name']);
			
					}elseif($event['project_id'] > 0)
					{
						if($project = $projects->get_project($event['project_id']))
					  {
					    $project_name = $project['description'] == '' ? $project['name'] : $project['name'].' ('.$project['description'].')';	
							$titles[$idx]['tooltip'] .= '<br />'.$strProject.': '. htmlspecialchars($project_name);
						}
					}
					
					
					if ($event['location'] != '')
					{
						if ($titles[$idx]['tooltip'] != '')
						{
							$titles[$idx]['tooltip'] .= "<br />";
						}
						$titles[$idx]['tooltip'] .= $sc_location.": ".htmlspecialchars($event['location']);
					}
					$event_cal_count = $cal->get_calendars_from_event($event['id']);
					if($view_id > 0 || $event_cal_count > 1)
					{
						$titles[$idx]['tooltip'] .= "<br />$cal_event_calendars: ";
						$first = true;
						while($cal->next_record())
						{
							if($first)
							{
								$first = false;
							}else
							{
								$titles[$idx]['tooltip'] .= ' ,';
							}						  
							$titles[$idx]['tooltip'] .= htmlspecialchars($cal->f('name'));
						}
					}
					$idx++;
				}
			}		

			if(isset($events['timed'][$new_date]))
			{			
				while($event = array_shift($events['timed'][$new_date]))
				{
					$titles[$idx]['event_id'] = $event['id'];
					$titles[$idx]['event_link'] = $event['write_permission'] ? 'event.php' : 'show_event.php';
					$titles[$idx]['start_date'] = date('Ymd', $event['start_time']);
					$titles[$idx]['end_date'] = date('Ymd', $event['end_time']);
					$titles[$idx]['background'] = $event["background"];
					if (date($_SESSION['GO_SESSION']['date_format'], $event['start_time']) != date($_SESSION['GO_SESSION']['date_format'], $event['end_time']))
					{
						$date_format = $_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'];
					}else
					{
						$date_format = $_SESSION['GO_SESSION']['time_format'];
					}
					$titles[$idx]['tooltip'] = date($date_format, $event['start_time']).'&nbsp;-&nbsp;'.
						date($date_format, $event['end_time']);
					$titles[$idx]['tooltip'] .= "&nbsp;".htmlspecialchars($event["name"]);
					$titles[$idx]['time'] = date($date_format, $event['start_time']);
					if($titles[$idx]['start_date'] != $titles[$idx]['end_date'])
					{
						$titles[$idx]['time'] = '';
					}
					$titles[$idx]['name'] = $event["name"];

					if($event['contact_id'] > 0 && $contact = $ab->get_contact($event['contact_id']))
					{
						$middle_name = $contact['middle_name'] == '' ? '' : $contact['middle_name'].' ';
						$contact_name = $contact['first_name'].' '.$middle_name.$contact['last_name'];
						$titles[$idx]['tooltip'] .= '<br />'.$strContact.': '.htmlspecialchars($contact_name);
						if ($contact['company_name'] != '')
						{
							$titles[$idx]['tooltip'] .= " (".htmlspecialchars($contact['company_name']).")";
						}
						
					}elseif($event['company_id'] > 0 && $company = $ab->get_company($event['company_id']))
					{
						$titles[$idx]['tooltip'] .= '<br />'.$strCompany.': '.htmlspecialchars($company['name']);
			
					}elseif($event['project_id'] > 0)
					{
						if($project = $projects->get_project($event['project_id']))
					  {
					    $project_name = $project['description'] == '' ? $project['name'] : $project['name'].' ('.$project['description'].')';	
							$titles[$idx]['tooltip'] .= '<br />'.$strProject.': '. htmlspecialchars($project_name);
						}
					}
					
					if ($event['location'] != '')
					{
						$titles[$idx]['tooltip'] .= "<br />".$sc_location.": ".htmlspecialchars($event['location']);
					}
					$event_cal_count = $cal->get_calendars_from_event($event['id']);
					if($view_id > 0 || $event_cal_count > 1)
					{
						$titles[$idx]['tooltip'] .= "<br />$cal_event_calendars: ";
						$first = true;
						while($cal->next_record())
						{
							if($first)
							{
								$first = false;
							}else
							{
								$titles[$idx]['tooltip'] .= ' ,';
							}						  
							$titles[$idx]['tooltip'] .= htmlspecialchars($cal->f('name'));
						}
					}
					$idx++;
				}
			}
			
			$max_events_to_display = empty($holiday_name) ? 4 : 3;
			$count_events = 0;
			$tooltip = '';
			$day_events = '';
			//var_dump($titles);
			if(!empty($titles))
			{
				foreach($titles as $title)
				{	
					if($new_date >= $title['start_date'] && $new_date <= $title['end_date'])
					{
						if($count_events < $max_events_to_display)
						{
							$title_text = empty($title['time']) ? cut_string($title['name'], 17, false) : cut_string($title['time'].' '.$title['name'], 17, false);
							$style_icon = 'style="background-color: #'.$title['background'].';"';
							$day_events .= '<div id="event_row">';
							$day_events .= '<a href="'.$title['event_link'].'?event_id='.$title['event_id'].'" class="icon" '.$style_icon.' '.$overlib->print_overlib($title['tooltip']).'>&nbsp;</a>';
							$day_events .= '<a href="'.$title['event_link'].'?event_id='.$title['event_id'].'" class="event" '.$overlib->print_overlib($title['tooltip']).'>'.$title_text.'</a>';
							$day_events .= '</div>';
						}
						$count_events++;
						$tooltip .= "<li>".$title['tooltip']."</li>";
					}
				}
			}
			
			$cell_title = !empty($holiday_name) ? $new_day."<br />".$holiday_name : $new_day;
			$tooltip = !empty($tooltip) ? "<ul>".$tooltip."</ul>" : "";
			$day_link = "javascript:change_view(1, $new_day,$new_month, $new_year);";
			$style_day = empty($day_events) ? 'style="height: 100%;"' : '';

			echo '<td height="80px" width="14%">'.
						'<div id="'.$div_id.'">'.
						'<a href="'.$day_link.'" '.$style_day.' '.$overlib->print_overlib($tooltip).'>'.$cell_title.'</a>'.
						$day_events;
						
			if($count_events > $max_events_to_display)
			{
					echo '......';
			}
			echo '</div></td>';			
		}
	}
	echo '</tr>';
	
	if($index_hours)
	{
		//process the all day events
		$all_day_events_count = false;
		
		$all_day_events = '<tr id="cal_all_day_events">';
		$all_day_events .= '<td class="cal_hour"></td>';

		for ($day_offset=$start_day;$day_offset<$end_day;$day_offset++)
		{
			$all_day_events .= '<td>';
			$day_to_display = $day+$day_offset;
			$new_time = mktime(0,0, 0, $month, $day_to_display, $year);      

			$new_date = date('Ymd', $new_time);
			if (isset($events['all_day'][$new_date]))
			{
				$all_day_events_count = true;
				
				$all_day_events .= '<table id="cal_event" width="100%" height="100%">';
				while ($event = array_shift($events['all_day'][$new_date]))
				{
					$all_day_events .= '<tr style="background-color: #'.$event['background'].'"><td width="100%">';
					$link = $event['write_permission'] ? 'event.php' : 'show_event.php';

					$tooltip = '';
					if (date($_SESSION['GO_SESSION']['date_format'], $event['start_time']) != date($_SESSION['GO_SESSION']['date_format'], $event['end_time']))
					{
						$tooltip .= date($_SESSION['GO_SESSION']['date_format'], $event['start_time']).' - '.date($_SESSION['GO_SESSION']['date_format'], $event['end_time']);
					}
					if($event['contact_id'] > 0 && $contact = $ab->get_contact($event['contact_id']))
					{	
						$middle_name = $contact['middle_name'] == '' ? '' : $contact['middle_name'].' ';
						$contact_name = $contact['first_name'].' '.$middle_name.$contact['last_name'];
						$tooltip .= '<br />'.$strContact.': '.htmlspecialchars($contact_name);
						if ($contact['company_name'] != '')
						{
							$tooltip .= " (".htmlspecialchars($contact['company_name']).")";
						}
						
					}elseif($event['company_id'] > 0 && $company = $ab->get_company($event['company_id']))
					{
						$tooltip .= '<br />'.$strCompany.': '.htmlspecialchars($company['name']);
			
					}elseif($event['project_id'] > 0)
					{
						if($project = $projects->get_project($event['project_id']))
					  {
					    $project_name = $project['description'] == '' ? $project['name'] : $project['name'].' ('.$project['description'].')';	
							$tooltip .= '<br />'.$strProject.': '. htmlspecialchars($project_name);
						}
					}
					if ($event['location'] != '')
					{
						if ($tooltip != '')
						{
							$tooltip .= "<br />";
						}
						$tooltip .= $sc_location.": ".htmlspecialchars($event['location']);
					}
					$event_cal_count = $cal->get_calendars_from_event($event['id']);
					if($view_id > 0 || $event_cal_count > 1)
					{
						$tooltip .= "<br />$cal_event_calendars: ";
						$first = true;
						while($cal->next_record())
						{
							if($first)
							{
								$first = false;
							}else
							{
								$tooltip .= ' ,';
							}						  
							$tooltip .= htmlspecialchars($cal->f('name'), ENT_QUOTES);  
						}
					}

					$all_day_events .= '<a class="calendar_event_link" href="'.$link.'?event_id='.$event['id'].'&return_to='.urlencode($link_back).'" '.$overlib->print_overlib($tooltip).'>'.htmlspecialchars($event['name']).'</a>';
					if (($event['write_permission'] || ($calendar_id > 0 && $calendar['write_permission'])) && !$print)
					{
						$all_day_events .= '</td><td valign="top" width="16" style="background-color: #'.$event['background'].'">';
						$all_day_events .= '<a href="delete_event.php?event_id='.$event['id'].'&calendar_id='.$calendar_id.'&return_to='.urlencode($link_back).'" title="'.$strDeleteItem.' "\''.htmlspecialchars($cal->f("name"), ENT_QUOTES).'\'"><img src="'.$GO_THEME->images['delete'].'" border="0"></a>';
					}
					$all_day_events .= '</td></tr>';
				}
				$all_day_events .= '</table></td>';
			}
		}
		$all_day_events .= "</tr>\r\n";
		
		if($all_day_events_count)
		{
			echo $all_day_events;
		}
	
		for ($hour_of_day=$cal_start_hour;$hour_of_day<=$cal_end_hour;$hour_of_day++)
		{
			echo '<tr id="'.$current_row.'_'.$hour_of_day.'"><td width="50" align="right" class="cal_hour">'.date($_SESSION['GO_SESSION']['time_format'], mktime($hour_of_day,0,0)).'</td>';

			//display the days row by row
			for ($day_offset=$start_day;$day_offset<$end_day;$day_offset++)
			{
				$day_to_display = $day+$day_offset;

				//make a valid date
				$new_time = mktime(0,0, 0, $month, $day_to_display, $year);
				$new_date = date('Ymd', $new_time);
				$new_day = date("j", $new_time);
				$new_month = date('m', $new_time);
				$new_year = date('Y', $new_time);

				if(isset($events['timed'][$new_date][$hour_of_day]))
				{
					echo '<td height="100%"><table height="100%" id="cal_event">';
		
					while($event = array_shift($events['timed'][$new_date][$hour_of_day]))
					{
						echo '<tr style="background-color: #'.$event['background'].';"><td width="100%">';
						$link = $event['write_permission'] ? 'event.php' : 'show_event.php';
						if (date($_SESSION['GO_SESSION']['date_format'], $event['start_time']) != date($_SESSION['GO_SESSION']['date_format'], $event['end_time']))
						{
							$date_format = $_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'];
						}else
						{
							$date_format = $_SESSION['GO_SESSION']['time_format'];
						}
						$tooltip = $sc_start_at.': '.date($date_format, $event['start_time']).'<br />'.
							$sc_end_at.': '.date($date_format, $event['end_time']);

						if($event['contact_id'] > 0 && $contact = $ab->get_contact($event['contact_id']))
						{	
							$middle_name = $contact['middle_name'] == '' ? '' : $contact['middle_name'].' ';
							$contact_name = $contact['first_name'].' '.$middle_name.$contact['last_name'];
							$tooltip .= '<br />'.$strContact.': '.htmlspecialchars($contact_name);
							if ($contact['company_name'] != '')
							{
								$tooltip .= " (".htmlspecialchars($contact['company_name']).")";
							}
							
						}elseif($event['company_id'] > 0 && $company = $ab->get_company($event['company_id']))
						{
							$tooltip .= '<br />'.$strCompany.': '.htmlspecialchars($company['name']);
				
						}elseif($event['project_id'] > 0)
						{
							if($project = $projects->get_project($event['project_id']))
						  {
						    $project_name = $project['description'] == '' ? $project['name'] : $project['name'].' ('.$project['description'].')';	
								$tooltip .= '<br />'.$strProject.': '. htmlspecialchars($project_name);
							}
						}
						if ($event['location'] != '')
						{
							$tooltip .= "<br />".$sc_location.": ".htmlspecialchars($event['location']);
						}
						$event_cal_count = $cal->get_calendars_from_event($event['id']);
						if($view_id > 0 || $event_cal_count > 1)
						{
							$tooltip .= "<br />$cal_event_calendars: ";
							$first = true;
							while($cal->next_record())
							{
								if($first)
								{
									$first = false;
								}else
								{
									$tooltip .= ' ,';
								}						  
								$tooltip .= htmlspecialchars($cal->f('name'));  
							}
						}

						echo '<a class="calendar_event_link" href="'.$link.'?event_id='.$event['id'].'&return_to='.urlencode($link_back).'" '.$overlib->print_overlib($tooltip).'>'.date($_SESSION['GO_SESSION']['time_format'], $event['start_time']).' '.htmlspecialchars($event['name']).'</a>';

						if (($event['write_permission'] || ($calendar_id > 0 && $calendar['write_permission'])) && !$print)
						{						
							echo '</td><td valign="top" width="16">';
							echo '<a href="delete_event.php?event_id='.$event['id'].'&calendar_id='.$calendar_id.'&return_to='.rawurlencode($link_back).'" title="'.$strDeleteItem.' \''.htmlspecialchars($event["name"], ENT_QUOTES).'\'"><img src="'.$GO_THEME->images['delete'].'" border="0"></a>';
						}else
						{
							echo '<td>&nbsp;</td>';
						}
						echo '</td></tr>';
					}
					echo '</table>';
				}else
				{
					if (isset($events['backgrounds'][$new_date][$hour_of_day]))
					{
						$style = ' style="background-color: #'.$events['backgrounds'][$new_date][$hour_of_day].'"';
					}else
					{
						$style = '';
					}
					echo '<td height="100%"'.$style.'>';
					if(!$print)
					{
						echo '<a onmouseover="javascript:glow_row(\''.$current_row.'_'.$hour_of_day.'\');" onmouseout="javascript:unglow_row(\''.$current_row.'_'.$hour_of_day.'\');" href="javascript:new_event('.$new_day.','.$new_month.','.$new_year.','.$hour_of_day.');"><img border="0" width="100%" height="12" src="'.$GO_THEME->images['blank'].'" /></a>';
					}

				}
				echo '</td>';
			}
		}
	}
	echo "</tr>\r\n";
}
?>
