<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */

require_once ("../../Group-Office.php");

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('addressbook');
require_once ($GO_LANGUAGE->get_language_file('addressbook'));

$custom_fields_plugin = $GO_MODULES->get_plugin('custom_fields');

$page_title = $contact_profile;
require_once ($GO_MODULES->class_path."addressbook.class.inc");
$ab = new addressbook();

$task = isset ($_REQUEST['task']) ? $_REQUEST['task'] : '';
$return_to = (isset ($_REQUEST['return_to']) && $_REQUEST['return_to'] != '') ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];
$link_back = (isset ($_REQUEST['link_back']) && $_REQUEST['link_back'] != '') ? $_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];
$contact_id = isset ($_REQUEST['contact_id']) ? $_REQUEST['contact_id'] : '0';
$vcf_file = isset ($_REQUEST['vcf_file']) ? $_REQUEST['vcf_file'] : '';

if (isset ($_REQUEST['popup'])) {
	$popup = true;
	$return_to = 'javascript:window.close();';
} else {
	$popup = false;
}
$addressbook_id = $contact['addressbook_id'] = isset ($_REQUEST['addressbook_id']) ? $_REQUEST['addressbook_id'] : $ab->get_default_addressbook($GO_SECURITY->user_id);

$templates_plugin = $GO_MODULES->get_plugin('templates');
if ($templates_plugin) {
	require_once ($templates_plugin['class_path'].'templates.class.inc');
	$tp = new templates();
}

$vcard_count = 0;
if (!empty ($vcf_file)) {
	require_once ($GO_MODULES->class_path."vcard.class.inc");
	$vcard = new vcard();
	$vcard_count = $vcard->get_count($vcf_file);
	if ($vcard_count > 0) {
		if ($record = $vcard->get_vcard_contact(0)) {
			$company = $record['company'];
		}
	}
}

switch ($task) {
	case 'save' :
		$require = 'edit_contact.inc';
		
		$contact['first_name'] = isset ($_REQUEST['first_name']) ? smart_addslashes($_REQUEST['first_name']) : '';
		$contact['middle_name'] = isset ($_REQUEST['middle_name']) ? smart_addslashes($_REQUEST['middle_name']) : '';
		$contact['last_name'] = isset ($_REQUEST['last_name']) ? smart_addslashes($_REQUEST['last_name']) : '';
		$contact['initials'] = isset ($_REQUEST['initials']) ? smart_addslashes($_REQUEST['initials']) : '';
		$contact['title'] = isset ($_REQUEST['title']) ? smart_addslashes($_REQUEST['title']) : '';
		$contact['sex'] = isset ($_REQUEST['sex']) ? smart_addslashes($_REQUEST['sex']) : 'M';
		$contact['birthday'] = isset ($_REQUEST['birthday']) ? date_to_db_date(smart_addslashes($_POST['birthday'])) : '';
		$contact['email'] = isset ($_REQUEST['email']) ? smart_addslashes($_REQUEST['email']) : '';
		$contact['work_phone'] = isset ($_REQUEST['work_phone']) ? smart_addslashes($_REQUEST['work_phone']) : '';
		$contact['home_phone'] = isset ($_REQUEST['home_phone']) ? smart_addslashes($_REQUEST['home_phone']) : '';
		$contact['fax'] = isset ($_REQUEST['fax']) ? smart_addslashes($_REQUEST['fax']) : '';
		$contact['cellular'] = isset ($_REQUEST['cellular']) ? smart_addslashes($_REQUEST['cellular']) : '';
		$contact['country'] = isset ($_REQUEST['country']) ? smart_addslashes($_REQUEST['country']) : '';
		$contact['state'] = isset ($_REQUEST['state']) ? smart_addslashes($_REQUEST['state']) : '';
		$contact['address'] = isset ($_REQUEST['address']) ? smart_addslashes($_REQUEST['address']) : '';
		$contact['address_no'] = isset ($_REQUEST['address_no']) ? smart_addslashes($_REQUEST['address_no']) : '';
		$contact['city'] = isset ($_REQUEST['city']) ? smart_addslashes($_REQUEST['city']) : '';
		$contact['zip'] = isset ($_REQUEST['zip']) ? smart_addslashes($_REQUEST['zip']) : '';
				
		$contact['company_id'] = $_POST['company_id']['value'];

		if ($contact['zip'] != '' && $contact['address'] == '' && $contact['city'] == '' && 
			$contact['state'] == '' && $contact['country'] == '' && 
			$addressinfo = $ab->get_addressinfo($contact['zip'])) {

			$contact['address'] = addslashes($addressinfo['street']);
			$contact['city'] = addslashes($addressinfo['city']);
			$contact['state'] = addslashes($addressinfo['state']);
			$contact['country'] = addslashes($addressinfo['country']);
		}
		
		$contact['department'] = isset ($_REQUEST['department']) ? smart_addslashes($_REQUEST['department']) : '';
		$contact['function'] = isset ($_REQUEST['function']) ? smart_addslashes($_REQUEST['function']) : '';
		$contact['comment'] = isset ($_REQUEST['comment']) ? smart_addslashes($_REQUEST['comment']) : '';
		$contact['color'] = isset ($_REQUEST['color']) ? smart_addslashes($_REQUEST['color']) : '000000';
		$contact['source_id'] = isset ($_REQUEST['source_id']) ? $_REQUEST['source_id'] : '';
		$contact['group_id'] = isset ($_REQUEST['group_id']) ? $_REQUEST['group_id'] : '';
		$contact['company_id'] = isset ($contact['company_id']) ? $contact['company_id'] : 0;


		if ($contact['first_name'] == '' && $contact['last_name'] == '') {
			$feedback = "<p class=\"Error\">".$error_missing_field."</p>";
		} else {
			//translate the given birthdayto gmt unix time		
			if ($contact_id > 0) {
				$contact['id'] = $contact_id;
				if ($ab->update_contact($contact)) {
					if ($_POST['close'] == 'true') {
						if ($popup) {
							echo '<script type="text/javascript">window.close()</script>';
						} else {
							if (isset ($_REQUEST['return_contact_id'])) {
								$return_to = add_params_to_url($return_to, 'contact_id='.$_REQUEST['contact_id']);
							}
							if($return_to != 'javascript:window.close();')
							{
								header('Location: '.$return_to);
							}else
							{
								echo '<script type="text/javascript">'.
								 'window.close();</script>';
							}
						}
						exit ();
					}
				} else {
					$feedback = "<p class=\"Error\">".$strSaveError."</p>";
				}
			}
			elseif (!isset($_POST['ignore']) && 
				$existing_contact_id = $ab->check_contact($GO_SECURITY->user_id, 
				$contact)) {
				$feedback = '<p class="Error">';

				$link = '<a href="contact.php?return_to='.urlencode($return_to).'&contact_id='.$existing_contact_id.'">'.$ab_here.'</a>';
				$feedback .= sprintf($ab_contact_exists, $link).'</p>';
				
				$ignore = true;
			} else {
				
				$contact['user_id'] = $GO_SECURITY->user_id;
				
				if ($contact_id = $ab->add_contact($contact)) {
					$link_back .= '&contact_id='.$contact_id;

					if ($_POST['close'] == 'true') {
						if ($popup) {
							echo '<script type="text/javascript">'.
								'if(opener.document.forms[0].multiselect.value=\'false\'){opener._click(\''.$contact_id.'\',\'contact\')};'.
								 'window.close();</script>';
							} else {
							if (isset ($_REQUEST['return_contact_id'])) {
								$return_to = add_params_to_url($return_to, 'contact_id='.$contact_id);
							}
							if($return_to != 'javascript:window.close();')
							{
								header('Location: '.$return_to);
							}else
							{
								echo '<script type="text/javascript">'.
								 'window.close();</script>';
							}
						}
						exit ();
					}
				} else {
					$feedback = "<p class=\"Error\">".$strSaveError."</p>";
				}
			}
		}

		break;

	case 'save_custom_fields' :
		if (isset ($_POST['fields'])) {
			require_once ($custom_fields_plugin['class_path'].'custom_fields.class.inc');
			$cf = new custom_fields('ab_custom_contact_fields');

			$cf->update_record($contact_id, $_POST['fields'], $_POST['values']);

			if ($_POST['close'] == 'true') {
				if ($popup) {
					echo '<script type="text/javascript">window.close()</script>';
				} else {
					if (isset ($_REQUEST['return_contact_id'])) {
						$return_to = add_params_to_url($return_to, 'contact_id='.$_REQUEST['contact_id']);
					}
					if($return_to != 'javascript:window.close();')
					{
						header('Location: '.$return_to);
					}else
					{
						echo '<script type="text/javascript">'.
						 'window.close();</script>';
					}
				}
				exit ();
			}
		}
		break;

	case 'save_mailing_groups' :
		$tp->remove_contact_from_mailing_groups($contact_id);
		if (isset ($_POST['mailing_groups'])) {
			while ($mailing_group_id = array_shift($_POST['mailing_groups'])) {
				$tp->add_contact_to_mailing_group($contact_id, $mailing_group_id);
			}
		}

		if ($_POST['close'] == 'true') {
			if ($popup) {
				echo '<script type="text/javascript">window.close()</script>';
			} else {
				if (isset ($_REQUEST['return_contact_id'])) {
					$return_to = add_params_to_url($return_to, 'contact_id='.$_REQUEST['contact_id']);
				}
				header('Location: '.$return_to);
			}
			exit ();
		}
		break;

	case 'start_timer' :
		$active_tab = 'activities';
		break;

	default :
		$require = 'edit_contact.inc';
		break;
}

if ($contact_id > 0) {
	$contact = $ab->get_contact($contact_id);
	$write_permission = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $contact["acl_write"]);
	if (!$write_permission && !$GO_SECURITY->has_permission($GO_SECURITY->user_id, $contact["acl_read"])) {
		Header("Location: ".$GO_CONFIG->host."error_docs/403.php");
		exit ();
	}
	if (!$write_permission) {
		$require = 'show_contact.inc';
	}
	$birthday = $contact['birthday'] > 0 ? db_date_to_date($contact['birthday']) : '';
	$addressbook_id = isset ($_REQUEST['addressbook_id']) ? $_REQUEST['addressbook_id'] : $contact['addressbook_id'];
}

if (isset ($_REQUEST['user_id']) && $_REQUEST['user_id'] > 0) {
	$contact = $GO_USERS->get_user($_REQUEST['user_id']);

	if ($ab->user_is_contact($GO_SECURITY->user_id, $_REQUEST['user_id'])) {
		$feedback = "<p class='Error'>".$contact_exist_warning."</p>";
		$contact['source_id'] = "";
	} else {
		$contact['source_id'] = $_REQUEST['user_id'];
	}
	$contact['company_name'] = $contact['company'];
	$contact['company_id'] = $ab->get_company_id_by_name($contact['company'], $contact['addressbook_id']);
	$contact['group_id'] = isset ($_REQUEST['group_id']) ? $_REQUEST['group_id'] : '';
	$birthday = $contact['birthday'] > 0 ? db_date_to_date($contact['birthday']) : '';
	$require = 'edit_contact.inc';
	//}elseif (($contact_id == 0 || $task != '') && $task != 'save_custom_fields')
}
elseif ($contact_id == 0 || $task == 'save') {
	$require = 'edit_contact.inc';;
	$contact['first_name'] = isset ($_REQUEST['first_name']) ? smart_stripslashes($_REQUEST['first_name']) : '';
	$contact['middle_name'] = isset ($_REQUEST['middle_name']) ? smart_stripslashes($_REQUEST['middle_name']) : '';
	$contact['last_name'] = isset ($_REQUEST['last_name']) ? smart_stripslashes($_REQUEST['last_name']) : '';
	$contact['initials'] = isset ($_REQUEST['initials']) ? smart_stripslashes($_REQUEST['initials']) : '';
	$contact['title'] = isset ($_REQUEST['title']) ? smart_stripslashes($_REQUEST['title']) : '';
	$contact['sex'] = isset ($_REQUEST['sex']) ? smart_stripslashes($_REQUEST['sex']) : 'M';
	$birthday = isset ($_REQUEST['birthday']) ? smart_stripslashes($_REQUEST['birthday']) : '';
	$contact['email'] = isset ($_REQUEST['email']) ? smart_stripslashes($_REQUEST['email']) : '';
	$contact['work_phone'] = isset ($_REQUEST['work_phone']) ? smart_stripslashes($_REQUEST['work_phone']) : '';
	$contact['home_phone'] = isset ($_REQUEST['home_phone']) ? smart_stripslashes($_REQUEST['home_phone']) : '';
	$contact['fax'] = isset ($_REQUEST['fax']) ? smart_stripslashes($_REQUEST['fax']) : '';
	$contact['cellular'] = isset ($_REQUEST['cellular']) ? smart_stripslashes($_REQUEST['cellular']) : '';
	$contact['country'] = isset ($_REQUEST['country']) ? smart_stripslashes($_REQUEST['country']) : '';
	$contact['state'] = isset ($_REQUEST['state']) ? smart_stripslashes($_REQUEST['state']) : '';
	$contact['address'] = isset ($_REQUEST['address']) ? smart_stripslashes($_REQUEST['address']) : '';
	$contact['address_no'] = isset ($_REQUEST['address_no']) ? smart_stripslashes($_REQUEST['address_no']) : '';
	$contact['city'] = isset ($_REQUEST['city']) ? smart_stripslashes($_REQUEST['city']) : '';
	$contact['zip'] = isset ($_REQUEST['zip']) ? smart_stripslashes($_REQUEST['zip']) : '';

	if ($contact['zip'] != '' && $contact['address'] == '' && $contact['city'] == '' && $addressinfo = $ab->get_addressinfo($contact['zip'])) {
		$contact['address'] = $addressinfo['street'];
		$contact['city'] = $addressinfo['city'];
	}

	$contact['department'] = isset ($_REQUEST['department']) ? smart_stripslashes($_REQUEST['department']) : '';
	$contact['function'] = isset ($_REQUEST['function']) ? smart_stripslashes($_REQUEST['function']) : '';
	$contact['comment'] = isset ($_REQUEST['comment']) ? smart_stripslashes($_REQUEST['comment']) : '';
	$contact['color'] = isset ($_REQUEST['color']) ? smart_stripslashes($_REQUEST['color']) : '000000';
	$contact['source_id'] = isset ($_REQUEST['source_id']) ? $_REQUEST['source_id'] : '';
	$contact['group_id'] = isset ($_REQUEST['group_id']) ? $_REQUEST['group_id'] : '';
	
	if(isset($_REQUEST['company_id']) && !is_array($_REQUEST['company_id']))
	{
		$contact['company_id'] = $_REQUEST['company_id'];
	}else
	{
		$contact['company_id'] = isset ($contact['company_id']) ? $contact['company_id'] : 0;
	}
}

if ($task == 'update') {
	$contact = $GO_USERS->get_user($contact['source_id']);
	$contact["source_id"] = $_REQUEST['source_id'];
	$contact['comment'] = $_REQUEST['comment'];
	$contact['group_id'] = $_REQUEST['group_id'];
	$contact['addressbook_id'] = $_REQUEST['addressbook_id'];
	$contact['company_id'] = $_REQUEST['company_id'];
	$birthday = $contact['birthday'] > 0 ? db_date_to_date($contact['birthday']) : '';
}

$datepicker = new date_picker();
$GO_HEADER['head'] = $datepicker->get_header();
$overlib = new overlib();
$GO_HEADER['head'] .= $overlib->get_header();

require_once ($GO_THEME->theme_path."header.inc");

echo '<form name="contact_form" method="post" action="'.$_SERVER['PHP_SELF'].'">';

//set this var if the user wants to ignore that a similar contact already exists.
if(isset($ignore))
{
	echo '<input type="hidden" name="ignore" value="true" />'; 
}

echo '<input type="hidden" value="'.$contact["source_id"].'" name="source_id" />';
echo '<input type="hidden" name="task" value="" />';
echo '<input type="hidden" name="close" value="false" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="link_back" value="'.$link_back.'" />';
echo '<input type="hidden" name="contact_id" value="'.$contact_id.'" />';
if (isset ($vcf_file)) {
	echo '<input type="hidden" name="vcf_file" value="'.$vcf_file.'" />';
}
if ($popup) {
	echo '<input type="hidden" name="popup" value="true" />';
}
if (isset ($_REQUEST['return_contact_id'])) {
	echo '<input type="hidden" name="return_contact_id" value="1" />';
}

echo '<table border="0"><tr>';

$title = $contact_id > 0 ? $ab_contact : $contacts_add;

$tabtable = new tabtable('contact_table', $title, '100%', '400', '120', '&contact_id='.$contact_id.'&return_to='.urlencode($return_to), false, 'left', 'top', 'add', 'vertical');

$active_tab = isset ($_REQUEST['active_tab']) ? $_REQUEST['active_tab'] : null;
if (isset ($active_tab)) {
	$tabtable->set_active_tab($active_tab);
}

if ($contact_id > 0) {
	$tabtable->add_tab('profile', $contact_profile);

	if ($contact['email'] != '') {
		$middle_name = $contact['middle_name'] == '' ? '' : $contact['middle_name'].' ';
		$name = $contact['first_name'].' '.$middle_name.$contact['last_name'];
		$full_email = '"'.$name.'" <'.$contact['email'].'>';
		echo '<td class="ModuleIcons" nowrap>';
		echo mail_to(addslashes($full_email), '<img src="'.$GO_THEME->images['ab_email'].'" border="0" height="32" width="32" /><br />'.$ab_send_message, 'small', true, $contact_id);
		echo '</td>';

		if (isset ($GO_MODULES->modules['email']) && $GO_MODULES->modules['email']['read_permission']) {
			echo '<td class="ModuleIcons" nowrap>';
			echo '<a href="'.$GO_MODULES->modules['email']['url'].'index.php?task=set_search_query&from='.$contact['email'].'&return_to='.urlencode($link_back).'" title="'.$ab_search_sender.'"><img src="'.$GO_THEME->images['ml_search'].'" border="0" '.'align="absmiddle" /><br />'.$ab_search_sender.'</a>';
			echo '</td>';
		}
	}

	if ($templates_plugin) {
		if ($tp->has_oo_templates($GO_SECURITY->user_id)) {
			echo '<td class="ModuleIcons" nowrap>';
			echo '<a target="_blank" href="'.$GO_MODULES->url.'templates/download_oo_template.php?contact_id='.$contact_id.'"><img src="'.$GO_THEME->images['new_letter'].'" border="0" height="32" width="32" /><br />'.$ab_oo_doc.'</td>';
			echo '</td>';
		}

		if ($contact['email'] != '' && $tp->get_mailing_groups($GO_SECURITY->user_id) && $write_permission) {
			$tabtable->add_tab('mailings', $ab_mailings);
		}
	}

	$projects_module = isset ($GO_MODULES->modules['projects']) ? $GO_MODULES->modules['projects'] : false;
	$notes_module = isset ($GO_MODULES->modules['notes']) ? $GO_MODULES->modules['notes'] : false;
	$calendar_module = isset ($GO_MODULES->modules['calendar']) ? $GO_MODULES->modules['calendar'] : false;
	$todos_module = isset ($GO_MODULES->modules['todos']) ? $GO_MODULES->modules['todos'] : false;

	if ($write_permission) {
		if ($projects_module && $projects_module['read_permission']) {
			echo '<td  class="ModuleIcons" nowrap>';
			echo '<a href="'.$projects_module['url'].'project.php?contact_id='.$contact_id.'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['pr_new_project'].'" border="0" height="32" width="32" /><br />'.$strNewProject.'</td>';
		}

		if ($notes_module && $notes_module['read_permission']) {
			echo '<td  class="ModuleIcons" nowrap>';
			echo '<a href="'.$notes_module['url'].'note.php?contact_id='.$contact_id.'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['ab_notes'].'" border="0" height="32" width="32" /><br />'.$strNewNote.'</td>';
		}

		if ($calendar_module && $calendar_module['read_permission']) {
			echo '<td class="ModuleIcons" nowrap>';
			echo '<a href="'.$calendar_module['url'].'index.php?contact_id='.$contact_id.'&link_back='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['cal_compose'].'" border="0" height="32" width="32" /><br />'.$strNewEvent.'</td>';
			echo '</td>';
		}

		if ($todos_module && $notes_module['read_permission']) {
			echo '<td  class="ModuleIcons" nowrap>';
			echo '<a href="'.$todos_module['url'].'todo.php?contact_id='.$contact_id.'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['todos_new'].'" border="0" height="32" width="32" /><br />'.$strNewTodo.'</td>';
		}
	}

	$tabtable->add_tab('activities', $strActivities);

	if ($custom_fields_plugin) {
		require_once ($custom_fields_plugin['class_path'].'custom_fields.class.inc');
		$cf = new custom_fields('ab_custom_contact_fields');

		if ($cf->get_catagories($GO_SECURITY->user_id) > 0) {
			while ($cf->next_record()) {
				$tabtable->add_tab($cf->f('id'), $cf->f('name'));
			}
		}
	}

}
echo '</tr></table>';

$tabtable->print_head();

if ($tabtable->get_active_tab_id() > 0) {
	$catagory_id = $tabtable->get_active_tab_id();
	$active_tab_id = 'custom_fields';
} else {
	$active_tab_id = $tabtable->get_active_tab_id();
}

switch ($active_tab_id) {
	case 'mailings' :
		require_once ($templates_plugin['path'].'mailing_groups.inc');
		break;

	case 'custom_fields' :
		require_once ('custom_fields/custom_fields.inc');
		break;

	case 'activities' :
		require_once ('activities.inc');
		break;

	default :
		if ($vcard_count > 0 && $contact_id == 0) {
			if ($record = $vcard->get_vcard_contact(0)) {
				$contact = $record['contact'];
				$contact['addressbook_id'] = $addressbook_id;
				$birthday = !empty ($contact['birthday']) ? date("d-m-Y", strtotime($contact['birthday'])) : "";
			}
		}
		require_once ($require);
		break;
}
$tabtable->print_foot();

echo '</form>';
require_once ($GO_THEME->theme_path."footer.inc");
?>