<?php

/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once ("../../Group-Office.php");

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('addressbook');
require_once ($GO_LANGUAGE->get_language_file('addressbook'));

$page_title = $contact_profile;
require_once ($GO_MODULES->class_path."addressbook.class.inc");
$ab = new addressbook();

$custom_fields_plugin = $GO_MODULES->get_plugin('custom_fields');

$templates_plugin = $GO_MODULES->get_plugin('templates');
if ($templates_plugin) {
	require_once ($templates_plugin['class_path'].'templates.class.inc');
	$tp = new templates();
}

$task = isset ($_REQUEST['task']) ? $_REQUEST['task'] : '';
$return_to = (isset ($_REQUEST['return_to']) && $_REQUEST['return_to'] != '') ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];
$link_back = (isset ($_REQUEST['link_back']) && $_REQUEST['link_back'] != '') ? $_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];

$company_id = isset ($_REQUEST['company_id']) ? $_REQUEST['company_id'] : '0';
$vcf_file = isset ($_REQUEST['vcf_file']) ? $_REQUEST['vcf_file'] : '';

if (isset ($_REQUEST['popup'])) {
	$popup = true;
	$return_to = 'javascript:window.close();';
} else {
	$popup = false;
}

$addressbook_id = isset ($_REQUEST['addressbook_id']) ? $_REQUEST['addressbook_id'] : '0';

//remember sorting of the projects list in a cookie
if (isset ($_REQUEST['new_sort_field'])) {
	SetCookie("contact_sort", $_REQUEST['new_sort_field'], time() + 3600 * 24 * 365, "/", "", 0);
	$_COOKIE['contact_sort'] = $_REQUEST['new_sort_field'];
}

if (isset ($_REQUEST['new_sort_direction'])) {
	SetCookie("contact_direction", $_REQUEST['new_sort_direction'], time() + 3600 * 24 * 365, "/", "", 0);
	$_COOKIE['contact_direction'] = $_REQUEST['new_sort_direction'];
}

//save
switch ($task) {
	case 'save_company' :
		$company['name'] = isset ($_REQUEST['name']) ? smart_addslashes($_REQUEST['name']) : '';
	$company['address'] = isset ($_REQUEST['address']) ? smart_addslashes($_REQUEST['address']) : '';
	$company['address_no'] = isset ($_REQUEST['address_no']) ? smart_addslashes($_REQUEST['address_no']) : '';
	$company['zip'] = isset ($_REQUEST['zip']) ? smart_addslashes($_REQUEST['zip']) : '';
	$company['city'] = isset ($_REQUEST['city']) ? smart_addslashes($_REQUEST['city']) : '';

	if ($company['zip'] != '' && $company['address'] == '' && $company['city'] == '' && $addressinfo = $ab->get_addressinfo($company['zip'])) {
		$company['address'] = $addressinfo['street'];
		$company['city'] = $addressinfo['city'];
	}

	$company['state'] = isset ($_REQUEST['state']) ? smart_addslashes($_REQUEST['state']) : '';

	$company['post_address'] = isset ($_REQUEST['post_address']) ? smart_addslashes($_REQUEST['post_address']) : '';
	$company['post_address_no'] = isset ($_REQUEST['post_address_no']) ? smart_addslashes($_REQUEST['post_address_no']) : '';
	$company['post_zip'] = isset ($_REQUEST['post_zip']) ? smart_addslashes($_REQUEST['post_zip']) : '';
	$company['post_city'] = isset ($_REQUEST['post_city']) ? smart_addslashes($_REQUEST['post_city']) : '';

	if ($company['post_zip'] != '' && $company['post_address'] == '' && $company['post_city'] == '' && $addressinfo = $ab->get_addressinfo($company['post_zip'])) {
		$company['post_address'] = $addressinfo['street'];
		$company['post_city'] = $addressinfo['city'];
	}

	$company['post_state'] = isset ($_REQUEST['post_state']) ? smart_addslashes($_REQUEST['post_state']) : '';
	$company['post_country'] = isset ($_REQUEST['post_country']) ? smart_addslashes($_REQUEST['post_country']) : '';

	$company['email'] = isset ($_REQUEST['email']) ? smart_addslashes($_REQUEST['email']) : '';
	$company['country'] = isset ($_REQUEST['country']) ? smart_addslashes($_REQUEST['country']) : '';
	$company['phone'] = isset ($_REQUEST['phone']) ? smart_addslashes($_REQUEST['phone']) : '';
	$company['fax'] = isset ($_REQUEST['fax']) ? smart_addslashes($_REQUEST['fax']) : '';
	$company['homepage'] = isset ($_REQUEST['homepage']) ? smart_addslashes($_REQUEST['homepage']) : '';
	$company['bank_no'] = isset ($_REQUEST['bank_no']) ? smart_addslashes($_REQUEST['bank_no']) : '';
	$company['vat_no'] = isset ($_REQUEST['vat_no']) ? smart_addslashes($_REQUEST['vat_no']) : '';

		if ($_REQUEST['homepage']  != '' && !eregi('http', $_REQUEST['homepage'])) {
			$company['homepage'] = 'http://'.smart_addslashes($_REQUEST['homepage']);
		}
		$company['addressbook_id']  = $addressbook_id;

		if ($company['name'] == '') {
			$feedback = "<p class=\"Error\">".$error_missing_field."</p>";
		} else {
			if ($company_id > 0) {
				$company['id'] = $company_id;
				if ($ab->update_company($company)) {
					if ($_POST['close'] == 'true') {
						if ($popup) {
							echo '<script type="text/javascript">window.close();</script>';
						} else {
							if (isset ($_REQUEST['return_company_id'])) {
								$return_to = add_params_to_url($return_to, 'company_id='.$_REQUEST['company_id']);
							}
							header('Location: '.$return_to);
						}
						exit ();
					}
				} else {
					$feedback = "<p class=\"Error\">".$strSaveError."</p>";
				}
			}elseif (!isset($_POST['ignore']) && $existing_company_id = $ab->check_company($GO_SECURITY->user_id, $company)) {
				$feedback = '<p class="Error">';

				$link = '<a href="company.php?return_to='.urlencode($return_to).'&company_id='.$existing_company_id.'">'.$ab_here.'</a>';
				$feedback .= sprintf($ab_company_exists, $link).'</p>';
				
				$ignore = true;
				
			} else {
				if ($company_id = $ab->add_company($company)) {

					if ($_POST['close'] == 'true') {
						if ($popup) {
							echo '<script type="text/javascript">'.
								'if(opener.document.forms[0].multiselect.value=\'false\'){opener._click(\''.$company_id.'\',\'company\')};'.
								 'window.close();</script>';
						} else {
							if (isset ($_REQUEST['return_company_id'])) {
								$return_to = add_params_to_url($return_to, 'company_id='.$_REQUEST['company_id']);
							}

							header('Location: '.$return_to);
						}
						exit ();
					}
				} else {
					$feedback = "<p class=\"Error\">".$strSaveError."</p>";
				}
			}
		}
		break;

	case 'save_custom_fields' :
		if (isset ($_POST['fields'])) {
			require_once ($custom_fields_plugin['class_path'].'custom_fields.class.inc');
			$cf = new custom_fields('ab_custom_company_fields');

			$cf->update_record($company_id, $_POST['fields'], $_POST['values']);
			if ($_POST['close'] == 'true') {
				if ($popup) {
					echo '<script type="text/javascript">window.close()</script>';
				} else {
					if (isset ($_REQUEST['return_contact_id'])) {
						$return_to = add_params_to_url($return_to, 'contact_id='.$_REQUEST['contact_id']);
					}
					header('Location: '.$return_to);
				}
				exit ();
			}
		}
		break;

	case 'save_mailing_groups' :
		$tp->remove_company_from_mailing_groups($company_id);
		if (isset ($_POST['mailing_groups'])) {
			while ($mailing_group_id = array_shift($_POST['mailing_groups'])) {
				$tp->add_company_to_mailing_group($company_id, $mailing_group_id);
			}
		}
		break;
}

$vcard_count = 0;
if (!empty ($vcf_file)) {
	require_once ($GO_MODULES->class_path."vcard.class.inc");
	$vcard = new vcard();
	$vcard_count = $vcard->get_count($vcf_file);
}

//check permissions
if ($company_id > 0 && $company = $ab->get_company($company_id)) {
	$addressbook_id = $company['addressbook_id'];
	if (!$write_permission = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $company['acl_write'])) {
		$read_permission = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $company['acl_read']);
	}

	$tabtable = new tabtable('company_table', $company['name'], '100%', '400', '120', '', true, 'left', 'top', 'company_form', 'vertical');

	$tabtable->add_tab('profile', $ab_company_properties);
	if ($templates_plugin) {

		if ($company['email'] != '' && $tp->get_mailing_groups($GO_SECURITY->user_id) && $write_permission) {
			$tabtable->add_tab('mailings', $ab_mailings);
		}
	}

	$tabtable->add_tab('contacts', $ab_employees);
	$tabtable->add_tab('activities', $strActivities);

	if ($custom_fields_plugin) {
		require_once ($custom_fields_plugin['class_path'].'custom_fields.class.inc');
		$cf = new custom_fields('ab_custom_company_fields');

		if ($cf->get_catagories($GO_SECURITY->user_id) > 0) {
			while ($cf->next_record()) {
				$tabtable->add_tab($cf->f('id'), $cf->f('name'));
			}
		}
	}

} else {
	$tabtable = new tabtable('company_table', $ab_new_company, '100%', '400', '120', '', true, 'left', 'top', 'company_form');
	$write_permission = true;
	$read_permission = true;
}

if (!$write_permission && !$read_permission) {
	header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
	exit ();
}
$overlib = new overlib();
$GO_HEADER['head'] = $overlib->get_header();
require_once ($GO_THEME->theme_path."header.inc");

$active_tab = isset ($_REQUEST['active_tab']) ? $_REQUEST['active_tab'] : null;
if (isset ($active_tab)) {
	$tabtable->set_active_tab($active_tab);
} else {
	$link_back .= '&active_tab='.$tabtable->active_tab;
}

if ($tabtable->get_active_tab_id() == 'contacts') {
	$ab->enable_contact_selector();
}

echo '<form method="post" name="company_form" action="'.$_SERVER['PHP_SELF'].'">';
//set this var if the user wants to ignore that a similar company already exists.
if(isset($ignore))
{
	echo '<input type="hidden" name="ignore" value="true" />'; 
}
echo '<input type="hidden" name="task" value="" />';
echo '<input type="hidden" name="close" value="false" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="link_back" value="'.$link_back.'" />';
echo '<input type="hidden" name="company_id" value="'.$company_id.'" />';
if ($popup) {
	echo '<input type="hidden" name="popup" value="true" />';
}

if ($company_id == 0 || $task == 'save_company') {
	$company['name'] = isset ($_REQUEST['name']) ? smart_stripslashes($_REQUEST['name']) : '';
	$company['address'] = isset ($_REQUEST['address']) ? smart_stripslashes($_REQUEST['address']) : '';
	$company['address_no'] = isset ($_REQUEST['address_no']) ? smart_stripslashes($_REQUEST['address_no']) : '';
	$company['zip'] = isset ($_REQUEST['zip']) ? smart_stripslashes($_REQUEST['zip']) : '';
	$company['city'] = isset ($_REQUEST['city']) ? smart_stripslashes($_REQUEST['city']) : '';

	if ($company['zip'] != '' && $company['address'] == '' && $company['city'] == '' && $addressinfo = $ab->get_addressinfo($company['zip'])) {
		$company['address'] = $addressinfo['street'];
		$company['city'] = $addressinfo['city'];
	}

	$company['state'] = isset ($_REQUEST['state']) ? smart_stripslashes($_REQUEST['state']) : '';

	$company['post_address'] = isset ($_REQUEST['post_address']) ? smart_stripslashes($_REQUEST['post_address']) : '';
	$company['post_address_no'] = isset ($_REQUEST['post_address_no']) ? smart_stripslashes($_REQUEST['post_address_no']) : '';
	$company['post_zip'] = isset ($_REQUEST['post_zip']) ? smart_stripslashes($_REQUEST['post_zip']) : '';
	$company['post_city'] = isset ($_REQUEST['post_city']) ? smart_stripslashes($_REQUEST['post_city']) : '';

	if ($company['post_zip'] != '' && $company['post_address'] == '' && $company['post_city'] == '' && $addressinfo = $ab->get_addressinfo($company['post_zip'])) {
		$company['post_address'] = $addressinfo['street'];
		$company['post_city'] = $addressinfo['city'];
	}

	$company['post_state'] = isset ($_REQUEST['post_state']) ? smart_stripslashes($_REQUEST['post_state']) : '';
	$company['post_country'] = isset ($_REQUEST['post_country']) ? smart_stripslashes($_REQUEST['post_country']) : '';

	$company['email'] = isset ($_REQUEST['email']) ? smart_stripslashes($_REQUEST['email']) : '';
	$company['country'] = isset ($_REQUEST['country']) ? smart_stripslashes($_REQUEST['country']) : '';
	$company['phone'] = isset ($_REQUEST['phone']) ? smart_stripslashes($_REQUEST['phone']) : '';
	$company['fax'] = isset ($_REQUEST['fax']) ? smart_stripslashes($_REQUEST['fax']) : '';
	$company['homepage'] = isset ($_REQUEST['homepage']) ? smart_stripslashes($_REQUEST['homepage']) : '';
	$company['bank_no'] = isset ($_REQUEST['bank_no']) ? smart_stripslashes($_REQUEST['bank_no']) : '';
	$company['vat_no'] = isset ($_REQUEST['vat_no']) ? smart_stripslashes($_REQUEST['vat_no']) : '';
}

if ($company_id > 0) {
	echo '<table border="0"><tr>';
	if ($company['email'] != '') {
		$full_email = '"'.$company['name'].'" <'.$company['email'].'>';
		echo '<td class="ModuleIcons" nowrap>';
		echo mail_to(addslashes($full_email), '<img src="'.$GO_THEME->images['ab_email'].'" border="0" height="32" width="32" /><br />'.$ab_send_message, 'small', true, 0, $company_id);
		echo '</td>';

		if (isset ($GO_MODULES->modules['email']) && $GO_MODULES->modules['email']['read_permission']) {
			echo '<td class="ModuleIcons" nowrap>';
			echo '<a href="'.$GO_MODULES->modules['email']['url'].'index.php?task=set_search_query&from='.$company['email'].'&return_to='.urlencode($link_back).'" title="'.$ab_search_sender.'"><img src="'.$GO_THEME->images['ml_search'].'" border="0" '.'align="absmiddle" /><br />'.$ab_search_sender.'</a>';
			echo '</td>';
		}
	}

	if ($templates_plugin) {
		if ($tp->has_oo_templates($GO_SECURITY->user_id)) {
			echo '<td class="ModuleIcons" nowrap>';
			echo '<a target="_blank" href="'.$GO_MODULES->url.'templates/download_oo_template.php?company_id='.$company_id.'"><img src="'.$GO_THEME->images['new_letter'].'" border="0" height="32" width="32" /><br />'.$ab_oo_doc.'</td>';
			echo '</td>';
		}
	}
	$todos_module = isset ($GO_MODULES->modules['todos']) ? $GO_MODULES->modules['todos'] : false;
	$projects_module = isset ($GO_MODULES->modules['projects']) ? $GO_MODULES->modules['projects'] : false;
	$notes_module = isset ($GO_MODULES->modules['notes']) ? $GO_MODULES->modules['notes'] : false;
	$calendar_module = isset ($GO_MODULES->modules['calendar']) ? $GO_MODULES->modules['calendar'] : false;

	if ($write_permission) {

		if ($projects_module && $projects_module['read_permission']) {
			echo '<td  class="ModuleIcons" nowrap>';
			echo '<a href="'.$projects_module['url'].'project.php?company_id='.$company_id.'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['pr_new_project'].'" border="0" height="32" width="32" /><br />'.$strNewProject.'</td>';
		}

		if ($notes_module && $notes_module['read_permission']) {
			echo '<td  class="ModuleIcons" nowrap>';
			echo '<a href="'.$notes_module['url'].'note.php?company_id='.$company_id.'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['ab_notes'].'" border="0" height="32" width="32" /><br />'.$strNewNote.'</td>';
		}

		if ($calendar_module && $calendar_module['read_permission']) {
			echo '<td class="ModuleIcons" nowrap>';
			echo '<a href="'.$calendar_module['url'].'index.php?company_id='.$company_id.'&link_back='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['cal_compose'].'" border="0" height="32" width="32" /><br />'.$strNewEvent.'</td>';
			echo '</td>';
		}

		if ($todos_module && $notes_module['read_permission']) {
			echo '<td  class="ModuleIcons" nowrap>';
			echo '<a href="'.$todos_module['url'].'todo.php?company_id='.$company_id.'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['todos_new'].'" border="0" height="32" width="32" /><br />'.$strNewTodo.'</td>';
		}
	}

	echo '</tr></table>';
}

$tabtable->print_head($return_to);
if ($tabtable->get_active_tab_id() > 0) {
	$catagory_id = $tabtable->get_active_tab_id();
	$active_tab_id = 'custom_fields';
} else {
	$active_tab_id = $tabtable->get_active_tab_id();
}

switch ($active_tab_id) {
	case 'mailings' :
		require_once ($templates_plugin['path'].'mailing_groups.inc');
		break;

	case 'custom_fields' :
		require_once ('custom_fields/custom_fields.inc');
		break;

	case 'contacts' :
		require_once ('company_contacts.inc');
		break;

	case 'activities' :
		require_once ('activities.inc');
		break;

	default :
		if ($vcard_count > 0 && $company_id == 0) {
			if ($record = $vcard->get_vcard_contact(0)) {
				$company = $record['company'];
				$company['addressbook_id'] = $addressbook_id;
			}
		}
		if ($write_permission) {
			require_once ('edit_company.inc');
		} else {
			require_once ('show_company.inc');
		}
		break;
}

$tabtable->print_foot();

echo '</form>';
require_once ($GO_THEME->theme_path."footer.inc");
?>