<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

if (isset($_POST['task']))
{
	switch($_POST['task'])
	{
	 case 'delete_companies';
		for ($i=0;$i<sizeof($_POST['companies']);$i++)
		{
			$company = $ab->get_company($_POST['companies'][$i]);

			if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $company['acl_write']))
			{
				$ab->delete_company($_POST['companies'][$i]);
			}
		}
	break;
	case "move_to_addressbook":
    $move_ab = $ab->get_addressbook($_POST['move_addressbook_id']);
    
    if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $move_ab['acl_write']))
    {
      if (isset($_POST['companies']))
      {
		for ($i=0;$i<sizeof($_POST['companies']);$i++)
		{
		  $ab->move_company_to_addressbook($_POST['companies'][$i], $_POST['move_addressbook_id']);
		}
      }
    }
  break;
  }
}

//define the items to show
$max_rows = isset($_REQUEST['max_rows']) ? $_REQUEST['max_rows'] : $_SESSION['GO_SESSION']['max_rows_list'];
$first = isset($_REQUEST['first']) ? $_REQUEST['first'] : 0;

if(isset($_REQUEST['new_sort_order']) && $_REQUEST['new_sort_order'] != $ab_settings['sort_companies_order'])
{
  $ab_settings['sort_companies_order'] = $_REQUEST['new_sort_order'];
  $ab_settings['sort_companies_field'] = $_REQUEST['new_sort_field'];  
		  
	$ab->update_settings($ab_settings);
}

if ($ab_settings['sort_companies_order'] == "DESC")
{
	$sort_arrow = '&nbsp;<img src="'.$GO_THEME->images['arrow_down'].'" border="0" />';
	$new_sort_order = "ASC";
}else
{
	$sort_arrow = '&nbsp;<img src="'.$GO_THEME->images['arrow_up'].'" border="0" />';
	$new_sort_order = "DESC";
}

echo '<input type="hidden" name="first" value="'.$first.'" />';
echo '<input type="hidden" name="max_rows" value="'.$max_rows.'" />';
echo '<input type="hidden" name="task" />';
echo '<input type="hidden" name="new_sort_field" value="'.$ab_settings['sort_companies_field'].'" />';
echo '<input type="hidden" name="new_sort_order" value="'.$ab_settings['sort_companies_order'].'" />';
?>
<table border="0" width="100%">
<tr>
	<?php
	if ($ab->get_subscribed_addressbooks($GO_SECURITY->user_id) > 1)
	{
		echo '<td>'.$ab_addressbook.':</td><td nowrap>';
		$subscribed_addressbooks = new dropbox();
		while ($ab->next_record())
		{
			$subscribed_addressbooks->add_value($ab->f('id'), $ab->f('name'));
		}
		$subscribed_addressbooks->print_dropbox('addressbook_id', $addressbook_id, 'onchange="javascript:document.forms[0].submit()"');
		
	}else
	{
		echo '<input type="hidden" name="addressbook_id" value="'.$addressbook_id.'" />';
	}

	if($ab->get_subscribed_addressbooks($GO_SECURITY->user_id) > 1)
	{
		$subscribed_addressbooks = new dropbox();
		$subscribed_addressbooks->add_value('0', $ab_move_com_to_ab);

		while ($ab->next_record())
		{
			  	if($ab->f('id') != $addressbook_id)
	  			{
	  				$subscribed_addressbooks->add_value($ab->f('id'), $ab->f('name'));   
	  			}
		}
		$subscribed_addressbooks->print_dropbox('move_addressbook_id', '0', 'onchange="javascript:move_to_addressbook()"');
	}
	?>
	</td>
	<td align="right" class="small" width="100%">
	<?php
	$count = $ab->get_companies($addressbook_id, $ab_settings['sort_companies_field'], $ab_settings['sort_companies_order'], $first, $max_rows);
	$str_count = $count == 1 ? $ab_companies_count_single : $ab_companies_count;
	echo $count.' '.$str_count;
	?>
	</td>
</tr>
</table>
<table width="100%" class="go_table">
<tr height="20">
	<th width="16"><input type="checkbox" name="dummy" value="dummy" onclick="javascript:invert_selection()" /></th>
	<th><a href="javascript:_sort('name','<?php echo $new_sort_order; ?>');"><?php echo $strName; ?>
	<?php
	if ($ab_settings['sort_companies_field'] == 'name')
	{
		echo $sort_arrow;
	}
	?>
	</a>
	</th>
	<th><a href="javascript:_sort('city','<?php echo $new_sort_order; ?>');"><?php echo $strCity; ?>
	<?php
	if ($ab_settings['sort_companies_field'] == 'city')
	{
		echo $sort_arrow;
	}
	?>
	</a>
	</th>
	<th><a href="javascript:_sort('email','<?php echo $new_sort_order; ?>');"><?php echo $strEmail; ?>
	<?php
	if ($ab_settings['sort_companies_field'] == 'email')
	{
		echo $sort_arrow;
	}
	?>
	</a>
	</th>
	<th><a href="javascript:_sort('homepage','<?php echo $new_sort_order; ?>');"><?php echo $strHomepage; ?>
	<?php
	if ($ab_settings['sort_companies_field'] == 'homepage')
	{
		echo $sort_arrow;
	}
	?>
	</a>
	</th>
	<th><a href="javascript:_sort('phone','<?php echo $new_sort_order; ?>');"><?php echo $strPhone; ?>
	<?php
	if ($ab_settings['sort_companies_field'] == 'phone')
	{
		echo $sort_arrow;
	}
	?>
	</a>
	</th>
</tr>

<?php
if ($count > 0)
{
	while($ab->next_record())
	{
		$full_email = ($ab->f("email") != "") ? '"'.$ab->f('name').'" <'.$ab->f('email').'>' : '';
		echo '<tr id="'.$ab->f("id").'">'.
			'<td width="16"><input id="'.addslashes($ab->f('name')).'" type="checkbox" onclick="javascript:item_click(this)" name="companies[]" value="'.$ab->f("id").'" /></td>'.
			'<td><a class="normal" href="'.$GO_MODULES->url.'company.php?company_id='.$ab->f('id').'&return_to='.rawurlencode($link_back).'">'.htmlspecialchars($ab->f('name')).'</a></td>'.
			'<td>'.$ab->f('city').'</td>'.
			'<td>'.mail_to(addslashes($full_email), $ab->f('email')).'</td>'.
			'<td><a class="normal" target="_blank" href="'.$ab->f('homepage').'">'.$ab->f('homepage').'</a></td>'.
			'<td>'.$ab->f('phone').'</td>';
		
	}

	$links = '';
	$max_links=10;
	if ($max_rows != 0)
	{
		if ($count > $max_rows)
		{
			$links = '<table class="navLinks"><tr><td>';
			$next_start = $first+$max_rows;
			$previous_start = $first-$max_rows;
			if ($first != 0)
			{
				$links .= '<a href="javascript:change_list(0, '.$max_rows.');">&lt&lt</a>&nbsp;';
				$links .= '<a href="javascript:change_list('.$previous_start.', '.$max_rows.');">'.$cmdPrevious.'</a>&nbsp;';
			}else
			{
				$links .= '<font color="#cccccc">&lt&lt '.$cmdPrevious.'</font>&nbsp;';
			}

			$start = ($first-(($max_links/2)*$max_rows));

			$end = ($first+(($max_links/2)*$max_rows));

			if ($start < 0)
			{
				$end = $end - $start;
				$start=0;
			}
			if ($end > $count)
			{
				$end = $count;
			}
			if ($start > 0)
			{
				$links .= '...&nbsp;';
			}

			for ($i=$start;$i<$end;$i+=$max_rows)
			{
				$page = ($i/$max_rows)+1;
				if ($i==$first)
				{
					$links .= '<b><i>'.$page.'</i></b>&nbsp;';
				}else
				{
					$links .= '<a href="javascript:change_list('.$i.', '.$max_rows.');">'.$page.'</a>&nbsp;';
				}
			}

			if ($end < $count)
			{
				$links .= '...&nbsp;';
			}

			$last_page = floor($count/$max_rows)*$max_rows;

			if ($count > $next_start)
			{
				$links .= '<a href="javascript:change_list('.$next_start.', '.$max_rows.');">'.$cmdNext.'</a>&nbsp;';
				$links .= '<a href="javascript:change_list('.$last_page.', '.$max_rows.');">&gt&gt</a>';
			}else
			{
				$links .= '<font color="#cccccc">'.$cmdNext.' &gt&gt</font>';
			}
			$links .= '</td><td align="right"><a class="normal" href="javascript:change_list(0, 0);">'.$cmdShowAll.'</a></td></tr></table>';

			echo '<tr height="20"><td colspan="99">'.$links.'</td></tr>';
		}
	}

}else
{
	echo '<tr><td colspan="99">'.$ab_no_companies.'</td></tr>';
}
?>
</table>

<script type="text/javascript">

function _sort(field, direction)
{
	document.forms[0].new_sort_field.value=field;
	document.forms[0].new_sort_order.value=direction;
	document.forms[0].submit();
}

function delete_company(id)
{
	document.forms[0].delete_company_id.value=id;
	document.forms[0].submit();
}

function change_list(first, max_rows)
{
	document.forms[0].first.value=first;
	document.forms[0].max_rows.value=max_rows;
	document.forms[0].submit();
}

function invert_selection()
{
	for (var i=0;i<document.forms[0].elements.length;i++)
	{
		if(document.forms[0].elements[i].type == 'checkbox' && document.forms[0].elements[i].name != 'dummy')
		{
			document.forms[0].elements[i].checked = !(document.forms[0].elements[i].checked);
			document.forms[0].elements[i].onclick();
		}
	}
}

function item_click(check_box)
{
	var item = get_object(check_box.value);
	if (check_box.checked)
	{
		item.className = 'SelectedRow';
	}else
	{
		item.className = '';
	}
}

function confirm_delete()
{
	var count = 0;
	var name = new String;
	for (var i=0;i<document.forms[0].elements.length;i++)
	{
		if(document.forms[0].elements[i].type == 'checkbox' && document.forms[0].elements[i].name != 'dummy')
		{
			if (document.forms[0].elements[i].checked == true)
			{
				count++;
				name = document.forms[0].elements[i].id;
			}
		}
	}
	switch (count)
	{
		case 0:
			alert("<?php echo $contacts_no_select; ?>");
		break;

		case 1:
			if (confirm("<?php echo $strDeletePrefix; ?> '"+name+"' <?php echo $strDeleteSuffix; ?>"))
			{
				document.forms[0].task.value='delete_companies';
				document.forms[0].submit();
			}
		break;

		default:
			if (confirm("<?php echo $strDeletePrefix.$strThis; ?> "+count+" <?php echo $contacts_contacts.$strDeleteSuffix; ?>"))
			{
				document.forms[0].task.value='delete_companies';
				document.forms[0].submit();
			}
		break;
	}
}

function move_to_addressbook()
{
  document.forms[0].task.value="move_to_addressbook";
  document.forms[0].submit();
}


</script>
