<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once("../../Group-Office.php");
$post_action = isset($post_action) ? $post_action : '';

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('addressbook');
require_once($GO_LANGUAGE->get_language_file('addressbook'));

//load contact management class
require_once($GO_MODULES->class_path."addressbook.class.inc");
$ab = new addressbook();

$return_to = (isset($_REQUEST['return_to']) && $_REQUEST['return_to'] != '') ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];
$link_back = (isset($_REQUEST['link_back']) && $_REQUEST['link_back'] != '') ? $_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];
$addressbook_id = isset($_REQUEST['addressbook_id']) ? $_REQUEST['addressbook_id'] : 0;

$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';

switch($task)
{
	case 'save':
		$name = smart_addslashes(trim($_POST['name']));
		if ($name == '')
		{
			$feedback = '<p class="Error">'.$error_missing_field.'</p>';
		}else
		{
			if ($addressbook_id > 0)
			{
				$existing_addressbook = $ab->get_addressbook_by_name($name);
				if($existing_addressbook && $existing_addressbook['id'] != $addressbook_id)
				{
					$feedback = '<p class="Error">'.$ab_addressbook_exists.'</p>';
				}elseif(!$ab->update_addressbook($_POST['addressbook_id'], $name))
				{
					$feedback = '<p class="Error">'.$strSaveError.'</p>';
				}elseif($_POST['close'] == 'true')
				{
					header('Location: '.$return_to);
					exit();
				}
			}else
			{
				if($ab->get_addressbook_by_name($name))
				{
					$feedback = '<p class="Error">'.$ab_addressbook_exists.'</p>';
				}elseif(!$addressbook_id = $ab->add_addressbook($GO_SECURITY->user_id, $name))
				{
					$feedback = '<p class="Error">'.$strSaveError.'</p>';
				}elseif($_POST['close'] == 'true')
				{
					header('Location: '.$return_to);
					exit();
				}
			}
		}
	break;

	case 'export':
		$file_type = isset($_REQUEST['file_type']) ? $_REQUEST['file_type'] : 'csv';
		$addressbook = $ab->get_addressbook($addressbook_id);

		$browser = detect_browser();
		header("Content-type: text/x-csv");
		header('Expires: '.gmdate('D, d M Y H:i:s') . ' GMT');
		$export_type = isset($_POST['export_type']) ? " - ".$_POST['export_type'] : '';
		if ($browser['name'] == 'MSIE')
		{
			header('Content-Disposition: inline; filename="'.$addressbook['name'].$export_type.'.'.$file_type.'"');
			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
			header('Pragma: public');
		}else
		{
			header('Pragma: no-cache');
			header('Content-Disposition: attachment; filename="'.$addressbook['name'].$export_type.'.'.$file_type.'"');
		}

		if($file_type == 'vcf') {
			require_once($GO_MODULES->path."classes/vcard.class.inc");
			$vcard = new vcard();
			if($vcard->export_addressbook($addressbook_id)) {
				echo $vcard->vcf;
			}
		} else {
			$quote = smart_stripslashes($_POST['quote']);
			$crlf = smart_stripslashes($_POST['crlf']);
			$crlf = str_replace('\\r', "\015", $crlf);
			$crlf = str_replace('\\n', "\012", $crlf);
			$crlf = str_replace('\\t', "\011", $crlf);
			$seperator = smart_stripslashes($_POST['seperator']);

			if ($_POST['export_type'] == 'contacts')
			{
				$headings = array($strTitle, $strFirstName, $strMiddleName, $strLastName, $strInitials, $strSex, $strBirthday, $strEmail, $strCountry, $strState, $strCity, $strZip, $strAddress, $strAddressNo, $strPhone, $strWorkphone, $strFax, $strWorkFax, $strCellular, $strCompany, $strDepartment, $strFunction, $ab_comment, $contacts_group);
				$headings = $quote.implode($quote.$seperator.$quote, $headings).$quote;
				echo $headings;
				echo $crlf;

				$ab->get_contacts_for_export($_POST['addressbook_id']);
				while ($ab->next_record())
				{
					$record = array($ab->f("title"), $ab->f("first_name"),$ab->f("middle_name"), $ab->f("last_name"), $ab->f("initials"), $ab->f("sex"), $ab->f('birthday'), $ab->f("email"), $ab->f("country"), $ab->f("state"), $ab->f("city"), $ab->f("zip"), $ab->f("address"), $ab->f("address_no"), $ab->f("home_phone"), $ab->f("work_phone"), $ab->f("fax"), $ab->f("work_fax"), $ab->f("cellular"), $ab->f("company"), $ab->f("department"), $ab->f("function"), $ab->f("comment"), $ab->f("group_name"));
					$record = $quote.implode($quote.$seperator.$quote, $record).$quote;
					echo $record;
					echo $crlf;
				}
			}else
			{
				$headings = array($strName, $strCountry, $strState, $strCity, $strZip, $strAddress, $strAddressNo, $strEmail, $strPhone, $strFax, $strHomepage, $ab_bank_no, $ab_vat_no);
				$headings = $quote.implode($quote.$seperator.$quote, $headings).$quote;
				echo $headings;
				echo $crlf;

				$ab->get_companies($_POST['addressbook_id']);

				while($ab->next_record())
				{
					$record = array($ab->f("name"), $ab->f("country"), $ab->f("state"), $ab->f("city"), $ab->f("zip"), $ab->f("address"), $ab->f("address_no"), $ab->f("email"), $ab->f("phone"), $ab->f("fax"), $ab->f("homepage"), $ab->f("bank_no"), $ab->f('vat_no'));
					$record = $quote.implode($quote.$seperator.$quote, $record).$quote;
					echo $record;
					echo $crlf;
				}
			}
		}
		exit();
	break;
}

if ($addressbook_id > 0 && $addressbook = $ab->get_addressbook($addressbook_id))
{
	if (!$write_permission = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $addressbook['acl_write']))
	{
		$read_permission = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $addressbook['acl_read']);
	}
	$name = isset($name) ? $name : $addressbook['name'];

	$tabtable = new tabtable('addressbook', $name, '100%', '400', '120', '', true);
	$tabtable->add_tab('name', $strProperties);
	if ($write_permission)
	{
		$tabtable->add_tab('groups', $contacts_groups);
		$tabtable->add_tab('import', $contacts_import);
	}
	$tabtable->add_tab('export', $contacts_export);
	$tabtable->add_tab('read_permissions', $strReadRights);
	$tabtable->add_tab('write_permissions', $strWriteRights);
}else
{
	$tabtable = new tabtable('addressbook', $ab_new_ab, '100%', '400', '120', '', true);
	$write_permission = true;
}

if (!$write_permission && !$read_permission)
{
	header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
	exit();
}

if (isset($_REQUEST['active_tab']))
{
	$tabtable->set_active_tab($_REQUEST['active_tab']);
}
$link_back .= '&active_tab='.$tabtable->active_tab;

require_once($GO_THEME->theme_path."header.inc");

echo '<form name="addressbook" method="post" action="'.$_SERVER['PHP_SELF'].'" enctype="multipart/form-data">';
echo '<input type="hidden" name="task" />';
echo '<input type="hidden" name="close" value="false" />';
echo '<input type="hidden" name="addressbook_id" value="'.$addressbook_id.'" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="link_back" value="'.$link_back.'" />';

$tabtable->print_head($return_to);

echo '<br />';
switch($tabtable->get_active_tab_id())
{
	case 'read_permissions':
		print_acl($addressbook["acl_read"]);
		echo '<br />';
		$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
	break;

	case 'write_permissions':
		print_acl($addressbook["acl_write"]);
		echo '<br />';
		$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
	break;

	case 'groups':
		require_once('groups.inc');
		echo '<br />';
		$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
	break;

	case 'import':
		require_once('import.inc');
	break;

	case 'export':
		require_once('export.inc');
	break;

	default:
		$name = isset($name) ? htmlspecialchars(stripslashes($name)) : '';
		echo '<table border="0">';
		if (isset($feedback))
		{
			echo '<tr><td colspan="2" class="Error">'.$feedback.'</td></tr>';
		}
		echo '<tr><td>'.$strName.':</td><td><input type="text" class="textbox" name="name" value="'.$name.'" size="40" /></td></tr></table>';
		echo '<br />';
		if ($write_permission)
		{
			$button = new button($cmdOk, "javascript:ok_addressbook()");
			echo '&nbsp;&nbsp;';
			$button = new button($cmdApply, "javascript:apply_addressbook()");
			echo '&nbsp;&nbsp;';
		}
		$button = new button($cmdClose, "javascript:document.location='".$return_to."';");

		echo'<script type="text/javascript">document.forms[0].name.focus();</script>';
	break;
}

$tabtable->print_foot();

echo '</form>';
?>
<script type="text/javascript" language="javascript">

function ok_addressbook()
{
	document.forms[0].close.value = 'true';
	document.forms[0].task.value = 'save';
	document.forms[0].submit();
}
function apply_addressbook()
{
	document.forms[0].task.value = 'save';
	document.forms[0].submit();
}

function copy_acl(task)
{
	document.forms[0].task.value = task;
	document.forms[0].submit();
}
</script>
<?php
require_once($GO_THEME->theme_path."footer.inc");
?>
