<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

//config file exists now so require it to get the properties.
require_once('../Group-Office.php');

$CONFIG_FILE = $GO_CONFIG->get_config_file();

require_once('install.inc');

function print_head()
{
	echo '<html><head><title>Group-Office Installation</title></head><body style="font-family: Arial,Helvetica">';
	echo '<div style="margin: 20px;text-align: center;"><img src="../lib/intermesh.gif" border="0" /></div>';
	echo '<form method="post" action="install.php">';
	echo '<table align="center" style="background: #f1f1f1;border-width: 1px;border-color: black;border-style: solid;font-family: Arial,Helvetica; font-size: 12px; width: 500px;">';
	echo '<tr><td align="center"><br /><h2>Group-Office installation</h2></td></tr>';
	echo '<tr><td><table style="border-width: 0px;padding: 20px;font-family: Arial,Helvetica; width: 500px;font-weight: normal; font-size: 12px;"><tr><td>';
}

function print_foot()
{
	echo '</td></tr></table></td></tr></table></form></body></html>';
}

//destroy session when user closes browser
ini_set('session.cookie_lifetime','0');


//get the path of this script
$script_path = __FILE__;
if ($script_path == '')
{
	print_head();
	echo '<b>Fatal error:</b> Could not get the path of the this script. The server variable \'SCRIPT_FILENAME\' and \'PATH_TRANSLATED\' are not set.';
	echo '<br /><br />Correct this and refresh this page. If you are not able to correct this try the manual installation described in the file \'INSTALL\'';
	print_foot();
	exit();
}

//check ifconfig exists and if the config file is writable
$config_location1 = '/etc/Group-Office/'.$_SERVER['SERVER_NAME'].str_replace($_SERVER['DOCUMENT_ROOT'],'', $GO_CONFIG->root_path).'config.php';
$config_location2 = $GO_CONFIG->root_path.'config.php';

if(!file_exists($CONFIG_FILE))
{
	print_head();
	echo 'The configuration file does not exist. You must create a writable configuration file at one of the following locations:<br />';
	echo '<ol><li>'.$config_location1.'</li>';
	echo '<li>'.$config_location2.'</li></ol></i></font>';
	echo 'The first location is more secure because the sensitive information is kept outside the document root but it does require root privileges on this machine.<br />The second advantage is that you will be able to seperate the source from the configuration. This can be very usefull with multiple installations on one machine.';
	echo 'If you choose this location then you have to make sure that in Apache\'s httpd.conf the following is set:<br /><br />';
	echo '<font color="#003399">';
	echo '<i>UseCanonicalName On</i></font><br />';
	echo 'This is to make sure it always finds your configuration file at the correct location.';
	echo '<br /><br /><font color="#003399">';
	echo '<i>$ touch config.php (Or FTP an empty config.php to the server)<br />';
	echo '$ chmod 666 config.php</i></font><br /><br /><div style="text-align: right;"><input type="submit" value="Continue" /></div>';
	print_foot();
	exit();
}elseif (!is_writable($CONFIG_FILE))
{
	print_head();
	echo 'The configuration file \''.$CONFIG_FILE.'\' exists but is not writable. If you wish to make changes then you have to make \''.$CONFIG_FILE.'\' writable during the configuration process.';
	echo '<br /><br />Correct this and refresh this page.';
	echo '<br /><br /><font color="#003399"><i>$ chmod 777 '.$CONFIG_FILE.'<br /></i></font>';
	print_foot();
	exit();
}

// require_once functions.inc which we need for validate_email(),
// just in case Group-Office.php has not already included it.
//require_once( $GO_CONFIG->root_path . 'functions.inc' );

$task = isset($_POST['task']) ? $_POST['task'] : '';

if ($_SERVER['REQUEST_METHOD'] =='POST')
{
	switch($task)
	{
		case 'administrator':
		$pass1=trim($_POST['pass1']);
		$pass2=trim($_POST['pass2']);
		$email=trim($_POST['email']);
		$username=trim($_POST['username']);


		if ($pass1 == '' || $username=='')
		{
			$feedback = '<font color="red">Please enter a password and a username!</font>';
		}elseif( strlen($pass1) < 4)
		{
			$feedback = '<font color="red">Password can\'t be shorter then 4 characters!</font>';
		}elseif($pass1 != $pass2)
		{
			$feedback = '<font color="red">Passwords did not match!</font>';
		}elseif(!validate_email( $email ))
		{
			$feedback = '<font color="red">Invalid E-mail address!</font>';
		}else
		{
			$GO_USERS->get_users();
			$new_user_id = $GO_USERS->nextid("users");

			$GO_GROUPS->query("DELETE FROM db_sequence WHERE seq_name='groups'");
			$GO_GROUPS->query("DELETE FROM groups");

			$admin_group_id = $GO_GROUPS->add_group($new_user_id, 'Admins');
			$root_group_id = $GO_GROUPS->add_group($new_user_id, 'Everyone');

			$new_user_id = $GO_USERS->add_user(
			smart_addslashes($username),	// Username
			smart_addslashes($pass1),			// Password
			'',	// First Name
			'',			// Middle Name
			'',			// Last Name
			'',			// Initials
			'',			// Title
			'M',			// Sex
			'',			// Birthday
			smart_addslashes($email),			// eMail Address
			'',			// Work Phone
			'',			// Home Phone
			'',			// Fax
			'',			// Cellular
			'',			// Country
			'',			// State
			'',			// City
			'',			// ZIP
			'',			// Address
			'',			// Company
			'',			// Work Country
			'',			// Work State
			'',			// Work City
			'',			// Work ZIP
			'',			// Work Address
			'',			// Work Fax
			'',			// Homepage
			'',			// Department
			'',			// Function
			'',			// Language
			'',			// Theme
			'',			// Start module
			true,		// Visible to everybody?
			$new_user_id
			);
			$old_umask = umask(000);
			mkdir($GO_CONFIG->file_storage_path.smart_stripslashes($username), $GO_CONFIG->create_mode);
			umask($old_umask);

			//grant administrator privileges
			$GO_GROUPS->add_user_to_group($new_user_id, $GO_CONFIG->group_root);

			$_SESSION['completed']['administrator'] = true;
		}
		break;
		
		case 'test':
		$_SESSION['completed']['test'] = true;
		break;

		case 'license':
		$_SESSION['completed']['license'] = true;
		break;

		case 'release_notes':
		$_SESSION['completed']['release_notes'] = true;
		break;

		case 'database_connection':
		$db = new db();
		$db->Halt_On_Error = 'no';

		$GO_CONFIG->db_host = smart_stripslashes($_POST['db_host']);
		$GO_CONFIG->db_name = smart_stripslashes($_POST['db_name']);
		$GO_CONFIG->db_user = smart_stripslashes($_POST['db_user']);
		$GO_CONFIG->db_pass = smart_stripslashes($_POST['db_pass']);

		if(@$db->connect($GO_CONFIG->db_name,
		$GO_CONFIG->db_host,
		$GO_CONFIG->db_user,
		$GO_CONFIG->db_pass))
		{

			if (save_config($GO_CONFIG))
			{
				$_SESSION['completed']['database_connection'] = true;
			}
		}else
		{
			$feedback ='<font color="red">Failed to connect to database</font>';
		}
		break;

		case 'database_structure':
		$db = new db();
		$db->Halt_On_Error = 'no';

		if (!$db->connect($GO_CONFIG->db_name, $GO_CONFIG->db_host, $GO_CONFIG->db_user, $GO_CONFIG->db_pass))
		{
			print_head();
			echo 'Can\'t connect to database!';
			echo '<br /><br />Correct this and refresh this page.';
			print_foot();
			exit();
		}else
		{
			if($_POST['upgrade'] == 'true')
			{
				$old_version = intval(str_replace('.', '', $_POST['db_version']));
				$new_version = intval(str_replace('.', '', $GO_CONFIG->version));
				require_once($GO_CONFIG->root_path.'lib/updates.inc');
				if (!isset($updates[$old_version]))
				{
					//invalid version, abort upgrade
					$feedback = '<font color="red">The version number you entered is invalid</font>';
				}else
				{
					for ($cur_ver=$old_version;$cur_ver<$new_version;$cur_ver++)
					{
						if (isset($updates[$cur_ver]))
						{
							while($query = array_shift($updates[$cur_ver]))
							{
								@$db->query($query);
							}
						}

						if (file_exists($GO_CONFIG->root_path.'lib/scripts/'.$cur_ver.'.inc'))
						{
							echo 'Running update script for version '.$cur_ver.'...<br>';
							require_once($GO_CONFIG->root_path.'lib/scripts/'.$cur_ver.'.inc');
						}
					}
					$db_version = $GO_CONFIG->version;
					install_required_modules();			
					
					$_SESSION['completed']['database_structure'] = true;
					//store the version number for future upgrades

					$GO_CONFIG->save_setting('version', $GO_CONFIG->version);

					//Upgrade modules
					$GO_MODULES->get_modules();
					while($GO_MODULES->next_record())
					{
						$module_info = $GO_MODULES->get_module_info($GO_MODULES->f('id'));

						if($module_info)
						{
							$installed_version = intval(str_replace('.', '', $GO_MODULES->f('version')));
							$new_version = intval(str_replace('.', '',$module_info['version']));

							if($installed_version < $new_version)
							{
								$update_file = $GO_CONFIG->root_path.'modules/'.$GO_MODULES->f('id').'/sql/'.$GO_MODULES->f('id').'.updates.inc';
								if(file_exists($update_file))
								{
									require_once($update_file);
									for ($cur_ver=$installed_version;$cur_ver<$new_version;$cur_ver++)
									{
										if (isset($updates[$cur_ver]))
										{
											while($query = array_shift($updates[$cur_ver]))
											{
												@$db->query($query);
											}
										}
									}

								}
								for ($cur_ver=$installed_version;$cur_ver<$new_version;$cur_ver++)
								{
									if (file_exists($GO_CONFIG->root_path.'modules/'.$GO_MODULES->f('id').'/sql/'.$cur_ver.'.inc'))
									{
										echo 'Running update script for module \''.$GO_MODULES->f('id').'\' version '.$cur_ver.'...<br />';
										require_once($GO_CONFIG->root_path.'modules/'.$GO_MODULES->f('id').'/sql/'.$cur_ver.'.inc');
									}
								}
							}
							$sql = "UPDATE modules SET version='".$module_info['version']."' WHERE id='".$GO_MODULES->f('id')."'";
							$db->query($sql);
						}
					}
				}
			}else
			{
				if(!isset($_POST['fresh_install']))
				{
					//delete all existing users
					$delete=new $go_users_class();
					$delete->Halt_On_Error = 'no';

					$GO_USERS->get_users();
					while($GO_USERS->next_record())
					{
						$delete->delete_user($GO_USERS->f('id'));
					}

					$GO_MODULES->get_modules();

					$delete_module = new GO_MODULES();
					$delete_module->Halt_On_Error = 'no';
					while($GO_MODULES->next_record())
					{
						$delete_module->delete_module($GO_MODULES->f('id'));
					}
				}
				//create new empty database
				//table is empty create the structure
				$queries = get_sql_queries($GO_CONFIG->root_path."lib/sql/groupoffice.sql");
				while ($query = array_shift($queries))
				{
					$db->query($query);
				}

				//store the version number for future upgrades
				$GO_CONFIG->save_setting('version', $GO_CONFIG->version);
				$db_version = $GO_CONFIG->version;
				
				install_required_modules();
				
				$_SESSION['completed']['database_structure'] = true;
			}
		}
		break;

		case 'userdir':
		if (!is_writable($_POST['userdir']))
		{
			$feedback = '<font color="red">The path you entered is not writable.<br />Please correct this and try again.</font>';
		}elseif($_POST['max_file_size'] > return_bytes(ini_get('upload_max_filesize')))
		{
			$feedback = '<font color="red">You entered a greater upload size then the PHP configuration allows.<br />Please correct this and try again.</font>';
		}
		if (substr($_POST['userdir'], -1) != '/') $_POST['userdir'] = $_POST['userdir'].'/';
		$GO_CONFIG->file_storage_path=smart_stripslashes($_POST['userdir']);
		$GO_CONFIG->create_mode=smart_stripslashes($_POST['create_mode']);
		$GO_CONFIG->max_file_size=smart_stripslashes($_POST['max_file_size']);			

		if (save_config($GO_CONFIG) && !isset($feedback))
		{
			//check for userdirs
			$GO_USERS->get_users();
			while($GO_USERS->next_record())
			{
				if(!file_exists($GO_CONFIG->file_storage_path.$GO_USERS->f('username')))
				{
					mkdir($GO_CONFIG->file_storage_path.$GO_USERS->f('username'));
				}
			}
			$_SESSION['completed']['userdir'] = true;
		}		

		break;
		
		case 'local_path':
		if (!is_writable($_POST['local_path']))
		{
			$feedback = '<font color="red">The path you entered is not writable.<br />Please correct this and try again.</font>';
		}else
		{
			if (substr($_POST['local_path'], -1) != '/') $_POST['local_path'] = $_POST['local_path'].'/';
			if (substr($_POST['local_url'], -1) != '/') $_POST['local_url'] = $_POST['local_url'].'/';
			
			$GO_CONFIG->local_path=smart_stripslashes($_POST['local_path']);
			$GO_CONFIG->local_url=smart_stripslashes($_POST['local_url']);

			if (save_config($GO_CONFIG))
			{
				$_SESSION['completed']['local_path'] = true;
			}
		}

		break;

		case 'tmpdir':
		$tmpdir=smart_stripslashes($_POST['tmpdir']);
		if (!is_writable($tmpdir))
		{
			$feedback = '<font color="red">The path you entered is not writable.<br />Please correct this and try again.</font>';
		}else
		{
			if (substr($tmpdir, -1) != '/') $tmpdir = $tmpdir.'/';
			$GO_CONFIG->tmpdir=$tmpdir;
			if (save_config($GO_CONFIG))
			{
				$_SESSION['completed']['tmpdir'] = true;
			}
		}

		break;

		case 'title':
		if ($_POST['title'] == '')
		{
			$feedback = 'You didn\'t enter a title.';

		}elseif(!validate_email($_POST['webmaster_email']))
		{
			$feedback = 'You entered an invalid e-mail address.';
		}else
		{
			$GO_CONFIG->webmaster_email = smart_stripslashes($_POST['webmaster_email']);
			$GO_CONFIG->title = smart_stripslashes($_POST['title']);
			if (save_config($GO_CONFIG))
			{
				$_SESSION['completed']['title'] = true;
			}
		}
		break;

		case 'url':
		$host = smart_stripslashes(trim($_POST['host']));
		$full_url = smart_stripslashes(trim($_POST['full_url']));
		if ($host != '' && $full_url != '')
		{
			if ($host != '/')
			{
				if (substr($host , -1) != '/') $host  = $host.'/';
				if (substr($host , 0, 1) != '/') $host  = '/'.$host;
			}

			if(substr($full_url,-1) != '/') $full_url = $full_url.'/';

			$GO_CONFIG->host = $host;
			$GO_CONFIG->full_url = $full_url;
			if (save_config($GO_CONFIG))
			{
				$_SESSION['completed']['url'] = true;
			}

		}else
		{
			$feedback = '<font color="red">You didn\'t enter both fields.</font>';
		}
		break;

		case 'theme':
		$GO_CONFIG->theme = smart_stripslashes($_POST['theme']);
		$GO_CONFIG->login_screen = smart_stripslashes($_POST['login_screen']);
		$GO_CONFIG->allow_themes = ($_POST['allow_themes'] == 'true') ? true : false;
		if (save_config($GO_CONFIG))
		{
			$_SESSION['completed']['theme'] = true;
		}
		break;

		case 'allow_password_change':
		$GO_CONFIG->allow_password_change = ($_POST['allow_password_change'] == 'true') ? true : false;
		if (save_config($GO_CONFIG))
		{
			$_SESSION['completed']['allow_password_change'] = true;
		}

		break;

		case 'allow_registration':
		$GO_CONFIG->allow_registration = ($_POST['allow_registration'] == 'true') ? true : false;
		if (save_config($GO_CONFIG))
		{
			$_SESSION['completed']['allow_registration'] = true;
		}

		break;

		case 'language':

		$GO_CONFIG->language = $_POST['language'];
		if (save_config($GO_CONFIG))
		{
			$_SESSION['completed']['language'] = true;
		}
		break;

		case 'smtp':
		if($_POST['max_attachment_size'] > return_bytes(ini_get('upload_max_filesize')))
		{
			$feedback = '<font color="red">You entered a greater upload size then the PHP configuration allows.<br />Please correct this and try again.</font>';
		}
		
		$GO_CONFIG->mailer = $_POST['mailer'];
		$GO_CONFIG->smtp_port = isset($_POST['smtp_port']) ? smart_stripslashes(trim($_POST['smtp_port'])) : '';
		$GO_CONFIG->smtp_server= isset($_POST['smtp_server']) ? smart_stripslashes(trim($_POST['smtp_server'])) : '';
		$GO_CONFIG->max_attachment_size= smart_stripslashes(trim($_POST['max_attachment_size']));
		$GO_CONFIG->email_connectstring_options = smart_stripslashes(trim($_POST['email_connectstring_options']));
		if (save_config($GO_CONFIG) && !isset($feedback))
		{
			$_SESSION['completed']['smtp'] = true;
		}
		break;

		case 'send_info':
		if ($_REQUEST['info'] != 'no')
		{
			$body = "Group-Office title: ".$GO_CONFIG->title."\r\n";
			$body = "Group-Office version: ".$GO_CONFIG->version."\r\n";
			$body .= "Usage: ".$_REQUEST['info']."\r\n";
			$body .= "Users: ".$_REQUEST['users']."\r\n";
			$body .= "Host: ".$GO_CONFIG->full_url."\r\n";
			$body .= "Webmaster: ".$GO_CONFIG->webmaster_email."\r\n";
			if ($_REQUEST['email'] != '')
			{
				$body .= "Contact about Group-Office Professional at: ".$_REQUEST['email']."\r\n";
				$body .= "Name: ".$_REQUEST['name']."\r\n";
			}

			sendmail('notify@intermesh.nl', $GO_CONFIG->webmaster_email, $GO_CONFIG->title, "Group-Office usage information", $body);
		}
		$_SESSION['completed']['send_info'] = true;
		break;

		case 'new_database':
		$_SESSION['completed']['new_database'] = true;

		break;

		case 'existing_database':
		$_SESSION['completed']['new_database'] = true;
		$_SESSION['completed']['create_database'] = true;
		break;

		case 'create_database':
		if($_POST['db_host'] == '' || $_POST['db_user'] == '' || $_POST['db_name'] == '' || $_POST['host_allow'] == '')
		{
			$feedback ='<font color="red">You did not fill in all the required fields</font>';
		}elseif($_POST['db_pass1'] != $_POST['db_pass2'])
		{
			$feedback ='<font color="red">Passwords did not match</font>';
		}else
		{
			$GO_CONFIG->db_name = '';
			$GO_CONFIG->db_pass = '';
			$GO_CONFIG->db_user = '';
			$GO_CONFIG->db_host = '';

			$db = new db();
			$db->Halt_On_Error = 'no';

			$GO_CONFIG->db_host = smart_stripslashes($_POST['db_host']);
			$GO_CONFIG->db_name = smart_stripslashes($_POST['db_name']);
			$GO_CONFIG->db_user = smart_stripslashes($_POST['db_user']);
			$GO_CONFIG->db_pass = smart_stripslashes($_POST['db_pass1']);

			if(@$db->connect('mysql', smart_stripslashes($_POST['db_host']), smart_stripslashes($_POST['admin_user']), smart_stripslashes($_POST['admin_pass'])))
			{
				$sql = 'CREATE DATABASE `'.$_POST['db_name'].'`;';
				if($db->query($sql))
				{
					$sql = "GRANT ALL PRIVILEGES ON ".smart_addslashes($_POST['db_name']).".*	TO ".
					"'".$_POST['db_user']."'@'".smart_addslashes($_POST['host_allow'])."' ".
					"IDENTIFIED BY '".smart_addslashes($_POST['db_pass1'])."' WITH GRANT OPTION";
					if($db->query($sql))
					{

						$db->query("FLUSH PRIVILEGES;");

						if (save_config($GO_CONFIG))
						{
							$_SESSION['completed']['create_database'] = true;
							$_SESSION['completed']['database_connection'] = true;
						}

					}else
					{
						$feedback ='<font color="red">Failed to create user.<br />'.
						'<b>MySQL Error</b>: '.$db->Errno.' '.$db->Error.'</font>';
					}
				}else
				{
					$feedback ='<font color="red">Failed to create database.<br />'.
					'<b>MySQL Error</b>: '.$db->Errno.' '.$db->Error.'</font>';;
				}
			}else
			{
				$feedback ='<font color="red">Failed to connect to database as administrator.<br />'.
				'<b>MySQL Error</b>: '.$db->Errno.' '.$db->Error.'</font>';
			}
		}
		break;

	}
}else
{
	unset($_SESSION);
}

//Store all options in config array during install
$_SESSION['completed'] = isset($_SESSION['completed']) ? $_SESSION['completed'] : array();

if(!isset($_SESSION['completed']['test']))
{
	print_head();
	echo '<input type="hidden" name="task" value="test" />';
	require_once($GO_CONFIG->root_path.'install/test.inc');
	
	if(isset($fatal_error))
	{
		echo '<p style="color: red;">Because of a fatal error in your system setup the installation can\'t continue. Please fix the errors above first.</p>';
	}else
	{
		echo '<br /><div align="center"><input type="submit" value="Continue" /></div>';
	}
	print_foot();
	exit();
}

if (!isset($_SESSION['completed']['license']))
{
	if(file_exists('../LICENSE.GPL'))
	{
		$license = '../LICENSE.GPL';
	}else
	{
		$license = '../LICENSE.PRO';
	}

	print_head();
	echo '<input type="hidden" name="task" value="license" />';
	echo 'Do you agree to the terms of the license agreement?<br /><br />';
	echo '<iframe style="width: 670; height: 250; background: #ffffff;" src="'.$license.'"></iframe>';
	echo '<br /><br /><div align="center"><input type="submit" value="I agree to these terms" /></div>';
	print_foot();
	exit();
}


if (!isset($_SESSION['completed']['release_notes']))
{
	print_head();
	echo '<input type="hidden" name="task" value="release_notes" />';
	echo 'Please read the release notes<br /><br />';
	echo '<iframe style="width: 670; height: 250; background: #ffffff;" src="../RELEASE"></iframe>';
	echo '<br /><br /><div align="center"><input type="submit" value="Continue" /></div>';
	print_foot();
	exit();
}

if(!isset($_SESSION['completed']['new_database']))
{
	print_head();
	echo '<p align="center">Do you wish to create a new database and user or do you want to use an existing database and user?<br /><br />';
	echo '<input type="hidden" name="task" value="" />';
	echo '<input type="button" onclick="javascript:_go(\'new_database\');" value="Create new database" />&nbsp;&nbsp;';
	echo '<input type="button" onclick="javascript:_go(\'existing_database\');" value="Use existing database" /></p>';
	echo '<script type="text/javascript">';
	echo 'function _go(task){document.forms[0].task.value=task;document.forms[0].submit();}</script>';

	print_foot();
	exit();
}

if(!isset($_SESSION['completed']['create_database']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="create_database" />
		Enter the administrator username and password and fill in the other fields to create a new database and user for Group-Office.
		<br /><br />
		<table width="100%" style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>
		Host:
		</td>
		<td>
		<?php $db_host = isset($_POST['db_host']) ? $_POST['db_host'] : $GO_CONFIG->db_host; ?>
		<input type="text" size="40" name="db_host" value="<?php echo $db_host; ?>" />
		</td>
		</tr>
		<tr>
		<td>
		Administrator username:
		</td>
		<td>
		<?php $admin_user = isset($_POST['admin_user']) ? $_POST['admin_user'] : 'root'; ?>
		<input type="text" size="40" name="admin_user" value="<?php echo $admin_user; ?>"  />
		</td>
		</tr>
		<tr>
		<td>
		Administrator password:
		</td>
		<td>
		<input type="password" size="40" name="admin_pass" value=""  />
		</td>
		</tr>

		<tr><td colspan="2">&nbsp;</td></tr>

		<tr>
		<td>
		Database:
		</td>
		<td>
		<?php $db_name = isset($_POST['db_name']) ? $_POST['db_name'] : $GO_CONFIG->db_name; ?>
		<input type="text" size="40" name="db_name" value="<?php echo $db_name; ?>" />
		</td>
		</tr>
		<tr>
		<td>
		Allow connections from host ('%' for any host):
			</td>
				<td>
				<?php $host_allow = isset($_POST['host_allow']) ? $_POST['host_allow'] : 'localhost'; ?>
				<input type="text" size="40" name="host_allow" value="<?php echo $host_allow; ?>" />
				</td>
				</tr>

				<tr>
				<td>
				Username:
				</td>
				<td>
				<?php $db_user = isset($_POST['db_user']) ? $_POST['db_user'] : $GO_CONFIG->db_user; ?>
				<input type="text" size="40" name="db_user" value="<?php echo $db_user; ?>"  />
				</td>
				</tr>
				<tr>
				<td>
				Password:
				</td>
				<td>
				<input type="password" size="40" name="db_pass1" value=""  />
				</td>
				</tr>
				<tr>
				<td>
				Confirm password:
				</td>
				<td>
				<input type="password" size="40" name="db_pass2" value=""  />
				</td>
				</tr>
				<tr>
				<td colspan="2" align="center">
				<br />
				<input type="submit" value="Continue" />
				</td>
				</tr>
				</table>

				<?php
				print_foot();
				exit();
}


//Get the database parameters first
//if option database_connection is set then we have succesfully set up database
if (!isset($_SESSION['completed']['database_connection']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="database_connection" />		
		Create a database now and fill in the values to connect to your database.<br />
		The database user should have permission to perform select-, insert-, update- and delete queries. It must also be able to lock tables.<br /><br />
		
		If you are upgrading then now is the last time to back up your database! Fill in the fields and click at 'Continue' to upgrade your database structure.
		<br /><br />

		<font color="#003399"><i>
		$ mysql -u root -p<br />
		mysql&#62; CREATE DATABASE groupoffice;<br />
		<table width="100%" border="0">
		mysql&#62; GRANT ALL PRIVILEGES ON groupoffice.* TO 'groupoffice'@'localhost'<br />
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-&#62; IDENTIFIED BY 'some_pass' WITH GRANT OPTION;<br />
		mysql&#62; quit;<br />
		</i></font>

		<br /><br />
		<table width="100%" style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>
		Host:
		</td>
		<td>
		<input type="text" size="40" name="db_host" value="<?php echo $GO_CONFIG->db_host; ?>" />
		</td>
		</tr>
		<tr>
		<td>
		Database:
		</td>
		<td>
		<input type="text" size="40" name="db_name" value="<?php echo $GO_CONFIG->db_name; ?>" />
		</td>
		</tr>

		<tr>
		<td>
		Username:
		</td>
		<td>
		<input type="text" size="40" name="db_user" value="<?php echo $GO_CONFIG->db_user; ?>"  />
		</td>
		</tr>
		<tr>
		<td>
		Password:
		</td>
		<td>
		<input type="password" size="40" name="db_pass" value=""  />
		</td>
		</tr>
		<tr>
		<td colspan="2" align="center">
		<br />
		<input type="submit" value="Continue" />
		</td>
		</tr>
		</table>

		<?php
		print_foot();
		exit();
}

//database connection is setup now
//next step isto check if the table structure is present.

if(!isset($_SESSION['completed']['database_structure']))
{
	$db = new db();
	$db->Halt_On_Error = 'no';
	if (!@$db->connect($GO_CONFIG->db_name, $GO_CONFIG->db_host, $GO_CONFIG->db_user, $GO_CONFIG->db_pass))
	{
		print_head();
		echo 'Can\'t connect to database!';
		echo '<br /><br />Correct this and refresh this page.';
		print_foot();
		exit();
	}else
	{
		$settings_exist = false;
		$db->query("SHOW TABLES");
		if ($db->num_rows() > 0)
		{
			//structure exists see if the settings table exists
			while ($db->next_record())
			{
				if ($db->f(0) == 'settings')
				{
					$settings_exist = true;
					break;
				}
			}
		}
		if ($settings_exist)
		{
			$db->query("SELECT value FROM settings WHERE name='version'");
			if ($db->next_record())
			{
				$db_version=str_replace('.','', $db->f('value'));
				require_once($GO_CONFIG->root_path.'lib/updates.inc');
				if (!isset($updates[$db_version]))
				{
					$db_version = false;
				}
			}else
			{
				$db_version = false;
			}
			print_head();
			if (isset($feedback))
			{
				echo $feedback.'<br /><br />';
			}
			?>
				<script type="text/javascript">
				function delete_database()
				{
					if (confirm("Are you sure you want to delete all Group-Office users and data?"))
					{
						document.forms[0].upgrade.value="false";
						document.forms[0].submit();
					}

				}
			</script>
				<input type="hidden" name="task" value="database_structure" />
				<input type="hidden" name="upgrade" value="true" />
				Group-Office has detected a previous installation of Group-Office. Do you wish to keep the existing data and perform an upgrade?
				<?php
				if (!$db_version)
				{
					echo '<br /><br />Group-Office was unable to detect your old Group-Office version.'.
					'The installer needs your old version number to determine updates that might apply.<br />'.
					'Please enter the version number below if you wish to perform an upgrade.';
				}
			?>
				<br /><br />
				<table width="100%" style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
				<?php
				if (!$db_version)
				{
					echo '<tr><td>Version:</td><td>';
					$db_version = isset($db_version) ? $db_version : $GO_CONFIG->db_version;
					echo '<input type="text" size="4" maxlength="4" name="db_version" value="'.$db_version.'" /></td></tr>';
				}else
				{
					echo '<input type="hidden" name="db_version" value="'.$db_version.'" />';
				}
			?>
				<tr>
				<td colspan="2" align="center">
				<input type="submit" value="Yes" />
				&nbsp;&nbsp;
			<input type="button" onclick="javasscript:delete_database()" value="No" />
				</td>
				</tr>
				</table>
				<?php
				print_foot();
				exit();
		}else
		{
			print_head();
			echo '<input type="hidden" name="upgrade" value="false" />'.
			'<input type="hidden" name="fresh_install" value="true" />'.
			'<input type="hidden" name="task" value="database_structure" />';


			echo 'Group-Office succesfully connected to your database!<br />'.
			'Click on \'Continue\' to create the tables for the Group-Office '.
			'base system. This can take some time. Don\'t interupt this process.<br /><br />';
			echo '<div align="center"><input type="submit" value="Continue" /></div>';
			print_foot();
			exit();
		}
	}
}

//the title of Group-Office
if (!isset($_SESSION['completed']['title']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="title" />
		Enter a title for your Group-Office and webmaster email address for your application.<br />
		The email address will receive information about new registered users.
		<br /><br />
		<table style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>Title:</td>
		</tr>
		<tr>
		<?php
		$title = isset($_POST['title']) ? $_POST['title'] : $GO_CONFIG->title;
		$webmaster_email = isset($_POST['webmaster_email']) ? $_POST['webmaster_email'] : $GO_CONFIG->webmaster_email;
	?>
		<td><input type="text" size="50" name="title" value="<?php echo $title; ?>" /></td>
		</tr>
		<tr>
		<td>
		Webmaster E-mail:
		</td>
		</tr>
		<tr>
		<td>
		<input type="text" size="50" name="webmaster_email" value="<?php echo $webmaster_email; ?>" />
		</td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}

if (!isset($_SESSION['completed']['url']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="url" />
		Enter a relative and an absolute url.<br /><br />
		<font color="#003399"><i>
		Example:<br />
		Relative URL: /groupoffice/<br />
		Absolute URL: http://www.intermesh.nl/groupoffice/</i>
		</font>
		<br /><br />
		<table width="100%" style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>
		Relative URL:
		</td>
		<td>
		<?php
		$host = isset($_POST['host']) ? $_POST['host'] : $GO_CONFIG->host;
	?>
		<input type="text" size="40" name="host" value="<?php echo $host; ?>" />
		</td>
		</tr>
		<tr>
		<td>Absolute URL:</td>
		<td>
		<?php
		$full_url = isset($_POST['full_url']) ? $_POST['full_url'] : $GO_CONFIG->full_url;
	?>
		<input type="text" size="40" name="full_url" value="<?php echo $full_url; ?>" />
		</td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}

//database structure exists now and is up to date
//now we get the userdir

if (!isset($_SESSION['completed']['userdir']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="userdir" />
		Group-Office needs a place to store user data. Create a writable path for this purpose now and enter it in the box below.<br />
		The path should be have 0777 permissions or should be owned by the webserver user. You probably need to be root to do the last.
		<br />Also enter a maximum number of bytes to upload and a valid octal value for the file permissions.
		<br /><br />
		<font color="#003399"><i>
		$ su<br />
		$ mkdir /home/groupoffice<br />
		$ chown apache:apache /home/groupoffice<br />
		</i></font>

		<br /><br />
		<table width="100%" style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td colspan="2">User home directory:</td>
		</tr>
		<tr>
		<?php
		$userdir = isset($_POST['userdir']) ? $_POST['userdir'] : $GO_CONFIG->file_storage_path;
		?>
		<td colspan="2"><input type="text" size="50" name="userdir" value="<?php echo $userdir; ?>" /></td>
		</tr>
		<tr>
		<td>
		Maximum upload size (Current PHP configuration allows <?php echo return_bytes(ini_get('upload_max_filesize')); ?> bytes):
		</td>
		</tr>
		<tr>
		<td>
		<input type="text" size="50" name="max_file_size" value="<?php echo $GO_CONFIG->max_file_size; ?>"  />
		</td>
		</tr>
		<tr>
		<td>
		Create mode:
		</td>
		</tr>
		<tr>
		<td>
		<?php
		if(!isset($_POST['create_mode']))
		{
			$create_mode_string = decoct((string)$GO_CONFIG->create_mode);
			if (strlen($create_mode_string) == 3)
			{
				$create_mode_string = '0'.$create_mode_string;
			}
		}else
		{
			$create_mode_string = smart_stripslashes($_POST['create_mode']);
		}
	?>
		<input type="text" size="4" name="create_mode" value="<?php echo $create_mode_string; ?>" />
		</td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}

if (!isset($_SESSION['completed']['local_path']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	
	if($GO_CONFIG->local_path == '') 
	{
		$GO_CONFIG->local_path = $GO_CONFIG->root_path.'local/';
		$GO_CONFIG->local_url = $GO_CONFIG->host.'local/';
	}
	?>
		<input type="hidden" name="task" value="local_path" />
		Group-Office needs a place to store local data. Create a writable path for this purpose now and enter it in the box below.<br />
		The path should be have 0777 permissions or should be owned by the webserver user. You probably need to be root to do the last.
		<br />This path also needs to be accessible through a webbrowser so please provide the URL to access this path too.
		<br /><br />
		<font color="#003399"><i>
		$ su<br />
		$ mkdir <?php echo $GO_CONFIG->local_path; ?><br />
		$ chown apache:apache <?php echo $GO_CONFIG->local_path; ?><br />
		</i></font>

		<br /><br />
		<table width="100%" style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
			<td>Local path:</td>
			<?php
			$local_path = isset($_POST['local_path']) ? $_POST['local_path'] : $GO_CONFIG->local_path;
			?>
			<td><input type="text" size="50" name="local_path" value="<?php echo $local_path; ?>" /></td>
		</tr>
		<tr>
		<tr>
			<td>Local URL:</td>
			<?php
			$local_url = isset($_POST['local_url']) ? $_POST['local_url'] : $GO_CONFIG->local_url;
			?>
			<td><input type="text" size="50" name="local_url" value="<?php echo $local_url; ?>" /></td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}

//database structure exists now and is up to date
//now we get the tempdir

if (!isset($_SESSION['completed']['tmpdir']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="tmpdir" />
		Group-Office needs a place to store temporarily data such as session data or file uploads. Create a writable path for this purpose now and enter it in the box below.<br />
		The /tmp directory is a good option.
		<br /><br />
		<table width="100%" style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>Temporarily files directory:</td>
		</tr>
		<tr>
		<?php
		$tmpdir = isset($_POST['tmpdir']) ? $_POST['tmpdir'] : $GO_CONFIG->tmpdir;
	?>
		<td><input type="text" size="50" name="tmpdir" value="<?php echo $tmpdir; ?>" /></td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}





//theme
if (!isset($_SESSION['completed']['theme']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="theme" />
		Select the default theme for Group-Office and whether users are allowed to change the theme or not.
		<br /><br />
		<table style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>Default theme:</td>
		<td>
		<?php
		$themes = $GO_THEME->get_themes();
		$dropbox = new dropbox();
		$dropbox->add_arrays($themes, $themes);
		$dropbox->print_dropbox("theme", $GO_CONFIG->theme);
	?>
		</td>
		</tr>
		<tr>
		<td>Login screen style:</td>
		<td>
		<?php
		$login_screens = $GO_THEME->get_login_screens();
		$dropbox = new dropbox();
		$dropbox->add_arrays($login_screens, $login_screens);
		$dropbox->print_dropbox("login_screen", $GO_CONFIG->login_screen);
		?>
		</td>
		</tr>
		<tr>
		<td align="right">Allow:</td>
		<td>
		<?php
		$allow_themes = isset($_POST['allow_themes']) ? $_POST['allow_themes'] : $GO_CONFIG->allow_themes;
		$allow_themes = $allow_themes ? 'true' : 'false';
		$dropbox = new dropbox();
		$dropbox->add_value('true', 'Yes');
		$dropbox->add_value('false', 'No');
		$dropbox->print_dropbox('allow_themes', $allow_themes);
	?>
		</td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}

//allow_password_change
if (!isset($_SESSION['completed']['allow_password_change']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="allow_password_change" />
		Do you want to allow users to change their password?
		<br /><br />
		<table style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td align="right">Allow:</td>
		<td>
		<?php
		$allow_password_change = isset($_POST['allow_password_change']) ? $_POST['allow_password_change'] : $GO_CONFIG->allow_password_change;
		$allow_password_change = $allow_password_change ? 'true' : 'false';
		$dropbox = new dropbox();
		$dropbox->add_value('true', 'Yes');
		$dropbox->add_value('false', 'No');
		$dropbox->print_dropbox('allow_password_change', $allow_password_change);
	?>
		</td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}

//allow_password_change
if (!isset($_SESSION['completed']['allow_registration']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="allow_registration" />
		Do you want to allow anyone to register as a user?
		<br /><br />
		<table style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td align="right">Allow:</td>
		<td>
		<?php
		$allow_registration = isset($_POST['allow_registration']) ? $_POST['allow_registration'] : $GO_CONFIG->allow_registration;
		$allow_registration = $allow_registration ? 'true' : 'false';
		$dropbox = new dropbox();
		$dropbox->add_value('true', 'Yes');
		$dropbox->add_value('false', 'No');
		$dropbox->print_dropbox('allow_registration', $allow_registration);
	?>
		</td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}
//language
if (!isset($_SESSION['completed']['language']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="language" />
		Select your language. Group-Office will use default regional settings based on this setting. 
		If your language is not in the list please select the closest match.<br />
		It would be nice if you added your missing language to the language/languages.inc file and send it to
		info@intermesh.nl!
		<br /><br />
		<table style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>Language:</td>
		<td>
		<?php
		$dropbox= new dropbox();
		$languages = $GO_LANGUAGE->get_languages();
		while($language = array_shift($languages))
		{
			$dropbox->add_value($language['code'], $language['description']);
		}
		$dropbox->print_dropbox("language", $GO_CONFIG->language);
	?>
		</td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}

if (!isset($_SESSION['completed']['smtp']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="smtp" />
		Group-Office has the ability to send and receive e-mail. Please configure your SMTP server. <br />
		Leave this blank use the php mail() function but then you won't be able use CC and BCC headers!
		<br />
		<br />
		<table style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>
		Mailer:
		</td>
		<td>
		<?php
		$dropbox = new dropbox();
		$dropbox->add_value('mail', 'PHP Mail() Function (Not recommended)');
		$dropbox->add_value('sendmail', 'Use local sendmail');
		$dropbox->add_value('qmail', 'Use local Qmail');
		$dropbox->add_value('smtp', 'Use remote SMTP');
		$dropbox->print_dropbox('mailer', $GO_CONFIG->mailer, 'onchange="javascript:change_mailer()"');
	?>
		</td>
		</tr>
		<tr>
		<td>
		SMTP server:
		</td>
		<td>
		<input type="text" size="40" name="smtp_server" value="<?php echo $GO_CONFIG->smtp_server; ?>"  />
		</td>
		</tr>
		<tr>
		<td>
		SMTP port:
		</td>
		<td>
		<input type="text" size="40" name="smtp_port" value="<?php echo $GO_CONFIG->smtp_port; ?>" />
		</td>
		</tr>
		<tr>
		<td valign="top">
		Maximum size of attachments:
		</td>
		<td>
		<input type="text" size="40" name="max_attachment_size" value="<?php echo $GO_CONFIG->max_attachment_size; ?>" /><br />
		Current PHP configuration allows <?php echo return_bytes(ini_get('upload_max_filesize')); ?> bytes
		</td>
		</tr>
		<tr>
		<td colspan="2">
		<br />
		Some servers require some connection string options when connecting
		to an IMAP or POP-3 server using the PHP IMAP extension. For example most Redhat systems
		require '/notls' or '/novalidate-cert'.
		If you are not sure then leave this field blank.
		<br /><br />
		</td>
		</tr>
		<tr>
		<td>
		Connection options:
		</td>
		<td>
		<input type="text" size="40" name="email_connectstring_options" value="<?php echo $GO_CONFIG->email_connectstring_options; ?>" />
		</td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<script type="text/javascript">
		function change_mailer()
		{
			if(document.forms[0].mailer.value=='smtp')
			{
				document.forms[0].smtp_server.disabled=false;
				document.forms[0].smtp_port.disabled=false;
			}else
			{
				document.forms[0].smtp_server.disabled=true;
				document.forms[0].smtp_port.disabled=true;
			}
		}
		change_mailer();
	</script>
		<?php
		print_foot();
		exit();
}


//check if we need to add the administrator account

if(!isset($_SESSION['completed']['administrator']))
{
	if (!$GO_USERS->get_user(1))
	{
		print_head();
		if (isset($feedback))
		{
			echo $feedback.'<br /><br />';
		}
		?>
			<input type="hidden" name="task" value="administrator" />
			Group-Office needs an administrator account. The username will be 'administrator'. Please create a password for 'administrator'.
			<br /><br />
			<table style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
			<tr>
			<td>Username:</td>
			<td>
			<?php 
			$username = isset($_POST['username']) ? smart_stripslashes(htmlspecialchars($_POST['username'])) : 'admin';
		?>
			<input name="username" type="text" value="<?php echo $username; ?>" />
			</tr>
			<tr>
			<td>
			Password:
			</td>
			<td>
			<input type="password" name="pass1" />
			</td>
			</tr>
			<tr>
			<td>
			Confirm password:
			</td>
			<td>
			<input type="password" name="pass2" />
			</td>
			</tr>
			<tr>
			<td>
			E-mail:
			</td>
			<td>
			<?php $email = isset($email)? $email : $GO_CONFIG->webmaster_email;?>
			<input type="text" size="40" name="email" value="<?php echo $email; ?>" />
			</td>
			</tr>
			</table><br />
			<div align="center">
			<input type="submit" value="Continue" />
			</div>
			<?php
			print_foot();
			exit();
	}
}

if(!isset($_SESSION['completed']['send_info']))
{
	print_head();
	if (isset($feedback))
	{
		echo $feedback.'<br /><br />';
	}
	?>
		<input type="hidden" name="task" value="send_info" />
		Intermesh would like to know that you are using Group-Office to find out how many people are
		using Group-Office. Please select an Option. (If you already sent information before, please select 'No').
		<br /><br />
		<table cellpadding="10" style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>
		<?php
		$info = isset($_REQUEST['info']) ? $_REQUEST['info'] : 'no';
		$users = isset($_REQUEST['users']) ? $_REQUEST['users'] : '&lt; 5';

		$radio_list = new radio_list('info', $info);
		$radio_list->add_option('no', "");
		echo "No, Don't send information to Intermesh <br />";
		$radio_list->add_option('business', "");
		echo "Yes, tell Intermesh that I'm using Group-Office for business purpose.<br />";
		$radio_list->add_option('personal', "");
		echo "Yes, tell Intermesh that I'm using Group-Office for personal use or I'm just testing.";
	?>
		</td>
		</tr>
		<tr>
		<td>
		How many users do you have in Group-Office?
		<?php
		$dropbox = new dropbox();
		$dropbox->add_value('&lt; 5', '&lt; 5');
		$dropbox->add_value('20-30', '20-30');
		$dropbox->add_value('30-50', '30-50');
		$dropbox->add_value('50-75', '50-75');
		$dropbox->add_value('75-100', '75-100');
		$dropbox->add_value('100-150', '100-150');
		$dropbox->add_value('150-200', '150-200');
		$dropbox->add_value('300-400', '300-400');
		$dropbox->add_value('&gt; 400', '&gt; 400');
		$dropbox->print_dropbox('users', $users);
	?>
		</td>
		</tr>
		<tr>
		<td>
		If you would like to receive information about Group-Office Professional
		please fill in a name and an e-mail address where Intermesh may contact you:<br />
		<?php
		$email = isset($email)? $email : $GO_CONFIG->webmaster_email;
		$name = isset($name)? $name : '';
	?>
		<table style="border-width: 0px;font-family: Arial,Helvetica; font-size: 12px;">
		<tr>
		<td>E-mail:</td>
		<td><input type="text" size="50" name="email" value="<?php echo $email; ?>" /></td>
		</tr>
		<tr>
		<td>Name:</td>
		<td><input type="text" size="50" name="name" value="<?php echo $name; ?>" /></td>
		</tr>
		</table>
		</td>
		</tr>
		</table><br />
		<div align="center">
		<input type="submit" value="Continue" />
		</div>
		<?php
		print_foot();
		exit();
}

print_head();

?>
Installation complete!<br />
<br />
Please make sure '<?php echo $CONFIG_FILE; ?>' is not writable anymore now and remove the install directory.<br />
<br />
<font color="#003399"><i>
$ chmod 644 <?php echo $CONFIG_FILE; ?><br />
$ rm -Rf <?php echo $GO_CONFIG->root_path.'install/'; ?>
</i></font>
<br />
<br />
If you don't have shell access then you should download Group-Office.php, delete Group-Office.php
from the server and upload it back to the server. This way you change the ownership to your account.
<br />
<br /> 
When you are done log in to Group-Office with the administrator account.<br />
<ul>
<li>Navigate to the menu: Administrator -> modules and install the modules you wish to use.</li>
<li>Navigate to the menu: Administrator -> Manage user groups and create user groups.</li>
<li>Navigate to the menu: Administrator -> Manage users and add new users.</li>
</ul>
<br />
You can also configure external authentication servers such as an IMAP, POP-3 or LDAP server.
Take a look at 'auth_sources.dist' for more information about this.
<br />
<br />
For troubleshooting please consult the <a target="_blank" href="FAQ">FAQ</a> included with the package. 
If that doesn't help post on the <a target="_blank" href="http://www.group-office.com/forum/">forums</a>.<br />
Developers should take a look at modules/example/index.php
<br /><br />
<div align="center">
<input type="button" value="Launch Group-Office!" onclick="javascript:window.location='<?php echo $GO_CONFIG->host; ?>';" />
</div>
<?php
print_foot();
session_destroy();
?>
