<?php
$CONFIG_KEYS =
array(
'debug',
'log',
'slash',
'language',
'theme',
'allow_themes',
'allow_password_change',
'allow_registration',
'register_modules_read',
'register_modules_write',
'register_user_groups',
'host',
'full_url',
'title',
'webmaster_email',
'root_path',
'tmpdir',
'local_path',
'local_url',
'max_users',
'refresh_rate',
'login_screen',
'db_type',
'db_host',
'db_name',
'db_user',
'db_pass',
'auth_sources',
'sync_auth_source_key',
'mime_types_file',
'file_storage_path',
'create_mode',
'max_file_size',
'max_attachment_size',
'user_quota',
'dav_switch',
'dav_apachedir',
'dav_drafts',
'dav_auth',
'dav_alias',
'dav_accessfilename',
'name_of_sharedir',
'mailer',
'smtp_server',
'smtp_port',
'email_connectstring_options',
'max_attachment_size',
'cmd_zip',
'cmd_unzip',
'cmd_tar',
'cmd_chpasswd',
'cmd_sudo'
);

function escape_config_value($value)
{
	return str_replace('\\"', '"', addslashes($value));
}

function save_config($config)
{
	global $CONFIG_KEYS, $CONFIG_FILE;

	//create mode needs some special handling
	if (!is_string($config->create_mode))
	{
		$config->create_mode = decoct((string)$config->create_mode);
	}
	if (strlen($config->create_mode) == 3)
	{
		$config->create_mode = '0'.$config->create_mode;
	}

	$config_data = "<?php\n/*Configuration file generated by Group-Office*/\n";

	for($i=0;$i<count($CONFIG_KEYS);$i++)
	{
		$config_data .= '$config[\''.$CONFIG_KEYS[$i].'\']=';

		if(is_bool($config->$CONFIG_KEYS[$i]))
		{
			$value = $config->$CONFIG_KEYS[$i] ? 'true' : 'false';
			$config_data .= $value.";\n";
		}elseif($CONFIG_KEYS[$i] == 'create_mode')
		{
			$config_data .= escape_config_value($config->$CONFIG_KEYS[$i]).";\n";			
		}else
		{
			$config_data .= "'".escape_config_value($config->$CONFIG_KEYS[$i])."';\n";			
		}
	}

	$config_data .= "?>";

	if (!$fp = fopen($CONFIG_FILE, 'w+'))
	{
		exit("Failed to open config file");
	}elseif(!fwrite($fp, $config_data))
	{
		exit("Failed to write to config file");
	}else
	{
		return fclose($fp);
	}
}

function return_bytes($val) {
   $val = trim($val);
   $last = strtolower($val{strlen($val)-1});
   switch($last) {
       // The 'G' modifier is available since PHP 5.1.0
       case 'g':
           $val *= 1024;
       case 'm':
           $val *= 1024;
       case 'k':
           $val *= 1024;
   }
   return $val;
}

function install_required_modules()
{
	global $GO_CONFIG,$GO_MODULES, $GO_SECURITY;
	
	require_once ($GO_CONFIG->class_path.'filesystem.class.inc');
	$fs = new filesystem();
	
	$modules = $fs->get_folders($GO_CONFIG->module_path);
	$module_count = count($modules);
	while($module = array_shift($modules))
	{
		if ($module['name'] != 'CVS' && !$sql_module = $GO_MODULES->get_module($module['name']))
		{
			$version = '';
			$sort_order = '1000';			
	
			$info_file = $module['path'].'/module.info';
			$module_info = $GO_MODULES->get_module_info($module['name']);			
			$required = isset($module_info['required']) ? $module_info['required'] : false;
			
			if($required)
			{			
				$version = $module_info['version'];
				$sort_order = isset($module_info['sort_order']) ? $module_info['sort_order'] : '1000';
				$admin_menu = isset($module_info['admin_menu']) ? $module_info['admin_menu'] : '0';
				
				$acl_read = $GO_SECURITY->get_new_acl('Module read: '.$module['name'], 0);
				$acl_write = $GO_SECURITY->get_new_acl('Module write: '.$module['name'], 0);
		
				if ($acl_read > 0 && $acl_write > 0) {
					if ($GO_SECURITY->add_group_to_acl($GO_CONFIG->group_root, $acl_write)) {
						if (!$GO_MODULES->add_module($module['name'], $version, $acl_read, $acl_write, $sort_order, $admin_menu)) {
							$feedback = '<p class="Error">'.$strSaveError.'</p>';
						}
					} else {
						$GO_SECURITY->delete_acl($acl_read);
						$GO_SECURITY->delete_acl($acl_write);
					}
				} else {
					$GO_SECURITY->delete_acl($acl_read);
					$GO_SECURITY->delete_acl($acl_write);
				}
			}
		}
	}
}
?>
