<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

if (isset($_REQUEST['handler_base64_encoded']))
{
	$_REQUEST['GO_HANDLER'] = base64_decode($_REQUEST['GO_HANDLER']);
}
require_once("../../Group-Office.php");
$GO_SECURITY->authenticate();

//check for the addressbook module
$ab_module = $GO_MODULES->get_module('addressbook');
if (!$ab_module || 
	!($GO_SECURITY->has_permission($GO_SECURITY->user_id, $ab_module['acl_read']) ||
 	$GO_SECURITY->has_permission($GO_SECURITY->user_id, $ab_module['acl_write'])))
{
	$ab_module = false;
}

require_once($GO_LANGUAGE->get_language_file('addressbook'));

$GO_FIELD = isset($_REQUEST['GO_FIELD']) ? smart_stripslashes($_REQUEST['GO_FIELD']) : '';
$GO_HANDLER = isset($_REQUEST['GO_HANDLER']) ? smart_stripslashes($_REQUEST['GO_HANDLER']) : '';

$post_action = isset($_REQUEST['post_action']) ? $_REQUEST['post_action'] : 'search';
$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';

$pass_value = isset($_REQUEST['pass_value']) ? $_REQUEST['pass_value'] : 'email';
$multiselect = (isset($_REQUEST['multiselect']) && $_REQUEST['multiselect'] == 'true') ? true : false;
$require_email_address = (isset($_REQUEST['require_email_address']) && $_REQUEST['require_email_address'] == 'true') ? true : false;
$show_users = (isset($_REQUEST['show_users']) && $_REQUEST['show_users'] == 'true') ? true : false;
$show_contacts = (isset($_REQUEST['show_contacts']) && $_REQUEST['show_contacts'] == 'true') ? true : false;
$show_companies = (isset($_REQUEST['show_companies']) && $_REQUEST['show_companies'] == 'true') ? true : false;
$show_projects = (isset($_REQUEST['show_projects']) && $_REQUEST['show_projects'] == 'true') ? true : false;
$show_files = (isset($_REQUEST['show_files']) && $_REQUEST['show_files'] == 'true') ? true : false;

$search_type = isset($_REQUEST['search_type']) ? $_REQUEST['search_type'] : '';

if ($show_contacts || $show_companies)
{
	$GO_MODULES->authenticate('addressbook');
	
	require_once($ab_module['class_path'].'addressbook.class.inc');
	$ab = new addressbook();
	$custom_fields_plugin = $GO_MODULES->get_plugin('custom_fields');
	
	$ab_settings = $ab->get_settings($GO_SECURITY->user_id);
	if($search_type == '')
	{
		$search_type = $ab_settings['search_type'];
	}
	
	$addressbook_id = isset($_REQUEST['addressbook_id']) ? $_REQUEST['addressbook_id'] : $ab->get_default_addressbook($GO_SECURITY->user_id);
}
//$GO_HEADER['body_arguments'] = 'onblur="self.focus();"';
$page_title = $contacts_select;
require_once($GO_THEME->theme_path."header.inc");
?>
<script type="text/javascript" language="javascript">
var nav4 = window.Event ? true : false;
function processkeypress(e)
{
	if(nav4)
    {
		var whichCode = e.which;
	}else
 	{
		var whichCode = event.keyCode;
	}

	if (whichCode == 13)
	{
		search();
		return true;
    }
}
if (window.Event) //if Navigator 4.X
{
	document.captureEvents(Event.KEYPRESS)
}
document.onkeypress = processkeypress;


function search()
{
	document.select.task.value = 'search';
	document.select.submit();
}

function item_click(id, check_box)
{
	var item = get_object(id);
	if (item)
	{
		if (check_box.checked)
		{
			item.className = 'SelectedRow';
		}else
		{
			item.className = '';
		}
	}
}

function invert_selection()
{
	for (var i=0;i<document.forms[0].elements.length;i++)
	{
		if(document.forms[0].elements[i].type == 'checkbox' && document.forms[0].elements[i].name != 'dummy')
		{
			document.forms[0].elements[i].checked = !(document.forms[0].elements[i].checked);
			document.forms[0].elements[i].onclick();
		}
	}
}

function expand_group(group_id)
{
	document.forms[0].new_sort_order.value = '';
	document.forms[0].expand_id.value = group_id;
	document.forms[0].task.value = "expand";
	document.forms[0].submit();
}

function select_group(group_id)
{
	var add = false;

	for (var i = 0; i < document.forms[0].elements.length; i++)
	{
		if (document.forms[0].elements[i].name == 'group_start_'+group_id)
		{
			add = true;
		}

		if (document.forms[0].elements[i].name == 'group_end_'+group_id)
		{
			add = false;
		}

		if(document.forms[0].elements[i].type == 'checkbox' && document.forms[0].elements[i].name != 'dummy' && add==true)
		{
			document.forms[0].elements[i].checked = !(document.forms[0].elements[i].checked);
			document.forms[0].elements[i].onclick();
		}
	}
}

function change_mode(mode)
{

	document.select.post_action.value = mode;
	document.select.submit();
}

function _click(clicked_value, clicked_type)
{
	document.select.action = "<?php echo $GO_HANDLER; ?>";
	document.select.clicked_type.value=clicked_type;
	document.select.clicked_value.value=clicked_value;
	document.select.submit();
}

function letter_click(letter)
{
	document.select.post_action.value = 'search';
	document.select.task.value='show_letter';
	document.select.query.value=letter;
	document.select.submit();
}
function sort(column)
{
	document.forms[0].task.value = 'sort';
	document.forms[0].new_sort_field.value = column;
	document.forms[0].submit();
}

function _select()
{
	document.select.action = "<?php echo $GO_HANDLER; ?>";
	document.forms[0].submit();
}
</script>
<form method="post" name="select" action="<?php echo $_SERVER['PHP_SELF']; ?>">
<?php
if ($multiselect)
{
	echo '<input type="hidden" value="true" name="multiselect" />';
}else
{
	echo '<input type="hidden" value="false" name="multiselect" />';
}
if($require_email_address)
{
	echo '<input type="hidden" value="true" name="require_email_address" />';
}
if($show_users)
{
	echo '<input type="hidden" value="true" name="show_users" />';
	$types_used[] = 'user';
}
if($show_contacts)
{
	echo '<input type="hidden" value="true" name="show_contacts" />';
	$types_used[] = 'contact';
}
if($show_companies)
{
	$types_used[]='company';
	echo '<input type="hidden" value="true" name="show_companies" />';
}
if($show_projects)
{
	$types_used[]='project';
	echo '<input type="hidden" value="true" name="show_projects" />';
}
if($show_files)
{
	$types_used[]='file';
	echo '<input type="hidden" value="true" name="show_files" />';
}

if($task == 'search' && ($search_type == 'contact' || $search_type == 'company' || $search_type == 'user') && isset($ab))
{
 $ab_settings['search_type'] = $_REQUEST['search_type'];
  switch($_REQUEST['search_type'])
  {
		case 'contact':
		  $ab_settings['search_contacts_field'] = $_REQUEST['search_field'];
		  $ab_settings['search_addressbook_id'] = $_REQUEST['search_addressbook_id'];
		break;
		
		case 'company':
		  $ab_settings['search_addressbook_id'] = $_REQUEST['search_addressbook_id'];
		  $ab_settings['search_companies_field'] = $_REQUEST['search_field'];
		break;
		
		case 'user':
		  $ab_settings['search_users_field'] = $_REQUEST['search_field'];
		break;
  }

  $ab->update_settings($ab_settings);
  $search_type = in_array($ab_settings['search_type'], $types_used) ? $ab_settings['search_type'] : $types_used[0];
}


	
?>
<input type="hidden" name="pass_value" value="<?php echo $pass_value; ?>" />
<input type="hidden" name="post_action" value="<?php echo $post_action; ?>" />
<input type="hidden" name="task" />
<input type="hidden" name="GO_FIELD" value="<?php echo $GO_FIELD; ?>" />
<input type="hidden" name="GO_HANDLER" value="<?php echo $GO_HANDLER; ?>" />
<input type="hidden" name="clicked_value" />
<input type="hidden" name="clicked_type" />

<?php
if ($show_contacts || $show_companies)
{
	?>
	<table border="0" cellspacing="0" cellpadding="0">
	<tr>		
		<?php 
		if($show_contacts)
		{
		?>
			<td class="ModuleIcons">
			<a class="small" href="javascript:change_mode('search');">
			<img src="<?php echo $GO_THEME->images['ab_search']; ?>" border="0" height="32" width="32" /><br />
			<?php echo $contacts_search; ?></a></td>
			</td>
			<td class="ModuleIcons">
			<a class="small" href="javascript:change_mode('contacts');">
			<img src="<?php echo $GO_THEME->images['ab_browse']; ?>" border="0" height="32" width="32" /><br />
			<?php echo $ab_browse; ?></a></td>
			</td>		
			<td class="ModuleIcons">
			<a class="small" href="javascript:popup('<?php echo $ab_module['url']; ?>contact.php?addressbook_id=<?php echo $addressbook_id; ?>&popup=true','770','500');">
			<img src="<?php echo $GO_THEME->images['add_contact']; ?>" border="0" height="32" width="32" /><br />
			<?php echo $ab_new_contact; ?></a></td>
			</td>
		<?php
		}
		
		if($show_companies)
		{
		?>
		<td class="ModuleIcons">
		<a class="small" href="javascript:popup('<?php echo $ab_module['url']; ?>company.php?addressbook_id=<?php echo $addressbook_id; ?>&popup=true','770','500');">
		<img src="<?php echo $GO_THEME->images['ab_add_company']; ?>" border="0" height="32" width="32" /><br />
		<?php echo $ab_new_company; ?></a></td>
		</td>
		<?php
		}
		?>
	</tr>
	</table>
	<?php
}

$contacts = isset($_POST['contacts']) ? $_POST['contacts'] : array();
$users = isset($_POST['users']) ? $_POST['users'] : array();
$companies = isset($_POST['companies']) ? $_POST['companies'] : array();

require_once($GO_CONFIG->class_path.'mail/RFC822.class.inc');
$RFC822 = new RFC822();

if (isset($_REQUEST['address_string']))
{
	$addresses = $RFC822->explode_address_list(smart_stripslashes($_REQUEST['address_string']));
}else
{
	$addresses = isset($_POST['addresses']) ? array_map('smart_stripslashes', $_POST['addresses']) : array();
}

if ($pass_value == 'email')
{
	$addresses = array_merge($addresses, $contacts, $users, $companies);
}

switch($post_action)
{
	case 'search':
	$count = 0;
	
	$tabtable = new tabtable('search_type',$cmdSearch,'100%','', '120','',true);	

	if ($show_contacts)
	{
		$tabtable->add_tab('contact',$contacts_contacts);
	}
	if ($show_companies)
	{
		$tabtable->add_tab('company',$ab_companies);
	}
	if ($show_users)
	{
		$tabtable->add_tab('user',$contacts_members);
	}
	if($show_projects)
	{
		$tabtable->add_tab('project', $strProjects);
	}
	if($show_files)
	{
		$tabtable->add_tab('file', $strFiles);
	}
		
	$tabtable->set_active_tab($search_type);
	$tabtable->print_head();
	?>
	<table border="0" cellpadding="0" cellspacing="3">
	<tr height="30">
		<td nowrap>
		<h2>
			<?php
			for($i=0;$i<count($alphabet);$i++)
			{
				echo '<a href="javascript:letter_click(\''.$alphabet[$i].'\')">'.$alphabet[$i].'</a>&nbsp;&nbsp;&nbsp;';
			}
			?>
		</h2>
		</td>
	</tr>
	<tr>
		<td>
		<?php	
		$dropbox = new dropbox();
		$dropbox->add_value('', $strSearchAll);
		$custom_fields_plugin = $GO_MODULES->get_plugin('custom_fields');

		switch ($search_type)
		{
			case 'company':
				//$search_field = $ab_settings['search_companies_field'];
				$search_field = isset($_POST['search_field']) ? $_POST['search_field'] : $ab_settings['search_companies_field'];
				$dropbox->add_value('name', $strName);
				$dropbox->add_value('email', $strEmail);
				$dropbox->add_value('address',$strAddress);
				$dropbox->add_value('city', $strCity);
				$dropbox->add_value('zip',$strZip);
				$dropbox->add_value('state',$strState);
				$dropbox->add_value('country', $strCountry);
				if ($custom_fields_plugin)
				{
					require_once($custom_fields_plugin['class_path'].'custom_fields.class.inc');
					$cf = new custom_fields('ab_custom_company_fields');

					if($cf->get_fields())
					{
						while($cf->next_record())
						{
							$dropbox->add_value('ab_custom_company_fields.`'.$cf->f('field').'`', $cf->f('field'));
						}
					}
				}

			break;

			case 'contact':
				//$search_field = $ab_settings['search_contacts_field'];
				$search_field = isset($_POST['search_field']) ? $_POST['search_field'] : $ab_settings['search_contacts_field'];
				$dropbox->add_value('ab_contacts.first_name', $strFirstName);
				$dropbox->add_value('ab_contacts.last_name', $strLastName);
				$dropbox->add_value('ab_contacts.email', $strEmail);
				$dropbox->add_value('ab_contacts.department',$strDepartment);
				$dropbox->add_value('ab_contacts.function',$strFunction);
				$dropbox->add_value('ab_contacts.address',$strAddress);
				$dropbox->add_value('ab_contacts.city', $strCity);
				$dropbox->add_value('ab_contacts.zip',$strZip);
				$dropbox->add_value('ab_contacts.state',$strState);
				$dropbox->add_value('ab_contacts.country', $strCountry);
				$dropbox->add_value('ab_contacts.comment', $ab_comment);
				if ($custom_fields_plugin)
				{
					require_once($custom_fields_plugin['class_path'].'custom_fields.class.inc');
					$cf = new custom_fields('ab_custom_contact_fields');

					if($cf->get_fields())
					{
						while($cf->next_record())
						{
							$dropbox->add_value('ab_custom_contact_fields.`'.$cf->f('field').'`', $cf->f('field'));
						}
					}
				}
			break;

			case 'user':
				$default_search_field = isset($ab_settings['search_users_field']) ? $ab_settings['search_users_field'] : 'users.first_name';				
				$search_field = isset($_POST['search_field']) ? $_POST['search_field'] : $default_search_field;
				$dropbox->add_value('users.first_name', $strFirstName);
				$dropbox->add_value('users.last_name', $strLastName);
				$dropbox->add_value('users.email', $strEmail);
				$dropbox->add_value('users.department',$strDepartment);
				$dropbox->add_value('users.function',$strFunction);
				$dropbox->add_value('users.address',$strAddress);
				$dropbox->add_value('users.city', $strCity);
				$dropbox->add_value('users.zip',$strZip);
				$dropbox->add_value('users.state',$strState);
				$dropbox->add_value('users.country', $strCountry);
				$dropbox->add_value('users.comment', $ab_comment);
			break;
			
			case 'project':
				$search_field = 'pmProjects.name';
				$dropbox->add_value('pmProjects.name', $strName);
			break;
			
			case 'file':
			
				$home_path = $GO_CONFIG->file_storage_path.$_SESSION['GO_SESSION']['username'];
				$search_field = isset($_POST['search_field']) ? $_POST['search_field'] : $home_path;
				$dropbox = new dropbox();
  			$dropbox->add_value($home_path, 'home');
				
				require_once($GO_LANGUAGE->get_language_file('filesystem'));
				require_once($GO_CONFIG->class_path.'filesystem.class.inc');
				$fs = new filesystem();
				$fs2 = new filesystem();
			  $fs2->get_authorized_sharers($GO_SECURITY->user_id);
				
			  while ($fs2->next_record())
			  {
			    $shares = array();
			    $share_count = $fs->get_shares($fs2->f('user_id'));
			    while ($fs->next_record())
			    {
			      if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $fs->f('acl_read')) || 
								$GO_SECURITY->has_permission($GO_SECURITY->user_id, $fs->f('acl_write')))
			      {
							$shares[] = $fs->f('path');
			      }
			    }
			    $share_count = count($shares) ;
			    if ($share_count > 0)
			    {
			      if ($user = $GO_USERS->get_user($fs2->f('user_id')))
			      {
							$dropbox->add_optgroup($user['username']);
							for ($i=0;$i<$share_count;$i++)
							{
							  $dropbox->add_value($shares[$i], basename($shares[$i]));
							}
			      }
			    }
			  }		
			break;
		}
		
		echo '<table><tr>';
		
		if ($search_type == 'contact' || $search_type == 'company')
		{
		  if($ab->get_subscribed_addressbooks($GO_SECURITY->user_id) > 1)
		  {
			$subscribed_addressbooks = new dropbox();

			$subscribed_addressbooks->add_value('0', $ab_all_your_addressbooks);

			while ($ab->next_record())
			{
				$subscribed_addressbooks->add_value($ab->f('id'), $ab->f('name'));
			}
			echo '<td>'.$ab_search_in.':</td><td>';
			$subscribed_addressbooks->print_dropbox('search_addressbook_id', $ab_settings['search_addressbook_id']);
			echo '</td><td>'.$ab_search_on.'</td>';
		  }else
		  {
			  echo '<input type="hidden" name="search_addressbook_id" value="'.$ab_settings['search_addressbook_id'].'" />';
		  }
		}else
		{
			$sab_id = isset($ab_settings['search_addressbook_id']) ? $ab_settings['search_addressbook_id'] : 0;
			echo '<input type="hidden" name="search_addressbook_id" value="'.$sab_id.'" />';
			echo '</td><td>'.$ab_search_on_users.':</td>';
		}
		
		echo '<td>';
		$dropbox->print_dropbox('search_field', $search_field);
		echo '</td>';		
		
		echo '</tr>';
		?>
		<tr>
			<td><?php echo $ab_search_keyword; ?>:</td>
			<td colspan="3"><input type="text" name="query" size="31" maxlength="255" class="textbox" value="<?php if (isset($_POST['query']) && $task != 'show_letter') echo htmlspecialchars(smart_stripslashes($_POST['query'])); ?>">
			<?php
			$button = new button($cmdSearch, "javascript:search()");
			?>
			</td>
		</tr>
		</table>



	<?php
	$tabtable->print_foot();
	
	if ($task == 'search' || $task == 'show_letter')
	{
		if ($task == 'show_letter')
		{
			$query = smart_addslashes($_POST['query']).'%';
		}else
		{
			$query = '%'.smart_addslashes($_POST['query']).'%';
		}

		if ($search_type == 'contact' || $search_type == 'user')
		{
			if ($search_type == 'user')
			{
				$click_type = 'user';
				$array_name = 'users[]';
				$ab = new $go_users_class();
				$ab->search($query, $search_field, $GO_SECURITY->user_id);
			}else
			{
				$click_type = 'contact';
				$array_name = 'contacts[]';
				$ab->search_contacts($GO_SECURITY->user_id, $query, $search_field, $ab_settings['search_addressbook_id']);
			}

			$search_results = '';
			while ($ab->next_record())
			{
				$mail_name = format_name($ab->f('last_name'), $ab->f('first_name'), $ab->f('middle_name'), 'first_name');
				$full_email = $RFC822->write_address($mail_name, $ab->f('email'));				
				$name = format_name($ab->f('last_name'), $ab->f('first_name'), $ab->f('middle_name'));

				if (
							(!$require_email_address || $ab->f("email") != '') && 
							(
								($search_type == 'user' && $GO_SECURITY->has_permission($GO_SECURITY->user_id, $ab->f('acl_id'))) ||
								($search_type != 'user')
							)
						)
				{
					$class="";
					$check = "";

					if ($pass_value == 'email')
					{
						if ($ab->f("email") != "")
						{
							$key = array_search($full_email, $addresses);
						}else
						{
							$key = false;
						}
						if (is_int($key))
						{
							unset($addresses[$key]);
							$check = "checked";
							$class = "SelectedRow";
						}
					}elseif($search_type == 'user')
					{
						$key = array_search($ab->f($pass_value), $users);

						if (is_int($key))
						{
							unset($users[$key]);
							$check = "checked";
							$class = "SelectedRow";
						}
					}elseif($search_type == 'contact')
					{
						$key = array_search($ab->f($pass_value), $contacts);

						if (is_int($key))
						{
							unset($contacts[$key]);
							$check = "checked";
							$class = "SelectedRow";
						}
					}

					$search_results .= "<tr id=\"".$ab->f('id')."\" class=\"".$class."\" height=\"20\">\n";
					
			
					$value = $pass_value == 'email' ?  htmlspecialchars($full_email,ENT_QUOTES) : $ab->f($pass_value);
					if ($multiselect)
					{
						$search_results .= '<td><input onclick="javascript:item_click('.
								$ab->f("id").', this);" type="checkbox" name="'.$array_name.
								'" value="'.$value.'" '.$check.' /></td>';
					}

					if ($search_type != 'user' && $ab->f('color') != '')
					{
						$style = ' style="color: '.$ab->f('color').';"';
					}else
					{
						$style = '';
					}

					$search_results .= '<td><a'.$style.' href="javascript:_click(\''.
						$value .'\', \''.$click_type.'\');" class="normal">'.$name.'</a>&nbsp;</td>';
					$search_results .= "<td>".mail_to(addslashes($full_email), empty_to_stripe($ab->f("email")))."&nbsp;</td>\n";
					$search_results .= "</tr>\n";
					$count++;
				}
			}
			echo '<tr><td><h2>'.$count.' '.$contacts_results.'</h2>';
			echo '<tr><td>';

			if ($count > 0)
			{
				echo '<table class="go_table" width="100%">';
				echo '<tr>';
				if ($multiselect)
				{
					echo '<th width="16"><input type="checkbox" name="dummy" value="dummy" onclick="javascript:invert_selection()" /></th>';
				}
				echo '<th>'.$strName.'</th>';
				echo '<th>'.$strEmail.'</th>';
				echo '</tr>';
				echo $search_results;
				echo '</table>';
			}
		}elseif($search_type=='company')
		{
			$ab->search_companies($GO_SECURITY->user_id, $query, $search_field, $ab_settings['search_addressbook_id']);

			$search_results = '';
			while ($ab->next_record())
			{
				if (!$require_email_address || $ab->f("email") != '')
				{
					$count++;

					$class="";
					$check = "";
					
					$full_email = $RFC822->write_address($ab->f('name'), $ab->f('email'));
					if ($pass_value == 'email')
					{
						if ($ab->f("email") != "")
						{
							$key = array_search($full_email, $addresses);
						}else
						{
							$key = false;
						}
						if (is_int($key))
						{
							unset($addresses[$key]);
							$check = "checked";
							$class = "SelectedRow";
						}
					}else
					{
						$key = array_search($ab->f($pass_value), $companies);
						if (is_int($key))
						{
							unset($companies[$key]);
							$check = "checked";
							$class = "SelectedRow";
						}
					}					
					
					$value = $pass_value == 'email' ?  htmlspecialchars($full_email,ENT_QUOTES) : $ab->f($pass_value);

					$search_results .= "<tr id=\"".$ab->f('id')."\" class=\"".$class."\" height=\"20\">\n";
					if ($multiselect)
					{
						$search_results .= '<td><input onclick="javascript:item_click('.$ab->f("id").', this);" type="checkbox" name="companies[]" value="'.$value.'" '.$check.' /></td>';
					}
					$search_results .= '<td><a href="javascript:_click(\''.$value.'\', \'company\');" class="normal">'.$ab->f('name').'</a>&nbsp;</td>';
					$search_results .= "<td>".mail_to(empty_to_stripe(addslashes($full_email)), empty_to_stripe($ab->f("email")),'normal',true, $ab->f("id"))."&nbsp;</td>\n";
					$search_results .= "</tr>\n";

				}
			}
			

			$result_str =  ($count == 1) ? $count.' '.$contacts_result : $count.' '.$contacts_results;
			echo '<br /><h2>'.$result_str.'</h2>';

			if ($count > 0)
			{
				echo '<table class="go_table" width="100%">';
				echo '<tr>';
				if ($multiselect)
				{
					echo '<th width="16"><input type="checkbox" name="dummy" value="dummy" onclick="javascript:invert_selection()" /></td>';
				}
				echo '<th>'.$strName.'</th>';
				echo '<th>'.$strEmail.'</th>';
				echo '</tr>';

				echo $search_results;

				echo '</table>';
			}
		}elseif($search_type == 'project')
		{
			require_once($GO_MODULES->modules['projects']['class_path'].'projects.class.inc');
			$projects = new projects();
			
			$count = $projects->get_authorized_projects($GO_SECURITY->user_id, 0, 0, 0, 
								'pmProjects.name', 'ASC', 0, 0, '', $search_field,$query);
			
			$result_str =  ($count == 1) ? $count.' '.$contacts_result : $count.' '.$contacts_results;
			echo '<br /><h2>'.$result_str.'</h2>';
			
			if($count > 0)
			{				
				echo '<table class="go_table" width="100%">';
				echo '<tr>';
				echo '<th>'.$strName.'</th>';
				echo '<th>'.$strOwner.'</th>';
				echo '</tr>';
				while($projects->next_record())
				{
					$project_name = $projects->f('description') == '' ? $projects->f('name') : $projects->f('name').' ('.$projects->f('description').')';
					echo '<tr><td><a href="javascript:_click(\''.$projects->f('id').
								'\', \'project\');" class="normal">'.$project_name.'</a>&nbsp;</td>'.
								'<td>'.show_profile($projects->f('user_id')).'</td></tr>';
					
				}
				echo '</table>';
			}
		}elseif($search_type == 'file')
		{			
			if ($_POST['query'] == '') 
			{
				$_POST['query'] = '.';
			}
			$results = $fs->search($search_field, $_POST['query']);
			$count = count($results);

			echo '<table class="go_table" width="100%"><tr>';
			echo '<th width="16">'.$strName.'</td>';
			echo '<th colspan="2" width="16">'.$fbLocation.'</td></tr>';

			while($result = array_shift($results))
			{
				echo '<tr height="18">';
				echo '<td nowrap><a href="javascript:_click(\''.addslashes($result['path']).'\', \'file\');">';
					
				if (!is_dir($result['path']))
				{
					$extension = get_extension($result['name']);
					echo '<img width="16" height="16" border="0" src="'.get_filetype_image($extension).'" align="absmiddle" />&nbsp;'.$result['name'].'</a></td>';
				}else
				{
					echo '<img width="16" height="16" border="0" src="'.$GO_THEME->images['folder'].'" align="absmiddle" />&nbsp;'.$result['name'].'</a></td>';
				}
				$location = dirname($result['path']);

				echo '<td nowrap>&nbsp;'.str_replace($GO_CONFIG->file_storage_path,$GO_CONFIG->slash,$location).'</td></tr>';
				
			}
			echo '<tr><td colspan="99" class="small" height="18">&nbsp;'.$count.' '.$fbItems.'</td></tr>';

			echo '</table>';
		}		
	}
	echo '<script type="text/javascript">document.select.query.focus();</script>';
	break;

	case 'contacts':		
		
		if ($task == 'expand')
		{
			if (isset($_POST['expand_id']))
			{
				$key = array_search($_POST['expand_id'], $_SESSION['contacts_expanded']);
				if (!$key)
				{
					$_SESSION['contacts_expanded'][]=$_POST['expand_id'];
				}else
				{
					unset($_SESSION['contacts_expanded'][$key]);
				}
			}
		}

		echo '<input type="hidden" name="new_sort_field" />';
		echo '<input type="hidden" name="expand_id" />';
		if (!isset($_SESSION['contacts_expanded']))
			$_SESSION['contacts_expanded'][]=-1;
		
		if($task == 'sort')
		{
		  $ab_settings['sort_contacts_order'] = $_REQUEST['new_sort_order'];
		  $ab_settings['sort_contacts_field'] = $_REQUEST['new_sort_field'];  
		  
		  $ab->update_settings($ab_settings);
		}
		if ($ab_settings['sort_contacts_order'] == "DESC")
		{
			$image_string = '&nbsp;<img src="'.$GO_THEME->images['arrow_down'].'" border="0" />';
			$new_sort_order = "ASC";
		}else
		{
			$image_string = '&nbsp;<img src="'.$GO_THEME->images['arrow_up'].'" border="0" />';
			$new_sort_order = "DESC";
		}
		echo '<input type="hidden" value="'.$new_sort_order.'" name="new_sort_order" />';

		if ($ab->get_subscribed_addressbooks($GO_SECURITY->user_id) > 1)
		{
			echo '<table border="0" cellpadding="0" cellspacing="0"><tr><td>'.$ab_addressbook.':</td><td>';
			$subscribed_addressbooks = new dropbox();
			while ($ab->next_record())
			{
				$subscribed_addressbooks->add_value($ab->f('id'), $ab->f('name'));
			}
			$subscribed_addressbooks->print_dropbox('addressbook_id', $addressbook_id, 'onchange="javascript:change_addressbook()"');
			echo '</td></tr></table>';
		}else
		{
			echo '<input type="hidden" name="addressbook_id" value="'.$addressbook_id.'" />';
		}

		echo "<table class=\"go_table\" width=\"100%\">\n";
		echo '<tr><th>&nbsp;</td>';
		if ($multiselect)
		{
			echo '<th width="16"><input type="checkbox" name="dummy" value="dummy" onclick="javascript:invert_selection()" /></td>';
		}
		echo "<th><a href=\"javascript:sort('name')\">".$strName;
		if ($ab_settings['sort_contacts_field'] == "name")
		        echo $image_string;
		echo "</a></td>\n";
		echo "<th><a href=\"javascript:sort('email')\">".$strEmail;
		if ($ab_settings['sort_contacts_field'] == "email")
		        echo $image_string;
		echo "</a></td>\n";
		echo "</tr>\n";		
		
		$contact_group_count= $ab->get_groups($addressbook_id);
		while($ab->next_record())
		{
			$contact_groups[] = array('id'=>$ab->f('id'), 'name'=>$ab->f('name'));
		}
		$contact_groups[] = array('id'=>0, 'name'=>$contacts_other);		
		$contact_group_count++;

		while($contact_group = array_shift($contact_groups))
		{
			if (in_array($contact_group['id'], $_SESSION['contacts_expanded']) || $contact_group_count == 1)
			{
				if($contact_group_count > 1)
				{
					echo "<tr><td><a href=\"javascript:expand_group(".$contact_group['id'].")\"><img src=\"".$GO_THEME->images['min_node']."\" border=\"0\" /></a></td><td><input type=\"checkbox\" name=\"dummy\" value=\"dummy\" onclick=\"javascript:select_group('".$contact_group['id']."')\" /></td><td colspan=\"4\">".$contact_group['name']."</td></tr>";
					
				}

				if ($ab->get_contacts_group($addressbook_id, $contact_group['id'], $ab_settings['sort_contacts_field'], $ab_settings['sort_contacts_order']) > 0)
				{
					echo '<input type="hidden" name="group_start_'.$contact_group['id'].'" />';
					while ($ab->next_record())
					{
						$check = "";
						$class = '';
													
						$mail_name = format_name($ab->f('last_name'), $ab->f('first_name'), $ab->f('middle_name'), 'first_name');
						$full_email = $RFC822->write_address($mail_name, $ab->f('email'));				
						$name = format_name($ab->f('last_name'), $ab->f('first_name'), $ab->f('middle_name'));

						if ($pass_value == 'email')
						{
							if ($ab->f("email") != "")
							{																		
								$key = array_search($full_email, $addresses);
							}else
							{
								$key = false;
							}
							if (is_int($key))
							{
								unset($addresses[$key]);
								$check = "checked";
								$class = "SelectedRow";
							}
						}else
						{
							$key = array_search($ab->f($pass_value), $contacts);
							if (is_int($key))
							{
								unset($contacts[$key]);
								$checked = "checked";
								$class = 'SelectedRow';
							}
						}

						if ($ab->f('color') != '')
						{
							$style = ' style="color: '.$ab->f('color').';"';
						}else
						{
							$style = '';
						}						

						echo "<tr id=\"".$ab->f("id")."\" class=\"".$class."\" height=\"20\"><td></td>\n";
						
						if (!$require_email_address || $ab->f('email') != '')
						{
							$value = $pass_value == 'email' ?  $full_email : $ab->f($pass_value);
							if ($multiselect)
							{
								echo "<td><input id=\"".$name."\" type=\"checkbox\" ".
											"onclick=\"javascript:item_click(".$ab->f('id').
											", this);\" name=\"contacts[]\" value=\"".htmlspecialchars($value).
											"\" ".$check." /></td>";
							}
							echo "<td><a".$style." class=\"normal\" ".
										"href=\"javascript:_click('".htmlspecialchars($value)."', 'contact');\">".
										empty_to_stripe($name)."</a>&nbsp;</td>\n";
						}else
						{
							if ($multiselect)
							{
								echo '<td></td>';
							}
							echo '<td><span style="'.$style.'">'.$name.'</span></td>';
						}
						
						echo "<td>".mail_to(empty_to_stripe($full_email), empty_to_stripe($ab->f("email")),'normal',true, $ab->f("id"))."&nbsp;</td>\n";
						echo "</tr>\n";
						
					}
					echo '<input type="hidden" name="group_end_'.$contact_group['id'].'" />';
				}else
				{
					echo "<tr><td colspan=\"99\" height=\"18\">".$contacts_empty_group."</td></tr>";
					
				}
			}else
			{
				echo "<tr><td><a href=\"javascript:expand_group(".$contact_group['id'].")\"><img src=\"".$GO_THEME->images['plus_node']."\" border=\"0\" /></a></td><td>&nbsp;</td><td colspan=\"4\" width=\"100%\">".$contact_group['name']."</td></tr>";
				
			}
		}		
	break;
}

echo '<table border="0" width="100%"><tr><td align="center"><br />';
if($multiselect && ($post_action != 'search' || $count > 0))
{
	$button = new button($cmdAdd,'javascript:_select();');
	echo '&nbsp;&nbsp;';
}
$button = new button($cmdCancel,'javascript:window.close();');
echo '</td></tr></table>';


while($address = array_pop($addresses))
{
	echo '<input type="hidden" name="addresses[]" value="'.htmlspecialchars(smart_stripslashes($address),ENT_QUOTES).'" />';
}

echo '</form>';

require_once($GO_THEME->theme_path."footer.inc");
?>
