<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/
require_once("../Group-Office.php");

$GO_SECURITY->authenticate();

$projects_module = isset($GO_MODULES->modules['projects']) ? $GO_MODULES->modules['projects'] : false;
if($projects_module && $projects_module['read_permission'])
{
	require_once($projects_module['class_path'].'projects.class.inc');
	$projects = new projects();
}

$fs_module = isset($GO_MODULES->modules['filesystem']) ? $GO_MODULES->modules['filesystem'] : false;
if($fs_module && $fs_module['read_permission'])
{
	require_once($GO_CONFIG->class_path.'filesystem.class.inc');
	$fs = new filesystem();
}

$ab_module = isset($GO_MODULES->modules['addressbook']) ? $GO_MODULES->modules['addressbook'] : false;
if ($ab_module && $ab_module['read_permission'])
{
	require_once($ab_module['class_path'].'addressbook.class.inc');
	$ab = new addressbook();
}

$overlib = new overlib();
$GO_HEADER['head'] = $overlib->get_header();

require_once($GO_THEME->theme_path."header.inc");

$task = isset($_POST['task']) ? $_POST['task'] : '';

$stay_open = false;

echo '<form name="reminder_form" action="'.$_SERVER['PHP_SELF'].'" method="post">'.
'<input type="hidden" name="task" />'.
'<input type="hidden" name="event_id" />'.
'<input type="hidden" name="todo_id" />';

/*
echo '<embed src="'.$GO_THEME->sounds['reminder'].'" hidden="true" '.
'autostart="true"><noembed><bgsound src="'.$GO_THEME->sounds['reminder'].
'"></noembed>';*/

echo '<object width="1" height="1">'.
'<param name="movie" value="'.$GO_THEME->sounds['reminder'].'">'.
'<param name="loop" value="false">'.
'<embed src="'.$GO_THEME->sounds['reminder'].'" loop="false" width="1" height="1">'.
'</embed>'.
'</object>';

echo '<table border="0" style="margin-top: 10px" width="100%">';

$email_module = isset($GO_MODULES->modules['email']) ? $GO_MODULES->modules['email'] : false;
if ($email_module && $GO_MODULES->modules['email']['read_permission'] &&
$_SESSION['new_mail'] > $_SESSION['notified_new_mail'])
{
	$stay_open = true;
	require_once($GO_LANGUAGE->get_language_file('email'));

	echo 	'<tr><td valign="top">'.
	'<img style="margin-right: 10px;" width="32" height="32" src="'.$GO_THEME->images['email_notify'].
	'" border="0" /></td><td>'.
	'<h2><a href="javascript:goto_url(\''.$email_module['url'].'\');">'.
	$lang_modules['email'].'</a></h2></td></tr><tr><td></td><td width="100%">';

	echo  '<a href="javascript:goto_url(\''.$email_module['url'].'\')">'.
	$ml_you_have.' '.$_SESSION['new_mail'].' ';

	if ($_SESSION['new_mail'] > 1)
	{
		echo $ml_new_mail_multiple;
	}else
	{
		echo $ml_new_mail_single;
	}
	echo '</a></td></tr>';
	echo '<tr><td colspan="99">&nbsp;</td></tr>';

	$_SESSION['notified_new_mail'] = $_SESSION['new_mail'];
}
$calendar_module = isset($GO_MODULES->modules['calendar']) ? $GO_MODULES->modules['calendar'] : false;
if ($calendar_module && $GO_MODULES->modules['calendar']['read_permission'])
{
	require_once($GO_LANGUAGE->get_language_file('calendar'));
	require_once($GO_MODULES->modules['calendar']['class_path'].'calendar.class.inc');
	$cal = new calendar();
	$cal2 = new calendar();
	
	if(isset($_POST['event_id']) && $_POST['event_id'] > 0)
	{
		switch($task)
		{
			case 'snooze':
				$cal->update_reminder($GO_SECURITY->user_id, $_POST['event_id'], get_gmt_time()+$_POST['snooze']);
			break;
			
			case 'dismiss':
				if($event = $cal->get_event($_POST['event_id']))
				{
					$next_recurrence_time = $cal2->get_next_recurrence_time(0,0, $event);	
					$update_reminder = $cal2->get_next_recurrence_time(0, $next_recurrence_time, $event)-$event['reminder'];
	
					if ($update_reminder > $next_recurrence_time)
					{
						$cal->update_reminder($GO_SECURITY->user_id, $event['id'], $update_reminder);
					}else
					{
						$cal->delete_reminder($GO_SECURITY->user_id, $event['id']);
					}
				}
			break;
		}
	}
	
	if($event_count = $cal->get_events_to_remind($GO_SECURITY->user_id))
	{
		$stay_open = true;
		
		echo 	'<tr><td valign="top">'.
		'<img style="margin-right: 10px;" width="32" height="32" src="'.$GO_THEME->images['calendar'].
		'" border="0" /></td><td>'.
		'<h2><a href="javascript:goto_url(\''.$calendar_module['url'].'\');">'.
		$sc_events.'</a></h2></td></tr><tr><td></td><td width="100%">';

		echo '<table width="100%">';
		while($cal->next_record())
		{

			$start_time = $cal->f('start_time')+(get_timezone_offset($cal->f('start_time'))*3600);
			$end_time = $cal->f('end_time')+(get_timezone_offset($cal->f('end_time'))*3600);

			$link =
			$GO_SECURITY->has_permission($GO_SECURITY->user_id, $cal->f('acl_write')) ?
			$calendar_module['url'].'event.php' : $calendar_module['url'].'show_event.php';

			if ($cal->f('all_day_event') == '1')
			{
				$date_format = $_SESSION['GO_SESSION']['date_format'];
			}elseif(date($_SESSION['GO_SESSION']['date_format'], $start_time) !=
			date($_SESSION['GO_SESSION']['date_format'],$end_time))
			{
				$date_format = $_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'];
			}else
			{
				$date_format = $_SESSION['GO_SESSION']['time_format'];
			}
			$title = $sc_start_at.': '.date($date_format, $start_time).'<br />'.
			$sc_end_at.': '.date($date_format, $end_time);

			if($cal->f('contact_id') > 0 && $contact = $ab->get_contact($cal->f('contact_id')))
			{
				$middle_name = $contact['middle_name'] == '' ? '' : $contact['middle_name'].' ';
				$contact_name = $contact['first_name'].' '.$middle_name.$contact['last_name'];
				$title .= '<br />'.$strContact.': '.htmlspecialchars($contact_name);
				if ($contact['company_name'] != '')
				{
					$title .= " (".htmlspecialchars($contact['company_name']).")";
				}

			}elseif($cal->f('company_id') > 0 && $company = $ab->get_company($cal->f('company_id')))
			{
				$title .= '<br />'.$strCompany.': '.htmlspecialchars($company['name']);

			}elseif($cal->f('project_id') > 0)
			{
				if($project = $projects->get_project($cal->f('project_id')))
				{
					$project_name = $project['description'] == '' ? $project['name'] : $project['name'].' ('.$project['description'].')';
					$title .= '<br />'.$strProject.': '. htmlspecialchars($project_name);
				}
			}

			if ($cal->f('location') != '')
			{
				$title .= "<br />".$sc_location.": ".htmlspecialchars($cal->f('location'));
			}
			$event_cal_count = $cal2->get_calendars_from_event($cal->f('id'));
			$title .= "<br />$cal_event_calendars: ";
			$first = true;
			while($cal2->next_record())
			{
				if($first)
				{
					$first = false;
				}else
				{
					$title .= ' ,';
				}
				$title .= htmlspecialchars($cal2->f('name'));
			}

			$style_event = 'style="background-color: #'.$cal->f('background').';"';
			echo '<tr height="16"><td width="8"></td><td>';
			echo '<a href="javascript:goto_url(\''.$link.'?event_id='.$cal->f('id').'\');" '.
			$overlib->print_overlib($title).
			'><div class="summary_icon" '.$style_event.'>&nbsp;</div>&nbsp;'.
			date($date_format, $start_time).'&nbsp;'.$cal->f('name').
			'</a></td><td align="right">';
			$dropbox = new dropbox();
			$dropbox->add_value('300', '5 '.$sc_mins);
			$dropbox->add_value('900', '15 '.$sc_mins);
			$dropbox->add_value('1800', '30 '.$sc_mins);
			$dropbox->add_value('3600', '1 '.$sc_hour);
			$dropbox->add_value('7200', '2 '.$sc_hours);
			$dropbox->add_value('86400', '1 '.$sc_day);
			$dropbox->add_value('604800','1'.$sc_week);
			$dropbox->print_dropbox('snooze', '300');
			echo '&nbsp;';
			$button = new button($strSnooze, "javascript:update_event_reminder(".$cal->f('id').",'snooze');");
			echo '&nbsp;';
			$button = new button($strDismiss, "javascript:update_event_reminder(".$cal->f('id').",'dismiss');");
			echo '</td></tr>';
			
		}
		echo '</table></td></tr>';
	}
}
$todos_module = isset($GO_MODULES->modules['todos']) ? $GO_MODULES->modules['todos'] : false;
if ($todos_module && $GO_MODULES->modules['todos']['read_permission'])
{
	$local_time = get_time();

	require_once($GO_LANGUAGE->get_language_file('todos'));

	require_once($GO_MODULES->modules['todos']['class_path'].'todos.class.inc');
	$todos = new todos();

	if(isset($_POST['todo_id']) && $_POST['todo_id'] > 0)
	{
		switch($task)
		{
			case 'snooze':
				$todos->update_reminder($GO_SECURITY->user_id, $_POST['todo_id'], get_gmt_time()+$_POST['snooze']);
			break;
			
			case 'dismiss':
				$todos->delete_reminder($GO_SECURITY->user_id, $_POST['todo_id']);
			break;
		}
	}
	
	if ($todo_count = $todos->get_todos_to_remind($GO_SECURITY->user_id))
	{
		$stay_open = true;
		
		$todos2=new todos();

		echo '<tr><td valign="top">'.
		'<img style="margin-right: 10px;" width="32" height="32" src="'.$GO_THEME->images['todos'].
		'" border="0" /></td><td>'.
		'<h2><a href="javascript:goto_url(\''.$todos_module['url'].'\');">'.
		$lang_modules['todos'].'</a></h2></td></tr><tr><td></td><td width="100%">';

		echo '<table width="100%">';

		while($todos->next_record())
		{
			//$todos2->set_reminded($todos->f('id'));

			$start_time = $todos->f('start_time')+(get_timezone_offset($todos->f('start_time'))*3600);
			$due_time = $todos->f('due_time')+(get_timezone_offset($todos->f('due_time'))*3600);
			$check = '';
			if ($todos->f('completion_time') > 0)
			{
				$class = 'todo_completed';
				$check = 'checked';
			}elseif($due_time < $local_time)
			{
				$class = 'todo_late';
			}else
			{
				$class= 'todo';
			}

			switch ($todos->f("priority"))
			{
				case "0":
				$priority = '<img src="'.$GO_THEME->images['low_priority'].'" width="8" height="16" />';
				break;

				case "2":
				$priority = '<img src="'.$GO_THEME->images['high_priority'].'" width="8" height="16" />';
				break;

				default:
				$priority = '';
				break;
			}

			$title = 	$sc_start_at.': '.date($_SESSION['GO_SESSION']['date_format'].' '.
			$_SESSION['GO_SESSION']['time_format'], $start_time).'<br />'.
			$cal_due_at.': '.date($_SESSION['GO_SESSION']['date_format'].' '.
			$_SESSION['GO_SESSION']['time_format'], $due_time);
			if ($todos->f('completion_time') > 0)
			{
				$title .= 	'<br />'.$cal_completed.': '.
				date($_SESSION['GO_SESSION']['date_format'].' '.
				$_SESSION['GO_SESSION']['time_format'],
				$todos->f('completion_time')+
				(get_timezone_offset($todos->f('completion_time'))*3600));
			}

			if($todos->f('contact_id') > 0 && $contact = $ab->get_contact($todos->f('contact_id')))
			{
				$middle_name = $contact['middle_name'] == '' ? '' : $contact['middle_name'].' ';
				$contact_name = $contact['first_name'].' '.$middle_name.$contact['last_name'];
				$title .= '<br />'.$strContact.': '.htmlspecialchars($contact_name);
				if ($contact['company_name'] != '')
				{
					$title .= " (".htmlspecialchars($contact['company_name']).")";
				}

			}elseif($todos->f('company_id') > 0 && $company = $ab->get_company($todos->f('company_id')))
			{
				$title .= '<br />'.$strCompany.': '.htmlspecialchars($company['name']);

			}elseif($todos->f('project_id') > 0)
			{
				if($project = $projects->get_project($todos->f('project_id')))
				{
					$project_name = $project['description'] == '' ? $project['name'] : $project['name'].' ('.$project['description'].')';
					$title .= '<br />'.$strProject.': '. htmlspecialchars($project_name);
				}
			}
			if ($todos->f('location') != '')
			{
				if ($title != '')
				{
					$title .= '<br />';
				}
				$title .= $sc_location.": ".htmlspecialchars($todos->f('location'));
			}

			$title .= '<br />'.$cal_status.': '.$todos->f('status').'%';


			$style_event = 'style="background-color: #'.$todos->f('background').';"';

			echo 	'<tr><td width="8">'.$priority.'</td>'.			
			'<td><a class="'.$class.'" href="javascript:goto_url(\''.$todos_module['url'].'todo.php?todo_id='.$todos->f('id').'\');" '.
				$overlib->print_overlib($title).'><div class="summary_icon" '.$style_event.'>&nbsp;</div>&nbsp;'.$todos->f('name').'</a></td>';
			
			echo '<td align="right">';
			$dropbox = new dropbox();
			$dropbox->add_value('300', '5 '.$sc_mins);
			$dropbox->add_value('900', '15 '.$sc_mins);
			$dropbox->add_value('1800', '30 '.$sc_mins);
			$dropbox->add_value('3600', '1 '.$sc_hour);
			$dropbox->add_value('7200', '2 '.$sc_hours);
			$dropbox->add_value('86400', '1 '.$sc_day);
			$dropbox->add_value('604800','1'.$sc_week);
			$dropbox->print_dropbox('snooze', '300');
				echo '&nbsp;';
			$button = new button($strSnooze, "javascript:update_todo_reminder(".$todos->f('id').",'snooze');");
			echo '&nbsp;';
			$button = new button($strDismiss, "javascript:update_todo_reminder(".$todos->f('id').",'dismiss');");
			echo '</td></tr>';
		}
		echo 	'</table>';
	}
	echo '</td></tr>';
}

echo '</table>';
echo '</form>';
?>
<script type="text/javascript">

<?php
if(!$stay_open)
{
	echo 'window.close();';
}
?>
function update_event_reminder(event_id, task)
{
	document.reminder_form.task.value=task;
	document.reminder_form.event_id.value=event_id;
	document.reminder_form.submit();
}

function update_todo_reminder(todo_id, task)
{
	document.reminder_form.task.value=task;
	document.reminder_form.todo_id.value=todo_id;
	document.reminder_form.submit();
}

function goto_url(url)
{
	if (opener.parent.main)
	{
		if(url.indexOf("?") > 0)
		{
			url = url+'&return_to='+escape(opener.parent.main.location)
		}else
		{
			url = url+'?return_to='+escape(opener.parent.main.location)
		}
		opener.parent.main.location=url;
		opener.parent.main.focus();
	}else
	{
		window.open('<?php echo $GO_CONFIG->full_url.'index.php?return_to='; ?>'+escape(url), 'groupoffice','scrollbars=yes,resizable=yes,status=yes');

	}
	document.location=document.location;
}
</script>
<?php
require_once($GO_THEME->theme_path."footer.inc");
?>
