<?php
/**
* @copyright Intermesh 2003
* @author Merijn Schering <mschering@intermesh.nl>
* @version $Revision: 1.12 $ $Date: 2005/05/18 12:41:09 $
*
*  This program is free software; you can redistribute it and/or modify it
*  under the terms of the GNU General Public License as published by the
*  Free Software Foundation; either version 2 of the License, or (at your
*  option) any later version.
*/

/**
* This package can authenticate a user using the Group-Office SQL database
*
* @package  Framework
* @author   Merijn Schering <mschering@intermesh.nl>
* @since    Group-Office 2.05
*/

class sql_auth extends db
{
	/**
   * This function logs a user in
   * 
   * @access public
   * 
   * @param string $username
   * @param string $password
   * @param array $params	The authentication source specified in auth_sources.inc
   * 
   * @return bool
   */
	function login($username, $password, $params=array()) {
		global $GO_CONFIG, $GO_SECURITY, $GO_LANGUAGE, $GO_USERS;
		$GO_SECURITY->user_id = 0;

		$sql = "SELECT id FROM users WHERE username='$username' AND password='".md5($password)."'";
		$this->query($sql);
		if ($this->next_record()) {
			$user_id = $this->f('id');

			if($user_id > 0) {
				//Update session
				$GO_SECURITY->logged_in( $user_id );				

				if($GO_CONFIG->dav_switch) {
					global $GO_DAV;
					$GO_DAV->check_login($username);
				}

				$GO_USERS->increment_logins( $user_id );

				return true;
			}
		}
		return false;
	}
}
?>
