<?php
/**
 * @copyright Intermesh 2003
 * @author Merijn Schering <mschering@intermesh.nl>
 * @version $Revision: 1.9 $ $Date: 2005/04/28 13:27:03 $

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */

/**
 * Create a hierarchical structured view of various items.
 * The treeview object needs to be stored in the session and placed inside a form
 * that uses POST data to work.
 * 
 * 
 * @package Framework
 * @subpackage Controls
 * 
 * @access public
 */
 
 class treeview
 {
 	/**
	* Internal ID of the treeview. Used to identify POST variables that are sent by 
	* the treeview
	*
	* @var     String
	* @access  private
	*/	
 	var $id;
 	
 	/**
	* The nodes that represent the root of the tree.
	*
	* @var     Array
	* @access  private
	*/	
 	var $rootNodes = array();
 	
  /**
	* The node state is an array of node ID's that are set to true or false.
	* True means the node is open.
	*
	* @var     Array
	* @access  private
	*/	
 	var $nodeState = null;
 		
 	/**
	* Associative array with the Node ID as index that references a node object.
	*
	* @var     Array
	* @access  private
	*/	
 	var $nodes = array();
 	
 	
   /**
   * Constructor: Initializes treeview
   * 
   * @access public
   * 
   * @return void
   */
 	function treeview()
 	{
 		$this->id = 'form_'.uniqid(time());
 	}
 	
 	 /**
   * Reset's the treeview exept for the node state so opened nodes will stay open.
   * 
   * @access public
   * @return void
   */
 	function reset()
 	{
 		$this->rootNodes = array();;
		$this->nodes = array();
 		$this->treeview();
 	}
 	
 	 	/**
   * Add's a node that has no parent to the treeview
   * 
   * @param treenode $treenode A node object
   * @access public
   * @return void
   */
 	function addRootNode($treenode)
 	{
 		$this->rootNodes[] = $treenode;
 	}
 	
 	 	/**
   * Builds the treeview in HTML format.
   * 
   * @param string $formName The name of the form the treeview is in.
   * @access public
   * @return string Treeview HTML
   */
 	function getTreeview($formName='forms[0]')
 	{ 	
 		if(isset($_POST[$this->id]['expandNodeId']))
 		{ 			
 			$this->nodes[$_POST[$this->id]['expandNodeId']]->open = !$this->nodes[$_POST[$this->id]['expandNodeId']]->open; 			
 			$this->nodeState[$_POST[$this->id]['expandNodeId']] = $this->nodes[$_POST[$this->id]['expandNodeId']]->open;
 		}
 		
 		$tree = 	'<input type="hidden" name="'.$this->id.'[expandNodeId]" value="0" />'; 		
 		
 		for($i=0;$i<count($this->rootNodes);$i++)
 		{
 			$tree .= $this->rootNodes[$i]->getNode($this);
 		} 		
 		
 		$tree .= '<script type="text/javascript">'.
 		 'function expand_'.$this->id.'(nodeId){'.
		'document.'.$formName.'.elements["'.$this->id.'[expandNodeId]"].value = nodeId;'.
		'document.'.$formName.'.submit();'.
		'}'.
 		'</script>';
 		
 		return $tree;
 	}
 	
 	function setOpen($nodeId)
 	{
 		$this->nodes[$nodeId]->open = true;
 		$this->nodeState[$nodeId] = true;
 	}
 	
 	function setClosed($nodeId)
 	{
 		$this->nodes[$nodeId]->open = false;
 		$this->nodeState[$nodeId] = false;
 	}
 	
 	/**
   * Tells if a node is open or not
   * 
   * @param string $nodeId The node ID
   * @access public
   * @return bool True if open
   */
 	function nodeIsOpen($nodeId)
 	{
 		$this->nodeState[$nodeId] = isset($this->nodeState[$nodeId]) ? $this->nodeState[$nodeId] : false;
 		return $this->nodeState[$nodeId];
 	}
 }


/**
 * Create a hierarchical structured view of various items.
 * The treeview object needs to be stored in the session and placed inside a form
 * that uses POST data to work.
 * 
 * 
 * @package Framework
 * @subpackage Controls
 * 
 * @access public
 */
 
class treenode
{
	
	var $htmlClosed = '';
	
	var $htmlOpened = '';
	
	var $childnodes = array();
	
	var $openedNodeImage = '-';	
	var $closedNodeImage = '+';
	var $noChildsImage = '&nbsp;';
	
	var $levelPadding = 20;
	
	var $open = false;


  function treenode($id, $htmlClosed, $htmlOpened=null, $open=false, $alwaysOpen=false)
  {
  	global $GO_THEME;
  	
  	$this->id = $id;
  	
  	$this->open = $alwaysOpen ? true : $open;
  	
  	$this->alwaysOpen = $alwaysOpen;
  	  	
  	$this->htmlClosed = $htmlClosed;
  	
  	$this->htmlOpened = isset($htmlOpened) ? $htmlOpened : $htmlClosed;  	
  	
  	$this->openedNodeImage = '<img src="'.$GO_THEME->images['min_node'].'" style="border:0px;margin-right:5px;" align="middle" />';
  	$this->closedNodeImage = '<img src="'.$GO_THEME->images['plus_node'].'" style="border:0px;margin-right:5px;" align="middle" />';
  	$this->noChildsImage = '<img src="'.$GO_THEME->images['blank'].'" style="border:0px;margin-right:5px;" align="middle" />';
  }
  
  function addNode($treenode)
  {  	
  	$this->childnodes[] = $treenode;
  }
  
  function getNode(&$treeview, $level=0)
  {   	
  	//this preserves node status when object is reset with treeview::reset() function
  	if($_SERVER['REQUEST_METHOD'] != 'POST')
  	{
  		$this->open = $treeview->nodeIsOpen($this->id);
  	}
  	
  	$image = $this->open ? $this->openedNodeImage :$this->closedNodeImage;
  	
  	$treeview->nodes[$this->id] = &$this;
  	
  	$padding = $level*$this->levelPadding;
  	
  	$node = '<div style="padding-left: '.$padding.'px;display:block;">';
  	
  	if(!$this->alwaysOpen && count($this->childnodes))
  	{
  		$node .= '<a href="javascript:expand_'.$treeview->id.'(\''.$this->id.'\');">'.$image.'</a>';
  	}else
  	{
  		$node .= $this->noChildsImage;
  	}
  	
  	
  	if($this->open && count($this->childnodes))
  	{
  		$node .= $this->htmlOpened;
  		$node .= '</div>';
  	
	  	for($i=0;$i<count($this->childnodes);$i++)
	  	{
	  		$node .= $this->childnodes[$i]->getNode($treeview,$level+1);
	  	}
  	}else
  	{
  		$node .= $this->htmlClosed;
  		$node .= '</div>';
  	}
  	return $node;
  }
}
?>