<?php
/**
 * @copyright Intermesh 2003
 * @author Merijn Schering <mschering@intermesh.nl>
 * @version $Revision: 1.5 $ $Date: 2005/04/09 19:13:26 $

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.

 * @package Framework
 * @subpackage Controls
 */

/**
 * Prints a color selector with custom colors
 *
 * @package Framework
 * @subpackage Controls
 * 
 * @access public
 */
class color_selector
{
	/**
	* The array of colors to be selectable
	*
	* @var     String
	* @access  private
	*/	
  var $colors = array();

	/**
	* Adds a color to the control
	*
	* @param String $color_code The Hexadecimal color code
	* @access  public
	* @retrun void
	*/	
  function add_color($color_code)
  {
    $this->colors[] = $color_code;
  }

	/**
	* Prints the color selector
	*
	* @param String $name The name of the control
	* @param String $selected_color The selected color code
	* @param String $form_name The form name where the color selector is in
	* @access  public
	* @retrun void
	*/	
  function print_color_selector($name, $selected_color, $form_name ='forms[0]')
  {
    global $GO_THEME;

    if (!in_array($selected_color, $this->colors))
    {
      $selected_color = $this->colors[0];
    }
    echo '<input type="hidden" name="'.$name.'" value="'.$selected_color.'" />';

		$id = uniqid(time());
    echo '<table border="0"><tr>';

    while ($color_code = array_shift($this->colors))
    {
      echo '<td id="'.$id .'_'.$color_code.'" style="background-color: #'.$color_code.'; border: 1px solid #aaa;"><a href="javascript:select_background_'.$id .'(\''.$color_code.'\');"><img border="0" height="16" width="16" src="'.$GO_THEME->images['blank'].'" /></a></td>';
    }
    echo '</tr></table>';

    echo "
      <script type=\"text/javascript\" language=\"javascript\">
      function select_background_".$id ."(color)
      {
				active_table_cell = get_object('".$id ."_'+document.".$form_name.".elements['".$name."'].value);
				table_cell = get_object('".$id."_'+color);
				active_table_cell.style.border = '1px solid #aaa';
				table_cell.style.border = '2px solid black';
				document.".$form_name.".elements['".$name."'].value = color;
      }
    select_background_".$id."('".$selected_color."');
    </script>";
  }
}
?>
