<?php
/**
 * @copyright Intermesh 2003
 * @author Merijn Schering <mschering@intermesh.nl>
 * @version $Revision: 1.7 $ $Date: 2005/04/09 19:13:26 $

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.

 * @package Framework
 * @subpackage Controls
 */

/**
 * Create a checkbox.
 * 
 * This class is used to draw checkboxes on the website.
 * 
 * @package Framework
 * @subpackage Controls
 * 
 * @access public
 */
class checkbox
{
  /**
   * Draw a new checkbox.
   * 
   * If you supply a name for this checkbox, it will be directly printed
   * on the page, else the constructor does nothing.
   * 
   * @access public
   * 
   * @param string $name
   * @param string $value
   * @param string $text
   * @param bool $checked defines if this checkbox is checked or not.
   * @param bool $disabled can be used to disable this checkbox.
   * @param string $attributes
   * 
   * @return void
   */
  function checkbox(
      $name='', $value='', $text='', $checked=false, $disabled=false,
      $attributes='' )
  {
    if ( $name && $value ) {
      echo $this->get_checkbox(
	  $name, $value, $text, $checked, $disabled, $attributes );
    }
  }

  /**
   * Create a checkbox.
   * 
   * This function returns a string that can be used to print a button on the
   * website.
   * 
   * @access public
   * 
   * @param string $name
   * @param string $value
   * @param string $text
   * @param bool $checked defines if this checkbox is checked or not.
   * @param bool $disabled can be used to disable this checkbox.
   * @param string $attributes
   * 
   * @return string
   */
  function get_checkbox(
      $name, $value, $text, $checked=false, $disabled=false, $attributes='' )
  {
    $id = uniqid( time() );
    $checked = $checked ? ' checked' : '';
    $disabled_str = $disabled ? ' disabled' : '';

    $checkbox = '<input id="'.$id.'" type="checkbox" name="'.$name.'" '.
      'value="'.$value.'"'.$checked.$disabled_str.' '.$attributes.' />';

    if ( $text != '' ) {
      if ( $disabled ) {
	$checkbox .= '<span style="color: #7d7d7d">'.$text.'</span>';
      } else {
	$checkbox .= '<a href="javascript:check_checkbox(\''.$id.'\')">'.
	  $text.'</a>';
      }
    }
    return $checkbox;
  }
}
?>
