/*
 * Decompiled with CFR 0.152.
 */
package jupload;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import javax.swing.JProgressBar;

public class FileUploadThreadV2
extends Thread {
    public static final String TITLE = "JUpload FileUploadThreadV2";
    public static final String DESCRIPTION = "Java Thread to upload files into a web server.";
    public static final String AUTHOR = "William JinHua Kwong";
    public static final double VERSION = 2.1;
    public static final String LAST_MODIFIED = "31 December 2003";
    private File[] files;
    private String uploadURL;
    private JProgressBar progress;
    private long totalFilesLength;
    private long uploadedLength;
    private boolean stop = false;
    private StringBuffer sb = new StringBuffer();
    private Exception e = null;

    public FileUploadThreadV2(File[] files, String uploadURL) {
        this.files = files;
        this.uploadURL = uploadURL;
        this.totalFilesLength = 0L;
        for (int i = 0; i < this.files.length; ++i) {
            this.totalFilesLength += this.files[i].length();
        }
    }

    public void setProgressPanel(JProgressBar pgrBar) {
        this.progress = pgrBar;
    }

    public void stopUpload() {
        this.stop = true;
    }

    public StringBuffer getServerOutput() {
        return this.sb;
    }

    public Exception getException() {
        return this.e;
    }

    private StringBuffer getRandomString() {
        StringBuffer sbRan = new StringBuffer(11);
        StringBuffer alphaNum = new StringBuffer();
        alphaNum.append("1234567890abcdefghijklmnopqrstuvwxyz");
        for (int i = 0; i < 11; ++i) {
            int num = (int)(Math.random() * (double)(alphaNum.length() - 1));
            sbRan.append(alphaNum.charAt(num));
        }
        return sbRan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFileStream(File f, DataOutputStream dOut) throws FileNotFoundException, IOException {
        byte[] byteBuff = null;
        FileInputStream fis = null;
        try {
            int numBytes = 0;
            byteBuff = new byte[1024];
            fis = new FileInputStream(f);
            while (-1 != (numBytes = fis.read(byteBuff)) && !this.stop) {
                dOut.write(byteBuff, 0, numBytes);
                this.uploadedLength += (long)numBytes;
                if (null == this.progress) continue;
                this.progress.setValue((int)this.uploadedLength);
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {}
            byteBuff = null;
        }
    }

    private void addServerOutPut(String s) {
        if (0 < this.sb.length() || !s.equals("")) {
            this.sb.append(s);
        }
    }

    private StringBuffer[] setAllHead(File[] fileA, StringBuffer bound) {
        StringBuffer[] sbArray = new StringBuffer[fileA.length];
        for (int i = 0; i < fileA.length; ++i) {
            File file = fileA[i];
            sbArray[i] = new StringBuffer();
            StringBuffer sb = sbArray[i];
            sb.append(bound.toString());
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data; name=\"File");
            sb.append(i);
            sb.append("\"; filename=\"");
            sb.append(file.toString());
            sb.append("\"");
            sb.append("\r\n");
            sb.append("Content-Type: application/octet-stream");
            sb.append("\r\n");
            sb.append("\r\n");
        }
        return sbArray;
    }

    private StringBuffer[] setAllTail(int fileLength, StringBuffer bound) {
        StringBuffer[] sbArray = new StringBuffer[fileLength];
        for (int i = 0; i < fileLength; ++i) {
            sbArray[i] = new StringBuffer("\r\n");
        }
        sbArray[sbArray.length - 1].append(bound.toString());
        sbArray[sbArray.length - 1].append("--\r\n");
        return sbArray;
    }

    private void setHeader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block23: {
            BufferedReader datain;
            FilterOutputStream dataout;
            Socket sock;
            block19: {
                sock = null;
                dataout = null;
                datain = null;
                URL url = new URL(this.uploadURL);
                StringBuffer boundary = new StringBuffer();
                boundary.append("-----------------------------");
                boundary.append(this.getRandomString().toString());
                long contentLength = this.totalFilesLength;
                StringBuffer[] head = this.setAllHead(this.files, boundary);
                StringBuffer[] tail = this.setAllTail(this.files.length, boundary);
                for (int i = 0; i < this.files.length; ++i) {
                    contentLength += (long)head[i].length();
                    contentLength += (long)tail[i].length();
                }
                StringBuffer header = new StringBuffer();
                header.append("POST ");
                header.append(url.getPath());
                header.append("?");
                header.append(url.getQuery());
                header.append(" HTTP/1.1\r\n");
                header.append("Host: ");
                header.append(url.getHost());
                header.append("\r\n");
                header.append("Content-type: multipart/form-data; boundary=");
                header.append(boundary.substring(2, boundary.length()) + "\r\n");
                header.append("Content-length: ");
                header.append(contentLength);
                header.append("\r\n");
                header.append("\r\n");
                sock = new Socket(url.getHost(), -1 == url.getPort() ? 80 : url.getPort());
                dataout = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
                datain = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                this.uploadedLength = 0L;
                if (null != this.progress) {
                    this.progress.setMaximum((int)this.totalFilesLength);
                }
                ((DataOutputStream)dataout).writeBytes(header.toString());
                for (int i = 0; i < this.files.length && !this.stop; ++i) {
                    ((DataOutputStream)dataout).writeBytes(head[i].toString());
                    this.uploadFileStream(this.files[i], (DataOutputStream)dataout);
                    ((DataOutputStream)dataout).writeBytes(tail[i].toString());
                }
                ((DataOutputStream)dataout).flush();
                if (this.stop || null == this.progress) break block19;
                this.progress.setString("Upload complete. PLease wait for server response.");
            }
            Object var13_13 = null;
            try {
                dataout.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            dataout = null;
            try {
                datain.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            datain = null;
            try {
                sock.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            sock = null;
            {
                break block23;
                catch (Exception e) {
                    this.e = e;
                    Object var13_14 = null;
                    try {
                        dataout.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    dataout = null;
                    try {
                        datain.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    datain = null;
                    try {
                        sock.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    sock = null;
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    dataout.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                dataout = null;
                try {
                    datain.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                datain = null;
                try {
                    sock.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                sock = null;
                throw throwable;
            }
        }
    }

    public void close() {
        this.files = null;
        this.e = null;
        this.sb = null;
    }
}

