/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.grizzly.pipeline;

import java.util.List;
import jp.sf.grizzly.pipeline.PipelineException;
import jp.sf.grizzly.pipeline.valve.Valve;
import jp.sf.grizzly.pipeline.valve.ValveContext;
import jp.sf.grizzly.storage.StreamStorage;

public class GrizzlyPipeline {
    protected String name;
    protected Valve[] valves;

    public GrizzlyPipeline(String name, List valveList) throws Exception {
        this.valves = valveList.toArray(new Valve[valveList.size()]);
        this.setName(name);
    }

    public void initialize() throws PipelineException {
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addValve(Valve valve) {
        Valve[] results = new Valve[this.valves.length + 1];
        System.arraycopy(this.valves, 0, results, 0, this.valves.length);
        results[this.valves.length] = valve;
        this.valves = results;
    }

    public synchronized Valve[] getValves() {
        Valve[] results = new Valve[this.valves.length];
        System.arraycopy(this.valves, 0, results, 0, this.valves.length);
        return results;
    }

    public synchronized void removeValve(Valve valve) {
        int index = -1;
        for (int i = 0; i < this.valves.length; ++i) {
            if (valve != this.valves[i]) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        Valve[] results = new Valve[this.valves.length - 1];
        int n = 0;
        for (int i = 0; i < this.valves.length; ++i) {
            if (i == index) continue;
            results[n++] = this.valves[i];
        }
        this.valves = results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(StreamStorage storage) throws PipelineException {
        Invocation invocation;
        GrizzlyPipeline grizzlyPipeline = this;
        synchronized (grizzlyPipeline) {
            invocation = new Invocation(this.valves);
        }
        invocation.invokeNext(storage);
    }

    private static final class Invocation
    implements ValveContext {
        private final Valve[] valves;
        private int at = 0;

        public Invocation(Valve[] valves) {
            this.valves = valves;
        }

        public void invokeNext(StreamStorage storage) throws PipelineException {
            if (this.at < this.valves.length) {
                Valve next = this.valves[this.at];
                ++this.at;
                next.invoke(storage, this);
            }
        }
    }
}

