// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: TestReflectionSample.java 129 2008-06-22 15:02:40Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package usecase.sample;

import jp.sourceforge.*;
import jp.sourceforge.greflect.*;

import java.util.*;
import java.lang.reflect.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: TestReflectionSample.java 129 2008-06-22 15:02:40Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class TestReflectionSample extends GreflectTestCase
{

    public TestReflectionSample(String testName){
        super(testName);
    }

    public void test01_InvokeSample1_Static()
        throws Throwable
    {
        // preparing
        Reflection api = new Reflection();
        Map<Integer,String> map = new HashMap<Integer,String>();

        // put map value
        api.new Invoker<String>(new Param<Map<Integer,String>>(map){}, "put",
                new Param<Integer>(1234){}, new Param<String>("hoge"){})
        {}.invoke();

        // get map value
        String r = api.new Invoker<String>(
                new Param<Map<Integer,String>>(map){}, "get",
                new Param<Integer>(1234){})
        {}.invoke();
        assertEquals("hoge", r);
    }

    public void test01_InvokeSample2_Ungeneric()
        throws Throwable
    {
        // preparing
        Reflection api = new Reflection();
        Object map = new HashMap<Integer,String>(){};

        // put map value
        api.new Invoker<String>(new UngenericParam(map), "put",
                new UngenericParam(1234), new UngenericParam("hoge"))
        {}.invoke();

        // get map value
        String r = api.new Invoker<String>(new UngenericParam(map), "get",
                new UngenericParam(1234))
        {}.invoke();
        assertEquals("hoge", r);
    }

    public void test02_InstantiateSample1_Normal()
        throws Throwable
    {
        // preparing
        Reflection api = new Reflection();
        Param<?> instype = new Param<ArrayList<String>>(){};

        // create ungeneric list
        Object ins = api.new Instantiator<Object>(instype){}.instantiate();

        // get map value
        List<String> list = api.new Caster<List<String>>(ins){}.cast();
        // use list
        for(String s : list){
            assertTrue(false);
        }
        assertTrue(true);
    }

    public void test03_InvokeStaticNoTypeVar_Normal()
        throws Throwable
    {
        // preparing
        Reflection api = new Reflection();
        //  :
        long now1 = System.currentTimeMillis();
        long now2 = api.new Invoker<Long>(new Param<System>(){},
                "currentTimeMillis")
        {}.invoke();
        long now3 = System.currentTimeMillis();

        assertTrue(now1 <= now2);
        assertTrue(now2 <= now3);
    }

    enum MyState {
        SOU, UTSU, FUTSUU
    };

    public void test04_InvokeStaticWithoutTypeParam_Normal()
        throws Throwable
    {
        // preparing
        Reflection api = new Reflection();
        MyState s = MyState.SOU;
        //  :
        s = api.new Invoker<MyState>(new Param<Enum>(){}, "valueOf",
                new Param<Class<MyState>>(MyState.class){}, new Param<String>(
                        "UTSU")
                {})
        {}.invoke();

        assertEquals(MyState.UTSU, s);
    }

}
