// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test02Instantiator_13GeneraringSignature.java 7 2008-05-10 12:03:43Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import jp.sourceforge.greflect.*;
import jp.sourceforge.*;
import java.util.*;
import java.lang.reflect.*;
import java.io.File;

public class Test02Instantiator_13GeneraringSignature extends GreflectTestCase
{
    private TypeConversionStrategy strategy = null;

    public Test02Instantiator_13GeneraringSignature(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        strategy = new DefaultTypeConversionStrategy();
    }

    static class TestCaster<T>
    {
    }

    public void test01_SimpleClass_Normal()
        throws Throwable
    {
        assertEquals("Ljava/io/File;", strategy.getTypeSignatureTo(File.class,
                TypeVarScope.NULL));

    }

    public void test02_Primitive_Error()
        throws Throwable
    {
        try{
            assertEquals("I", strategy.getTypeSignatureTo(int.class,
                    TypeVarScope.NULL));
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertTrue(ex.getMessage().startsWith(
                    "The instanciation of type 'int' is not supported."));
            assertTrue(true);
        }
    }

    public void test03_ParameterizedType_Normal()
        throws Throwable
    {
        Type t = TestCaster.class.getTypeParameters()[0];
        Object o = new TestCaster<HashMap<String,Integer>>(){};
        TypeVarScope s = new ClassTypeVarScope(o.getClass());
        assertEquals(
                "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Integer;>;",
                strategy.getTypeSignatureTo(t, s));

    }

    public void test04_ParameterizedType_Error()
        throws Throwable
    {
        try{
            Type t = TestCaster.class.getTypeParameters()[0];
            TypeVarScope s = TypeVarScope.NULL;
            assertEquals(
                    "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Integer;>;",
                    strategy.getTypeSignatureTo(t, s));
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertTrue(ex
                    .getMessage()
                    .startsWith(
                            "The instanciation fails because type variable 'T' is not resolved. Revise the specitication."));
            assertTrue(true);
        }
    }

    public void test05_ParameterizedTypeNest_Normal()
        throws Throwable
    {
        Type t = TestCaster.class.getTypeParameters()[0];
        Object o = new TestCaster<HashMap<String,List<Integer>>>(){};
        TypeVarScope s = new ClassTypeVarScope(o.getClass());
        assertEquals(
                "Ljava/util/HashMap<Ljava/lang/String;Ljava/util/List<Ljava/lang/Integer;>;>;",
                strategy.getTypeSignatureTo(t, s));

    }

    public void test06_GenericArrayType_Normal()
        throws Throwable
    {
        Type t = TestCaster.class.getTypeParameters()[0];
        Object o = new TestCaster<HashMap<String,Integer>[]>(){};
        TypeVarScope s = new ClassTypeVarScope(o.getClass());
        assertEquals(
                "[Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Integer;>;",
                strategy.getTypeSignatureTo(t, s));

    }

    public void test07_ParameterizedGenericArrayType_Normal()
        throws Throwable
    {
        Type t = TestCaster.class.getTypeParameters()[0];
        Object o = new TestCaster<HashMap<String,Integer[]>>(){};
        TypeVarScope s = new ClassTypeVarScope(o.getClass());
        assertEquals(
                "Ljava/util/HashMap<Ljava/lang/String;[Ljava/lang/Integer;>;",
                strategy.getTypeSignatureTo(t, s));

    }

    public void test08_WildcardType_Normal__Deferred()
        throws Throwable
    {
        Type t = TestCaster.class.getTypeParameters()[0];
        Object o = new TestCaster<HashMap<String,?>>(){};
        TypeVarScope s = new ClassTypeVarScope(o.getClass());
        assertEquals(
                "<V:Ljava/lang/Object;>Ljava/util/HashMap<Ljava/lang/String;TV;>;",
                strategy.getTypeSignatureTo(t, s));

    }

}
