// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test02Instantiator_12LoadingGeneratedClass.java 27 2008-05-21 21:56:24Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import jp.sourceforge.*;
import jp.sourceforge.greflect.GreflectTestCase;

import java.util.*;
import java.lang.reflect.*;
import java.io.File;

public class Test02Instantiator_12LoadingGeneratedClass extends
        GreflectTestCase
{
    private BytecodeGeneratorClassLoader classLoader = null;

    public Test02Instantiator_12LoadingGeneratedClass(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        // load target class
        new ManyAttributeObject(true, (byte) 77, '厄', (short) 7777,
                0.9999999999, 1000000000001L);

        classLoader = new BytecodeGeneratorClassLoader(
                ManyAttributeObject.class.getClassLoader());
    }

    public void test01_SimpleClass_ObjectParam_Error()
        throws Throwable
    {
        Constructor<?> scst = File.class.getConstructor(String.class);
        Constructor<?> cst = classLoader.generateClassAndGetConstructorFor(
                scst, "Ljava/io/File;");
        Object o = cst.newInstance("hogehoge");
        assertEquals(new File("hogehoge"), o);

        assertEquals(File.class, o.getClass());
    }

    public void test02_UngenericClass_NoParam_Normal()
        throws Throwable
    {
        Constructor<?> scst = HashMap.class.getConstructor();
        Constructor<?> cst = classLoader.generateClassAndGetConstructorFor(
                scst,
                "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Integer;>;");
        Class c = cst.newInstance().getClass();

        ParameterizedType st = (ParameterizedType) c.getGenericSuperclass();
        assertEquals(String.class, st.getActualTypeArguments()[0]);
    }

    public void test03_UngenericClass_PrimitiveParam_Normal()
        throws Throwable
    {
        Constructor<?> scst = HashMap.class.getConstructor(int.class,
                float.class);
        Constructor<?> cst = classLoader.generateClassAndGetConstructorFor(
                scst,
                "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Integer;>;");

        HashMap<?,?> o = (HashMap<?,?>) cst.newInstance(7, 0.66f);

        ParameterizedType st = (ParameterizedType) o.getClass()
                .getGenericSuperclass();
        assertEquals(String.class, st.getActualTypeArguments()[0]);
    }

    public void test04_UngenericClass_Twice_Normal()
        throws Throwable
    {
        Constructor<?> scst = HashMap.class.getConstructor(int.class,
                float.class);
        Constructor<?> cst = classLoader.generateClassAndGetConstructorFor(
                scst,
                "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Integer;>;");

        HashMap<?,?> o = (HashMap<?,?>) cst.newInstance(7, 0.66f);

        ParameterizedType st = (ParameterizedType) o.getClass()
                .getGenericSuperclass();
        assertEquals(String.class, st.getActualTypeArguments()[0]);
    }

    /** 'over 4': Switching bytecode instructions from ALOAD_n to ALOAD. */
    public void test05_Over4Param_OtherPrimitiveParam_Normal()
        throws Throwable
    {
        Constructor<?> scst = ManyAttributeObject.class.getConstructor(
                boolean.class, byte.class, char.class, short.class,
                double.class, long.class);
        Constructor<?> cst = classLoader
                .generateClassAndGetConstructorFor(scst,
                        "Ljp/sourceforge/greflect/impl/ManyAttributeObject<Ljava/lang/String;>;");

        Object oo = cst.newInstance(true, (byte) 77, '厄', (short) 7777,
                0.9999999999, 1000000000001L);
        assertEquals("jp.sourceforge.greflect.impl.ManyAttributeObject", oo
                .getClass().getSuperclass().getName());
        assertSame(ManyAttributeObject.class, oo.getClass().getSuperclass());
        ManyAttributeObject<?> o = (ManyAttributeObject<?>) oo;
        assertEquals(true, o.mBoolean);
        assertEquals(77, o.mByte);
        assertEquals('厄', o.mChar);
        assertEquals(7777, o.mShort);
        assertEquals(0.9999999999, o.mDouble);
        assertEquals(1000000000001L, o.mLong);

        ParameterizedType st = (ParameterizedType) o.getClass()
                .getGenericSuperclass();
        assertEquals(String.class, st.getActualTypeArguments()[0]);
    }

    public void test06_ObjectArray_PrimitiveArray_Normal()
        throws Throwable
    {
        Constructor<?> scst = ManyAttributeObject.class.getConstructor(
                String[].class, byte[][].class);
        Constructor<?> cst = classLoader
                .generateClassAndGetConstructorFor(scst,
                        "Ljp/sourceforge/greflect/impl/ManyAttributeObject<Ljava/lang/String;>;");

        String[] p1 = new String[19];
        byte[][] p2 = new byte[13][17];
        Object oo = cst.newInstance(p1, p2);
        assertEquals("jp.sourceforge.greflect.impl.ManyAttributeObject", oo
                .getClass().getSuperclass().getName());
        assertSame(ManyAttributeObject.class, oo.getClass().getSuperclass());
        ManyAttributeObject<?> o = (ManyAttributeObject<?>) oo;
        assertSame(p1, o.mStrings);
        assertSame(p2, o.mBytes);

        ParameterizedType st = (ParameterizedType) o.getClass()
                .getGenericSuperclass();
        assertEquals(String.class, st.getActualTypeArguments()[0]);
    }

}
