// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test02Instantiator_11GeneratingByteCode.java 7 2008-05-10 12:03:43Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import jp.sourceforge.*;
import jp.sourceforge.greflect.GreflectTestCase;

import org.apache.bcel.generic.*;
import org.apache.bcel.classfile.*;
import java.util.*;
import java.lang.reflect.*;
import java.io.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: Test02Instantiator_11GeneratingByteCode.java 7 2008-05-10 12:03:43Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test02Instantiator_11GeneratingByteCode extends GreflectTestCase
{

    static class TestClassLoader extends ClassLoader
    {
        final File dir;

        TestClassLoader(File dir){
            super(Test02Instantiator_11GeneratingByteCode.class
                    .getClassLoader());
            this.dir = dir;
        }

        Class<?> getLoadedClass(String class_name)
            throws IOException
        {
            byte[] buf = new byte[1024];
            File f = new File(dir, convertClassNameToPath(class_name)
                    + ".class");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            InputStream is = new FileInputStream(f);
            try{
                for(;;){
                    int n = is.read(buf, 0, buf.length);
                    if(n < 0) break;
                    os.write(buf, 0, n);
                }
            }finally{
                is.close();
            }
            byte[] bytes = os.toByteArray();
            os.close();

            Class<?> cls = defineClass(class_name, bytes, 0, bytes.length);
            resolveClass(cls);
            return cls;
        }
    }

    public Test02Instantiator_11GeneratingByteCode(String testName){
        super(testName);
    }

    protected boolean needsToWriteFiles(){
        return true;
    }

    private static String convertClassNameToPath(String cname){
        return cname.replace('.', '/');
    }

    public void test01_SimpleClass_ObjectParam_Normal()
        throws Throwable
    {
        Constructor<?> cst = File.class.getConstructor(String.class);
        ClassGen c = BytecodeGeneratorClassLoader.createUngenericClassGen(
                "Test01Generated", cst, "Ljava/io/File;");
        JavaClass jc = c.getJavaClass();
        jc.dump(new File(getTmpDir(), convertClassNameToPath(c.getClassName())
                + ".class"));
        assertTrue(true);

        Class<?> cls = new TestClassLoader(getTmpDir()).getLoadedClass(c
                .getClassName());
        assertTrue(File.class.isAssignableFrom(cls));
        assertEquals(File.class, cls.getSuperclass());
        assertEquals(0, cls.getGenericInterfaces().length);
        assertEquals(0, cls.getTypeParameters().length);
        assertEquals(File.class, cls.getGenericSuperclass());
    }

    public void test02_UngenericClass_NoParam_Normal()
        throws Throwable
    {
        Constructor<?> cst = HashMap.class.getConstructor();
        ClassGen c = BytecodeGeneratorClassLoader.createUngenericClassGen(
                "Test02Generated", cst,
                "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Integer;>;");
        JavaClass jc = c.getJavaClass();
        jc.dump(new File(getTmpDir(), convertClassNameToPath(c.getClassName())
                + ".class"));
        assertTrue(true);

        Class<?> cls = new TestClassLoader(getTmpDir()).getLoadedClass(c
                .getClassName());
        assertTrue(HashMap.class.isAssignableFrom(cls));
        assertEquals(HashMap.class, cls.getSuperclass());
        assertEquals(0, cls.getGenericInterfaces().length);
        assertEquals(0, cls.getTypeParameters().length);
        ParameterizedType pt = (ParameterizedType) cls.getGenericSuperclass();
        assertEquals(HashMap.class, pt.getRawType());
        assertEquals(2, pt.getActualTypeArguments().length);
        assertEquals(String.class, pt.getActualTypeArguments()[0]);
        assertEquals(Integer.class, pt.getActualTypeArguments()[1]);
    }

    public void test03_UngenericClass_PrimitiveParam_Normal()
        throws Throwable
    {
        Constructor<?> cst = HashMap.class.getConstructor(int.class,
                float.class);
        ClassGen c = BytecodeGeneratorClassLoader.createUngenericClassGen(
                "Test03Generated", cst,
                "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Integer;>;");
        JavaClass jc = c.getJavaClass();
        jc.dump(new File(getTmpDir(), convertClassNameToPath(c.getClassName())
                + ".class"));
        assertTrue(true);

        Class<?> cls = new TestClassLoader(getTmpDir()).getLoadedClass(c
                .getClassName());
        assertTrue(HashMap.class.isAssignableFrom(cls));
        assertEquals(HashMap.class, cls.getSuperclass());
        assertEquals(0, cls.getGenericInterfaces().length);
        assertEquals(0, cls.getTypeParameters().length);
        ParameterizedType pt = (ParameterizedType) cls.getGenericSuperclass();
        assertEquals(HashMap.class, pt.getRawType());
        assertEquals(2, pt.getActualTypeArguments().length);
        assertEquals(String.class, pt.getActualTypeArguments()[0]);
        assertEquals(Integer.class, pt.getActualTypeArguments()[1]);
    }

    public void test04_GenericClass_Normal()
        throws Throwable
    {
        Constructor<?> cst = HashMap.class.getConstructor();
        ClassGen c = BytecodeGeneratorClassLoader
                .createUngenericClassGen("Test04Generated", cst,
                        "<X:Ljava/lang/Object;>Ljava/util/HashMap<Ljava/lang/String;TX;>;");
        JavaClass jc = c.getJavaClass();
        jc.dump(new File(getTmpDir(), convertClassNameToPath(c.getClassName())
                + ".class"));
        assertTrue(true);

        Class<?> cls = new TestClassLoader(getTmpDir()).getLoadedClass(c
                .getClassName());
        assertTrue(HashMap.class.isAssignableFrom(cls));
        assertEquals(HashMap.class, cls.getSuperclass());
        assertEquals(0, cls.getGenericInterfaces().length);
        assertEquals(1, cls.getTypeParameters().length);
        assertEquals("X", cls.getTypeParameters()[0].getName());
        ParameterizedType pt = (ParameterizedType) cls.getGenericSuperclass();
        assertEquals(HashMap.class, pt.getRawType());
        assertEquals(2, pt.getActualTypeArguments().length);
        assertEquals(String.class, pt.getActualTypeArguments()[0]);
        assertEquals("X", ((TypeVariable) pt.getActualTypeArguments()[1])
                .getName());
    }

    /** 'over 4': Switching bytecode instructions from ALOAD_n to ALOAD. */
    public void test05_Over4Param_OtherPrimitiveParam_Normal()
        throws Throwable
    {
        Constructor<?> cst = ManyAttributeObject.class.getConstructor(
                boolean.class, byte.class, char.class, short.class,
                double.class, long.class);
        ClassGen c = BytecodeGeneratorClassLoader
                .createUngenericClassGen("Test05Generated", cst,
                        "Ljp/sourceforge/greflect/impl/ManyAttributeObject<Ljava/lang/String;>;");
        JavaClass jc = c.getJavaClass();
        jc.dump(new File(getTmpDir(), convertClassNameToPath(c.getClassName())
                + ".class"));
        assertTrue(true);

        Class<?> cls = new TestClassLoader(getTmpDir()).getLoadedClass(c
                .getClassName());
        assertTrue(ManyAttributeObject.class.isAssignableFrom(cls));
        assertEquals(ManyAttributeObject.class, cls.getSuperclass());
        assertEquals(0, cls.getGenericInterfaces().length);
        assertEquals(0, cls.getTypeParameters().length);
        ParameterizedType pt = (ParameterizedType) cls.getGenericSuperclass();
        assertEquals(ManyAttributeObject.class, pt.getRawType());
        assertEquals(1, pt.getActualTypeArguments().length);
        assertEquals(String.class, pt.getActualTypeArguments()[0]);
    }

    public void test06_ObjectArray_PrimitiveArray_Normal()
        throws Throwable
    {
        Constructor<?> cst = ManyAttributeObject.class.getConstructor(
                String[].class, byte[][].class);
        ClassGen c = BytecodeGeneratorClassLoader
                .createUngenericClassGen("Test06Generated", cst,
                        "LLjp/sourceforge/greflect/impl/ManyAttributeObject<Ljava/lang/String;>;");
        JavaClass jc = c.getJavaClass();
        jc.dump(new File(getTmpDir(), convertClassNameToPath(c.getClassName())
                + ".class"));
        assertTrue(true);
    }

}
