// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test04Caster_03GenericTypeVarInstance.java 122 2008-06-11 14:05:11Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;
import java.util.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test04Caster_03GenericTypeVarInstance.java 122 2008-06-11 14:05:11Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test04Caster_03GenericTypeVarInstance extends GreflectTestCase
{
    Reflection api;

    public Test04Caster_03GenericTypeVarInstance(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    static class GenericClass<I, S>
    {
        I i = null;

        I getI(){
            return i;
        }

        void setI(I i){
            this.i = i;
        }
    }

    public void test00_SameGeneric_Error()
        throws Throwable
    {
        try{
            Object o = new GenericClass<Integer,String>();
            GenericClass<Integer,String> r = api.new Caster<GenericClass<Integer,String>>(
                    o)
            {}.cast();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The type variable 'class jp.sourceforge.greflect.Test04Caster_03GenericTypeVarInstance\\$GenericClass:S' cannot be resolved in the scope 'GenericClass\\{\\}'.*",
                    ex);
        }
    }

    public void test01_WildcardReturn_Error__Deferred()
        throws Throwable
    {
        try{
            Object o = new GenericClass<Integer,String>(){};
            GenericClass<Integer,?> r = api.new Caster<GenericClass<Integer,?>>(
                    o)
            {}.cast();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The instance cannot cast to 'GenericClass<Integer,String>'.*",
                    ex);
        }
    }

}
