// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test04Caster_01NoTypeVarInstance.java 116 2008-06-05 14:13:59Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;
import java.util.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test04Caster_01NoTypeVarInstance.java 116 2008-06-05 14:13:59Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test04Caster_01NoTypeVarInstance extends GreflectTestCase
{
    Reflection api;

    public Test04Caster_01NoTypeVarInstance(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    static class NoTypeVarClass
    {

    }

    private Object createNoTypeVarClass(){
        return new NoTypeVarClass();
    }

    public void test00_NoTypeVar_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        NoTypeVarClass r = api.new Caster<NoTypeVarClass>(o){}.cast();
        assertSame(o, r);
    }

    public void test01_StringParam_Error()
        throws Throwable
    {
        try{
            Object o = new String("hoge");
            NoTypeVarClass r = api.new Caster<NoTypeVarClass>(o){}.cast();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex("The instance cannot cast to 'NoTypeVarClass'.*", ex);
        }
    }

    public void test02_StringReturn_Normal()
        throws Throwable
    {
        Object o = new String("hoge");
        String r = api.new Caster<String>(o){}.cast();
        assertSame(o, r);
    }

    public void test03_StringReturn_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            String r = api.new Caster<String>(o){}.cast();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex("The instance cannot cast to 'String'.*", ex);
        }
    }

}
