// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test03Assignable_04GenericArrayType.java 132 2008-07-02 13:51:18Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;

import java.util.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test03Assignable_04GenericArrayType.java 132 2008-07-02 13:51:18Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test03Assignable_04GenericArrayType extends GreflectTestCase
{

    Reflection api;

    public Test03Assignable_04GenericArrayType(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    public void test00_IntegerArray_Normal()
        throws Throwable
    {
        UngenericParam c1 = new UngenericParam(new Integer[]{new Integer(12)});
        UngenericParam c2 = new UngenericParam(new Integer[0]);
        Param<Integer[]> c3 = new Param<Integer[]>(
                new Integer[]{new Integer(34)})
        {};
        Param<Integer[]> c4 = new Param<Integer[]>(new Integer[0]){};

        assertEquals(true, api.isAssignableFromTo(c1, c2));
        assertEquals(true, api.isAssignableFromTo(c2, c3));
        assertEquals(true, api.isAssignableFromTo(c3, c4));
        assertEquals(true, api.isAssignableFromTo(c4, c1));

    }

    public void test01_IntegerInheritance_Normal()
        throws Throwable
    {
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        UngenericParam c1 = new UngenericParam(new Integer[]{new Integer(12)});
        UngenericParam c2 = new UngenericParam(new Long[]{new Long(23)});
        UngenericParam c3 = new UngenericParam(new Number[]{new Long(23)});
        Param<Integer[]> c4 = new Param<Integer[]>(
                new Integer[]{new Integer(34)})
        {};
        Param<Long[]> c5 = new Param<Long[]>(new Long[]{new Long(34L)}){};
        Param<Number[]> c6 = new Param<Number[]>(new Number[]{new Integer(45)})
        {};
        assertEquals(false, api.isAssignableFromTo(c1, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c1));

        assertEquals(true, api.isAssignableFromTo(c1, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c1));

        assertEquals(true, api.isAssignableFromTo(c2, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c2));

        assertEquals(false, api.isAssignableFromTo(c4, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c4));

        assertEquals(true, api.isAssignableFromTo(c4, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c4));

        assertEquals(true, api.isAssignableFromTo(c5, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c5));

        assertEquals(false, api.isAssignableFromTo(c1, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c1));
        assertEquals(false, api.isAssignableFromTo(c4, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c4));

        assertEquals(true, api.isAssignableFromTo(c1, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c1));
        assertEquals(true, api.isAssignableFromTo(c4, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c4));

        assertEquals(true, api.isAssignableFromTo(c2, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c2));
        assertEquals(true, api.isAssignableFromTo(c5, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c5));
    }

    public void test02_ArrayList_Normal()
        throws Throwable
    {
        UngenericParam c1 = new UngenericParam(new ArrayList<Integer[]>(){});
        UngenericParam c2 = new UngenericParam(new ArrayList<Number[]>(){});
        Param<List<Integer[]>> c4 = new Param<List<Integer[]>>(
                new ArrayList<Integer[]>())
        {};
        Param<List<Number[]>> c5 = new Param<List<Number[]>>(
                new ArrayList<Number[]>())
        {};
        Param<List<Number[]>> c6 = new Param<List<Number[]>>(
                new ArrayList<Number[]>())
        {};

        assertEquals(true, api.isAssignableFromTo(c1, c1));
        assertEquals(false, api.isAssignableFromTo(c2, c1));
        assertEquals(false, api.isAssignableFromTo(c1, c2));

        assertEquals(true, api.isAssignableFromTo(c4, c4));
        assertEquals(false, api.isAssignableFromTo(c4, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c4));
        assertEquals(true, api.isAssignableFromTo(c5, c6));

        assertEquals(false, api.isAssignableFromTo(c1, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c1));

        assertEquals(false, api.isAssignableFromTo(c4, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c4));

    }

    public void test03_ObjectAndArray_Normal()
        throws Throwable
    {
        UngenericParam c1 = new UngenericParam(new Integer[]{new Integer(12)});
        UngenericParam c2 = new UngenericParam(new Object());
        UngenericParam c3 = new UngenericParam("hoge");
        Param<Integer[]> c4 = new Param<Integer[]>(
                new Integer[]{new Integer(34)})
        {};
        Param<Object> c5 = new Param<Object>(new Integer[0]){};
        Param<String> c6 = new Param<String>("hoge"){};

        assertEquals(true, api.isAssignableFromTo(c1, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c1));
        assertEquals(false, api.isAssignableFromTo(c1, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c1));

        assertEquals(true, api.isAssignableFromTo(c4, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c4));
        assertEquals(false, api.isAssignableFromTo(c4, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c4));

        assertEquals(true, api.isAssignableFromTo(c1, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c1));
        assertEquals(false, api.isAssignableFromTo(c1, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c1));

        assertEquals(true, api.isAssignableFromTo(c4, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c4));
        assertEquals(false, api.isAssignableFromTo(c4, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c4));

    }

    public void test04_NestedObjectAndArray_Normal()
        throws Throwable
    {
        UngenericParam c1 = new UngenericParam(
                new Integer[][]{{new Integer(12)},});
        UngenericParam c2 = new UngenericParam(new Object[]{new Integer[0]});
        UngenericParam c3 = new UngenericParam(new String[]{"hoge"});
        Param<Integer[][]> c4 = new Param<Integer[][]>(
                new Integer[][]{{new Integer(34)},})
        {};
        Param<Object[]> c5 = new Param<Object[]>(new Object[]{new Integer[0]}){};
        Param<String[]> c6 = new Param<String[]>(new String[]{"hoge"}){};

        assertEquals(true, api.isAssignableFromTo(c1, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c1));
        assertEquals(false, api.isAssignableFromTo(c1, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c1));

        assertEquals(true, api.isAssignableFromTo(c4, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c4));
        assertEquals(false, api.isAssignableFromTo(c4, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c4));

        assertEquals(true, api.isAssignableFromTo(c1, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c1));
        assertEquals(false, api.isAssignableFromTo(c1, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c1));

        assertEquals(true, api.isAssignableFromTo(c4, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c4));
        assertEquals(false, api.isAssignableFromTo(c4, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c4));

    }

    public void test05_PrimitiveArray_Normal()
        throws Throwable
    {
        UngenericParam c1 = new UngenericParam(new int[]{12});
        UngenericParam c2 = new UngenericParam(new Object());
        UngenericParam c3 = new UngenericParam(new long[]{12L});
        Param<int[]> c4 = new Param<int[]>(new int[]{34}){};
        Param<Object> c5 = new Param<Object>(new Integer[0]){};
        Param<long[]> c6 = new Param<long[]>(new long[]{34L}){};
        Param<int[]> c7 = new Param<int[]>(new int[]{56}){};

        assertEquals(true, api.isAssignableFromTo(c1, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c1));
        assertEquals(true, api.isAssignableFromTo(c1, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c1));

        assertEquals(true, api.isAssignableFromTo(c4, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c4));
        assertEquals(true, api.isAssignableFromTo(c4, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c4));
        assertEquals(true, api.isAssignableFromTo(c4, c7));

        assertEquals(true, api.isAssignableFromTo(c1, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c1));
        assertEquals(true, api.isAssignableFromTo(c1, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c1));

        assertEquals(true, api.isAssignableFromTo(c4, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c4));
        assertEquals(true, api.isAssignableFromTo(c4, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c4));

    }

    public void test06_NestedPrimitiveArray_Normal()
        throws Throwable
    {
        UngenericParam c1 = new UngenericParam(new int[][]{{12},});
        UngenericParam c2 = new UngenericParam(new Object[0]);
        UngenericParam c3 = new UngenericParam(new long[][]{{12L},});
        Param<int[][]> c4 = new Param<int[][]>(new int[][]{{34},}){};
        Param<Object[]> c5 = new Param<Object[]>(new Integer[2][3]){};
        Param<long[][]> c6 = new Param<long[][]>(new long[][]{{34L},}){};
        Param<int[][]> c7 = new Param<int[][]>(new int[][]{{56},}){};

        assertEquals(true, api.isAssignableFromTo(c1, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c1));
        assertEquals(true, api.isAssignableFromTo(c1, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c1));

        assertEquals(true, api.isAssignableFromTo(c4, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c4));
        assertEquals(true, api.isAssignableFromTo(c4, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c4));
        assertEquals(true, api.isAssignableFromTo(c4, c7));

        assertEquals(true, api.isAssignableFromTo(c1, c5));
        assertEquals(false, api.isAssignableFromTo(c5, c1));
        assertEquals(true, api.isAssignableFromTo(c1, c6));
        assertEquals(false, api.isAssignableFromTo(c6, c1));

        assertEquals(true, api.isAssignableFromTo(c4, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c4));
        assertEquals(true, api.isAssignableFromTo(c4, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c4));

    }

}
