// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test03Assignable_01UngenericTypeVarInstances.java 130 2008-07-02 13:23:39Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;
import java.util.*;
import java.lang.reflect.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test03Assignable_01UngenericTypeVarInstances.java 130 2008-07-02 13:23:39Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test03Assignable_01UngenericTypeVarInstances extends
        GreflectTestCase
{

    Reflection api;

    public Test03Assignable_01UngenericTypeVarInstances(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    static class TestTypeHolder<T>
    {
    }

    public void test00_Integer_Normal()
        throws Throwable
    {
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        UngenericParam c1 = new UngenericParam(new Integer(12));
        UngenericParam c2 = new UngenericParam(new Integer(23));
        Param<Integer> c3 = new Param<Integer>(new Integer(34)){};
        Param<Integer> c4 = new Param<Integer>(new Integer(45)){};

        assertEquals(true, api.isAssignableFromTo(c1, c2));
        assertEquals(true, api.isAssignableFromTo(c2, c3));
        assertEquals(true, api.isAssignableFromTo(c3, c4));
        assertEquals(true, api.isAssignableFromTo(c4, c1));

    }

    public void test01_IntegerInheritance_Normal()
        throws Throwable
    {
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        UngenericParam c1 = new UngenericParam(new Integer(12));
        UngenericParam c2 = new UngenericParam(new Long(23));
        Param<Integer> c3 = new Param<Integer>(new Integer(34)){};
        Param<Number> c4 = new Param<Number>(new Integer(45)){};
        assertEquals(false, api.isAssignableFromTo(c1, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c1));

        assertEquals(true, api.isAssignableFromTo(c3, c4));
        assertEquals(false, api.isAssignableFromTo(c4, c3));

        assertEquals(true, api.isAssignableFromTo(c1, c4));
        assertEquals(false, api.isAssignableFromTo(c4, c1));

        assertEquals(false, api.isAssignableFromTo(c3, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c3));

    }

    public void test02_List0_Normal()
        throws Throwable
    {
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        Param<List<Integer>> c1 = new Param<List<Integer>>(
                new ArrayList<Integer>())
        {};
        Param<List<String>> c2 = new Param<List<String>>(
                new ArrayList<String>())
        {};

        assertEquals(true, api.isAssignableFromTo(c1, c1));

        assertEquals(false, api.isAssignableFromTo(c1, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c1));

    }

    public void test03_List2Inheritance_Normal()
        throws Throwable
    {
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        UngenericParam c1 = new UngenericParam(new ArrayList<Integer>(){});
        Param<List<Integer>> c2 = new Param<List<Integer>>(
                new ArrayList<Integer>())
        {};
        Param<AbstractCollection<Integer>> c3 = new Param<AbstractCollection<Integer>>(
                new ArrayList<Integer>())
        {};
        Param<Collection<Integer>> c4 = new Param<Collection<Integer>>(
                new ArrayList<Integer>())
        {};

        assertEquals(true, api.isAssignableFromTo(c1, c2));
        assertEquals(false, api.isAssignableFromTo(c2, c1));

        assertEquals(true, api.isAssignableFromTo(c1, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c1));

        assertEquals(false, api.isAssignableFromTo(c2, c3));
        assertEquals(false, api.isAssignableFromTo(c3, c2));

        assertEquals(true, api.isAssignableFromTo(c2, c4));
        assertEquals(false, api.isAssignableFromTo(c4, c2));

    }

}
