// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test02Instantiator_02UngenericTypeVarInstance.java 115 2008-06-05 13:50:20Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;
import java.util.*;
import java.lang.reflect.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test02Instantiator_02UngenericTypeVarInstance.java 115 2008-06-05 13:50:20Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test02Instantiator_02UngenericTypeVarInstance extends
        GreflectTestCase
{

    Reflection api;

    public Test02Instantiator_02UngenericTypeVarInstance(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    static class TestTypeHolder<T>
    {
    }

    public static class GenericClass<I, S>
    {
        I field01 = null;

        S field02 = null;

        S field03 = null;

        public GenericClass(I p){
            field01 = p;
        }

        public GenericClass(List<List<S>> p){
            field02 = p.get(0).get(0);
        }

        public GenericClass(Iterator<S> p){
            field03 = p.next();
        }

        public GenericClass(Map<I,S> p1, Map<S,I> p2){
            field01 = p2.get("hoge");
            field02 = p1.get(1234);
        }

        public I func01(){
            return field01;
        }

        public S func02(){
            return field02;
        }

        public S func03(){
            return field03;
        }

    }

    public void test00_TypeVarInteger0_Normal()
        throws Throwable
    {
        //Object o = new TestTypeHolder<GenericClass<Integer,String>>(){};
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        //Constructor<?> cst = GenericClass.class.getConstructor(Object.class); // not Integer
        Param<Integer> p1 = new Param<Integer>(1234567){};
        GenericClass<?,?> r = api.new Instantiator<GenericClass<Integer,String>>(
                new Param<GenericClass<Integer,String>>(){}, p1)
        {}.instantiate();
        assertTrue(!GenericClass.class.equals(r.getClass()));
        assertEquals(1234567, r.field01);

        int r2 = api.new Invoker<Integer>(new UngenericParam(r), "func01"){}
                .invoke();
        assertEquals(1234567, r2);
    }

    public void test00_TypeVarInteger1_ParamConstructor_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<GenericClass<Integer,String>>(){};
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = HashMap.class.getConstructor(int.class); // illegal
            Param<Integer> p1 = new Param<Integer>(1234567){};
            GenericClass<?,?> r = api.new Instantiator<GenericClass<Integer,String>>(
                    new Param<HashMap<Integer,String>>(){}, p1)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'GenericClass<Integer,String>' is not suitable to set the created object of 'HashMap<K=Integer,V=String>'.*",
                    ex);
        }
    }

    public void test00_TypeVarInteger2_ParamTypeVar_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<GenericClass<Integer,String>>(){};
            //TypeVariable tv = GenericClass.class.getTypeParameters()[0]; //illegal
            //Constructor<?> cst = GenericClass.class
            //        .getConstructor(Object.class);
            Param<Integer> p1 = new Param<Integer>(1234567){};
            Integer r = api.new Instantiator<Integer>(
                    new Param<GenericClass<Integer,String>>(){}, p1)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'Integer' is not suitable to set the created object of 'GenericClass<I=Integer,S=String>'.*",
                    ex);
        }
    }

    public void test00_TypeVarInteger3_ParamUngeneric_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<GenericClass<Integer,String>>(); // illegal
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = GenericClass.class
            //        .getConstructor(Object.class); // not Integer
            Param<Integer> p1 = new Param<Integer>(1234567){};
            GenericClass<Integer,?> r = api.new Instantiator<GenericClass<Integer,?>>(
                    new Param<GenericClass<Integer,?>>(){}, p1)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
            //"The type variable 'class .*TestTypeHolder:T' cannot be resolved in the scope .*",
                    "The instanciation of type '\\?' is not supported.*", ex);
        }
    }

    public void test00_TypeVarInteger4_ArgumentType_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<GenericClass<Integer,String>>(){};
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = GenericClass.class
            //        .getConstructor(Object.class); // not Integer
            Param<String> p1 = new Param<String>("hoge"){}; // illgal
            GenericClass<?,?> r = api.new Instantiator<GenericClass<Integer,String>>(
                    new Param<GenericClass<Integer,String>>(){}, p1)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'String' is not applicable for the param0 type 'Integer' of the constructor .*",
                    ex);
        }
    }

    public void test00_TypeVarInteger5_ArgumentNestedList_Normal()
        throws Throwable
    {
        //Object o = new TestTypeHolder<GenericClass<String,Integer>>(){};
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        //Constructor<?> cst = GenericClass.class.getConstructor(List.class);
        List<Integer> l = new ArrayList<Integer>();
        l.add(54321);
        List<List<Integer>> l2 = new ArrayList<List<Integer>>();
        l2.add(l);
        Param<List<List<Integer>>> p1 = new Param<List<List<Integer>>>(l2){};
        GenericClass<?,?> r = api.new Instantiator<GenericClass<String,Integer>>(
                new Param<GenericClass<String,Integer>>(){}, p1)
        {}.instantiate();
        assertTrue(!GenericClass.class.equals(r.getClass()));
        assertEquals(54321, r.field02);

        int r2 = api.new Invoker<Integer>(new UngenericParam(r), "func02"){}
                .invoke();
        assertEquals(54321, r2);
    }

    public void test00_TypeVarInteger6_ArgumentNestedList_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<GenericClass<String,Integer>>(){};
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = GenericClass.class.getConstructor(List.class);
            List<String> l = new ArrayList<String>(); // illegal
            l.add("hoge");
            List<List<String>> l2 = new ArrayList<List<String>>();
            l2.add(l);
            Param<List<List<String>>> p1 = new Param<List<List<String>>>(l2){};
            GenericClass<?,?> r = api.new Instantiator<GenericClass<String,Integer>>(
                    new Param<GenericClass<String,Integer>>(){}, p1)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'List<List<String>>' is not applicable for the param0 type 'List<List<Integer>>' of the constructor .*",
                    ex);
        }
    }

    public void test00_TypeVarInteger7_ArgumentMap_Normal()
        throws Throwable
    {
        //Object o = new TestTypeHolder<GenericClass<Integer,String>>(){};
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        //Constructor<?> cst = GenericClass.class.getConstructor(Map.class,
        //        Map.class);
        Map<Integer,String> m1 = new HashMap<Integer,String>();
        m1.put(1234, "hogeratta");
        Map<String,Integer> m2 = new HashMap<String,Integer>();
        m2.put("hoge", 345);
        Param<Map<Integer,String>> p1 = new Param<Map<Integer,String>>(m1){};
        Param<Map<String,Integer>> p2 = new Param<Map<String,Integer>>(m2){};
        GenericClass<?,?> r = api.new Instantiator<GenericClass<Integer,String>>(
                new Param<GenericClass<Integer,String>>(){}, p1, p2)
        {}.instantiate();
        assertTrue(!GenericClass.class.equals(r.getClass()));
        assertEquals(345, r.field01);
        assertEquals("hogeratta", r.field02);

        int r2 = api.new Invoker<Integer>(new UngenericParam(r), "func01"){}
                .invoke();
        assertEquals(345, r2);
        String r3 = api.new Invoker<String>(new UngenericParam(r), "func02"){}
                .invoke();
        assertEquals("hogeratta", r3);
    }

    public void test00_TypeVarInteger8_ArgumentMapType1_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<GenericClass<Integer,String>>(){};
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = GenericClass.class.getConstructor(Map.class,
            //        Map.class);
            Map<String,String> m1 = new HashMap<String,String>(); // illegal
            m1.put("hoge", "hogeratta");
            Map<String,Integer> m2 = new HashMap<String,Integer>();
            m2.put("hoge", 345);
            Param<Map<String,String>> p1 = new Param<Map<String,String>>(m1){};
            Param<Map<String,Integer>> p2 = new Param<Map<String,Integer>>(m2){};
            GenericClass<?,?> r = api.new Instantiator<GenericClass<Integer,String>>(
                    new Param<GenericClass<Integer,String>>(){}, p1, p2)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'Map<String,String>' is not applicable for the param0 type 'Map<Integer,String>' of the constructor .*",
                    ex);
        }
    }

    public void test00_TypeVarInteger8_ArgumentMapType2_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<GenericClass<Integer,String>>(){};
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = GenericClass.class.getConstructor(Map.class,
            //        Map.class);
            Map<Integer,String> m1 = new HashMap<Integer,String>();
            m1.put(1234, "hogeratta");
            Map<String,String> m2 = new HashMap<String,String>(); // illegal
            m2.put("hoge", "foo");
            Param<Map<Integer,String>> p1 = new Param<Map<Integer,String>>(m1){};
            Param<Map<String,String>> p2 = new Param<Map<String,String>>(m2){};
            GenericClass<?,?> r = api.new Instantiator<GenericClass<Integer,String>>(
                    new Param<GenericClass<Integer,String>>(){}, p1, p2)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'Map<String,String>' is not applicable for the param1 type 'Map<String,Integer>' of the constructor .*",
                    ex);
        }
    }

    public void test01_TypeVarNestedList0_Normal()
        throws Throwable
    {
        List<List<String>> l1 = new ArrayList<List<String>>();
        Param<List<List<String>>> p1 = new Param<List<List<String>>>(l1){};
        GenericClass<?,?> r = api.new Instantiator<GenericClass<List<List<Integer>>,String>>(
                new Param<GenericClass<List<List<Integer>>,String>>(){}, p1)
        {}.instantiate();
        assertTrue(!GenericClass.class.equals(r.getClass()));
        assertSame(l1, r.field01);

        List<List<Integer>> r2 = api.new Invoker<List<List<Integer>>>(
                new UngenericParam(r), "func01")
        {}.invoke();
        assertSame(l1, r2);
    }

    public void test01_TypeVarNestedList0_Error()
        throws Throwable
    {
        try{
            List<List<Integer>> l1 = new ArrayList<List<Integer>>();
            Param<List<List<Integer>>> p1 = new Param<List<List<Integer>>>(l1){};
            GenericClass<?,?> r = api.new Instantiator<GenericClass<List<List<Integer>>,String>>(
                    new Param<GenericClass<List<List<Integer>>,String>>(){}, p1)
            {}.instantiate();
            assertTrue(!GenericClass.class.equals(r.getClass()));
            assertSame(l1, r.field01);

            List<List<Integer>> r2 = api.new Invoker<List<List<Integer>>>(
                    new UngenericParam(r), "func01")
            {}.invoke();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'List<List<Integer>>' is not applicable for the param0 type 'List<List<String>>' of the constructor .*",
                    ex);
        }
    }

    public void test02_TypeVarMap0_Normal()
        throws Throwable
    {
        //Object o = new TestTypeHolder<GenericClass<Map<Integer,String>,String>>()
        //{};
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        //Constructor<?> cst = GenericClass.class.getConstructor(Object.class); // not List
        Map<Integer,String> m1 = new HashMap<Integer,String>();
        Param<Map<Integer,String>> p1 = new Param<Map<Integer,String>>(m1){};
        GenericClass<?,?> r = api.new Instantiator<GenericClass<Map<Integer,String>,String>>(
                new Param<GenericClass<Map<Integer,String>,String>>(){}, p1)
        {}.instantiate();
        assertTrue(!GenericClass.class.equals(r.getClass()));
        assertSame(m1, r.field01);

        Map<Integer,String> r2 = api.new Invoker<Map<Integer,String>>(
                new UngenericParam(r), "func01")
        {}.invoke();
        assertSame(m1, r2);
    }

}
