// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test02Instantiator_01NoTypeVarInstance.java 44 2008-05-23 22:01:32Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;
import java.util.*;
import java.lang.reflect.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test02Instantiator_01NoTypeVarInstance.java 44 2008-05-23 22:01:32Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test02Instantiator_01NoTypeVarInstance extends GreflectTestCase
{

    Reflection api;

    public Test02Instantiator_01NoTypeVarInstance(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    static class TestTypeHolder<T>
    {
    }

    public static class NoTypeVarClass
    {
        Integer field01 = null;

        String field02 = null;

        String field03 = null;

        public NoTypeVarClass(Integer p){
            field01 = p;
        }

        public NoTypeVarClass(List<List<String>> p){
            field02 = p.get(0).get(0);
        }

        public NoTypeVarClass(Iterator<String> p){
            field03 = p.next();
        }

        public NoTypeVarClass(Map<Integer,String> p1, Map<String,Integer> p2){
            field01 = p2.get("hoge");
            field02 = p1.get(1234);
        }

        public Integer func01(){
            return field01;
        }

        public String func02(){
            return field02;
        }

        public String func03(){
            return field03;
        }

    }

    public void test00_TypeVarInteger0_Normal()
        throws Throwable
    {
        //Object o = new TestTypeHolder<NoTypeVarClass>(){};
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        //Constructor<?> cst = NoTypeVarClass.class.getConstructor(Integer.class);
        Param<Integer> p1 = new Param<Integer>(1234567){};
        NoTypeVarClass r = api.new Instantiator<NoTypeVarClass>(
                new Param<NoTypeVarClass>(){}, p1)
        {}.instantiate();
        assertEquals(NoTypeVarClass.class, r.getClass());
        assertEquals(1234567, r.field01.intValue());

        int r2 = api.new Invoker<Integer>(new UngenericParam(r), "func01"){}
                .invoke();
        assertEquals(1234567, r2);
    }

    public void test00_TypeVarInteger1_ParamConstructor_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<NoTypeVarClass>(){};
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = ArrayList.class.getConstructor(int.class); // illegal
            Param<Integer> p1 = new Param<Integer>(1234567){};
            NoTypeVarClass r = api.new Instantiator<NoTypeVarClass>(
                    new Param<ArrayList<Integer>>(){}, p1)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'NoTypeVarClass' is not suitable to set the created object of 'ArrayList<E=Integer>'.*",
                    ex);
        }
    }

    public void test00_TypeVarInteger2_ParamTypeVar_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<NoTypeVarClass>(){};
            //TypeVariable tv = List.class.getTypeParameters()[0]; //illegal
            //Constructor<?> cst = NoTypeVarClass.class
            //        .getConstructor(Integer.class);
            Param<Integer> p1 = new Param<Integer>(1234567){};
            Integer r = api.new Instantiator<Integer>(
                    new Param<NoTypeVarClass>(){}, p1)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    //"The type variable '.*List:E' cannot be resolved in the scope .*",
                    //"The specified type 'Integer' is not declaring the constructor '.*'.*",
                    //"The type variable 'class jp.sourceforge.greflect.Param:T' cannot be resolved .*",
                    "The specified type 'Integer' is not suitable to set the created object of 'NoTypeVarClass'.*",
                    ex);
        }
    }

    public void test00_TypeVarInteger3_ParamUngeneric_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<NoTypeVarClass>(); // illegal
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = ArrayList.class.getConstructor(int.class); // not Integer
            Param<Integer> p1 = new Param<Integer>(1234567){};
            List r = api.new Instantiator<List>(new Param<ArrayList>(){}, p1){}
                    .instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    //"The type variable '.*TestTypeHolder:T' cannot be resolved in the scope .*",
                    "The type variable 'class java.util.ArrayList:E' cannot be resolved in the scope '.*'.*",
                    ex);
        }
    }

    public void test00_TypeVarInteger4_ArgumentType_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<NoTypeVarClass>(){};
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = NoTypeVarClass.class
            //        .getConstructor(Integer.class); // not Integer
            Param<String> p1 = new Param<String>("hoge"){}; // illgal
            NoTypeVarClass r = api.new Instantiator<NoTypeVarClass>(
                    new Param<NoTypeVarClass>(){}, p1)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(NoSuchMethodException ex){
            assertRegex(
                    "There is no suitable method to class jp.sourceforge.greflect.Test02Instantiator_01NoTypeVarInstance.NoTypeVarClass <init>.java.lang.String..*",
                    ex);
        }
    }

    public void test00_TypeVarInteger5_ArgumentNestedList_Normal()
        throws Throwable
    {
        //Object o = new TestTypeHolder<NoTypeVarClass>(){};
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        //Constructor<?> cst = NoTypeVarClass.class.getConstructor(List.class);
        List<String> l = new ArrayList<String>();
        l.add("hoge");
        List<List<String>> l2 = new ArrayList<List<String>>();
        l2.add(l);
        Param<List<List<String>>> p1 = new Param<List<List<String>>>(l2){};
        NoTypeVarClass r = api.new Instantiator<NoTypeVarClass>(
                new Param<NoTypeVarClass>(){}, p1)
        {}.instantiate();
        assertEquals(NoTypeVarClass.class, r.getClass());
        assertEquals("hoge", r.field02);

        String r2 = api.new Invoker<String>(new UngenericParam(r), "func02"){}
                .invoke();
        assertEquals("hoge", r2);
    }

    public void test00_TypeVarInteger6_ArgumentNestedList_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<NoTypeVarClass>(){};
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = NoTypeVarClass.class
            //        .getConstructor(List.class);
            List<Integer> l = new ArrayList<Integer>(); // illegal
            l.add(54321);
            List<List<Integer>> l2 = new ArrayList<List<Integer>>();
            l2.add(l);
            Param<List<List<Integer>>> p1 = new Param<List<List<Integer>>>(l2){};
            NoTypeVarClass r = api.new Instantiator<NoTypeVarClass>(
                    new Param<NoTypeVarClass>(){}, p1)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'List<List<Integer>>' is not applicable for the param0 type 'List<List<String>>' of the constructor .*",
                    ex);
        }
    }

    public void test00_TypeVarInteger7_ArgumentMap_Normal()
        throws Throwable
    {
        //Object o = new TestTypeHolder<NoTypeVarClass>(){};
        //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
        //Constructor<?> cst = NoTypeVarClass.class.getConstructor(Map.class,
        //        Map.class); // not Integer
        Map<Integer,String> m1 = new HashMap<Integer,String>();
        m1.put(1234, "hogeratta");
        Map<String,Integer> m2 = new HashMap<String,Integer>();
        m2.put("hoge", 345);
        Param<Map<Integer,String>> p1 = new Param<Map<Integer,String>>(m1){};
        Param<Map<String,Integer>> p2 = new Param<Map<String,Integer>>(m2){};
        NoTypeVarClass r = api.new Instantiator<NoTypeVarClass>(
                new Param<NoTypeVarClass>(){}, p1, p2)
        {}.instantiate();
        assertEquals(345, r.field01.intValue());
        assertEquals("hogeratta", r.field02);

        int r2 = api.new Invoker<Integer>(new UngenericParam(r), "func01"){}
                .invoke();
        assertEquals(345, r2);
        String r3 = api.new Invoker<String>(new UngenericParam(r), "func02"){}
                .invoke();
        assertEquals("hogeratta", r3);
    }

    public void test00_TypeVarInteger8_ArgumentMapType1_Error()
        throws Throwable
    {
        try{
            //Object o = new TestTypeHolder<NoTypeVarClass>(){};
            //TypeVariable tv = TestTypeHolder.class.getTypeParameters()[0];
            //Constructor<?> cst = NoTypeVarClass.class.getConstructor(Map.class,
            //        Map.class);
            Map<String,String> m1 = new HashMap<String,String>(); // illegal
            m1.put("hoge", "hogeratta");
            Map<String,Integer> m2 = new HashMap<String,Integer>();
            m2.put("hoge", 345);
            Param<Map<String,String>> p1 = new Param<Map<String,String>>(m1){};
            Param<Map<String,Integer>> p2 = new Param<Map<String,Integer>>(m2){};
            NoTypeVarClass r = api.new Instantiator<NoTypeVarClass>(
                    new Param<NoTypeVarClass>(){}, p1, p2)
            {}.instantiate();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'Map<String,String>' is not applicable for the param0 type 'Map<Integer,String>' of the constructor .*",
                    ex);
        }
    }

}
