// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test01Invoker_41StaticMethod.java 124 2008-06-21 10:36:57Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;

//import java.util.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test01Invoker_41StaticMethod.java 124 2008-06-21 10:36:57Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test01Invoker_41StaticMethod extends GreflectTestCase
{

    Reflection api;

    public Test01Invoker_41StaticMethod(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    public void test00_NoTypeVar_Normal()
        throws Throwable
    {
        // preparing
        Reflection api = new Reflection();

        //  :
        long now1 = System.currentTimeMillis();
        long now2 = api.new Invoker<Long>(new Param<System>(){},
                "currentTimeMillis")
        {}.invoke();
        long now3 = System.currentTimeMillis();

        assertTrue(now1 <= now2);
        assertTrue(now2 <= now3);
    }

    enum MyState {
        SOU, UTSU, FUTSUU
    };

    public void test01_InvokeStaticWithoutTypeParam_Normal__Deferred()
        throws Throwable
    {
        // preparing
        Reflection api = new Reflection();
        MyState s = MyState.SOU;
        //  :
        s = api.new Invoker<MyState>(new Param<Enum>(){}, "valueOf",
                new Param<Class<MyState>>(MyState.class){}, new Param<String>(
                        "UTSU")
                {})
        {}.invoke();

        assertEquals(MyState.UTSU, s);
    }

    public void test02_InvokeStaticWithTypeparam_Error()
        throws Throwable
    {
        try{
            // preparing
            Reflection api = new Reflection();
            MyState s = MyState.SOU;
            //  :
            s = api.new Invoker<MyState>(new Param<Enum<MyState>>(){},
                    "valueOf", new Param<Class<MyState>>(MyState.class){},
                    new Param<String>("UTSU"){})
            {}.invoke();
            assertTrue(false);
        }catch(IllegalAccessException ex){
            assertRegex(
                    "The class that declare the static method must be specified without type variables. Revise the specification.*",
                    ex);
        }
    }

}
