// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test01Invoker_21InvokeFromUngenericObject.java 44 2008-05-23 22:01:32Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;
import java.util.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test01Invoker_21InvokeFromUngenericObject.java 44 2008-05-23 22:01:32Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test01Invoker_21InvokeFromUngenericObject extends GreflectTestCase
{

    public Test01Invoker_21InvokeFromUngenericObject(String testName){
        super(testName);
    }

    static class GenericClass<I, S>
    {
        public I func00(I p){
            return p;
        }

        public List<S> func01(List<List<S>> p){
            List<S> r = new ArrayList<S>();
            r.add(p.get(0).get(0));
            return r;
        }

        public List<List<S>> func02(List<S> p){
            List<List<S>> r = new ArrayList<List<S>>();
            r.add(p);
            return r;
        }

        public Map<I,I> func03(Map<I,S> p1, Map<S,I> p2){
            Map<I,I> map = new HashMap<I,I>();
            for(I k : p1.keySet()){
                map.put(k, p2.get(p1.get(k)));
            }
            return map;
        }

    }

    static class GenericInvoker<P, R>
    {
        R invoke(P param)
            throws Throwable
        {
            Reflection api = new Reflection();
            Object o = new GenericClass<Integer,String>(){};
            Param<P> p1 = new Param<P>(param){};
            R r = api.new Invoker<R>(new UngenericParam(o), "func00", p1){}
                    .invoke();
            return r;
        }
    }

    public void test00_Integer_Normal__Deferred()
        throws Throwable
    {
        GenericInvoker<Integer,?> v = new GenericInvoker<Integer,Integer>(){};
        Object r = v.invoke(new Integer(1234567));
        assertTrue(new Integer(1234567).equals(r));
    }

    public void test00_IntegerParam_Error__Deferred()
        throws Throwable
    {
        try{
            GenericInvoker<Integer,?> v = new GenericInvoker<Integer,String>(){};
            Object r = v.invoke(new Integer(1234567));
            doNothing(r);
            assertTrue(false);
        }catch(NoSuchMethodException ex){
            assertTrue(ex
                    .getMessage()
                    .startsWith(
                            "The specified type 'String' is not applicable for the param1 type 'Integer' of the method "));
        }
    }

}
