// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test01Invoker_11WildcardCapture.java 132 2008-07-02 13:51:18Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;

import java.util.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test01Invoker_11WildcardCapture.java 132 2008-07-02 13:51:18Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test01Invoker_11WildcardCapture extends GreflectTestCase
{
    Reflection api;

    public Test01Invoker_11WildcardCapture(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    static class NoTypeVarClass
    {
        public <T> T func00(T arg){
            return arg;
        }

        public <T> T func01(List<T> arg){
            return arg.get(0);
        }

        public <T> List<T> func02(List<T> arg){
            return arg;
        }

        public <T, U> Map<T,U> func03(Map<T,U> arg){
            return arg;
        }

        public <T extends Number> T func10(T arg){
            return arg;
        }

        public <T extends Number> List<T> func11(List<T> arg){
            return arg;
        }

    }

    private Object createNoTypeVarClass(){
        return new NoTypeVarClass();
    }

    public void test00_ParamToReturn_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<String> p1 = new Param<String>("00"){};
        String r = api.new Invoker<String>(new UngenericParam(o), "func00", p1)
        {}.invoke();
        assertTrue("00".equals(r));
    }

    public void test00_ParamToReturn_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            Param<String> p1 = new Param<String>("00"){};
            Integer r = api.new Invoker<Integer>(new UngenericParam(o),
                    "func00", p1)
            {}.invoke();
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'Integer' is not applicable for the return type 'T' of the method.*",
                    ex);
        }
    }

    public void test01_ListParamToReturn_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        List<String> l = new ArrayList<String>();
        l.add("01");
        Param<List<String>> p1 = new Param<List<String>>(l){};
        String r = api.new Invoker<String>(new UngenericParam(o), "func01", p1)
        {}.invoke();
        assertTrue("01".equals(r));
    }

    public void test01_ListParamToReturn_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            List<String> l = new ArrayList<String>();
            l.add("01");
            Param<List<String>> p1 = new Param<List<String>>(l){};
            Integer r = api.new Invoker<Integer>(new UngenericParam(o),
                    "func01", p1)
            {}.invoke();
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'Integer' is not applicable for the return type 'T' of the method.*",
                    ex);
        }
    }

    public void test02_ListParamToListReturn_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        List<String> l = new ArrayList<String>();
        l.add("02");
        Param<List<String>> p1 = new Param<List<String>>(l){};
        List<String> r = api.new Invoker<List<String>>(new UngenericParam(o),
                "func02", p1)
        {}.invoke();
        assertTrue("02".equals(r.get(0)));
    }

    public void test02_ListParamToListReturn_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            List<String> l = new ArrayList<String>();
            l.add("02");
            Param<List<String>> p1 = new Param<List<String>>(l){};
            List<Integer> r = api.new Invoker<List<Integer>>(
                    new UngenericParam(o), "func02", p1)
            {}.invoke();
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'List<Integer>' is not applicable for the return type 'List<T>' of the method.*",
                    ex);
        }
    }

    public void test03_MapParamToMapReturn_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Map<Integer,String> m = new HashMap<Integer,String>();
        m.put(3, "03");
        Param<Map<Integer,String>> p1 = new Param<Map<Integer,String>>(m){};
        Map<Integer,String> r = api.new Invoker<Map<Integer,String>>(
                new UngenericParam(o), "func03", p1)
        {}.invoke();
        assertTrue("03".equals(r.get(3)));
    }

    public void test03_MapParamToMapReturn1_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            Map<Integer,String> m = new HashMap<Integer,String>();
            m.put(3, "03");
            Param<Map<Integer,String>> p1 = new Param<Map<Integer,String>>(m){};
            Map<String,String> r = api.new Invoker<Map<String,String>>(
                    new UngenericParam(o), "func03", p1)
            {}.invoke();
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'Map<String,String>' is not applicable for the return type 'Map<T,U>' of the method.*",
                    ex);
        }
    }

    public void test03_MapParamToMapReturn2_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            Map<Integer,String> m = new HashMap<Integer,String>();
            m.put(3, "03");
            Param<Map<Integer,String>> p1 = new Param<Map<Integer,String>>(m){};
            Map<Integer,Integer> r = api.new Invoker<Map<Integer,Integer>>(
                    new UngenericParam(o), "func03", p1)
            {}.invoke();
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertRegex(
                    "The specified type 'Map<Integer,Integer>' is not applicable for the return type 'Map<T,U>' of the method.*",
                    ex);
        }
    }

    public void test10_ExtendsParamToReturn_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Integer> p1 = new Param<Integer>(10){};
        int r = api.new Invoker<Integer>(new UngenericParam(o), "func10", p1){}
                .invoke();
        assertTrue(10 == r);
    }

    public void test10_ExtendsParamToReturn_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            Param<String> p1 = new Param<String>("10"){};
            String r = api.new Invoker<String>(new UngenericParam(o), "func10",
                    p1)
            {}.invoke();
            assertTrue(false);
        }catch(NoSuchMethodException ex){
            assertRegex("There is no suitable method to .*", ex);
        }
    }

    public void test11_ExtendsListParamToListReturn_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        List<Integer> l = new ArrayList<Integer>();
        l.add(11);
        Param<List<Integer>> p1 = new Param<List<Integer>>(l){};
        List<Integer> r = api.new Invoker<List<Integer>>(new UngenericParam(o),
                "func11", p1)
        {}.invoke();
        assertTrue(11 == r.get(0));
    }

    public void test11_ExtendsListParamToListReturn_Error__Deferred()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            List<String> l = new ArrayList<String>();
            l.add("11");
            Param<List<String>> p1 = new Param<List<String>>(l){};
            List<String> r = api.new Invoker<List<String>>(
                    new UngenericParam(o), "func11", p1)
            {}.invoke();
            assertTrue(false);
        }catch(NoSuchMethodException ex){
            assertRegex("There is no suitable method to .*", ex);
        }
    }

}
