// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test01Invoker_03PrimitiveParamReturn.java 125 2008-06-21 14:50:02Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;
import java.util.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test01Invoker_03PrimitiveParamReturn.java 125 2008-06-21 14:50:02Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test01Invoker_03PrimitiveParamReturn extends GreflectTestCase
{
    Reflection api;

    public Test01Invoker_03PrimitiveParamReturn(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    static class NoTypeVarClass
    {
        public boolean funcBoolean(boolean p){
            return !p;
        }

        public byte funcByte(byte p){
            return (byte) (p + 1);
        }

        public char funcChar(char p){
            return (char) (p + 2);
        }

        public short funcShort(Short p){
            return (short) (p + 3);
        }

        public int funcInt(int p){
            return p + 4;
        }

        public long funcLong(long p){
            return p + 5;
        }

        public float funcFloat(float p){
            return p + 6;
        }

        public double funcDouble(double p){
            return p + 7;
        }

    }

    private Object createNoTypeVarClass(){
        return new NoTypeVarClass();
    }

    public void test00_Boolean_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Boolean> p1 = new Param<Boolean>(true){};
        boolean r = api.new Invoker<Boolean>(new UngenericParam(o),
                "funcBoolean", p1)
        {}.invoke();
        assertTrue(r == false);
    }

    public void test01_Byte_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Byte> p1 = new Param<Byte>((byte) 120){};
        byte r = api.new Invoker<Byte>(new UngenericParam(o), "funcByte", p1){}
                .invoke();
        assertTrue(r == 121);
    }

    public void test02_Char_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Character> p1 = new Param<Character>('A'){};
        char r = api.new Invoker<Character>(new UngenericParam(o), "funcChar",
                p1)
        {}.invoke();
        assertTrue(r == 'C');
    }

    public void test03_Short_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Short> p1 = new Param<Short>((short) 1234){};
        short r = api.new Invoker<Short>(new UngenericParam(o), "funcShort", p1)
        {}.invoke();
        assertTrue(r == 1237);
    }

    public void test04_Int_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Integer> p1 = new Param<Integer>(1234567){};
        int r = api.new Invoker<Integer>(new UngenericParam(o), "funcInt", p1){}
                .invoke();
        assertTrue(r == 1234571);
    }

    public void test05_Long_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Long> p1 = new Param<Long>(12345678901L){};
        long r = api.new Invoker<Long>(new UngenericParam(o), "funcLong", p1){}
                .invoke();
        assertTrue(r == 12345678906L);
    }

    public void test06_Float_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Float> p1 = new Param<Float>(1234567.5f){};
        float r = api.new Invoker<Float>(new UngenericParam(o), "funcFloat", p1)
        {}.invoke();
        assertTrue(r == 1234573.5f);
    }

    public void test07_Double_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Double> p1 = new Param<Double>(12345678901.5){};
        double r = api.new Invoker<Double>(new UngenericParam(o), "funcDouble",
                p1)
        {}.invoke();
        assertTrue(r == 12345678908.5);
    }

    public void test10_ParamIntToLong_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Integer> p1 = new Param<Integer>(1234567){};
        long r = api.new Invoker<Long>(new UngenericParam(o), "funcLong", p1){}
                .invoke();
        assertTrue(r == 1234572L);
    }

    public void test11_ReturnIntToLong_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<Integer> p1 = new Param<Integer>(1234567){};
        long r = api.new Invoker<Integer>(new UngenericParam(o), "funcInt", p1)
        {}.invoke();
        assertTrue(r == 1234571L);
    }

}
