// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Test01Invoker_01NoTypeVarInstance.java 44 2008-05-23 22:01:32Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import jp.sourceforge.*;
import java.util.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: Test01Invoker_01NoTypeVarInstance.java 44 2008-05-23 22:01:32Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class Test01Invoker_01NoTypeVarInstance extends GreflectTestCase
{
    Reflection api;

    public Test01Invoker_01NoTypeVarInstance(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        api = new Reflection();
    }

    static class NoTypeVarClass
    {
        public String func00(String p){
            return p + " ok";
        }

        public List<String> func01(List<List<String>> p){
            List<String> r = new ArrayList<String>();
            r.add(p.get(0).get(0) + " ok");
            return r;
        }

        public List<List<String>> func02(List<String> p){
            List<List<String>> r = new ArrayList<List<String>>();
            r.add(p);
            return r;
        }

        public Map<Integer,Integer> func03(Map<Integer,String> p1,
                Map<String,Integer> p2)
        {
            Map<Integer,Integer> map = new HashMap<Integer,Integer>();
            for(Integer k : p1.keySet()){
                map.put(k, p2.get(p1.get(k)));
            }
            return map;
        }

    }

    private Object createNoTypeVarClass(){
        return new NoTypeVarClass();
    }

    public void test00_String_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<String> p1 = new Param<String>("00"){};
        String r = api.new Invoker<String>(new UngenericParam(o), "func00", p1)
        {}.invoke();
        assertTrue("00 ok".equals(r));
    }

    public void test00_StringParam_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            Param<Object> p1 = new Param<Object>("00"){};
            String r = api.new Invoker<String>(new UngenericParam(o), "func00",
                    p1)
            {}.invoke();
            doNothing(r);
            assertTrue(false);
        }catch(NoSuchMethodException ex){
            assertTrue(true);
        }
    }

    public void test00_StringReturn_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Param<String> p1 = new Param<String>("00"){};
        Object r = api.new Invoker<Object>(new UngenericParam(o), "func00", p1)
        {}.invoke();
        assertTrue("00 ok".equals(r));
    }

    public void test00_StringReturn_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            Param<String> p1 = new Param<String>("00"){};
            Integer r = api.new Invoker<Integer>(new UngenericParam(o),
                    "func00", p1)
            {}.invoke();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertTrue(ex
                    .getMessage()
                    .startsWith(
                            "The specified type 'Integer' is not applicable for the return type 'String' of the method "));
        }
    }

    public void test01_GenericNestedListParam_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        List<String> p0 = new ArrayList<String>();
        p0.add("test01");
        List<List<String>> p1 = new ArrayList<List<String>>();
        p1.add(p0);
        List<String> r = api.new Invoker<List<String>>(new UngenericParam(o),
                "func01", new Param<List<List<String>>>(p1){})
        {}.invoke();
        assertTrue("test01 ok".equals(r.get(0)));
    }

    public void test01_GenericNestedListParam_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            List<Object> p0 = new ArrayList<Object>();
            p0.add("test01");
            List<List<Object>> p1 = new ArrayList<List<Object>>();
            p1.add(p0);
            List<String> r = api.new Invoker<List<String>>(
                    new UngenericParam(o), "func01",
                    new Param<List<List<Object>>>(p1){})
            {}.invoke();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertTrue(ex
                    .getMessage()
                    .startsWith(
                            "The specified type 'List<List<Object>>' is not applicable for the param0 type 'List<List<String>>' of the method "));
        }
    }

    public void test01_GenericNestedListReturn_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        List<String> p1 = new ArrayList<String>();
        p1.add("test02");
        List<List<String>> r = api.new Invoker<List<List<String>>>(
                new UngenericParam(o), "func02", new Param<List<String>>(p1){})
        {}.invoke();
        assertTrue("test02".equals(r.get(0).get(0)));
    }

    public void test01_GenericNestedListReturn_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            List<String> p1 = new ArrayList<String>();
            p1.add("test02");
            List<List<Object>> r = api.new Invoker<List<List<Object>>>(
                    new UngenericParam(o), "func02",
                    new Param<List<String>>(p1){})
            {}.invoke();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertTrue(ex
                    .getMessage()
                    .startsWith(
                            "The specified type 'List<List<Object>>' is not applicable for the return type 'List<List<String>>' of the method "));
        }
    }

    public void test02_UngenericNestedList_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        List<String> p0 = new ArrayList<String>(){};
        p0.add("test01");
        List<List<String>> p1 = new ArrayList<List<String>>(){};
        p1.add(p0);
        List<String> r = api.new Invoker<List<String>>(new UngenericParam(o),
                "func01", new Param<List<List<String>>>(p1){})
        {}.invoke();
        assertTrue("test01 ok".equals(r.get(0)));
    }

    public void test03_GenericMap_Normal()
        throws Throwable
    {
        Object o = createNoTypeVarClass();
        Map<Integer,String> p1 = new HashMap<Integer,String>();
        p1.put(1234, "a");
        p1.put(2345, "b");
        Map<String,Integer> p2 = new HashMap<String,Integer>();
        p2.put("a", 5678);
        p2.put("b", 6789);
        Map<Integer,Integer> r = api.new Invoker<Map<Integer,Integer>>(
                new UngenericParam(o), "func03",
                new Param<Map<Integer,String>>(p1){},
                new Param<Map<String,Integer>>(p2){})
        {}.invoke();
        assertTrue(5678 == r.get(1234));
        assertTrue(6789 == r.get(2345));
    }

    public void test03_GenericMapParam1_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            Map<Integer,String> p1 = new HashMap<Integer,String>();
            p1.put(1234, "a");
            p1.put(2345, "b");
            Map<Integer,Integer> r = api.new Invoker<Map<Integer,Integer>>(
                    new UngenericParam(o), "func03",
                    new Param<Map<Integer,String>>(p1){},
                    new Param<Map<Integer,String>>(p1){})
            {}.invoke();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertTrue(ex
                    .getMessage()
                    .startsWith(
                            "The specified type 'Map<Integer,String>' is not applicable for the param1 type 'Map<String,Integer>' of the method "));
        }
    }

    public void test03_GenericMapParam2_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            Map<String,Integer> p2 = new HashMap<String,Integer>();
            p2.put("a", 5678);
            p2.put("b", 6789);
            Map<Integer,Integer> r = api.new Invoker<Map<Integer,Integer>>(
                    new UngenericParam(o), "func03",
                    new Param<Map<String,Integer>>(p2){},
                    new Param<Map<String,Integer>>(p2){})
            {}.invoke();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertTrue(ex
                    .getMessage()
                    .startsWith(
                            "The specified type 'Map<String,Integer>' is not applicable for the param0 type 'Map<Integer,String>' of the method "));
        }
    }

    public void test03_GenericMapReturn_Error()
        throws Throwable
    {
        try{
            Object o = createNoTypeVarClass();
            Map<Integer,String> p1 = new HashMap<Integer,String>();
            p1.put(1234, "a");
            p1.put(2345, "b");
            Map<String,Integer> p2 = new HashMap<String,Integer>();
            p2.put("a", 5678);
            p2.put("b", 6789);
            Map<Integer,Object> r = api.new Invoker<Map<Integer,Object>>(
                    new UngenericParam(o), "func03",
                    new Param<Map<Integer,String>>(p1){},
                    new Param<Map<String,Integer>>(p2){})
            {}.invoke();
            doNothing(r);
            assertTrue(false);
        }catch(TypeViolationException ex){
            assertTrue(ex
                    .getMessage()
                    .startsWith(
                            "The specified type 'Map<Integer,Object>' is not applicable for the return type 'Map<Integer,Integer>' of the method "));
        }
    }

}
