// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: GreflectTestCase.java 7 2008-05-10 12:03:43Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import junit.framework.*;
import java.io.File;
import java.util.regex.*;

/**
 * 
 * .
 * <DT><B> SourceInfo: </B></DT>
 * <DD> Sticky Tag: $Name: $
 * <BR> Last Updater: $Author: $
 * <BR> $Id: GreflectTestCase.java 7 2008-05-10 12:03:43Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public abstract class GreflectTestCase extends TestCase
{

    private static final String TMPDIR_PATH = "target/test-grefrect";;

    private File tmpDir = null;

    public GreflectTestCase(String testName){
        super(testName);
    }

    @Override
    protected void setUp()
        throws Exception
    {
        super.setUp();
        if(needsToWriteFiles()){
            File dir = new File(TMPDIR_PATH + "/" + getClass().getName());
            dir.mkdir();
            tmpDir = dir;
        }
    }

    protected boolean needsToWriteFiles(){
        return false;
    }

    protected File getTmpDir(){
        return tmpDir;
    }

    protected void doNothing(Object o){
    }

    protected void assertRegex(String regex, Throwable th){
        assertRegex(regex, th.getMessage());
    }

    protected void assertRegex(String regex, String mes)
        throws PatternSyntaxException, AssertionFailedError
    {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(mes);
        if(m.matches()){
            assertTrue(true);
        }else{
            throw new AssertionFailedError("The message '" + mes
                    + "' is not match to '" + regex + "'.");
        }
    }

}
