// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: TypeVisitor.java 7 2008-05-10 12:03:43Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import jp.sourceforge.greflect.*;
import java.lang.reflect.*;

/**
 * A visitor of {@link java.lang.reflect.Type} [visitor]
 * .
 * <DT><B> Type Variable {@code }: </B></DT>
 * <DD> 
 * (none)
 * </DD>
 *
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: TypeVisitor.java 7 2008-05-10 12:03:43Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public abstract class TypeVisitor<R>
{

    public R visit(Type type)
        throws TypeViolationException
    {
        if(type instanceof Class<?>){
            return visit((Class<?>) type);
        }else if(type instanceof TypeVariable<?>){
            return visit((TypeVariable<?>) type);
        }else if(type instanceof ParameterizedType){
            return visit((ParameterizedType) type);
        }else if(type instanceof WildcardType){
            return visit((WildcardType) type);
        }else if(type instanceof GenericArrayType){
            return visit((GenericArrayType) type);
        }else{
            return visitSusupportedType(type);
        }
    }

    public R visit(Class type)
        throws TypeViolationException
    {
        return visitSusupportedType(type);
    }

    public R visit(TypeVariable<?> type)
        throws TypeViolationException
    {
        return visitSusupportedType(type);
    }

    public R visit(ParameterizedType type)
        throws TypeViolationException
    {
        return visitSusupportedType(type);
    }

    public R visit(WildcardType type)
        throws TypeViolationException
    {
        return visitSusupportedType(type);
    }

    public R visit(GenericArrayType type)
        throws TypeViolationException
    {
        return visitSusupportedType(type);
    }

    public R visitSusupportedType(Type type)
        throws TypeViolationException
    {
        throw new TypeViolationException(
                "The visitor of ''{0}'' is not implemented.", type);
    }

}
