// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: TypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import java.lang.reflect.GenericDeclaration;
//import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.*;

/**
 * A <EM>mapping from type variables to the resolved types</EM>
 * .
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * 型変数を解決する。<B>with</B> {@link Type}
 * 
 * </LI></OL>
 *
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: TypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public interface TypeVarScope
{
    public static final Set<TypeVariable<? extends GenericDeclaration>> NULL_TYPEVAR_SET = Collections
            .<TypeVariable<? extends GenericDeclaration>>unmodifiableSet(new HashSet<TypeVariable<? extends GenericDeclaration>>());

    public static final TypeVarScope NULL = new TypeVarScope(){
        public GenericTypeRef resolveTypeVariable(
                TypeVariable<? extends GenericDeclaration> key)
        {
            return null;
        }

        public boolean isEmpty(){
            return true;
        }

        public Set<TypeVariable<? extends GenericDeclaration>> getTypeVariableSet()
        {
            return NULL_TYPEVAR_SET;
        }
    };

    GenericTypeRef resolveTypeVariable(
            TypeVariable<? extends GenericDeclaration> key);

    boolean isEmpty();

    Set<TypeVariable<? extends GenericDeclaration>> getTypeVariableSet();
}
