// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: TypeConversionStrategy.java 129 2008-06-22 15:02:40Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import java.lang.reflect.Type;
import jp.sourceforge.greflect.impl.TypeVarScope;
import jp.sourceforge.greflect.TypeViolationException;

/**
 * The <EM> logic for manipulations of generic objects </EM> [strategy] [concurrent]
 * .
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 *
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: TypeConversionStrategy.java 129 2008-06-22 15:02:40Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public interface TypeConversionStrategy
{
    Type resolveTypeVariable(Type type, TypeVarScope scope);

    Class<?> getRawClassOf(Type type, TypeVarScope scope)
        throws TypeViolationException;

    boolean isAssignableFromTo(Class<?> from, Class<?> to);

    boolean isAssignableFromTo(Type stype, TypeVarScope sscope, Type dtype,
            TypeVarScope dscope)
        throws TypeViolationException;

    TypeVarScope getUnresolvedTypeVarsFromTo(Type stype, TypeVarScope sscope,
            Type dtype, TypeVarScope dscope)
        throws TypeViolationException;

    String getTypeDescriptionFor(Type type, TypeVarScope scope,
            boolean ignoreTypeName);

    void writeTypeDescriptionTo(StringBuilder buf, Type type,
            TypeVarScope scope, boolean ignoreTypeName);

    String getTypeSignatureTo(Type type, TypeVarScope scope)
        throws TypeViolationException;
}
