// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: ExtractingTypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import java.util.*;
//import java.beans.*;
import java.lang.reflect.*;
import java.util.*;
import jp.sourceforge.greflect.TypeViolationException;

/**
 * A TypeVarScope extracting result from another type definition [concurrent]
 * .
 * <DT><B> Type Variable {@code }: </B></DT>
 * <DD> 
 * (none)
 * </DD>
 *
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: ExtractingTypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class ExtractingTypeVarScope implements TypeVarScope
{
    static class TypeVarMap extends
            HashMap<TypeVariable<? extends GenericDeclaration>,GenericTypeRef>
    {
    }

    /** immutable typevar - SpecifiedType mapping. */
    private final TypeVarMap typeVarMap;

    public static TypeVarScope makeMargedScope(Type type, TypeVarScope scope)
        throws TypeViolationException
    {
        TypeVarScope r = new ExtractingTypeVarScope(type, scope);
        return new BranchedTypeVarScope(r, scope);
    }

    public ExtractingTypeVarScope(Type type, TypeVarScope scope)
        throws TypeViolationException
    {
        if(type == null) throw new NullPointerException("cls");
        TypeVarMap map = new TypeVarMap();

        garbageTypeVarsStage1(map, type, scope);

        typeVarMap = map;
    }

    private static void garbageTypeVarsStage1(TypeVarMap map, Type type,
            TypeVarScope scope)
        throws TypeViolationException
    {
        if(type instanceof Class<?>){
            // skip
        }else if(type instanceof ParameterizedType){
            ParameterizedType t = (ParameterizedType) type;
            Type rtr = t.getRawType();
            //TypeVariable<?> tvs = rtr.getTypeParameters()();
            Type[] ptps = t.getActualTypeArguments();
            if(rtr instanceof Class){
                final Class<?> rt = (Class<?>) rtr;

                final TypeVariable<?>[] tvs = rt.getTypeParameters();
                if(tvs.length != ptps.length){
                    throw new TypeViolationException(
                            "The number of types ''{0}'' is not match with the number of type parameters of ''{1}'' Revise the specifications.",
                            ptps.length, rt.getName());
                }

                for(int i = tvs.length; --i >= 0;){
                    TypeVariable<?> tv = tvs[i];
                    GenericTypeRef o = map.get(tv);
                    if(o == null){
                        o = new SimpleGenericTypeRef(ptps[i]);
                        map.put(tv, o);
                    }else{
                        // When same type variable is used twice,
                        // resolveTypeVariable() fails.
                        o = new SimpleGenericTypeRef(null);
                        map.put(tv, o);
                    }

                    garbageTypeVarsStage1(map, ptps[i], scope);
                }

            }else{
                throw new TypeViolationException(
                        "The raw class ''{0}'' of the parameterized type is not a class. Report it as a bug.",
                        type);
            }

        }else if(type instanceof TypeVariable<?>){
            GenericTypeRef ref = scope
                    .resolveTypeVariable((TypeVariable<?>) type);
            if(ref != null){
                garbageTypeVarsStage1(map, ref.getType(),
                        new BranchedTypeVarScope(ref.getScope(), scope));
            }
        }else if(type instanceof WildcardType){
            // skip
        }else if(type instanceof GenericArrayType){
            // skip
        }else{
            throw new TypeViolationException(
                    "The type ''{0}'' is not supported. Report it as a bug.",
                    type);
        }
    }

    /**
     @param name typevar name.
     @return [null:not found].
     */
    public GenericTypeRef resolveTypeVariable(
            TypeVariable<? extends GenericDeclaration> key)
    {
        //TypeVarKey k = tvkFactory.get(key);
        //return getFixedTypeOf(k);
        //return null;
        GenericTypeRef ref = typeVarMap.get(key);
        if(ref == null || ref.getType() == null){
            return null;
        }else{
            return ref;
        }
    }

    public boolean isEmpty(){
        return typeVarMap.isEmpty();
    }

    public Set<TypeVariable<? extends GenericDeclaration>> getTypeVariableSet()
    {
        return typeVarMap.keySet();
    }

    public String toString(){
        StringBuffer buf = new StringBuffer();
        //buf.append("ClassTypeVarScope:");
        boolean first = true;
        buf.append("{");
        //buf.append(typeVarMap.toString());
        first = true;
        for(TypeVariable<? extends GenericDeclaration> key : typeVarMap
                .keySet()){
            if(first){
                first = false;
            }else{
                buf.append(',');
            }
            GenericDeclaration gd = key.getGenericDeclaration();
            if(gd instanceof Class<?>){
                // skip domain
            }else if(gd instanceof Method){
                buf.append(((Method) gd).getName());
                buf.append(':');
            }else{
                buf.append(gd.toString());
                buf.append(':');
            }
            buf.append(key.getName());
            buf.append('=');
            GenericTypeRef tr = typeVarMap.get(key);
            if(tr != null){
                buf.append(typeVarMap.get(key));
            }else{
                buf.append('?');
            }
        }
        buf.append('}');
        return buf.toString();
    }

}
