// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: DefaultTypeConversionStrategy.java 132 2008-07-02 13:51:18Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import java.lang.reflect.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.*;

import jp.sourceforge.greflect.impl.TypeConversionStrategy;
import jp.sourceforge.greflect.UnresolvedTypeVariableException;
import jp.sourceforge.greflect.TypeViolationException;

/**
 * The default implementation of TypeConversionStrategy [strategy] [concurrent]
 * .
 * <DT><B> Responsibilities &amp; Collaborations : </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 *
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo </B></DT>
 * <DD> $Id: DefaultTypeConversionStrategy.java 132 2008-07-02 13:51:18Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class DefaultTypeConversionStrategy implements TypeConversionStrategy
{
    private static Type[] EMPTY_TYPES = new Type[0];

    private static TypeVariable<?>[] EMPTY_TYPE_VARIABLES = new TypeVariable<?>[0];

    final boolean simpleTypeDescription = true;

    Logger log = Logger.global;

    {
        //log.setLevel(Level.FINEST);
        //log.setLevel(Level.INFO);
        log.setLevel(Level.WARNING);
    }

    private Type resolveAndCheckTypeVariable(Type type, TypeVarScope scope)
        throws TypeViolationException
    {
        Type t = resolveTypeVariable(type, scope);
        if(t instanceof TypeVariable){
            TypeVariable tv = (TypeVariable<?>) t;
            String tname = tv.getGenericDeclaration() + ":" + tv.getName();
            throw new UnresolvedTypeVariableException(
                    "The type variable ''{0}'' cannot be resolved in the scope ''{1}''. Use ungeneric tecnique.",
                    tname, scope);
            //       ((TypeVariable)t).getName(), scope);
        }else{
            return t;
        }
    }

    public Type resolveTypeVariable(Type type, TypeVarScope scope){
        if(type instanceof TypeVariable){
            //final String tvnam = ((TypeVariable)type).getName();
            final TypeVariable<? extends GenericDeclaration> tv = ((TypeVariable<? extends GenericDeclaration>) type);
            //ClassTypeVarScope fd = findFixedDeclaration(scope);
            if(scope != null){
                //Type ft = scope.resolveTypeVariable(tv);
                GenericTypeRef gtr = scope.resolveTypeVariable(tv);
                if(gtr == null){
                    return type;
                }
                //Type ft = gtr.getType(GenericTypeRef.For.NO_ACCESS);
                Type ft = gtr.getType();
                // when resolved Type is TypeVariable too, resolve recursively.
                // If typevar dependencies has a circle, it will stopd by StackOverFlowError.
                return resolveTypeVariable(ft, scope);
            }else{
                throw new NullPointerException("scope");
            }
        }else{
            return type;
        }
    }

    public Class<?> getRawClassOf(Type type, TypeVarScope scope)
        throws TypeViolationException
    {
        Type t = resolveTypeVariable(type, scope);
        if(t instanceof Class){
            return (Class) t;
        }else if(t instanceof ParameterizedType){
            Type rt = ((ParameterizedType) t).getRawType();
            if(rt instanceof Class){
                return (Class) rt;
            }else{
                throw new TypeViolationException(
                        "The raw of type variable ''{0}'' must be a Class to find the method to invoke. Revise the type variable.",
                        getTypeDescriptionFor(type, scope, false));
            }
        }else{
            throw new TypeViolationException(
                    "The type variable ''{0}'' must be a Class or a parameterized Class but ''{1}''. Revise the type variable.",
                    getTypeDescriptionFor(type, scope, false), (t == null) ? t
                            : t.getClass().getName());
        }
    }

    /*
     public void checkAssignable(Type stype, TypeVarScope sscope, Type dtype,
     TypeVarScope dscope)
     throws TypeViolationException
     {
     boolean r = isAssignable(stype, sscope, dtype, dscope);
     if(!r){
     String src = getTypeDescription(stype, sscope);
     String dst = getTypeDescription(dtype, dscope);
     throw new TypeViolationException("The type " + src
     + " cannot convert to "
     + dst);
     }
     }
     */

    public boolean isAssignableFromTo(Class<?> from, Class<?> to){
        if(from.isPrimitive() || to.isPrimitive()){
            // case for primitive, and autoboxing.
            Prim sp = getPrim(from);
            Prim dp = getPrim(to);
            //if(log != null && log.isLoggable(Level.INFO)){
            //    log.log(Level.INFO, "getPrim():" + sp + " -> " + dp);
            //}
            return dp.isAssignableFrom(sp);
        }
        return to.isAssignableFrom(from);
    }

    public boolean isAssignableFromTo(Type stype, TypeVarScope sscope,
            Type dtype, TypeVarScope dscope)
        throws TypeViolationException
    {
        TypeVarScope tv = getUnresolvedTypeVarsFromTo(stype, sscope, dtype,
                dscope);
        if(tv == null){
            return false;
        }else if(tv.isEmpty()){
            return true;
        }else{
            throw new UnresolvedTypeVariableException(
                    "The type variable ''{0}'' cannot be resolved in the scope ''{1}''. Use ungeneric tecnique.",
                    null, dscope);
        }
    }

    public TypeVarScope getUnresolvedTypeVarsFromTo(Type stype,
            TypeVarScope sscope, Type dtype, TypeVarScope dscope)
        throws TypeViolationException
    {
        if(log != null && log.isLoggable(Level.INFO)){
            String mes = "isAssignable:" + stype + " in " + sscope + " -> "
                    + dtype + " in " + dscope;
            log.log(Level.INFO, mes);
        }

        if(stype == null){
            throw new NullPointerException("stype");
        }
        if(dtype == null){
            throw new NullPointerException("dtype");
        }
        //if(sscope == null){
        //    throw new NullPointerException("sscope");
        //}
        //if(dscope == null){
        //    throw new NullPointerException("dscope");
        //}
        stype = resolveAndCheckTypeVariable(stype, sscope);
        dtype = resolveTypeVariable(dtype, dscope);

        Type[] sps = null;
        Type[] dps = null;
        Class<?> src = null;
        Class<?> drc = null;
        Type sarray = null;
        Type darray = null;

        if(dtype instanceof Class){
            // case for Class object in this case, source and distination
            // must be non-parameterized class.
            drc = (Class<?>) dtype;
            if(drc.isArray()){
                darray = drc.getComponentType();
            }else{
                try{
                    dps = drc.getTypeParameters();
                }catch(GenericSignatureFormatError ex){
                    dps = EMPTY_TYPES;
                }
            }

        }else if(dtype instanceof ParameterizedType){
            final ParameterizedType dt = (ParameterizedType) dtype;
            Type r = dt.getRawType();
            if(r instanceof Class<?>){
                drc = (Class<?>) r;
                dps = dt.getActualTypeArguments();
            }else{
                throw new TypeViolationException(
                        "The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.",
                        dtype);
            }
        }else if(dtype instanceof TypeVariable){
            TypeVariable<? extends GenericDeclaration> tv = (TypeVariable<? extends GenericDeclaration>) dtype;
            if(tv.getGenericDeclaration() instanceof Method){
                return new SingleTypeVarScope(tv, new SimpleGenericTypeRef(
                        stype, sscope));
            }else{
                throw new UnresolvedTypeVariableException(
                        "The type variable ''{0}'' cannot be resolved in the scope ''{1}''. Use ungeneric tecnique.",
                        tv, dscope);
            }
        }else if(dtype instanceof GenericArrayType){
            GenericArrayType dt = (GenericArrayType) dtype;
            darray = dt.getGenericComponentType();
        }else{
            throw new TypeViolationException(
                    "The type ''{0}'' is not supported. Report as a bug", dtype);
        }

        if(stype instanceof Class){
            // case for Class object in this case, source and distination
            // must be non-parameterized class.
            src = (Class<?>) stype;
            if(src.isArray()){
                sarray = src.getComponentType();
            }else{
                try{
                    sps = src.getTypeParameters();
                }catch(GenericSignatureFormatError ex){
                    sps = EMPTY_TYPES;
                }
            }

        }else if(stype instanceof ParameterizedType){
            final ParameterizedType st = (ParameterizedType) stype;
            Type r = st.getRawType();
            if(r instanceof Class<?>){
                src = (Class<?>) r;
                sps = st.getActualTypeArguments();
            }else{
                throw new TypeViolationException(
                        "The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.",
                        stype);
            }
        }else if(stype instanceof GenericArrayType){
            GenericArrayType st = (GenericArrayType) stype;
            sarray = st.getGenericComponentType();
            sps = EMPTY_TYPES;
        }else{
            throw new TypeViolationException(
                    "The type ''{0}'' is not supported. Report as a bug", stype);
        }

        // The case of arrays
        if(darray != null){
            if(sarray != null){
                return getUnresolvedTypeVarsFromTo(sarray, sscope, darray,
                        dscope);
            }else{
                return null;
            }
        }

        assert dps != null;
        assert drc != null;

        if(sarray != null){
            return drc.equals(Object.class) ? TypeVarScope.NULL : null;
        }

        assert sps != null;
        assert src != null;

        // The case of Class or ParameterizedType.
        if(dps.length == 0 && sps.length == 0){
            if(src.isPrimitive() || drc.isPrimitive()){
                // case for primitive, and autoboxing.
                Prim sp = getPrim(src);
                Prim dp = getPrim(drc);
                if(log != null && log.isLoggable(Level.INFO)){
                    log.log(Level.INFO, "getPrim():" + sp + " -> " + dp);
                }
                return dp.isAssignableFrom(sp) ? TypeVarScope.NULL : null;
            }
            // this is a shortcut for inheritance checking.
            // even if A extends B<T> extends C, it works
            // for A and C when a and C has no type parameters.
            return drc.isAssignableFrom(src) ? TypeVarScope.NULL : null;
        }else{
            if(drc.equals(src)){
                if(dps.length == sps.length){
                    TypeVarScope tvs = TypeVarScope.NULL;
                    for(int i = sps.length; --i >= 0;){
                        TypeVarScope tv = getUnresolvedTypeVarsMatchedForAssignment(
                                sps[i], sscope, dps[i], dscope);
                        if(tvs != null){
                            if(tvs.isEmpty() || tv == null){
                                tvs = tv;
                            }else{
                                tvs = new BranchedTypeVarScope(tvs, tv);
                            }
                        }
                    }
                    return tvs;
                }else{
                    throw new TypeViolationException(
                            "The parameter length of ''{0}'' and ''{1}'' is unmatch. Report as a bug.",
                            src, drc);
                }
            }
            return getUnresolvedTypeVarsStage2(stype, sscope, dtype, dscope);
        }
    }

    private TypeVarScope getUnresolvedTypeVarsStage2(Type stype,
            TypeVarScope sscope, Type dtype, TypeVarScope dscope)
        throws TypeViolationException
    {
        if(log != null && log.isLoggable(Level.INFO)){
            log.log(Level.INFO, "isAssignableStage2:"
                    //System.out.println("opaopa:"
                    + stype + " in " + sscope + " -> " + dtype + " in "
                    + dscope);
        }

        if(stype == null){
            throw new NullPointerException("stype");
        }
        if(dtype == null){
            throw new NullPointerException("dtype");
        }

        if(Object.class.equals(dtype)){
            // shortcut for Object.
            // it contains the case for Objct <- interface.
            return TypeVarScope.NULL;
        }

        if(stype instanceof Class){
            final Class<?> c = (Class) stype;

            Type st = c.getGenericSuperclass();
            if(st != null && isAssignableFromTo(st, sscope, dtype, dscope)){
                return TypeVarScope.NULL;
            }
            Type[] ifs = c.getGenericInterfaces();
            for(int i = 0; i < ifs.length; i++){
                if(isAssignableFromTo(ifs[i], sscope, dtype, dscope)){
                    return TypeVarScope.NULL;
                }
            }
            return null;
        }else if(stype instanceof ParameterizedType){
            final ParameterizedType pt = (ParameterizedType) stype;
            final Type st = pt.getRawType();
            if(st instanceof Class){
                Type[] ps = pt.getActualTypeArguments();
                Class<?> sc = (Class<?>) st;
                TypeVarScope cscp = ChainedTypeVarScope.chain(sscope, sc, ps);

                return getUnresolvedTypeVarsStage2(sc, cscp, dtype, dscope);
            }else{
                throw new TypeViolationException(
                        "The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.",
                        st);
            }
        }else if(stype instanceof WildcardType){
            throw new TypeViolationException(
                    "The wildcard type ''{0}'' is unsupported now. Revise the type variable.",
                    stype);
        }else if(stype instanceof TypeVariable){
            throw new TypeViolationException(
                    "The type variable ''{0}'' cannot be the target for substitution. Revise the type variable.",
                    stype);
        }else{
            throw new TypeViolationException(
                    "The type ''{0}'' is unsupported now. Revise the type variable.",
                    stype);
        }

    }

    private TypeVarScope getUnresolvedTypeVarsMatchedForAssignment(Type stype,
            TypeVarScope sscope, Type dtype, TypeVarScope dscope)
        throws TypeViolationException
    {
        if(log != null && log.isLoggable(Level.INFO)){
            log.log(Level.INFO, "isMatchedForAssignment:"
                    //System.out.println("opaopa:"
                    + stype + " in " + sscope + " -> " + dtype + " in "
                    + dscope);
        }

        if(stype == null){
            throw new NullPointerException("stype");
        }
        if(dtype == null){
            throw new NullPointerException("dtype");
        }
        stype = resolveAndCheckTypeVariable(stype, sscope);
        dtype = resolveTypeVariable(dtype, dscope);

        if(dtype instanceof Class){
            // case for Class object in this case, source and distination
            // must be non-parameterized class.
            final Class<?> dc = (Class) dtype;
            TypeVariable<?>[] tvs;
            try{
                tvs = dc.getTypeParameters();
            }catch(GenericSignatureFormatError ex){
                tvs = EMPTY_TYPE_VARIABLES;
            }
            if(tvs.length > 0){
                throw new TypeViolationException(
                        "The ''{0}'' have type variables. Use ungeneric tecnique.",
                        dtype);
            }
            if(stype instanceof Class){
                final Class<?> st = (Class) stype;
                try{
                    if(st.getTypeParameters().length > 0){
                        throw new TypeViolationException(
                                "The ''{0}'' have type variables. Use ungeneric tecnique.",
                                stype);
                    }
                }catch(GenericSignatureFormatError ex){
                    // skip
                }
                return dc.equals(st) ? TypeVarScope.NULL : null;
            }else{
                return null;
            }
        }else if(dtype instanceof ParameterizedType){
            final ParameterizedType dt = (ParameterizedType) dtype;
            if(stype instanceof ParameterizedType){
                final ParameterizedType st = (ParameterizedType) stype;
                final Type sr = st.getRawType();
                final Type dr = dt.getRawType();
                if(!(sr instanceof Class)){
                    throw new TypeViolationException(
                            "The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.",
                            st);
                }
                if(!(dr instanceof Class)){
                    throw new TypeViolationException(
                            "The raw type of parameterized type ''{0}'' is not a Class. Revise the type variable.",
                            dt);
                }
                if(sr.equals(dr)){
                    Type[] sas = st.getActualTypeArguments();
                    Type[] das = dt.getActualTypeArguments();
                    if(sas.length == das.length){
                        TypeVarScope tvs = TypeVarScope.NULL;
                        for(int i = sas.length; --i >= 0;){
                            TypeVarScope tv = getUnresolvedTypeVarsMatchedForAssignment(
                                    sas[i], sscope, das[i], dscope);
                            if(tvs != null){
                                if(tvs.isEmpty() || tv == null){
                                    tvs = tv;
                                }else{
                                    tvs = new BranchedTypeVarScope(tvs, tv);
                                }
                            }
                        }
                        return tvs;
                    }else{
                        throw new TypeViolationException(
                                "The parameter length of ''{0}'' and ''{1}'' is unmatch. Report as a bug.",
                                sr, dr);
                    }
                }
                return null;
            }else{
                return null;
            }
        }else if(dtype instanceof WildcardType){
            final WildcardType dt = (WildcardType) dtype;
            Type[] lbs = dt.getLowerBounds();
            if(lbs != null && lbs.length != 0){
                throw new TypeViolationException(
                        "The type ''{0}'' with lower bounds is unsupported. Revise the type variable.",
                        dtype);
            }
            Type[] ubs = dt.getUpperBounds();
            if(ubs == null || ubs.length != 1 || Object.class.equals(ubs[0])){
            }else{
                throw new TypeViolationException(
                        "The type ''{0}'' with upper bounds is unsupported. Revise the type variable.",
                        dtype);
            }
            return TypeVarScope.NULL;
        }else if(dtype instanceof TypeVariable){
            TypeVariable<? extends GenericDeclaration> tv = (TypeVariable<? extends GenericDeclaration>) dtype;
            if(tv.getGenericDeclaration() instanceof Method){
                return new SingleTypeVarScope(tv, new SimpleGenericTypeRef(
                        stype, sscope));
            }else{
                throw new UnresolvedTypeVariableException(
                        "The type variable ''{0}'' cannot be resolved in the scope ''{1}''. Use ungeneric tecnique.",
                        tv, dscope);
            }
        }else if(dtype instanceof GenericArrayType){
            GenericArrayType dt = (GenericArrayType) dtype;
            if(stype instanceof Class){
                final Class<?> st = (Class) stype;
                if(st.isArray()){
                    return getUnresolvedTypeVarsMatchedForAssignment(st
                            .getComponentType(), sscope, dt
                            .getGenericComponentType(), dscope);
                }else{
                    return null;
                }
            }else if(stype instanceof GenericArrayType){
                final GenericArrayType st = (GenericArrayType) stype;
                return getUnresolvedTypeVarsMatchedForAssignment(st
                        .getGenericComponentType(), sscope, dt
                        .getGenericComponentType(), dscope);
            }else{
                return null;
            }
        }else{
            throw new TypeViolationException(
                    "The type ''{0}'' is unsupported. Report as a bug", dtype);
        }
    }

    /**
     * (overridden)
     * .
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     * 
     * @param type
     * @param scope
     * @return
     * @see jp.sourceforge.greflect.TypeConversionStrategy#getTypeDescription(java.lang.reflect.Type, jp.sourceforge.greflect.impl.TypeVarScope)
     */
    public String getTypeDescriptionFor(Type type, TypeVarScope scope,
            boolean ignoreTypeName)
    {
        StringBuilder buf = new StringBuilder();
        writeTypeDescriptionTo(buf, type, scope, ignoreTypeName);
        return buf.toString();
    }

    /**
     * (overridden)
     * .
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     * 
     * @param buf
     * @param type
     * @param scope
     * @see jp.sourceforge.greflect.TypeConversionStrategy#writeTypeDescriptionTo(java.lang.StringBuilder, java.lang.reflect.Type, jp.sourceforge.greflect.impl.TypeVarScope)
     */
    public void writeTypeDescriptionTo(StringBuilder buf, Type type,
            TypeVarScope scope, boolean ignoreTypeName)
    {

        if(buf == null){
            throw new IllegalArgumentException("buf");
        }
        if(type == null){
            buf.append("null");
            return;
        }

        if(type instanceof Class){
            final Class<?> dc = (Class<?>) type;

            if(simpleTypeDescription){
                buf.append(dc.getSimpleName());
            }else{
                buf.append(dc.getName());
            }

            TypeVariable<?>[] tvs;
            try{
                tvs = dc.getTypeParameters();
            }catch(GenericSignatureFormatError ex){
                tvs = EMPTY_TYPE_VARIABLES;
            }
            if(tvs.length > 0){
                buf.append('<');
                for(int i = 0; i < tvs.length; i++){
                    if(i > 0){
                        buf.append(',');
                    }
                    TypeVariable<?> tv = tvs[i];
                    buf.append(tv.getName());

                    Type t = resolveTypeVariable(tv, scope);
                    if(t instanceof TypeVariable<?>){
                        TypeVariable<?> rt = (TypeVariable<?>) t;
                        writeTypeVariableTo(buf, rt, ignoreTypeName);
                    }else{
                        buf.append('=');
                        writeTypeDescriptionTo(buf, t, scope, ignoreTypeName);
                    }
                }
                buf.append('>');
            }
        }else if(type instanceof TypeVariable<?>){
            final TypeVariable<?> dt = (TypeVariable<?>) type;
            if(!ignoreTypeName){
                final GenericDeclaration gd = dt.getGenericDeclaration();
                if(gd instanceof Class<?>){
                    if(simpleTypeDescription){
                        buf.append(((Class<?>) gd).getSimpleName());
                    }else{
                        buf.append(((Class<?>) gd).getName());
                    }
                }else if(gd instanceof Method){
                    buf.append(((Method) gd).getName());
                }else{
                    buf.append(gd.toString());
                }
                buf.append(':');
                buf.append(dt.getName());
                buf.append('=');
            }

            Type t = resolveTypeVariable(type, scope);
            if(t instanceof TypeVariable<?>){
                TypeVariable<?> rt = (TypeVariable<?>) t;
                writeTypeVariableTo(buf, rt, ignoreTypeName);
            }else{
                writeTypeDescriptionTo(buf, t, scope, ignoreTypeName);
            }
        }else if(type instanceof ParameterizedType){
            final ParameterizedType dt = (ParameterizedType) type;
            final Type dr = dt.getRawType();
            if(dr instanceof Class<?>){
                if(simpleTypeDescription){
                    buf.append(((Class<?>) dr).getSimpleName());
                }else{
                    buf.append(((Class<?>) dr).getName());
                }
            }else{
                buf.append(dr.toString());
            }

            buf.append('<');
            final Type[] das = dt.getActualTypeArguments();
            for(int i = 0; i < das.length; i++){
                if(i > 0){
                    buf.append(',');
                }
                Type t = das[i];
                writeTypeDescriptionTo(buf, t, scope, ignoreTypeName);
            }
            buf.append('>');

        }else if(type instanceof WildcardType){
            buf.append(type.toString());
        }else if(type instanceof TypeVariable){
            throw new UnsupportedOperationException();
        }else{
            throw new UnsupportedOperationException();
        }
    }

    private void writeTypeVariableTo(StringBuilder buf, TypeVariable<?> rt,
            boolean ignoreTypeName)
    {
        if(!ignoreTypeName){
            final GenericDeclaration gd = rt.getGenericDeclaration();
            if(gd instanceof Class<?>){
                if(simpleTypeDescription){
                    buf.append(((Class<?>) gd).getSimpleName());
                }else{
                    buf.append(((Class<?>) gd).getName());
                }
            }else if(gd instanceof Method){
                buf.append(((Method) gd).getName());
            }else{
                buf.append(gd.toString());
            }
            buf.append(':');
        }
        buf.append(rt.getName());
    }

    static enum Prim {
        NONE {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return false;
            }
        },
        BOOLEAN_P {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return boolean_p.contains(p);
            }
        },
        BOOLEAN_W {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return boolean_w.contains(p);
            }
        },
        BYTE_P {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return byte_p.contains(p);
            }
        },
        BYTE_W {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return byte_w.contains(p);
            }
        },
        CHAR_P {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return char_p.contains(p);
            }
        },
        CHAR_W {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return char_w.contains(p);
            }
        },
        SHORT_P {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return short_p.contains(p);
            }
        },
        SHORT_W {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return short_w.contains(p);
            }
        },
        INT_P {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return int_p.contains(p);
            }
        },
        INT_W {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return int_w.contains(p);
            }
        },
        LONG_P {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return long_p.contains(p);
            }
        },
        LONG_W {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return long_w.contains(p);
            }
        },
        FLOAT_P {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return float_p.contains(p);
            }
        },
        FLOAT_W {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return float_w.contains(p);
            }
        },
        DOUBLE_P {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return double_p.contains(p);
            }
        },
        DOUBLE_W {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return double_w.contains(p);
            }
        },
        VOID_P {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return false;
            }
        },
        VOID_W {
            @Override
            boolean isAssignableFrom(Prim p)
            {
                return p == this;
            }
        },
        ;
        static final EnumSet<Prim> boolean_p;

        static final EnumSet<Prim> boolean_w;

        static final EnumSet<Prim> byte_p;

        static final EnumSet<Prim> byte_w;

        static final EnumSet<Prim> char_p;

        static final EnumSet<Prim> char_w;

        static final EnumSet<Prim> short_p;

        static final EnumSet<Prim> short_w;

        static final EnumSet<Prim> int_p;

        static final EnumSet<Prim> int_w;

        static final EnumSet<Prim> long_p;

        static final EnumSet<Prim> long_w;

        static final EnumSet<Prim> float_p;

        static final EnumSet<Prim> float_w;

        static final EnumSet<Prim> double_p;

        static final EnumSet<Prim> double_w;

        static{
            boolean_w = EnumSet.of(BOOLEAN_P, BOOLEAN_W);
            boolean_p = boolean_w;

            byte_w = EnumSet.of(BYTE_P, BYTE_W);
            char_w = EnumSet.of(CHAR_P, CHAR_W);
            short_w = EnumSet.of(SHORT_P, SHORT_W);
            int_w = EnumSet.of(INT_P, INT_W);
            long_w = EnumSet.of(LONG_P, LONG_W);
            float_w = EnumSet.of(FLOAT_P, FLOAT_W);
            double_w = EnumSet.of(DOUBLE_P, DOUBLE_W);

            byte_p = byte_w;
            char_p = char_w;
            short_p = EnumSet.copyOf(short_w);
            short_p.addAll(byte_p);
            int_p = EnumSet.copyOf(int_w);
            int_p.addAll(short_p);
            int_p.addAll(char_p);
            long_p = EnumSet.copyOf(long_w);
            long_p.addAll(int_p);
            float_p = EnumSet.copyOf(float_w);
            float_p.addAll(long_p);
            double_p = EnumSet.copyOf(double_w);
            double_p.addAll(float_p);
        }

        abstract boolean isAssignableFrom(Prim p);
    }

    final Map<Class<?>,Prim> primMap;

    {
        Map<Class<?>,Prim> map = new HashMap<Class<?>,Prim>(32);

        map.put(boolean.class, Prim.BOOLEAN_P);
        map.put(byte.class, Prim.BYTE_P);
        map.put(char.class, Prim.CHAR_P);
        map.put(short.class, Prim.SHORT_P);
        map.put(int.class, Prim.INT_P);
        map.put(long.class, Prim.LONG_P);
        map.put(float.class, Prim.FLOAT_P);
        map.put(double.class, Prim.DOUBLE_P);
        map.put(void.class, Prim.VOID_P);

        map.put(Boolean.class, Prim.BOOLEAN_W);
        map.put(Byte.class, Prim.BYTE_W);
        map.put(Character.class, Prim.CHAR_W);
        map.put(Short.class, Prim.SHORT_W);
        map.put(Integer.class, Prim.INT_W);
        map.put(Long.class, Prim.LONG_W);
        map.put(Float.class, Prim.FLOAT_W);
        map.put(Double.class, Prim.DOUBLE_W);
        map.put(Void.class, Prim.VOID_W);

        primMap = Collections.unmodifiableMap(map);
    }

    private Prim getPrim(Class<?> c){
        Prim p = primMap.get(c);
        return (p != null) ? p : Prim.NONE;
    }

    /*
     public boolean assign(GenericBeanHolder sbean, Object spropname,
     GenericBeanHolder dbean, Object dpropname, boolean noexec)
     throws TypeViolationException
     {
     if(sbean == null) throw new IllegalArgumentException("null sbean.");
     if(dbean == null) throw new IllegalArgumentException("null dbean.");
     if(spropname == null) throw new IllegalArgumentException(
     "null spropname.");
     if(dpropname == null) throw new IllegalArgumentException(
     "null dpropname.");

     final ClassTypeVarScope sdef = sbean.getTypeDef();
     final ClassTypeVarScope ddef = dbean.getTypeDef();
     assert sdef != null && ddef != null;

     if(log != null && log.isLoggable(Level.INFO)){
     log.log(Level.INFO, "isAssignable:"
     //System.out.println("opaopa:"
     + spropname + " of " + sbean + " -> " + dpropname + " of "
     + dbean);
     }

     final GenericTypeRef sref = sdef.getPropertyTypeRef(spropname);
     if(sref == null){
     throw new TypeViolationException("No such property: "
     + spropname + " in " + sbean);
     }

     final GenericTypeRef dref = ddef.getPropertyTypeRef(dpropname);
     if(dref == null){
     throw new TypeViolationException("No such property: "
     + dpropname + " in " + dbean);
     }

     final Type stype = sref.getType(GenericTypeRef.For.GET);
     final Type dtype = dref.getType(GenericTypeRef.For.SET);
     boolean ret = false;
     if(stype != null && dtype != null){
     ret = isAssignable(stype, sref.getScope(), dtype, dref.getScope());
     }else{
     if(log != null && log.isLoggable(Level.INFO)){
     log.log(Level.INFO,
     "isAssignable: missing getter/setter types="
     //System.out.println("opaopa:"
     + stype + "/" + dtype);
     }
     }
     if(noexec){
     return ret;
     }else{
     if(ret){
     final Object sobj = sbean.getBean();
     if(sobj == null){
     throw new TypeViolationException(
     "The bean has gone.");
     }
     final Object dobj = dbean.getBean();
     if(dobj == null){
     throw new TypeViolationException(
     "The bean has gone.");
     }

     try{
     Object v = sref.invokeGet(sobj);

     dref.invokeSet(dobj, v);
     }catch(TypeViolationException ex){
     throw ex;
     }catch(Exception ex){
     throw new TypeViolationException(
     "Unexpected assignment error.", ex);
     }
     return true;
     }else{
     throw new TypeViolationException("Cannot assign.",
     stype, dtype);

     }
     }
     }
     */

    public String getTypeSignatureTo(Type type, final TypeVarScope scope)
        throws TypeViolationException
    {
        //final StringBuilder header = new StringBuilder(); // signature header
        final StringBuilder body = new StringBuilder(); // signature body

        TypeVisitor<Integer> v = new TypeVisitor<Integer>(){
            private void writeClassnameTo(StringBuilder b, String name){
                int n = name.length();
                for(int i = 0; i < n; i++){
                    char c = name.charAt(i);
                    if(c == '.'){
                        b.append('/');
                    }else{
                        b.append(c);
                    }
                }
            }

            @Override
            public Integer visit(Class type)
                throws TypeViolationException
            {
                if(type.isPrimitive()){
                    return visitSusupportedType(type);
                }else{
                    body.append('L');
                    writeClassnameTo(body, type.getName());
                    body.append(';');
                    return null;
                }
            }

            @Override
            public Integer visit(TypeVariable<?> type)
                throws TypeViolationException
            {
                GenericTypeRef gtr = scope.resolveTypeVariable(type);
                if(gtr == null){
                    throw new TypeViolationException(
                            "The instanciation fails because type variable ''{0}'' is not resolved. Revise the specitication.",
                            type);
                }else{
                    return visit(gtr.getType());
                }
            }

            @Override
            public Integer visit(ParameterizedType type)
                throws TypeViolationException
            {
                Type rt = type.getRawType();
                Type[] ps = type.getActualTypeArguments();
                if(rt instanceof Class){
                    body.append('L');
                    writeClassnameTo(body, ((Class<?>) rt).getName());
                    body.append('<');
                    for(int i = 0; i < ps.length; i++){
                        visit(ps[i]);
                    }
                    body.append('>');
                    body.append(';');
                    return null;
                }else{
                    return visitSusupportedType(type);
                }
            }

            @Override
            public Integer visit(WildcardType type)
                throws TypeViolationException
            {
                throw new TypeViolationException(
                        "The instanciation of type ''{0}'' is not supported. Revise the specitication.",
                        type);
                //return visitSusupportedType(type);
            }

            @Override
            public Integer visit(GenericArrayType type)
                throws TypeViolationException
            {
                body.append('[');
                return visit(type.getGenericComponentType());
            }

            @Override
            public Integer visitSusupportedType(Type type)
                throws TypeViolationException
            {
                throw new TypeViolationException(
                        "The instanciation of type ''{0}'' is not supported. Report it as a bug.",
                        type);
            }

        };

        v.visit(type);
        return body.toString();
    }
}
