// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: ClassTypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import java.util.*;
//import java.beans.*;
import java.lang.reflect.*;
import java.util.*;
import jp.sourceforge.greflect.TypeViolationException;

/**
 * A TypeVarScope generated from a Class [concurrent]
 * .
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: ClassTypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class ClassTypeVarScope implements //DiforgTypeDef, 
        TypeVarScope
{
    static class TypeVarMap extends
            HashMap<TypeVariable<? extends GenericDeclaration>,GenericTypeRef>
    {
    }

    //public static final TypeVarKey.Factory tvkFactory
    //    = new TypeVarKey.Factory();

    private final Class<?> rawClass;

    /** immutable list of typevars. */
    //private final List<GenericTypeRef> typeargs;
    //private final List<FixedType> types;
    /** immutable typevar - SpecifiedType mapping. */
    private final TypeVarMap typeVarMap;

    /** immutable property-name - typeref mapping. */
    //private final Map<String,GenericTypeRef> propMap;
    //final Map<TypeVarKey, Type> typeVarMap;
    //final Map<String, FixedType> typeVarMap;
    public static TypeVarScope getTypeScopeWithEnclosings(Class<?> cls)
        throws TypeViolationException
    {
        // enclosing trace is not supported now.
        return new ClassTypeVarScope(cls);
    }

    public ClassTypeVarScope(Class<?> cls)
        throws TypeViolationException
    {
        //this(cls, new GenericTypeRef[cls.getTypeParameters().length]);
        /*
         if(cls == null) throw new NullPointerException("cls");
         rawClass = cls;
         typeargs = new ArrayList<GenericTypeRef>();
         typeVarMap = new HashMap<TypeVariable<? extends GenericDeclaration>,GenericTypeRef>();
         try{
         propMap = createPropertyTypeRefs(cls);
         }catch(IntrospectionException ex){
         throw new TypeViolationException(
         "fail in creating GenericTypeRef", ex);
         }
         */
        //}
        //public ClassTypeVarScope(Class<?> cls, Type[] tps)
        //private ClassTypeVarScope(Class<?> cls, Type... tps)
        //    throws TypeViolationException
        //{
        //    this(cls, createGenericTypeRefArray(tps));
        //}
        //private ClassTypeVarScope(Class<?> cls, GenericTypeRef... tps)
        //    throws TypeViolationException
        //{
        if(cls == null) throw new NullPointerException("cls");
        rawClass = cls;

        /*
         TypeVariable<Class<T>>[] tvs = cls.getTypeParameters();
         if(tvs.length != tps.length){
         throw new IllegalArgumentException(cls + ":" + tvs.length
         + "typevar exist, not "
         + tps.length);
         }

         // TODO: type of typevar check.

         List<Type> l = new ArrayList<Type>(tps.length);
         Map<TypeVariable<? extends GenericDeclaration>, Type> map
         = new HashMap<TypeVariable<? extends GenericDeclaration>, Type>();

         for(int i = 0; i < tps.length; i++){
         if(tps[i] == null) throw new NullPointerException("tps idx="+i);
         l.add(tps[i]);
         //TypeVarKey k = tvkFactory.get(tvs[i]);
         //map.put(k, tps[i]);
         map.put(tvs[i], tps[i]);
         }
         types = Collections.unmodifiableList(l);
         */
        //List<GenericTypeRef> l = new ArrayList<GenericTypeRef>(tps.length);
        //for(int i = 0; i < tps.length; i++){
        //    l.add(tps[i]);
        //}
        //typeargs = l;
        //garbageTypeVars(map, cls);
        TypeVarMap map = new TypeVarMap();

        garbageTypeVarsStage1(map, cls);

        typeVarMap = map;

        //try{
        //    propMap = createPropertyTypeRefs(cls);
        //}catch(IntrospectionException ex){
        //    throw new TypeViolationException("fail in creating GenericTypeRef",
        //            ex);
        //}
    }

    private static <T> void garbageTypeVarsStage1(TypeVarMap map, Class<T> cls)
        throws TypeViolationException
    {
        //final TypeVariable<Class<T>>[] tvs = cls.getTypeParameters();
        //if(tvs.length == types.length){
        //    for(int i = tvs.length; --i >= 0;){
        //        TypeVariable<Class<T>> tv = tvs[i];
        //        GenericTypeRef o = map.get(tv);
        //        if(o == null){
        //            // null may be put.
        //            map.put(tv, types[i]);
        //        }else{
        //            // This code is executed when a interface is inherited
        //            // by 2 or more path from target class.
        //            // In this case, only one path is chosen because
        //            // each path should be resolvable.
        //            //throw new TypeViolationException("The type variable ''{0}'' has two different scope ''{1}'' and ''{2}''. Report as a bug.", tv, o.getScope(), types[i].getScope());
        //        }

        //    }

        {
            Type t = cls.getGenericSuperclass();
            if(t != null){
                garbageTypeVarsStage2(map, t);
            }
        }

        for(Type t : cls.getGenericInterfaces()){
            garbageTypeVarsStage2(map, t);
        }
        //}else{
        //    throw new TypeViolationException("The number of types ''{0}'' is not match with the number of type parameters of ''{1}'' Revise the specifications.",
        //                                     types.length, cls.getName());
        //}
    }

    //private static final GenericTypeRef[] ZERO_LENGTH_TYPE_ARRAY = new GenericTypeRef[0];

    private static void garbageTypeVarsStage2(TypeVarMap map, Type type)
        throws TypeViolationException
    {
        if(type instanceof Class<?>){
            Class<?> t = (Class<?>) type;
            garbageTypeVarsStage1(map, t);
        }else if(type instanceof ParameterizedType){
            ParameterizedType t = (ParameterizedType) type;
            Type rtr = t.getRawType();
            //TypeVariable<?> tvs = rtr.getTypeParameters()();
            Type[] ptps = t.getActualTypeArguments();
            if(rtr instanceof Class){
                final Class<?> rt = (Class<?>) rtr;
                //for(int i=ptps.length; --i>=0;){
                //    Type at = ptps[i];
                //    garbageTypeVarsStage2(map, at);
                //}

                final TypeVariable<?>[] tvs = rt.getTypeParameters();
                if(tvs.length != ptps.length){
                    throw new TypeViolationException(
                            "The number of types ''{0}'' is not match with the number of type parameters of ''{1}'' Revise the specifications.",
                            ptps.length, rt.getName());
                }

                for(int i = tvs.length; --i >= 0;){
                    TypeVariable<?> tv = tvs[i];
                    GenericTypeRef o = map.get(tv);
                    if(o == null){
                        o = new SimpleGenericTypeRef(ptps[i]);
                        // null may be put.
                        map.put(tv, o);
                    }else{
                        // This code is executed when a interface is inherited
                        // by 2 or more path from target class.
                        // In this case, only one path is chosen because
                        // each path should be resolvable.
                        //throw new TypeViolationException("The type variable ''{0}'' has two different scope ''{1}'' and ''{2}''. Report as a bug.", tv, o.getScope(), types[i].getScope());
                    }

                }

                garbageTypeVarsStage1(map, rt);
            }else{
                throw new TypeViolationException(
                        "The raw class ''{0}'' of the parameterized type is not a class. Report it as a bug.",
                        type);
            }

        }else{
            throw new TypeViolationException(
                    "The type ''{0}'' is not supported. Report it as a bug.",
                    type);
        }
    }

    /*
     private static class PropertyTypeRef implements GenericTypeRef
     {

     private final Method getter;

     private final Method setter;

     private final TypeVarScope scope;

     public PropertyTypeRef(Method getter, Method setter, TypeVarScope scope)
     {
     this.getter = getter;
     this.setter = setter;
     this.scope = scope;
     }

     public Type getType(For f)
     throws TypeViolationException
     {
     switch(f){
     case NO_ACCESS:
     case GET:
     if(getter == null){
     return null;
     }else{
     return getter.getGenericReturnType();
     }
     case SET:
     if(setter == null){
     return null;
     }else{
     Type[] p = setter.getGenericParameterTypes();
     if(p.length == 1){
     assert p[0] != null;
     return p[0];
     }else{
     throw new TypeViolationException(
     "Unsupport setter method:" + setter);
     }
     }
     default:
     throw new IllegalArgumentException("Unsupported For value:" + f);
     }
     }

     public TypeVarScope getScope(){
     return scope;
     }

     public Object invokeGet(Object bean)
     throws TypeViolationException, IllegalAccessException,
     IllegalArgumentException, InvocationTargetException,
     UnsupportedOperationException
     {
     if(getter != null){
     Object ret = getter.invoke(bean);
     return ret;
     }else{
     throw new UnsupportedOperationException();
     }
     }

     public void invokeSet(Object bean, Object value)
     throws TypeViolationException, IllegalAccessException,
     IllegalArgumentException, InvocationTargetException,
     UnsupportedOperationException
     {
     if(setter != null){
     setter.invoke(bean, value);
     }else{
     throw new UnsupportedOperationException();
     }
     }

     }

     private Map<String,GenericTypeRef> createPropertyTypeRefs(Class<?> cls)
     throws TypeViolationException, IntrospectionException
     {
     BeanInfo bi = Introspector.getBeanInfo(cls);
     Map<String,GenericTypeRef> m = new HashMap<String,GenericTypeRef>();
     for(PropertyDescriptor p : bi.getPropertyDescriptors()){
     assert p.getReadMethod() != null || p.getWriteMethod() != null;
     GenericTypeRef r = new PropertyTypeRef(p.getReadMethod(), p
     .getWriteMethod(), this);
     m.put(p.getName(), r);
     }
     return m;
     }
     */

    /*
     static GenericTypeRef[] createGenericTypeRefArray(Type... arg){
     GenericTypeRef[] r = new GenericTypeRef[arg.length];
     for(int i = arg.length; --i >= 0;){
     r[i] = new SimpleGenericTypeRef(arg[i]);
     }
     return r;
     }
     */

    /**
     * 
     * @uml.property name="declaredClass"
     */
    /*
     protected ClassTypeVarScope(Class<T> cls, FixedType ... tps){
     if(cls == null) throw new NullPointerException("cls");
     declaredClass = cls;
     TypeVariable<Class<T>>[] tvs = cls.getTypeParameters();
     if(tvs.length != tps.length){
     throw new IllegalArgumentException(cls + ":" + tvs.length
     + "typevar exist, not "
     + tps.length);
     }

     // TODO: type of typevar check.

     List<FixedType> l = new ArrayList<FixedType>(tps.length);
     Map<String, FixedType> map = new HashMap<String, FixedType>();
     for(int i = tps.length; --i>=0; ){
     if(tps[i] == null) throw new NullPointerException("tps idx="+i);
     l.set(i,tps[i]);
     map.put(tvs[i].getName(), tps[i]);
     }
     types = Collections.unmodifiableList(l);
     typeVarMap = map;
     }
     */

    public Class<?> getRawType(){
        return rawClass;
    }

    /**
     @param name typevar name.
     @return [null:not found].
     */
    //public Type getFixedTypeOf(String name){
    //public Type getFixedTypeOf(TypeVarKey key){
    //    return typeVarMap.get(key);
    //    //return null;
    //}
    public GenericTypeRef resolveTypeVariable(
            TypeVariable<? extends GenericDeclaration> key)
    {
        //TypeVarKey k = tvkFactory.get(key);
        //return getFixedTypeOf(k);
        //return null;
        GenericTypeRef ref = typeVarMap.get(key);
        return ref;
    }

    //public FixedType getFixedTypeOf(String name){
    //    return typeVarMap.get(name);
    //}

    public boolean isEmpty(){
        return typeVarMap.isEmpty();
    }

    public Set<TypeVariable<? extends GenericDeclaration>> getTypeVariableSet()
    {
        return typeVarMap.keySet();
    }

    public String toString(){
        StringBuffer buf = new StringBuffer();
        //buf.append("ClassTypeVarScope:");
        buf.append(getRawType().getSimpleName());
        boolean first = true;
        /*
         buf.append('<');
         boolean first = true;
         for(int i = 0; i < typeargs.size(); i++){
         if(first){
         first = false;
         }else{
         buf.append(',');
         }
         GenericTypeRef ta = typeargs.get(i);
         if(ta != null){
         buf.append(ta.toString());
         }
         }
         buf.append(">{");
         */
        buf.append("{");
        //buf.append(typeVarMap.toString());
        first = true;
        for(TypeVariable<? extends GenericDeclaration> key : typeVarMap
                .keySet()){
            if(first){
                first = false;
            }else{
                buf.append(',');
            }
            GenericDeclaration gd = key.getGenericDeclaration();
            if(gd instanceof Class<?>){
                if(gd.equals(getRawType())){
                    // skip domain
                }else{
                    buf.append(((Class<?>) gd).getSimpleName());
                    buf.append(':');
                }
            }else if(gd instanceof Method){
                buf.append(((Method) gd).getName());
                buf.append(':');
            }else{
                buf.append(gd.toString());
                buf.append(':');
            }
            buf.append(key.getName());
            buf.append('=');
            GenericTypeRef tr = typeVarMap.get(key);
            if(tr != null){
                buf.append(typeVarMap.get(key));
            }else{
                buf.append('?');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    /*
     public Type getType(For f){
     switch(f){
     case NO_ACCESS:
     case GET:
     return rawClass;
     case SET:
     return null;
     default:
     throw new IllegalArgumentException("Unsupport For value:" + f);
     }
     }
     */

    /*
     public Type getType(){
     return rawClass;
     }


     public TypeVarScope getScope(){
     return this;
     }

     public Object invokeGet(Object bean)
     throws TypeViolationException
     {
     return bean;
     }

     public void invokeSet(Object bean, Object value)
     throws TypeViolationException
     {
     throw new TypeViolationException(
     "Set operation is unsupported for typeref to bean.");
     }
     */

    /*
     public GenericTypeRef getPropertyTypeRef(Object key)
     throws TypeViolationException
     {
     return propMap.get(key);
     }
     public Object newInstance()
     throws TypeViolationException, NoSuchMethodException,
     SecurityException, InstantiationException, IllegalAccessException,
     IllegalArgumentException, InvocationTargetException
     {
     // TODO support arg
     Constructor<?> c = rawClass.getConstructor();
     return c.newInstance();
     }
     */

}
