// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: ChainedTypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.Method;
import java.util.*;
import jp.sourceforge.greflect.TypeViolationException;

/**
 * A TypeVarScope implementation [chain of responsibility] [immutable]
 * .
 * <DT><B> Responsibilities &amp; Collaborations : </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 *
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo </B></DT>
 * <DD> $Id: ChainedTypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class ChainedTypeVarScope implements TypeVarScope
{
    private final TypeVarScope scope;

    private final TypeVariable<? extends GenericDeclaration> typeVar;

    private final GenericTypeRef fixedType;

    public ChainedTypeVarScope(TypeVarScope scope,
            TypeVariable<? extends GenericDeclaration> tvar,
            GenericTypeRef fixed)
    {
        //if(scope == null){
        //    throw new IllegalArgumentException("scope");
        //}
        if(tvar == null){
            throw new IllegalArgumentException("tvar");
        }
        if(fixed == null){
            throw new IllegalArgumentException("fixed");
        }
        this.scope = scope;
        typeVar = tvar;
        fixedType = fixed;
    }

    private static GenericTypeRef[] createGenericTypeRefArray(Type... arg){
        GenericTypeRef[] r = new GenericTypeRef[arg.length];
        for(int i = arg.length; --i >= 0;){
            r[i] = new SimpleGenericTypeRef(arg[i]);
        }
        return r;
    }

    public static <T> TypeVarScope chain(TypeVarScope scope, Class<T> cls,
            Type[] types)
        throws TypeViolationException
    {
        return chain(scope, cls, createGenericTypeRefArray(types));
    }

    public static <T> TypeVarScope chain(TypeVarScope scope, Class<T> cls,
            GenericTypeRef[] types)
        throws TypeViolationException
    {
        TypeVariable<? extends GenericDeclaration>[] tvs = cls
                .getTypeParameters();
        if(tvs.length != types.length){
            throw new TypeViolationException(
                    "The number of type variable is not match. Revise the specification.");
        }
        for(int i = 0; i < tvs.length; i++){
            scope = new ChainedTypeVarScope(scope, tvs[i], types[i]);
        }
        return scope;
    }

    public GenericTypeRef resolveTypeVariable(
            TypeVariable<? extends GenericDeclaration> key)
    {
        if(key != null && key.equals(typeVar)){
            return fixedType;
        }else{
            return scope.resolveTypeVariable(key);
        }
    }

    public boolean isEmpty(){
        return false;
    }

    public Set<TypeVariable<? extends GenericDeclaration>> getTypeVariableSet()
    {
        Set<TypeVariable<? extends GenericDeclaration>> s = new HashSet<TypeVariable<? extends GenericDeclaration>>();
        s.addAll(scope.getTypeVariableSet());
        s.add(typeVar);
        return s;
    }

    public String toString(){
        GenericDeclaration gd = typeVar.getGenericDeclaration();
        String name;
        if(gd instanceof Class<?>){
            name = ((Class<?>) gd).getSimpleName();
        }else if(gd instanceof Method){
            name = ((Method) gd).getName();
        }else{
            name = gd.toString();
        }
        return "{" + name + ":" + typeVar.getName() + "=" + fixedType + ","
                + scope + "}";
    }

}
