// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: BytecodeGeneratorClassLoader.java 7 2008-05-10 12:03:43Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import static org.apache.bcel.Constants.*;
import java.lang.reflect.Modifier;
import java.lang.reflect.Constructor;
import jp.sourceforge.greflect.*;
import org.apache.bcel.generic.*;
import org.apache.bcel.classfile.*;
import java.util.*;
import java.io.*;

/**
 * A ClassLoader for the bytecode generator.
 * .
 * <DT><B> Type Variable {@code }: </B></DT>
 * <DD> 
 * (none)
 * </DD>
 *
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: BytecodeGeneratorClassLoader.java 7 2008-05-10 12:03:43Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class BytecodeGeneratorClassLoader extends ClassLoader
{
    private static final String[] NULL_STRINGS = new String[]{};

    private static final String BYTECODE_CLASSNAME_PACKAGE = "jp.sourceforge.greflect.generated.";

    private static final String BYTECODE_CLASSNAME_PREFIX = BYTECODE_CLASSNAME_PACKAGE
            + "Ungeneric$$";

    private static final int BYTECODE_MODIFIER = Modifier.PUBLIC
            | Modifier.FINAL;

    private static final short BYTECODE_VERSION_MAJOR = 0x31;

    private static final short BYTECODE_VERSION_MINOR = 0;

    private static final String ATTRIBUTE_NAME_SIGNATURE = "Signature";

    private static final int BYTEBUF_SIZE = 1024;

    class LoaderEntry
    {
        //Construictor<?> constructor = null;
        Constructor<?> superConstructor = null;

        String classSignature = null;
    }

    private final Object lock = new Object();

    /**
     * The ID of generated class.
     * NOTE: synchronize(lock) is required to access.
     */
    private int classId = 101;

    /**
     * The concurrent classname-LoaderEntry map.
     * NOTE: synchronize(lock) is required to access.
     */
    private Map<String,LoaderEntry> classesByName = new HashMap<String,LoaderEntry>();

    /**
     * The concurrent superconstructor-LoaderEntry map.
     * NOTE: synchronize(lock) is required to access.
     */
    //private Map<Constructor<?>, LoaderEntry> classesByConstructor = new HashMap<Constructor<?>, LoaderEntry>();
    /**
     * Ignored packages are by default ( "java.", "sun.", "javax."), i.e. loaded by system class loader.
     * @see ClassLoader
     */
    public BytecodeGeneratorClassLoader(){
        super();
    }

    /**
     * Ignored packages are by default ( "java.", "sun.", "javax."), i.e. loaded by system class loader.
     * @param deferTo - delegate class loader to use for ignored packages.
     * @see ClassLoader
     */
    public BytecodeGeneratorClassLoader(java.lang.ClassLoader deferTo){
        super(deferTo);
    }

    /**
     * @param ignored_packages - classes contained in these packages will be loaded with the system class loader.
     * @param deferTo - delegate class loader to use for ignored packages.
     * @see ClassLoader
     */
    /*
     public BytecodeGeneratorClassLoader(java.lang.ClassLoader deferTo, String[] ignored_packages){
     super(deferTo, ignored_packages);
     }
     */

    public Constructor<?> generateClassAndGetConstructorFor(
            Constructor<?> super_cst, String class_signature)
        throws TypeViolationException, SecurityException,
        ClassNotFoundException
    {
        if(super_cst.getDeclaringClass().getTypeParameters().length == 0){
            // If the class has no type variable.
            return super_cst;
        }else{
            // If the class has type variable.
            final String clsname;
            synchronized(lock){
                clsname = BYTECODE_CLASSNAME_PREFIX + classId;
                classId++;

                LoaderEntry e = new LoaderEntry();
                e.classSignature = class_signature;
                e.superConstructor = super_cst;
                classesByName.put(clsname, e);
            }

            final Class<?> cls = loadClass(clsname, true);
            try{
                final Constructor<?> cst = cls.getConstructor(super_cst
                        .getParameterTypes());
                return cst;
            }catch(NoSuchMethodException ex){
                throw new TypeViolationException(ex,
                        "The constructor of the generated class is not found. Report it as a bug.");
            }
        }
    }

    @Override
    protected Class<?> findClass(String class_name)
        throws ClassNotFoundException
    {
        if(class_name == null
                || !class_name.startsWith(BYTECODE_CLASSNAME_PACKAGE)){
            throw new ClassNotFoundException(
                    "The BytecodeGeneratorClassLoader cannot load the class '"
                            + class_name + "'. Revise ClassLoader setting.");
        }
        final Constructor<?> scst;
        final String clsSignature;
        synchronized(lock){
            LoaderEntry e = classesByName.get(class_name);
            if(e == null){
                throw new ClassNotFoundException("The generated class '"
                        + class_name + "' is not found. Report it as a bug.");
            }else{
                scst = e.superConstructor;
                clsSignature = e.classSignature;
            }
        }

        try{
            ByteArrayOutputStream bos = null;
            try{
                final ClassGen clsgen = createUngenericClassGen(class_name,
                        scst, clsSignature);
                bos = new ByteArrayOutputStream(BYTEBUF_SIZE);
                clsgen.getJavaClass().dump(bos);
                byte[] bytecode = bos.toByteArray();
                Class<?> cls = defineClass(class_name, bytecode, 0,
                        bytecode.length);
                return cls;
            }finally{
                if(bos != null){
                    bos.close();
                }
            }
        }catch(TypeViolationException ex){
            throw new ClassNotFoundException("Loading generated class '"
                    + class_name
                    + "' fails to type violstion. Report it as a bug.", ex);
        }catch(IOException ex){
            throw new ClassNotFoundException("Loading generated class '"
                    + class_name + "' fails to I/O. Report it as a bug.", ex);
        }
    }

    private static Type makeTypeForClass(Class<?> cls)
        throws TypeViolationException
    {
        int dim = 0;
        Class<?> c;
        for(c = cls; c.isArray(); c = c.getComponentType()){
            dim++;
        }
        Type t;
        if(c.isPrimitive()){
            if(c.equals(int.class)){
                t = BasicType.INT;
            }else if(c.equals(boolean.class)){
                t = BasicType.BOOLEAN;
            }else if(c.equals(byte.class)){
                t = BasicType.BYTE;
            }else if(c.equals(double.class)){
                t = BasicType.DOUBLE;
            }else if(c.equals(long.class)){
                t = BasicType.LONG;
            }else if(c.equals(float.class)){
                t = BasicType.FLOAT;
            }else if(c.equals(char.class)){
                t = BasicType.CHAR;
            }else if(c.equals(short.class)){
                t = BasicType.SHORT;
            }else if(c.equals(void.class)){
                t = BasicType.VOID;
            }else{
                throw new TypeViolationException(
                        "The primitive type ''{0}'' is unknown. Report it as a bug.",
                        cls);
            }
        }else{
            t = new ObjectType(c.getName());
        }
        if(dim == 0){
            return t;
        }else{
            return new ArrayType(t, dim);
        }
    }

    private static LoadInstruction makeLoadInstruction(Class<?> c, int ix)
        throws TypeViolationException
    {
        if(c.isPrimitive()){
            if(c.equals(int.class)){
                return new ILOAD(ix);
            }else if(c.equals(boolean.class)){
                return new ILOAD(ix);
            }else if(c.equals(byte.class)){
                return new ILOAD(ix);
            }else if(c.equals(double.class)){
                return new DLOAD(ix);
            }else if(c.equals(long.class)){
                return new LLOAD(ix);
            }else if(c.equals(float.class)){
                return new FLOAD(ix);
            }else if(c.equals(char.class)){
                return new ILOAD(ix);
            }else if(c.equals(short.class)){
                return new ILOAD(ix);
            }else if(c.equals(void.class)){
                throw new TypeViolationException(
                        "No load instruction for ''{0}'' exists. Report it as a bug.",
                        c);
            }else{
                throw new TypeViolationException(
                        "The primitive type ''{0}'' is unknown. Report it as a bug.",
                        c);
            }
        }else{
            return new ALOAD(ix);
        }
    }

    static ClassGen createUngenericClassGen(String clsname, Constructor<?> cst,
            String clsSignature)
        throws TypeViolationException
    {
        final Class<?> cls = cst.getDeclaringClass();
        final Class<?>[] params = cst.getParameterTypes();

        if(cls.isInterface()){
            throw new TypeViolationException(
                    "The type ''{0}'' is a Interface. Revise the type variable.",
                    cls);
        }

        //final String filename = BytecodeGeneratorClassLoader.class.getSimpleName() + ".java";
        //final int pxid = newProxyId();
        //final String clsname = BYTECODE_CLASSNAME_PREFIX + pxid;
        final ClassGen clsgen = new ClassGen(clsname, cls.getName(),
        //filename,
                null, BYTECODE_MODIFIER, NULL_STRINGS);
        clsgen.setMajor(BYTECODE_VERSION_MAJOR);
        clsgen.setMinor(BYTECODE_VERSION_MINOR);

        { // Creating generic signature (attribute "Signature" for the class).
            ConstantPoolGen cpg = clsgen.getConstantPool();
            int ixsign = cpg.addUtf8(ATTRIBUTE_NAME_SIGNATURE);
            int ixsigv = cpg.addUtf8(clsSignature);

            clsgen.addAttribute(new Signature(ixsign, 2, ixsigv, cpg
                    .getConstantPool()));
        }

        { // Creating constructor.
            InstructionList il = new InstructionList();

            Type[] types = new Type[params.length];
            String[] paramnames = new String[params.length];
            for(int i = params.length; --i >= 0;){
                types[i] = makeTypeForClass(params[i]);
                paramnames[i] = "param" + i;
            }
            MethodGen mg = new MethodGen(ACC_PUBLIC, Type.VOID, types,
                    paramnames, "<init>", clsname, il, clsgen.getConstantPool());
            InstructionFactory factory = new InstructionFactory(clsgen);

            il.append(new ALOAD(0));
            for(int i = 0, n = 1; i < params.length; i++){
                il.append(makeLoadInstruction(params[i], n));
                if(params[i].equals(double.class)
                        || params[i].equals(long.class)){
                    n += 2;
                }else{
                    n++;
                }
            }
            il.append(factory.createInvoke(cls.getName(), "<init>", Type.VOID,
                    types, INVOKESPECIAL));
            il.append(new RETURN());

            mg.setMaxStack();
            clsgen.addMethod(mg.getMethod());
            il.dispose();
        }

        return clsgen;
    }

}
