// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: BranchedTypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect.impl;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.TypeVariable;
import java.util.*;

/**
 * A TypeVarScope implementation [chain of responsibility] [immutable]
 * .
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: BranchedTypeVarScope.java 132 2008-07-02 13:51:18Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class BranchedTypeVarScope implements TypeVarScope
{
    private final TypeVarScope first;

    private final TypeVarScope second;

    public BranchedTypeVarScope(TypeVarScope first, TypeVarScope second){
        if(first == null) throw new NullPointerException("first");
        if(second == null) throw new NullPointerException("second");
        this.first = first;
        this.second = second;
    }

    public GenericTypeRef resolveTypeVariable(
            TypeVariable<? extends GenericDeclaration> key)
    {
        GenericTypeRef r = first.resolveTypeVariable(key);
        if(r == null) r = second.resolveTypeVariable(key);
        return r;
    }

    public boolean isEmpty(){
        return first.isEmpty() && second.isEmpty();
    }

    public Set<TypeVariable<? extends GenericDeclaration>> getTypeVariableSet()
    {
        Set<TypeVariable<? extends GenericDeclaration>> s = new HashSet<TypeVariable<? extends GenericDeclaration>>();
        s.addAll(first.getTypeVariableSet());
        s.addAll(second.getTypeVariableSet());
        return s;
    }

    public String toString(){
        return "{" + first.toString() + "," + second.toString() + "}";
    }

}
