// <!-- 厄 虫 退 散
// $Id: UnresolvedTypeVariableException.java 106 2008-05-29 15:06:37Z yo-zi $
// Copyright 2005 Ito Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// -->

package jp.sourceforge.greflect;

/**
 * UnresolvedTypeVariableException will throw when the type variable of the specified generic type cannot be resolved
 * <BR/> 指定したジェネリック型の型変数が解決できないときスローされます。
 * .
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: UnresolvedTypeVariableException.java 106 2008-05-29 15:06:37Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class UnresolvedTypeVariableException extends TypeViolationException
{

    /**
     * <code>serialVersionUID</code>
     */
    private static final long serialVersionUID = 3978703991372854325L;

    public UnresolvedTypeVariableException(){
        super();
    }

    public UnresolvedTypeVariableException(String mes, Object... args){
        super(mes, args);
    }

    public UnresolvedTypeVariableException(Throwable th, String mes,
            Object... args)
    {
        super(th, mes, args);
    }

}
