// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: UngenericParam.java 111 2008-06-01 05:02:54Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import java.lang.reflect.*;

import jp.sourceforge.greflect.impl.*;

/**
 * A parameter holder for ungeneric object
 * <BR/> アンジェネリックオブジェクトのパラメータを保持します。
 * .
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> Create ungeneric object.
 * <B>with</B> {@link Reflection.Instantiator}
 * 
 * </LI><LI> Invoke method.
 * <B>with</B> {@link Reflection.Invoker}
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: UngenericParam.java 111 2008-06-01 05:02:54Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public final class UngenericParam extends Param<Object>
{
    /**
     * Create UngenericParam object that keeps ungeneric object
     * <BR/> アンジェネリックオブジェクトを保持するUngenericParamオブジェクトを作成する。
     * .
     * <BR/>NOTE: This Constructor is not check that the value is ungeneric or not
     * .
     * <BR/>@lang ja NOTE:このコンストラクタはvalueがアンジェネリックかそうでないかチェックしません。
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * The value must not be null.
     * <P/> @lang ja valueはnullであってはなりません。
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     */
    public UngenericParam(Object value)
        throws NullPointerException
    {
        super(value);
        if(value == null) throw new NullPointerException();
    }

    /**
     * 
     * .
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     * @return
     */
    @Override
    Type getType()
        throws TypeViolationException
    {
        return value.getClass();
    }

    /**
     * 
     * .
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     * @return
     */
    @Override
    TypeVarScope getTypeVarScope()
        throws TypeViolationException
    {
        return ClassTypeVarScope.getTypeScopeWithEnclosings(value.getClass());
    }

}
